/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import configuration.TapeSettingsType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.swing.table.AbstractTableModel;
import machine.Clock;
import machine.ClockTimeoutListener;
import machine.MachineTypes;
import machine.Memory;
import utilities.TapeBlockListener;
import utilities.TapeStateListener;
import z80core.Z80;

public class Tape
implements ClockTimeoutListener {
    private Z80 cpu;
    private BufferedInputStream tapeFile;
    private ByteArrayOutputStream record;
    private DeflaterOutputStream dos;
    private ByteArrayInputStream bais;
    private InflaterInputStream iis;
    private File filename;
    private byte[] tapeBuffer;
    private final int[] offsetBlocks = new int[4096];
    private int nOffsetBlocks;
    private int idxHeader;
    private int tapePos;
    private int blockLen;
    private int mask;
    private int bitTime;
    private byte byteTmp;
    private int cswPulses;
    private final Clock clock;
    private final ArrayList<TapeStateListener> stateListeners;
    private final ArrayList<TapeBlockListener> blockListeners = new ArrayList();
    private State statePlay;
    private int earBit;
    private boolean micBit;
    private static final int EAR_OFF = 191;
    private static final int EAR_ON = 255;
    private static final int EAR_MASK = 64;
    private long timeLastOut;
    private boolean tapePlaying;
    private boolean tapeRecording;
    private TapeExtensionType tapeExtension;
    private final int LEADER_LENGHT = 2168;
    private final int SYNC1_LENGHT = 667;
    private final int SYNC2_LENGHT = 735;
    private final int ZERO_LENGHT = 855;
    private final int ONE_LENGHT = 1710;
    private final int HEADER_PULSES = 8063;
    private final int DATA_PULSES = 3223;
    private final int END_BLOCK_PAUSE = 3500000;
    private int leaderLenght;
    private int leaderPulses;
    private int sync1Lenght;
    private int sync2Lenght;
    private int zeroLenght;
    private int oneLenght;
    private int bitsLastByte;
    private int endBlockPause;
    private int nLoops;
    private int loopStart;
    private int freqSample;
    private float cswStatesSample;
    private MachineTypes spectrumModel;
    private final TapeTableModel tapeTableModel;
    private final TapeSettingsType settings;
    private int nCalls;
    private int callBlk;
    private short[] callSeq;
    private int totp;
    private int npp;
    private int asp;
    private int totd;
    private int npd;
    private int asd;
    private int ptrSymbol;
    private int ptrDataStream;
    private int numPulses;
    private int nTotp;
    private static final String tzxHeader = "ZXTape!\u001a";
    private static final String tzxCreator = "TZX created with JSpeccy v0.93";

    public Tape(TapeSettingsType tapeSettings) {
        this.stateListeners = new ArrayList();
        this.clock = Clock.getInstance();
        this.settings = tapeSettings;
        this.statePlay = State.STOP;
        this.tapeRecording = false;
        this.tapePlaying = false;
        this.tapeExtension = TapeExtensionType.NO_TAPE;
        this.tapePos = 0;
        this.earBit = 255;
        this.spectrumModel = MachineTypes.SPECTRUM48K;
        this.nOffsetBlocks = 0;
        this.idxHeader = 0;
        Arrays.fill(this.offsetBlocks, 0);
        this.tapeTableModel = new TapeTableModel();
    }

    public void addTapeChangedListener(TapeStateListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public void removeTapeChangedListener(TapeStateListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.stateListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    private void fireTapeStateChanged(TapeState state) {
        for (TapeStateListener listener : this.stateListeners) {
            listener.stateChanged(state);
        }
    }

    public void addTapeBlockListener(TapeBlockListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.blockListeners.contains(listener)) {
            this.blockListeners.add(listener);
        }
    }

    public void removeTapeBlockListener(TapeBlockListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.blockListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    private void fireTapeBlockChanged(int block) {
        for (TapeBlockListener listener : this.blockListeners) {
            listener.blockChanged(block);
        }
    }

    public void setSpectrumModel(MachineTypes model) {
        this.spectrumModel = model;
    }

    public void setZ80Cpu(Z80 z80) {
        this.cpu = z80;
    }

    private int getNumBlocks() {
        return this.tapeExtension == TapeExtensionType.NO_TAPE ? 1 : this.nOffsetBlocks + 1;
    }

    public int getSelectedBlock() {
        return this.idxHeader;
    }

    public void setSelectedBlock(int block) {
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || this.isTapePlaying() || block > this.nOffsetBlocks) {
            return;
        }
        this.idxHeader = block;
        this.fireTapeBlockChanged(block);
    }

    private String getCleanMsg(int offset, int len) {
        byte[] msg = new byte[len];
        for (int car = 0; car < len; ++car) {
            msg[car] = (this.tapeBuffer[offset + car] & 0xFF) > 31 && (this.tapeBuffer[offset + car] & 0xFF) < 128 ? this.tapeBuffer[offset + car] : 63;
        }
        return new String(msg);
    }

    private String getBlockType(int block) {
        String msg;
        ResourceBundle bundle = ResourceBundle.getBundle("utilities/Bundle");
        if (this.tapeExtension == TapeExtensionType.NO_TAPE) {
            return bundle.getString("NO_TAPE_INSERTED");
        }
        if (block >= this.nOffsetBlocks) {
            return bundle.getString("END_OF_TAPE");
        }
        if (this.tapeExtension == TapeExtensionType.CSW) {
            return String.format(bundle.getString("CSW_DATA"), this.tapeBuffer[23], this.tapeBuffer[24]);
        }
        if (this.tapeExtension == TapeExtensionType.TAP) {
            return bundle.getString("STD_SPD_DATA");
        }
        int offset = this.offsetBlocks[block];
        switch (this.tapeBuffer[offset] & 0xFF) {
            case 16: {
                msg = bundle.getString("STD_SPD_DATA");
                break;
            }
            case 17: {
                msg = bundle.getString("TURBO_SPD_DATA");
                break;
            }
            case 18: {
                msg = bundle.getString("PURE_TONE");
                break;
            }
            case 19: {
                msg = bundle.getString("PULSE_SEQUENCE");
                break;
            }
            case 20: {
                msg = bundle.getString("PURE_DATA");
                break;
            }
            case 21: {
                msg = bundle.getString("DIRECT_DATA");
                break;
            }
            case 24: {
                msg = bundle.getString("CSW_RECORDING");
                break;
            }
            case 25: {
                msg = bundle.getString("GDB_DATA");
                break;
            }
            case 32: {
                msg = bundle.getString("PAUSE_STOP");
                break;
            }
            case 33: {
                msg = bundle.getString("GROUP_START");
                break;
            }
            case 34: {
                msg = bundle.getString("GROUP_STOP");
                break;
            }
            case 35: {
                msg = bundle.getString("JUMP_TO");
                break;
            }
            case 36: {
                msg = bundle.getString("LOOP_START");
                break;
            }
            case 37: {
                msg = bundle.getString("LOOP_STOP");
                break;
            }
            case 38: {
                msg = bundle.getString("CALL_SEQ");
                break;
            }
            case 39: {
                msg = bundle.getString("RETURN_SEQ");
                break;
            }
            case 40: {
                msg = bundle.getString("SELECT_BLOCK");
                break;
            }
            case 42: {
                msg = bundle.getString("STOP_48K_MODE");
                break;
            }
            case 43: {
                msg = bundle.getString("SET_SIGNAL_LEVEL");
                break;
            }
            case 48: {
                msg = bundle.getString("TEXT_DESC");
                break;
            }
            case 49: {
                msg = bundle.getString("MESSAGE_BLOCK");
                break;
            }
            case 50: {
                msg = bundle.getString("ARCHIVE_INFO");
                break;
            }
            case 51: {
                msg = bundle.getString("HARDWARE_TYPE");
                break;
            }
            case 53: {
                msg = bundle.getString("CUSTOM_INFO");
                break;
            }
            case 90: {
                msg = "ZXTape!";
                break;
            }
            default: {
                msg = String.format(bundle.getString("UNKN_TZX_BLOCK"), this.tapeBuffer[offset]);
            }
        }
        return msg;
    }

    private String getBlockInfo(int block) {
        String msg;
        ResourceBundle bundle = ResourceBundle.getBundle("utilities/Bundle");
        if (this.tapeExtension == TapeExtensionType.NO_TAPE) {
            return bundle.getString("NO_TAPE_INSERTED");
        }
        if (block >= this.nOffsetBlocks) {
            return bundle.getString("END_OF_TAPE");
        }
        if (this.tapeExtension == TapeExtensionType.CSW) {
            if ((this.tapeBuffer[23] & 0xFF) == 1) {
                return String.format(bundle.getString("CSW1_PULSES"), this.readInt(this.tapeBuffer, 25, 2));
            }
            if ((this.tapeBuffer[33] & 0xFF) == 2) {
                return String.format(bundle.getString("CSW2_ZRLE_PULSES"), this.readInt(this.tapeBuffer, 29, 4), this.readInt(this.tapeBuffer, 25, 4));
            }
            return String.format(bundle.getString("CSW2_RLE_PULSES"), this.readInt(this.tapeBuffer, 29, 4), this.readInt(this.tapeBuffer, 25, 4));
        }
        if (this.tapeExtension == TapeExtensionType.TAP) {
            String msg2;
            int offset = this.offsetBlocks[block];
            int len = this.readInt(this.tapeBuffer, offset, 2);
            if ((this.tapeBuffer[offset + 2] & 0xFF) == 0) {
                switch (this.tapeBuffer[offset + 3] & 0xFF) {
                    case 0: {
                        msg2 = String.format(bundle.getString("PROGRAM_HEADER"), this.getCleanMsg(offset + 4, 10));
                        break;
                    }
                    case 1: {
                        msg2 = bundle.getString("NUMBER_ARRAY_HEADER");
                        break;
                    }
                    case 2: {
                        msg2 = bundle.getString("CHAR_ARRAY_HEADER");
                        break;
                    }
                    case 3: {
                        msg2 = String.format(bundle.getString("BYTES_HEADER"), this.getCleanMsg(offset + 4, 10));
                        break;
                    }
                    default: {
                        msg2 = "";
                        break;
                    }
                }
            } else {
                msg2 = String.format(bundle.getString("BYTES_MESSAGE"), len);
            }
            return msg2;
        }
        int offset = this.offsetBlocks[block];
        block6 : switch (this.tapeBuffer[offset++] & 0xFF) {
            case 16: {
                int len = this.readInt(this.tapeBuffer, offset + 2, 2);
                if (this.tapeBuffer[offset + 4] == 0) {
                    switch (this.tapeBuffer[offset + 5] & 0xFF) {
                        case 0: {
                            msg = String.format(bundle.getString("PROGRAM_HEADER"), this.getCleanMsg(offset + 6, 10));
                            break block6;
                        }
                        case 1: {
                            msg = bundle.getString("NUMBER_ARRAY_HEADER");
                            break block6;
                        }
                        case 2: {
                            msg = bundle.getString("CHAR_ARRAY_HEADER");
                            break block6;
                        }
                        case 3: {
                            msg = String.format(bundle.getString("BYTES_HEADER"), this.getCleanMsg(offset + 6, 10));
                            break block6;
                        }
                    }
                    msg = String.format(bundle.getString("UNKN_HEADER_ID"), this.tapeBuffer[offset + 5]);
                    break;
                }
                msg = String.format(bundle.getString("BYTES_MESSAGE"), len);
                break;
            }
            case 17: {
                int len = this.readInt(this.tapeBuffer, offset + 15, 3);
                msg = String.format(bundle.getString("BYTES_MESSAGE"), len);
                break;
            }
            case 18: {
                int len = this.readInt(this.tapeBuffer, offset, 2);
                int num = this.readInt(this.tapeBuffer, offset + 2, 2);
                msg = String.format(bundle.getString("PURE_TONE_MESSAGE"), num, len);
                break;
            }
            case 19: {
                int len = this.tapeBuffer[offset] & 0xFF;
                msg = String.format(bundle.getString("PULSE_SEQ_MESSAGE"), len);
                break;
            }
            case 20: {
                int len = this.readInt(this.tapeBuffer, offset + 7, 3);
                msg = String.format(bundle.getString("BYTES_MESSAGE"), len);
                break;
            }
            case 21: {
                int len = this.readInt(this.tapeBuffer, offset + 5, 3);
                msg = String.format(bundle.getString("BYTES_MESSAGE"), len);
                break;
            }
            case 24: {
                if ((this.tapeBuffer[offset + 9] & 0xFF) == 2) {
                    msg = String.format(bundle.getString("CSW2_ZRLE_PULSES"), this.readInt(this.tapeBuffer, offset + 10, 4), this.readInt(this.tapeBuffer, offset + 6, 3));
                    break;
                }
                msg = String.format(bundle.getString("CSW2_RLE_PULSES"), this.readInt(this.tapeBuffer, offset + 10, 4), this.readInt(this.tapeBuffer, offset + 6, 3));
                break;
            }
            case 25: {
                int len = this.readInt(this.tapeBuffer, offset, 4);
                msg = String.format(bundle.getString("BYTES_MESSAGE"), len);
                break;
            }
            case 32: {
                int len = this.readInt(this.tapeBuffer, offset, 2);
                if (len == 0) {
                    msg = bundle.getString("STOP_THE_TAPE");
                    break;
                }
                msg = String.format(bundle.getString("PAUSE_MS"), len);
                break;
            }
            case 33: {
                int len = this.tapeBuffer[offset] & 0xFF;
                msg = this.getCleanMsg(offset + 1, len);
                break;
            }
            case 34: {
                msg = "";
                break;
            }
            case 35: {
                msg = String.format(bundle.getString("NUMBER_OF_BLOCKS"), this.tapeBuffer[offset]);
                break;
            }
            case 36: {
                int len = this.readInt(this.tapeBuffer, offset, 2);
                msg = String.format(bundle.getString("NUMBER_OF_ITER"), len);
                break;
            }
            case 37: {
                msg = "";
                break;
            }
            case 38: {
                int len = this.readInt(this.tapeBuffer, offset, 2);
                msg = String.format(bundle.getString("NUMBER_OF_CALLS"), len);
                break;
            }
            case 39: {
                msg = "";
                break;
            }
            case 40: {
                int len = this.tapeBuffer[offset + 2] & 0xFF;
                msg = String.format(bundle.getString("NUMBER_OF_SELS"), len);
                break;
            }
            case 42: {
                msg = "";
                break;
            }
            case 43: {
                int len = this.tapeBuffer[offset + 2] & 0xFF;
                msg = String.format(bundle.getString("SIGNAL_TO_LEVEL"), len);
                break;
            }
            case 48: {
                int len = this.tapeBuffer[offset] & 0xFF;
                msg = this.getCleanMsg(offset + 1, len);
                break;
            }
            case 49: {
                int len = this.tapeBuffer[offset + 1] & 0xFF;
                msg = this.getCleanMsg(offset + 2, len);
                break;
            }
            case 50: {
                int len = this.tapeBuffer[offset + 2] & 0xFF;
                msg = String.format(bundle.getString("NUMBER_OF_STRINGS"), len);
                break;
            }
            case 51: {
                msg = "";
                break;
            }
            case 53: {
                msg = this.getCleanMsg(offset, 10);
                break;
            }
            case 90: {
                msg = String.format(bundle.getString("TZX_HEADER"), this.tapeBuffer[offset + 7] & 0xFF, this.tapeBuffer[offset + 8] & 0xFF);
                break;
            }
            default: {
                msg = "";
            }
        }
        return msg;
    }

    public TapeTableModel getTapeTableModel() {
        return this.tapeTableModel;
    }

    @Override
    public void clockTimeout() {
        switch (this.tapeExtension) {
            case TAP: {
                this.playTap();
                break;
            }
            case TZX: {
                this.playTzx();
                break;
            }
            case CSW: {
                this.playCsw();
                break;
            }
            default: {
                System.out.println("Warning!, clockTiemout without tape playing");
            }
        }
    }

    private int readInt(byte[] buffer, int start, int len) {
        int res = 0;
        for (int idx = 0; idx < len; ++idx) {
            res |= buffer[start + idx] << idx * 8 & 255 << idx * 8;
        }
        return res;
    }

    public boolean insert(File fileName) {
        if (this.tapeExtension != TapeExtensionType.NO_TAPE) {
            return false;
        }
        try {
            this.tapeFile = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException fex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, fex);
            return false;
        }
        try {
            this.tapeBuffer = new byte[this.tapeFile.available()];
            this.tapeFile.read(this.tapeBuffer);
            this.tapeFile.close();
            this.filename = fileName;
        }
        catch (IOException ex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        this.idxHeader = 0;
        this.tapePos = 0;
        this.statePlay = State.STOP;
        this.tapeRecording = false;
        this.tapePlaying = false;
        String name = this.filename.getName().toLowerCase();
        switch (name.substring(name.lastIndexOf("."), name.length())) {
            case ".tap": {
                this.tapeExtension = TapeExtensionType.TAP;
                if (this.findTAPOffsetBlocks()) break;
                this.nOffsetBlocks = 0;
                return false;
            }
            case ".tzx": {
                this.tapeExtension = TapeExtensionType.TZX;
                if (this.findTZXOffsetBlocks()) break;
                this.nOffsetBlocks = 0;
                return false;
            }
            case ".csw": {
                this.tapeExtension = TapeExtensionType.CSW;
                this.nOffsetBlocks = 1;
                Arrays.fill(this.offsetBlocks, 0);
                break;
            }
            default: {
                this.tapeExtension = TapeExtensionType.NO_TAPE;
                return false;
            }
        }
        this.tapeTableModel.fireTableDataChanged();
        this.fireTapeStateChanged(TapeState.INSERT);
        this.fireTapeBlockChanged(0);
        return true;
    }

    public boolean insertEmbeddedTape(String fileName, String extension, byte[] tapeData, int selectedBlock) {
        if (this.tapeExtension != TapeExtensionType.NO_TAPE) {
            return false;
        }
        this.tapeBuffer = new byte[tapeData.length];
        System.arraycopy(tapeData, 0, this.tapeBuffer, 0, this.tapeBuffer.length);
        this.filename = new File(fileName);
        this.idxHeader = 0;
        this.tapePos = 0;
        this.statePlay = State.STOP;
        this.tapeRecording = false;
        this.tapePlaying = false;
        switch (extension) {
            case "tap": {
                this.tapeExtension = TapeExtensionType.TAP;
                if (this.findTAPOffsetBlocks()) break;
                this.nOffsetBlocks = 0;
                return false;
            }
            case "tzx": {
                this.tapeExtension = TapeExtensionType.TZX;
                if (this.findTZXOffsetBlocks()) break;
                this.nOffsetBlocks = 0;
                return false;
            }
            default: {
                this.tapeExtension = TapeExtensionType.NO_TAPE;
                return false;
            }
        }
        this.tapeTableModel.fireTableDataChanged();
        this.fireTapeStateChanged(TapeState.INSERT);
        this.fireTapeBlockChanged(selectedBlock);
        return true;
    }

    public boolean eject() {
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || this.tapePlaying || this.tapeRecording) {
            return false;
        }
        this.tapeExtension = TapeExtensionType.NO_TAPE;
        this.tapeBuffer = null;
        this.filename = null;
        this.nOffsetBlocks = 0;
        this.tapeTableModel.fireTableDataChanged();
        this.fireTapeStateChanged(TapeState.EJECT);
        return true;
    }

    public int getEarBit() {
        return this.earBit;
    }

    public void setEarBit(boolean earValue) {
        this.earBit = earValue ? 255 : 191;
    }

    public boolean isTapePlaying() {
        return this.tapePlaying;
    }

    public boolean isTapeRecording() {
        return this.tapeRecording;
    }

    public boolean isTapeRunning() {
        return this.tapePlaying || this.tapeRecording;
    }

    public boolean isTapeInserted() {
        return this.tapeExtension != TapeExtensionType.NO_TAPE;
    }

    public boolean isTapeReady() {
        return this.tapeExtension != TapeExtensionType.NO_TAPE && !this.tapePlaying && !this.tapeRecording;
    }

    public File getTapeFilename() {
        return this.filename;
    }

    public boolean play() {
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || this.tapePlaying || this.tapeRecording) {
            return false;
        }
        if (this.idxHeader >= this.nOffsetBlocks) {
            return false;
        }
        this.statePlay = State.START;
        this.tapePos = this.offsetBlocks[this.idxHeader];
        this.fireTapeStateChanged(TapeState.PLAY);
        this.tapePlaying = true;
        this.clock.addClockTimeoutListener(this);
        this.clockTimeout();
        return true;
    }

    public void stop() {
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || !this.tapePlaying || this.tapeRecording) {
            return;
        }
        this.tapePlaying = false;
        this.statePlay = State.STOP;
        this.fireTapeBlockChanged(this.idxHeader);
        this.fireTapeStateChanged(TapeState.STOP);
        this.clock.removeClockTimeoutListener(this);
    }

    public boolean rewind() {
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || this.tapePlaying || this.tapeRecording) {
            return false;
        }
        this.idxHeader = 0;
        this.tapePos = this.offsetBlocks[0];
        this.fireTapeBlockChanged(0);
        return true;
    }

    private boolean findTAPOffsetBlocks() {
        int len;
        this.nOffsetBlocks = 0;
        Arrays.fill(this.offsetBlocks, 0);
        for (int offset = 0; offset < this.tapeBuffer.length && this.nOffsetBlocks < this.offsetBlocks.length; offset += len + 2) {
            if (this.tapeBuffer.length - offset < 2) {
                return false;
            }
            len = this.readInt(this.tapeBuffer, offset, 2);
            if (offset + len + 2 > this.tapeBuffer.length) {
                return false;
            }
            this.offsetBlocks[this.nOffsetBlocks++] = offset;
        }
        return true;
    }

    private boolean playTap() {
        switch (this.statePlay) {
            case STOP: {
                this.stop();
                break;
            }
            case START: {
                this.fireTapeBlockChanged(this.idxHeader);
                this.tapePos = this.offsetBlocks[this.idxHeader];
                this.blockLen = this.readInt(this.tapeBuffer, this.tapePos, 2);
                this.tapePos += 2;
                this.leaderPulses = this.tapeBuffer[this.tapePos] >= 0 ? 8063 : 3223;
                this.earBit = 191;
                this.statePlay = State.LEADER;
                this.clock.setTimeout(2168);
                break;
            }
            case LEADER: {
                this.earBit ^= 0x40;
                if (this.leaderPulses-- > 0) {
                    this.clock.setTimeout(2168);
                    break;
                }
                this.statePlay = State.SYNC;
                this.clock.setTimeout(667);
                break;
            }
            case SYNC: {
                this.earBit ^= 0x40;
                this.statePlay = State.NEWBYTE;
                this.clock.setTimeout(735);
                break;
            }
            case NEWBYTE: {
                this.mask = 128;
            }
            case NEWBIT: {
                this.earBit ^= 0x40;
                this.bitTime = (this.tapeBuffer[this.tapePos] & this.mask) == 0 ? 855 : 1710;
                this.statePlay = State.HALF2;
                this.clock.setTimeout(this.bitTime);
                break;
            }
            case HALF2: {
                this.earBit ^= 0x40;
                this.clock.setTimeout(this.bitTime);
                this.mask >>>= 1;
                if (this.mask == 0) {
                    ++this.tapePos;
                    if (--this.blockLen > 0) {
                        this.statePlay = State.NEWBYTE;
                        break;
                    }
                    this.statePlay = State.PAUSE;
                    break;
                }
                this.statePlay = State.NEWBIT;
                break;
            }
            case PAUSE: {
                this.earBit ^= 0x40;
                this.statePlay = State.PAUSE_STOP;
                this.clock.setTimeout(3500000);
                break;
            }
            case PAUSE_STOP: {
                ++this.idxHeader;
                if (this.tapePos == this.tapeBuffer.length) {
                    this.stop();
                    break;
                }
                this.statePlay = State.START;
                this.playTap();
            }
        }
        return true;
    }

    private boolean findTZXOffsetBlocks() {
        this.nOffsetBlocks = 0;
        int offset = 0;
        Arrays.fill(this.offsetBlocks, 0);
        if (this.tapeBuffer.length == 0) {
            return true;
        }
        if (this.tapeBuffer[0] != 90) {
            return false;
        }
        while (offset < this.tapeBuffer.length && this.nOffsetBlocks < this.offsetBlocks.length) {
            this.offsetBlocks[this.nOffsetBlocks++] = offset;
            switch (this.tapeBuffer[offset] & 0xFF) {
                case 16: {
                    if (this.tapeBuffer.length - offset < 5) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 3, 2);
                    offset += len + 5;
                    break;
                }
                case 17: {
                    if (this.tapeBuffer.length - offset < 19) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 16, 3);
                    offset += len + 19;
                    break;
                }
                case 18: {
                    offset += 5;
                    break;
                }
                case 19: {
                    if (this.tapeBuffer.length - offset < 2) {
                        return false;
                    }
                    int len = this.tapeBuffer[offset + 1] & 0xFF;
                    offset += len * 2 + 2;
                    break;
                }
                case 20: {
                    if (this.tapeBuffer.length - offset < 11) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 8, 3);
                    offset += len + 11;
                    break;
                }
                case 21: {
                    if (this.tapeBuffer.length - offset < 9) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 6, 3);
                    offset += len + 9;
                    break;
                }
                case 24: 
                case 25: {
                    if (this.tapeBuffer.length - offset < 5) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 1, 4);
                    offset += len + 5;
                    break;
                }
                case 32: 
                case 35: 
                case 36: {
                    offset += 3;
                    break;
                }
                case 33: {
                    if (this.tapeBuffer.length - offset < 2) {
                        return false;
                    }
                    int len = this.tapeBuffer[offset + 1] & 0xFF;
                    offset += len + 2;
                    break;
                }
                case 34: 
                case 37: 
                case 39: {
                    ++offset;
                    break;
                }
                case 38: {
                    if (this.tapeBuffer.length - offset < 3) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 1, 2);
                    offset += len * 2 + 3;
                    break;
                }
                case 40: 
                case 50: {
                    if (this.tapeBuffer.length - offset < 3) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 1, 2);
                    offset += len + 3;
                    break;
                }
                case 42: {
                    offset += 5;
                    break;
                }
                case 43: {
                    offset += 6;
                    break;
                }
                case 48: {
                    if (this.tapeBuffer.length - offset < 2) {
                        return false;
                    }
                    int len = this.tapeBuffer[offset + 1] & 0xFF;
                    offset += len + 2;
                    break;
                }
                case 49: {
                    if (this.tapeBuffer.length - offset < 3) {
                        return false;
                    }
                    int len = this.tapeBuffer[offset + 2] & 0xFF;
                    offset += len + 3;
                    break;
                }
                case 51: {
                    if (this.tapeBuffer.length - offset < 2) {
                        return false;
                    }
                    int len = this.tapeBuffer[offset + 1] & 0xFF;
                    offset += len * 3 + 2;
                    break;
                }
                case 53: {
                    if (this.tapeBuffer.length - offset < 21) {
                        return false;
                    }
                    int len = this.readInt(this.tapeBuffer, offset + 17, 4);
                    offset += len + 21;
                    break;
                }
                case 90: {
                    offset += 10;
                    break;
                }
                default: {
                    System.out.println(String.format("Block ID: %02x", this.tapeBuffer[offset]));
                    return false;
                }
            }
            if (offset <= this.tapeBuffer.length) continue;
            return false;
        }
        return true;
    }

    private boolean playTzx() {
        boolean repeat;
        do {
            repeat = false;
            switch (this.statePlay) {
                case STOP: {
                    this.stop();
                    break;
                }
                case START: {
                    this.tapePos = this.offsetBlocks[this.idxHeader];
                    this.earBit = this.settings.isInvertedEar() ? 255 : 191;
                    this.statePlay = State.TZX_HEADER;
                    repeat = true;
                    break;
                }
                case LEADER: {
                    this.earBit ^= 0x40;
                }
                case LEADER_NOCHG: {
                    if (this.leaderPulses-- > 0) {
                        this.statePlay = State.LEADER;
                        this.clock.setTimeout(this.leaderLenght);
                        break;
                    }
                    this.clock.setTimeout(this.sync1Lenght);
                    this.statePlay = State.SYNC;
                    break;
                }
                case SYNC: {
                    this.earBit ^= 0x40;
                    this.clock.setTimeout(this.sync2Lenght);
                    if (this.blockLen > 0) {
                        this.statePlay = State.NEWBYTE;
                        break;
                    }
                    this.statePlay = State.PAUSE;
                    break;
                }
                case NEWBYTE_NOCHG: {
                    this.earBit ^= 0x40;
                }
                case NEWBYTE: {
                    this.mask = 128;
                }
                case NEWBIT: {
                    this.earBit ^= 0x40;
                    this.bitTime = (this.tapeBuffer[this.tapePos] & this.mask) == 0 ? this.zeroLenght : this.oneLenght;
                    this.statePlay = State.HALF2;
                    this.clock.setTimeout(this.bitTime);
                    break;
                }
                case HALF2: {
                    this.earBit ^= 0x40;
                    this.clock.setTimeout(this.bitTime);
                    this.mask >>>= 1;
                    if (this.blockLen == 1 && this.bitsLastByte < 8 && this.mask == 128 >>> this.bitsLastByte) {
                        this.statePlay = State.LAST_PULSE;
                        ++this.tapePos;
                        break;
                    }
                    if (this.mask != 0) {
                        this.statePlay = State.NEWBIT;
                        break;
                    }
                    ++this.tapePos;
                    if (--this.blockLen > 0) {
                        this.statePlay = State.NEWBYTE;
                        break;
                    }
                    this.statePlay = State.LAST_PULSE;
                    break;
                }
                case LAST_PULSE: {
                    this.earBit ^= 0x40;
                    if (this.endBlockPause == 0) {
                        this.statePlay = State.TZX_HEADER;
                        repeat = true;
                        break;
                    }
                    this.statePlay = State.PAUSE;
                    this.clock.setTimeout(3500);
                    break;
                }
                case PAUSE: {
                    this.earBit = this.settings.isInvertedEar() ? 255 : 191;
                    this.statePlay = State.TZX_HEADER;
                    this.clock.setTimeout(this.endBlockPause);
                    break;
                }
                case TZX_HEADER: {
                    if (this.idxHeader >= this.nOffsetBlocks) {
                        this.statePlay = State.STOP;
                        repeat = true;
                        break;
                    }
                    this.decodeTzxHeader();
                    repeat = true;
                    break;
                }
                case PURE_TONE: {
                    this.earBit ^= 0x40;
                }
                case PURE_TONE_NOCHG: {
                    if (this.leaderPulses-- > 0) {
                        this.clock.setTimeout(this.leaderLenght);
                        this.statePlay = State.PURE_TONE;
                        break;
                    }
                    this.statePlay = State.TZX_HEADER;
                    repeat = true;
                    break;
                }
                case PULSE_SEQUENCE: {
                    this.earBit ^= 0x40;
                }
                case PULSE_SEQUENCE_NOCHG: {
                    if (this.leaderPulses-- > 0) {
                        this.clock.setTimeout(this.readInt(this.tapeBuffer, this.tapePos, 2));
                        this.tapePos += 2;
                        this.statePlay = State.PULSE_SEQUENCE;
                        break;
                    }
                    this.statePlay = State.TZX_HEADER;
                    repeat = true;
                    break;
                }
                case NEWDR_BYTE: {
                    this.mask = 128;
                    this.statePlay = State.NEWDR_BIT;
                }
                case NEWDR_BIT: {
                    boolean earState;
                    if ((this.tapeBuffer[this.tapePos] & this.mask) != 0) {
                        earState = true;
                        this.earBit = 255;
                    } else {
                        earState = false;
                        this.earBit = 191;
                    }
                    int timeout = 0;
                    while ((this.tapeBuffer[this.tapePos] & this.mask) != 0 == earState) {
                        timeout += this.zeroLenght;
                        this.mask >>>= 1;
                        if (this.mask == 0) {
                            this.mask = 128;
                            ++this.tapePos;
                            if (--this.blockLen != 0) continue;
                            this.statePlay = State.LAST_PULSE;
                            break;
                        }
                        if (this.blockLen != 1 || this.bitsLastByte >= 8 || this.mask != 128 >>> this.bitsLastByte) continue;
                        this.statePlay = State.LAST_PULSE;
                        ++this.tapePos;
                        break;
                    }
                    this.clock.setTimeout(timeout);
                    break;
                }
                case PAUSE_STOP: {
                    if (this.endBlockPause == 0) {
                        this.statePlay = State.STOP;
                        repeat = true;
                        break;
                    }
                    this.earBit = this.settings.isInvertedEar() ? 255 : 191;
                    this.statePlay = State.TZX_HEADER;
                    this.clock.setTimeout(this.endBlockPause);
                    break;
                }
                case CSW_RLE: {
                    if (this.blockLen == 0) {
                        this.statePlay = State.PAUSE;
                        repeat = true;
                    }
                    this.earBit ^= 0x40;
                    int timeout = this.tapeBuffer[this.tapePos++] & 0xFF;
                    --this.blockLen;
                    if (timeout == 0) {
                        timeout = this.readInt(this.tapeBuffer, this.tapePos, 4);
                        this.tapePos += 4;
                        this.blockLen -= 4;
                    }
                    timeout = (int)((float)timeout * this.cswStatesSample);
                    this.clock.setTimeout(timeout);
                    break;
                }
                case CSW_ZRLE: {
                    int timeout;
                    this.earBit ^= 0x40;
                    try {
                        if (timeout < 0) {
                            this.iis.close();
                            this.bais.close();
                            repeat = true;
                            this.statePlay = State.PAUSE;
                            break;
                        }
                        if (timeout == 0) {
                            int count;
                            byte[] nSamples = new byte[4];
                            for (timeout = this.iis.read(); timeout < 4 && (count = this.iis.read(nSamples, timeout, nSamples.length - timeout)) != -1; timeout += count) {
                            }
                            if (timeout == 4) {
                                timeout = this.readInt(nSamples, 0, 4);
                            } else {
                                this.iis.close();
                                this.bais.close();
                                repeat = true;
                                this.statePlay = State.PAUSE;
                                break;
                            }
                        }
                        timeout = (int)((float)timeout * this.cswStatesSample);
                        this.clock.setTimeout(timeout);
                        break;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        } while (repeat);
        return true;
    }

    private void decodeTzxHeader() {
        boolean repeat = true;
        block27: while (repeat) {
            if (this.idxHeader >= this.nOffsetBlocks) {
                return;
            }
            this.fireTapeBlockChanged(this.idxHeader);
            this.tapePos = this.offsetBlocks[this.idxHeader];
            switch (this.tapeBuffer[this.tapePos] & 0xFF) {
                case 16: {
                    this.leaderLenght = 2168;
                    this.sync1Lenght = 667;
                    this.sync2Lenght = 735;
                    this.zeroLenght = 855;
                    this.oneLenght = 1710;
                    this.bitsLastByte = 8;
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 1, 2) * 3500;
                    this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 3, 2);
                    this.tapePos += 5;
                    this.leaderPulses = (this.tapeBuffer[this.tapePos] & 0xFF) < 128 ? 8063 : 3223;
                    this.statePlay = State.LEADER_NOCHG;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 17: {
                    this.leaderLenght = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.sync1Lenght = this.readInt(this.tapeBuffer, this.tapePos + 3, 2);
                    this.sync2Lenght = this.readInt(this.tapeBuffer, this.tapePos + 5, 2);
                    this.zeroLenght = this.readInt(this.tapeBuffer, this.tapePos + 7, 2);
                    this.oneLenght = this.readInt(this.tapeBuffer, this.tapePos + 9, 2);
                    this.leaderPulses = this.readInt(this.tapeBuffer, this.tapePos + 11, 2);
                    this.bitsLastByte = this.tapeBuffer[this.tapePos + 13] & 0xFF;
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 14, 2) * 3500;
                    this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 16, 3);
                    this.tapePos += 19;
                    this.statePlay = State.LEADER_NOCHG;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 18: {
                    this.leaderLenght = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.leaderPulses = this.readInt(this.tapeBuffer, this.tapePos + 3, 2);
                    this.tapePos += 5;
                    this.statePlay = State.PURE_TONE_NOCHG;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 19: {
                    this.leaderPulses = this.tapeBuffer[this.tapePos + 1] & 0xFF;
                    this.tapePos += 2;
                    this.statePlay = State.PULSE_SEQUENCE_NOCHG;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 20: {
                    this.zeroLenght = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.oneLenght = this.readInt(this.tapeBuffer, this.tapePos + 3, 2);
                    this.bitsLastByte = this.tapeBuffer[this.tapePos + 5] & 0xFF;
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 6, 2) * 3500;
                    this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 8, 3);
                    this.tapePos += 11;
                    this.statePlay = State.NEWBYTE_NOCHG;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 21: {
                    this.zeroLenght = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 3, 2) * 3500;
                    this.bitsLastByte = this.tapeBuffer[this.tapePos + 5] & 0xFF;
                    this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 6, 3);
                    this.tapePos += 9;
                    this.statePlay = State.NEWDR_BYTE;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 24: {
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 5, 2) * 3500;
                    this.cswStatesSample = 3500000.0f / (float)this.readInt(this.tapeBuffer, this.tapePos + 7, 3);
                    this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 1, 4) - 10;
                    if (this.tapeBuffer[this.tapePos + 10] == 2) {
                        this.statePlay = State.CSW_ZRLE;
                        this.bais = new ByteArrayInputStream(this.tapeBuffer, this.tapePos + 15, this.blockLen);
                        this.iis = new InflaterInputStream(this.bais);
                    } else {
                        this.statePlay = State.CSW_RLE;
                    }
                    this.tapePos += 15;
                    ++this.idxHeader;
                    this.earBit ^= 0x40;
                    repeat = false;
                    continue block27;
                }
                case 25: {
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 5, 2) * 3500;
                    this.totp = this.readInt(this.tapeBuffer, this.tapePos + 7, 4);
                    this.npp = this.tapeBuffer[this.tapePos + 11] & 0xFF;
                    this.asp = this.tapeBuffer[this.tapePos + 12] & 0xFF;
                    this.totd = this.readInt(this.tapeBuffer, this.tapePos + 13, 4);
                    this.npd = this.tapeBuffer[this.tapePos + 17] & 0xFF;
                    this.asd = this.tapeBuffer[this.tapePos + 18] & 0xFF;
                    ++this.idxHeader;
                    System.out.println("Gen. Data Block not supported!. Skipping...");
                    continue block27;
                }
                case 32: {
                    this.endBlockPause = this.readInt(this.tapeBuffer, this.tapePos + 1, 2) * 3500;
                    this.tapePos += 3;
                    this.statePlay = State.PAUSE_STOP;
                    ++this.idxHeader;
                    repeat = false;
                    continue block27;
                }
                case 33: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 34: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 35: {
                    short target = (short)this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.idxHeader += target;
                    continue block27;
                }
                case 36: {
                    this.nLoops = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                    this.loopStart = ++this.idxHeader;
                    continue block27;
                }
                case 37: {
                    if (--this.nLoops == 0) {
                        ++this.idxHeader;
                        continue block27;
                    }
                    this.idxHeader = this.loopStart;
                    continue block27;
                }
                case 38: {
                    if (this.callSeq == null) {
                        this.nCalls = this.readInt(this.tapeBuffer, this.tapePos + 1, 2);
                        this.callSeq = new short[this.nCalls];
                        for (int idx = 0; idx < this.nCalls; ++idx) {
                            this.callSeq[idx] = (short)this.readInt(this.tapeBuffer, this.tapePos + idx * 2 + 3, 2);
                        }
                        this.callBlk = this.idxHeader;
                        this.nCalls = 0;
                        this.idxHeader += this.callSeq[this.nCalls++];
                        continue block27;
                    }
                    System.out.println("The CALL blocks can't be nested!. Skipping!!!");
                    ++this.idxHeader;
                    continue block27;
                }
                case 39: {
                    if (this.nCalls < this.callSeq.length) {
                        this.idxHeader = this.callBlk + this.callSeq[this.nCalls++];
                        continue block27;
                    }
                    this.idxHeader = this.callBlk + 1;
                    this.callSeq = null;
                    continue block27;
                }
                case 40: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 42: {
                    if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                        this.statePlay = State.STOP;
                        repeat = false;
                    }
                    ++this.idxHeader;
                    continue block27;
                }
                case 43: {
                    this.earBit = this.tapeBuffer[this.tapePos + 5] == 0 ? 191 : 255;
                    ++this.idxHeader;
                    continue block27;
                }
                case 48: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 49: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 50: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 51: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 53: {
                    ++this.idxHeader;
                    continue block27;
                }
                case 90: {
                    ++this.idxHeader;
                    continue block27;
                }
            }
            System.out.println(String.format("Block ID: %02x", this.tapeBuffer[this.tapePos]));
            repeat = false;
            ++this.idxHeader;
        }
    }

    private void printGDBHeader(int index) {
        int npulse;
        int symbol;
        int offset;
        int blkLenght = this.readInt(this.tapeBuffer, ++index, 4);
        System.out.println(String.format("GDB size: %d bytes", blkLenght));
        System.out.println(String.format("End Block Pause: %d ms", this.endBlockPause));
        System.out.println(String.format("Total number of symbols in pilot/sync block (TOTP): %d", this.totp));
        System.out.println(String.format("Maximum number of pulses per pilot/sync symbol (NPP): %d", this.npp));
        System.out.println(String.format("Number of pilot/sync symbols in the alphabet table (ASP): %d", this.asp));
        if (this.totp > 0) {
            offset = index + 18;
            for (symbol = 0; symbol < this.asp; ++symbol) {
                System.out.print(String.format("\tSymbol %d, type %d: ", symbol, this.tapeBuffer[offset++] & 0xFF));
                for (npulse = 0; npulse < this.npp; ++npulse) {
                    System.out.print(String.format("%d ", this.readInt(this.tapeBuffer, offset, 2)));
                    offset += 2;
                }
                System.out.println("");
            }
            for (int pulse = 0; pulse < this.totp; ++pulse) {
                System.out.println(String.format("\t\tRepeat %d: symbol %d repeated %d times", pulse, this.tapeBuffer[offset++] & 0xFF, this.readInt(this.tapeBuffer, offset, 2)));
                offset += 2;
            }
        }
        System.out.println(String.format("Total number of symbols in data stream (TOTD): %d", this.totd));
        System.out.println(String.format("Maximum number of pulses per data symbol (NPD): %d", this.npd));
        System.out.println(String.format("Number of data symbols in the alphabet table (ASD): %d", this.asd));
        offset = index + 18;
        if (this.totp > 0) {
            offset += (2 * this.npp + 1) * this.asp + this.totp * 3;
        }
        for (symbol = 0; symbol < this.asd; ++symbol) {
            System.out.print(String.format("\tSymbol %d, type %d: ", symbol, this.tapeBuffer[offset++] & 0xFF));
            for (npulse = 0; npulse < this.npd; ++npulse) {
                System.out.print(String.format("%d ", this.readInt(this.tapeBuffer, offset, 2)));
                offset += 2;
            }
            System.out.println("");
        }
    }

    private boolean playCsw() {
        switch (this.statePlay) {
            case STOP: {
                ++this.idxHeader;
                this.stop();
                break;
            }
            case START: {
                if ((this.tapeBuffer[23] & 0xFF) == 1) {
                    this.earBit = (this.tapeBuffer[28] & 1) != 0 ? 191 : 255;
                    this.cswStatesSample = 3500000.0f / (float)this.readInt(this.tapeBuffer, 25, 2);
                    this.tapePos = 32;
                    this.statePlay = State.CSW_RLE;
                } else {
                    this.earBit = (this.tapeBuffer[34] & 1) != 0 ? 191 : 255;
                    this.cswStatesSample = 3500000.0f / (float)this.readInt(this.tapeBuffer, 25, 4);
                    this.tapePos = 52 + this.tapeBuffer[35];
                    if ((this.tapeBuffer[33] & 0xFF) == 2) {
                        this.bais = new ByteArrayInputStream(this.tapeBuffer, this.tapePos, this.tapeBuffer.length - this.tapePos);
                        this.iis = new InflaterInputStream(this.bais);
                        this.statePlay = State.CSW_ZRLE;
                        this.clock.setTimeout(1);
                        return true;
                    }
                    this.statePlay = State.CSW_RLE;
                }
            }
            case CSW_RLE: {
                int timeout;
                if (this.tapePos == this.tapeBuffer.length) {
                    this.stop();
                    break;
                }
                this.earBit ^= 0x40;
                if ((timeout = this.tapeBuffer[this.tapePos++] & 0xFF) == 0) {
                    timeout = this.readInt(this.tapeBuffer, this.tapePos, 4);
                    this.tapePos += 4;
                }
                timeout = (int)((float)timeout * this.cswStatesSample);
                this.clock.setTimeout(timeout);
                break;
            }
            case CSW_ZRLE: {
                this.earBit ^= 0x40;
                try {
                    int timeout;
                    if (timeout < 0) {
                        this.iis.close();
                        this.bais.close();
                        this.stop();
                        break;
                    }
                    if (timeout == 0) {
                        int count;
                        byte[] nSamples = new byte[4];
                        for (timeout = this.iis.read(); timeout < 4 && (count = this.iis.read(nSamples, timeout, nSamples.length - timeout)) != -1; timeout += count) {
                        }
                        if (timeout == 4) {
                            timeout = this.readInt(nSamples, 0, 4);
                        } else {
                            this.iis.close();
                            this.bais.close();
                            this.stop();
                            break;
                        }
                    }
                    timeout = (int)((float)timeout * this.cswStatesSample);
                    this.clock.setTimeout(timeout);
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return true;
    }

    public boolean flashLoad(Memory memory) {
        int count;
        if (this.tapeExtension == TapeExtensionType.NO_TAPE || this.cpu == null || this.tapeExtension != TapeExtensionType.TAP && this.tapeExtension != TapeExtensionType.TZX) {
            return false;
        }
        if (this.idxHeader >= this.nOffsetBlocks) {
            return false;
        }
        if (this.tapeExtension == TapeExtensionType.TZX) {
            block4: while (this.idxHeader < this.nOffsetBlocks) {
                this.tapePos = this.offsetBlocks[this.idxHeader];
                switch (this.tapeBuffer[this.tapePos] & 0xFF) {
                    case 16: 
                    case 17: {
                        break block4;
                    }
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 43: {
                        return false;
                    }
                    default: {
                        ++this.idxHeader;
                        continue block4;
                    }
                }
            }
            if (this.idxHeader >= this.nOffsetBlocks) {
                return false;
            }
            this.fireTapeBlockChanged(this.idxHeader);
            if (this.tapeBuffer[this.tapePos] == 16) {
                this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 3, 2);
                this.tapePos += 5;
            } else {
                this.blockLen = this.readInt(this.tapeBuffer, this.tapePos + 16, 3);
                this.tapePos += 19;
            }
        } else {
            this.tapePos = this.offsetBlocks[this.idxHeader];
            this.blockLen = this.readInt(this.tapeBuffer, this.tapePos, 2);
            this.tapePos += 2;
        }
        if (this.cpu.getRegA() != (this.tapeBuffer[this.tapePos] & 0xFF)) {
            this.cpu.xor(this.tapeBuffer[this.tapePos]);
            this.cpu.setCarryFlag(false);
            ++this.idxHeader;
            return true;
        }
        this.cpu.setRegA(this.tapeBuffer[this.tapePos]);
        int addr = this.cpu.getRegIX();
        int nBytes = this.cpu.getRegDE();
        for (count = 0; count < nBytes && count < this.blockLen - 1; ++count) {
            memory.writeByte(addr, this.tapeBuffer[this.tapePos + count + 1]);
            this.cpu.xor(this.tapeBuffer[this.tapePos + count + 1]);
            addr = addr + 1 & 0xFFFF;
        }
        if (count == nBytes) {
            this.cpu.xor(this.tapeBuffer[this.tapePos + count + 1]);
            this.cpu.cp(1);
        }
        if (count < nBytes) {
            this.cpu.setFlags(80);
        }
        this.cpu.setRegIX(addr);
        this.cpu.setRegDE(nBytes - count);
        ++this.idxHeader;
        this.fireTapeBlockChanged(this.idxHeader);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTapeBlock(Memory memory) {
        if (!this.filename.canWrite()) {
            return false;
        }
        int addr = this.cpu.getRegIX();
        int nBytes = this.cpu.getRegDE();
        BufferedOutputStream fOut = null;
        this.record = new ByteArrayOutputStream();
        if (this.filename.getName().toLowerCase().endsWith("tzx")) {
            if (this.nOffsetBlocks == 0) {
                byte[] idTZX;
                byte[] hdrTZX;
                try {
                    hdrTZX = tzxHeader.getBytes("US-ASCII");
                    idTZX = tzxCreator.getBytes("US-ASCII");
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
                this.record.write(hdrTZX, 0, hdrTZX.length);
                this.record.write(1);
                this.record.write(20);
                this.record.write(48);
                this.record.write(idTZX.length);
                this.record.write(idTZX, 0, idTZX.length);
            }
            this.record.write(16);
            this.record.write(232);
            this.record.write(3);
        }
        this.record.write(nBytes + 2);
        this.record.write(nBytes + 2 >>> 8);
        int parity = this.cpu.getRegA();
        this.record.write(parity);
        for (int address = addr; address < addr + nBytes; ++address) {
            byte value = memory.readByte(address);
            this.record.write(value);
            parity ^= value;
        }
        this.record.write(parity);
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(this.filename, true));
            this.record.writeTo(fOut);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                this.record.close();
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        File tmp = this.filename;
        this.eject();
        this.insert(tmp);
        return true;
    }

    public boolean startRecording() {
        if (!this.isTapeReady() || !this.filename.getName().toLowerCase().endsWith(".tzx")) {
            return false;
        }
        this.record = new ByteArrayOutputStream();
        this.timeLastOut = 0L;
        this.tapeRecording = true;
        if (this.settings.isHighSamplingFreq()) {
            this.freqSample = 48000;
            this.cswStatesSample = 3500000.0f / (float)this.freqSample;
            this.cswPulses = 0;
            this.dos = new DeflaterOutputStream(this.record);
        } else {
            this.freqSample = 79;
        }
        this.fireTapeStateChanged(TapeState.RECORD);
        return true;
    }

    public boolean stopRecording() {
        if (!this.tapeRecording) {
            return false;
        }
        FilterOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(this.filename, true));
            if (this.nOffsetBlocks == 0) {
                fOut.write(tzxHeader.getBytes("US-ASCII"));
                ((BufferedOutputStream)fOut).write(1);
                ((BufferedOutputStream)fOut).write(20);
                byte[] idTZX = tzxCreator.getBytes("US-ASCII");
                ((BufferedOutputStream)fOut).write(48);
                ((BufferedOutputStream)fOut).write(idTZX.length);
                fOut.write(idTZX);
            }
            if (this.settings.isHighSamplingFreq()) {
                this.dos.close();
                this.record.close();
                ((BufferedOutputStream)fOut).write(24);
                ((BufferedOutputStream)fOut).write(this.record.size() + 10);
                ((BufferedOutputStream)fOut).write(this.record.size() + 10 >>> 8);
                ((BufferedOutputStream)fOut).write(this.record.size() + 10 >>> 16);
                ((BufferedOutputStream)fOut).write(this.record.size() + 10 >>> 24);
                ((BufferedOutputStream)fOut).write(0);
                ((BufferedOutputStream)fOut).write(0);
                ((BufferedOutputStream)fOut).write(this.freqSample);
                ((BufferedOutputStream)fOut).write(this.freqSample >>> 8);
                ((BufferedOutputStream)fOut).write(this.freqSample >>> 16);
                ((BufferedOutputStream)fOut).write(2);
                ((BufferedOutputStream)fOut).write(this.cswPulses);
                ((BufferedOutputStream)fOut).write(this.cswPulses >>> 8);
                ((BufferedOutputStream)fOut).write(this.cswPulses >>> 16);
                ((BufferedOutputStream)fOut).write(this.cswPulses >>> 24);
                this.record.writeTo(fOut);
            } else {
                if (this.bitsLastByte != 0) {
                    this.byteTmp = (byte)(this.byteTmp << 8 - this.bitsLastByte);
                    this.record.write(this.byteTmp);
                }
                ((BufferedOutputStream)fOut).write(21);
                ((BufferedOutputStream)fOut).write(this.freqSample);
                ((BufferedOutputStream)fOut).write(0);
                ((BufferedOutputStream)fOut).write(0);
                ((BufferedOutputStream)fOut).write(0);
                ((BufferedOutputStream)fOut).write(this.bitsLastByte);
                ((BufferedOutputStream)fOut).write(this.record.size());
                ((BufferedOutputStream)fOut).write(this.record.size() >>> 8);
                ((BufferedOutputStream)fOut).write(this.record.size() >>> 16);
                this.record.close();
                this.record.writeTo(fOut);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tapeRecording = false;
        File tmp = this.filename;
        this.eject();
        this.insert(tmp);
        return true;
    }

    public void recordPulse(boolean micState) {
        block9: {
            if (this.timeLastOut == 0L) {
                this.timeLastOut = this.clock.getAbsTstates();
                this.micBit = micState;
                return;
            }
            int len = (int)(this.clock.getAbsTstates() - this.timeLastOut);
            if (this.settings.isHighSamplingFreq()) {
                ++this.cswPulses;
                int pulses = (int)((float)len / this.cswStatesSample + 0.49f);
                try {
                    if (pulses > 255) {
                        this.dos.write(0);
                        this.dos.write(pulses);
                        this.dos.write(pulses >>> 8);
                        this.dos.write(pulses >>> 16);
                        this.dos.write(pulses >>> 24);
                        break block9;
                    }
                    this.dos.write(pulses);
                }
                catch (IOException ex) {
                    Logger.getLogger(Tape.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int pulses = len + (this.freqSample >>> 1);
                pulses /= this.freqSample;
                while (pulses-- > 0) {
                    if (this.bitsLastByte == 8) {
                        this.record.write(this.byteTmp);
                        this.bitsLastByte = 0;
                        this.byteTmp = 0;
                    }
                    this.byteTmp = (byte)(this.byteTmp << 1);
                    if (this.micBit) {
                        this.byteTmp = (byte)(this.byteTmp | 1);
                    }
                    ++this.bitsLastByte;
                }
            }
        }
        this.timeLastOut = this.clock.getAbsTstates();
        this.micBit = micState;
    }

    public class TapeTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return Tape.this.getNumBlocks();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String msg;
            switch (col) {
                case 0: {
                    return String.format("%4d", row + 1);
                }
                case 1: {
                    msg = Tape.this.getBlockType(row);
                    break;
                }
                case 2: {
                    msg = Tape.this.getBlockInfo(row);
                    break;
                }
                default: {
                    return "NON EXISTENT COLUMN!";
                }
            }
            return msg;
        }

        @Override
        public String getColumnName(int col) {
            String msg;
            ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
            switch (col) {
                case 0: {
                    msg = bundle.getString("JSpeccy.tapeCatalog.columnModel.title0");
                    break;
                }
                case 1: {
                    msg = bundle.getString("JSpeccy.tapeCatalog.columnModel.title1");
                    break;
                }
                case 2: {
                    msg = bundle.getString("JSpeccy.tapeCatalog.columnModel.title2");
                    break;
                }
                default: {
                    msg = "COLUMN ERROR!";
                }
            }
            return msg;
        }
    }

    private static enum TapeExtensionType {
        NO_TAPE,
        TAP,
        TZX,
        CSW;

    }

    private static enum State {
        STOP,
        START,
        LEADER,
        LEADER_NOCHG,
        SYNC,
        NEWBYTE,
        NEWBYTE_NOCHG,
        NEWBIT,
        HALF2,
        LAST_PULSE,
        PAUSE,
        TZX_HEADER,
        PURE_TONE,
        PURE_TONE_NOCHG,
        PULSE_SEQUENCE,
        PULSE_SEQUENCE_NOCHG,
        NEWDR_BYTE,
        NEWDR_BIT,
        PAUSE_STOP,
        CSW_RLE,
        CSW_ZRLE;

    }

    public static enum TapeState {
        EJECT,
        INSERT,
        STOP,
        PLAY,
        RECORD;

    }
}

