/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import machine.Clock;

public class Microdrive {
    private static final int RAW_SECTOR_SIZE = 792;
    private static final int MDR_SECTOR_SIZE = 587;
    private static final int MDR_HEADER_SIZE = 15;
    private static final int MDR_RECORD_SIZE = 528;
    private static final int MDR_GAP_LENGTH = 10;
    private static final String mdvtID = "MDVT";
    private static final int timeTransfer = 168;
    private static final int MDVT_WR_PROT = 1;
    private static final int MDVT_COMPRESSED = 2;
    private static final int MDVT_MDR_CONVERTED = 4;
    private static final int MDVT_UNFORMATTED = 8;
    private static final byte GAP = 4;
    private static final byte SYNC = 2;
    private static final byte WRITE_PROT_MASK = -2;
    private static final byte CLOCK_GAP = 4;
    private static final byte CLOCK_DATA = 0;
    private static final byte DATA_FILLER = 90;
    private static final byte[] preamble = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private byte[] cartridge;
    private byte[] clockGap;
    private byte lastData;
    private int status;
    private int cartridgePos = 0;
    private int numSectors;
    private int mdrSectors;
    private int sectorSize;
    private boolean isCartridge = false;
    private boolean modified;
    private boolean unformatted;
    private boolean writeProtected = true;
    private boolean wrGapPending;
    private boolean mdrFile = false;
    private BufferedInputStream fIn;
    private BufferedOutputStream fOut;
    private File filename;
    private final Clock clock = Clock.getInstance();
    private long startGap;

    public void selected() {
        if (!this.isCartridge) {
            return;
        }
        this.wrGapPending = false;
        int pos = this.cartridgePos - 1;
        if (pos < 0) {
            pos = this.clockGap.length - 1;
        }
        while (this.clockGap[this.cartridgePos] == 0 && this.cartridgePos != pos) {
            if (++this.cartridgePos < this.clockGap.length) continue;
            this.cartridgePos = 0;
        }
        if (++this.cartridgePos >= this.clockGap.length) {
            this.cartridgePos = 0;
        }
    }

    public int readStatus() {
        if (!this.isCartridge) {
            return 245;
        }
        if (this.wrGapPending) {
            return 251;
        }
        this.status = 249;
        if (this.clockGap[this.cartridgePos] != 0) {
            this.status |= 4;
        }
        if (this.clockGap[this.cartridgePos] == 0 && (this.lastData & this.cartridge[this.cartridgePos]) == 0) {
            this.status |= 2;
        }
        this.lastData = this.cartridge[this.cartridgePos];
        if (++this.cartridgePos >= this.clockGap.length) {
            this.cartridgePos = 0;
        }
        if (this.writeProtected) {
            this.status &= 0xFFFFFFFE;
        }
        return this.status & 0xFF;
    }

    public int readData() {
        if (!this.isCartridge) {
            return 255;
        }
        this.lastData = this.cartridge[this.cartridgePos];
        if (++this.cartridgePos >= this.clockGap.length) {
            this.cartridgePos = 0;
        }
        this.clock.addTstates(168);
        return this.lastData & 0xFF;
    }

    public void writeControl(int value) {
        if (!this.isCartridge) {
            return;
        }
        int op = value & 0xC;
        if (op == 4 && !this.wrGapPending) {
            this.startGap = this.clock.getAbsTstates();
            this.wrGapPending = true;
            return;
        }
        if ((op == 0 || op == 12) && this.wrGapPending) {
            long gapLen = (this.clock.getAbsTstates() - this.startGap) / 168L;
            while (gapLen-- > 0L) {
                this.cartridge[this.cartridgePos] = 90;
                this.clockGap[this.cartridgePos] = 4;
                if (++this.cartridgePos < this.clockGap.length) continue;
                this.cartridgePos = 0;
            }
            this.wrGapPending = false;
        }
    }

    public void writeData(int value) {
        if (!this.isCartridge) {
            return;
        }
        this.clockGap[this.cartridgePos] = 0;
        this.cartridge[this.cartridgePos] = (byte)value;
        this.modified = true;
        this.unformatted = false;
        if (++this.cartridgePos >= this.clockGap.length) {
            this.cartridgePos = 0;
        }
        this.clock.addTstates(168);
    }

    public boolean isWriteProtected() {
        if (!this.isCartridge) {
            return true;
        }
        return this.writeProtected;
    }

    public void setWriteProtected(boolean flag) {
        if (!this.isCartridge) {
            return;
        }
        this.writeProtected = flag;
        this.modified = true;
    }

    public boolean isCartridge() {
        return this.isCartridge;
    }

    public boolean isModified() {
        return this.modified;
    }

    public final boolean insertNew(int numSectors) {
        if (this.isCartridge) {
            return false;
        }
        this.cartridge = new byte[numSectors * 792];
        this.clockGap = new byte[numSectors * 792];
        Arrays.fill(this.cartridge, (byte)90);
        Arrays.fill(this.clockGap, (byte)4);
        this.isCartridge = true;
        this.mdrFile = false;
        this.writeProtected = false;
        this.unformatted = true;
        this.modified = true;
        this.filename = null;
        this.numSectors = numSectors;
        this.cartridgePos = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insertFromFile(File fileName) {
        block96: {
            if (this.isCartridge) {
                return false;
            }
            this.isCartridge = false;
            try {
                boolean bl;
                int count;
                int count2;
                this.fIn = new BufferedInputStream(new FileInputStream(fileName));
                if (fileName.getName().toLowerCase().endsWith(".mdr")) {
                    this.mdrFile = true;
                    int mdrLen = this.fIn.available();
                    int nsectors = this.mdrSectors = (mdrLen - 1) / 543;
                    int pos = 0;
                    this.clockGap = new byte[nsectors * 587];
                    this.cartridge = new byte[nsectors * 587];
                    while (nsectors-- > 0) {
                        int pream;
                        int gap;
                        for (gap = 0; gap < 10; ++gap) {
                            this.cartridge[pos] = 90;
                            this.clockGap[pos++] = 4;
                        }
                        for (pream = 0; pream < preamble.length; ++pream) {
                            this.cartridge[pos] = preamble[pream];
                            this.clockGap[pos++] = 0;
                        }
                        for (int header = 0; header < 15; ++header) {
                            this.cartridge[pos] = (byte)this.fIn.read();
                            this.clockGap[pos++] = 0;
                        }
                        for (gap = 0; gap < 10; ++gap) {
                            this.cartridge[pos] = 90;
                            this.clockGap[pos++] = 4;
                        }
                        for (pream = 0; pream < preamble.length; ++pream) {
                            this.cartridge[pos] = preamble[pream];
                            this.clockGap[pos++] = 0;
                        }
                        for (int data = 0; data < 528; ++data) {
                            this.cartridge[pos] = (byte)this.fIn.read();
                            this.clockGap[pos++] = 0;
                        }
                    }
                    this.writeProtected = true;
                    break block96;
                }
                byte[] blockID = new byte[4];
                int readed = this.fIn.read(blockID);
                if (readed != blockID.length) {
                    boolean pos = false;
                    return pos;
                }
                String readedID = new String(blockID, "US-ASCII");
                if (!mdvtID.equals(readedID)) {
                    boolean ex = false;
                    return ex;
                }
                readed = this.fIn.read(blockID);
                if (readed != blockID.length) {
                    boolean ex = false;
                    return ex;
                }
                int headerSize = blockID[0] & 0xFF | blockID[1] << 8 & 0xFF00 | blockID[2] << 16 & 0xFF0000 | blockID[3] << 24 & 0xFF000000;
                byte[] header = new byte[headerSize];
                readed = this.fIn.read(header);
                if (readed != header.length) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.mdrFile = (header[2] & 4) != 0;
                this.writeProtected = (header[2] & 1) != 0;
                this.unformatted = (header[2] & 8) != 0;
                this.sectorSize = header[4] & 0xFF | header[5] << 8 & 0xFF00;
                this.numSectors = header[6] & 0xFF | header[7] << 8 & 0xFF00;
                int gapEntries = header[10] & 0xFF | header[11] << 8 & 0xFF00;
                int lenTextField = this.fIn.read() & 0xFF;
                if (lenTextField > 0 && this.fIn.skip(lenTextField) != (long)lenTextField) {
                    boolean bl3 = false;
                    return bl3;
                }
                lenTextField = this.fIn.read() & 0xFF;
                if (lenTextField > 0 && this.fIn.skip(lenTextField) != (long)lenTextField) {
                    boolean bl4 = false;
                    return bl4;
                }
                lenTextField = this.fIn.read() & 0xFF;
                if (lenTextField > 0 && this.fIn.skip(lenTextField) != (long)lenTextField) {
                    boolean bl5 = false;
                    return bl5;
                }
                if ((header[2] & 8) != 0) {
                    this.cartridge = new byte[this.sectorSize * this.numSectors];
                    this.clockGap = new byte[this.sectorSize * this.numSectors];
                    Arrays.fill(this.cartridge, (byte)90);
                    Arrays.fill(this.clockGap, (byte)4);
                    this.isCartridge = true;
                    this.unformatted = true;
                    this.filename = fileName;
                    this.cartridgePos = 0;
                    boolean bl6 = true;
                    return bl6;
                }
                if ((header[2] & 2) != 0) {
                    byte[] cswGaps;
                    try (InflaterInputStream iis = new InflaterInputStream(this.fIn);){
                        int count3;
                        this.cartridge = new byte[this.sectorSize * this.numSectors];
                        for (readed = 0; readed < this.cartridge.length && (count3 = iis.read(this.cartridge, readed, this.cartridge.length - readed)) != -1; readed += count3) {
                        }
                        if (readed != this.cartridge.length) {
                            iis.close();
                            count3 = 0;
                            return count3 != 0;
                        }
                        cswGaps = new byte[gapEntries << 1];
                        for (readed = 0; readed < cswGaps.length; readed += count3) {
                            count3 = iis.read(cswGaps, readed, cswGaps.length - readed);
                            if (count3 != -1) continue;
                            break;
                        }
                    }
                    if (readed != cswGaps.length) {
                        boolean iis = false;
                        return iis;
                    }
                    this.clockGap = this.convertCswToGaps(header[9], cswGaps);
                    if (this.clockGap == null) {
                        boolean iis = false;
                        return iis;
                    }
                    break block96;
                }
                this.cartridge = new byte[this.sectorSize * this.numSectors];
                for (readed = 0; readed < this.cartridge.length && (count2 = this.fIn.read(this.cartridge, readed, this.cartridge.length - readed)) != -1; readed += count2) {
                }
                if (readed != this.cartridge.length) {
                    count2 = 0;
                    return count2 != 0;
                }
                byte[] cswGaps = new byte[gapEntries << 1];
                for (readed = 0; readed < cswGaps.length && (count = this.fIn.read(cswGaps, readed, cswGaps.length - readed)) != -1; readed += count) {
                }
                if (readed != cswGaps.length) {
                    bl = false;
                    return bl;
                }
                this.clockGap = this.convertCswToGaps(header[9], cswGaps);
                if (this.clockGap == null) {
                    bl = false;
                    return bl;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Microdrive.class.getName()).log(Level.SEVERE, null, ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (this.fIn != null) {
                        this.fIn.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Microdrive.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        }
        this.cartridgePos = 0;
        this.isCartridge = true;
        this.modified = false;
        this.filename = fileName;
        return true;
    }

    public final boolean eject() {
        if (!this.isCartridge) {
            return true;
        }
        this.isCartridge = false;
        this.modified = false;
        this.writeProtected = true;
        this.filename = null;
        this.cartridgePos = 0;
        return true;
    }

    public final String getFilename() {
        if (this.filename == null) {
            return null;
        }
        return this.filename.getName();
    }

    public final String getAbsolutePath() {
        if (this.filename == null) {
            return null;
        }
        return this.filename.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean save() {
        block33: {
            if (!this.isCartridge || !this.modified) {
                return true;
            }
            try {
                this.fOut = new BufferedOutputStream(new FileOutputStream(this.filename));
            }
            catch (FileNotFoundException fex) {
                Logger.getLogger(Microdrive.class.getName()).log(Level.SEVERE, null, fex);
                return false;
            }
            try {
                this.fOut.write(mdvtID.getBytes("US-ASCII"));
                this.fOut.write(12);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(1);
                this.fOut.write(0);
                int flags = 0;
                if (this.writeProtected) {
                    flags |= 1;
                }
                if (this.mdrFile) {
                    flags |= 4;
                }
                flags = this.unformatted ? (flags |= 8) : (flags |= 2);
                this.fOut.write(flags);
                this.fOut.write(flags >>> 8);
                if (this.mdrFile) {
                    this.fOut.write(587);
                    this.fOut.write(2);
                    this.fOut.write(this.mdrSectors);
                    this.fOut.write(this.mdrSectors >>> 8);
                    this.fOut.write(10);
                } else {
                    this.fOut.write(792);
                    this.fOut.write(3);
                    this.fOut.write(this.numSectors);
                    this.fOut.write(this.numSectors >>> 8);
                    this.fOut.write(0);
                }
                this.fOut.write(this.clockGap[0]);
                ByteArrayOutputStream buffer = null;
                if (this.unformatted) {
                    this.fOut.write(0);
                    this.fOut.write(0);
                } else {
                    buffer = this.createCswBuffer();
                    int buflen = buffer.size();
                    this.fOut.write(buflen >>> 1);
                    this.fOut.write(buflen >>> 9);
                }
                String creatorID = "JSpeccy 0.93";
                byte[] fieldText = creatorID.getBytes("UTF-8");
                int fieldLen = fieldText.length < 256 ? fieldText.length : 255;
                this.fOut.write(fieldLen);
                this.fOut.write(fieldText, 0, fieldLen);
                this.fOut.write(0);
                this.fOut.write(0);
                if (this.unformatted) break block33;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (DeflaterOutputStream dos = new DeflaterOutputStream(baos);){
                    dos.write(this.cartridge);
                    dos.write(buffer.toByteArray());
                }
                baos.writeTo(this.fOut);
            }
            catch (IOException ex) {
                Logger.getLogger(Microdrive.class.getName()).log(Level.SEVERE, null, ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (this.fOut != null) {
                        this.fOut.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Microdrive.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.modified = false;
        return true;
    }

    public final boolean save(File newName) {
        this.filename = newName;
        this.modified = true;
        return this.save();
    }

    public int getCartridgePos() {
        return this.cartridgePos;
    }

    public void setCartridgePos(int offset) {
        if (this.cartridge == null || offset < 0 || offset > this.cartridge.length - 1) {
            offset = 0;
        }
        this.cartridgePos = offset;
    }

    private ByteArrayOutputStream createCswBuffer() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte value = this.clockGap[0];
        int counter = 0;
        for (int pos = 0; pos < this.clockGap.length; ++pos) {
            if (this.clockGap[pos] == value) {
                ++counter;
                continue;
            }
            value = this.clockGap[pos];
            buffer.write(counter);
            buffer.write(counter >>> 8);
            counter = 1;
        }
        buffer.write(counter);
        buffer.write(counter >>> 8);
        return buffer;
    }

    private byte[] convertCswToGaps(byte firstGap, byte[] cswGaps) {
        byte[] dataGaps = new byte[this.cartridge.length];
        int nGap = 0;
        int idx = 0;
        firstGap = (byte)(firstGap == 0 ? 0 : 4);
        while (nGap < cswGaps.length) {
            int gapLen = cswGaps[nGap] & 0xFF | cswGaps[nGap + 1] << 8 & 0xFF00;
            nGap += 2;
            while (gapLen-- > 0) {
                dataGaps[idx++] = firstGap;
            }
            firstGap = (byte)(firstGap == 0 ? 4 : 0);
        }
        if (idx != dataGaps.length) {
            System.out.println("Error regenerating GAP info!");
            return null;
        }
        return dataGaps;
    }
}

