/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.splib.gui.caret;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import tv.porst.splib.gui.caret.ICaretListener;

public class JCaret {
    private static final int DEFAULT_BLINK_TIME = 500;
    private static final Color DEFAULT_CARET_COLOR = Color.RED;
    private final List<ICaretListener> m_listeners = new ArrayList<ICaretListener>();
    private final Timer m_caretTimer;
    private boolean m_isCaretVisible = false;
    private final Color m_caretColor = Color.RED;
    private final InternalListener m_listener = new InternalListener();

    public JCaret() {
        this(500, DEFAULT_CARET_COLOR);
    }

    public JCaret(Color caretColor) {
        this(500, caretColor);
    }

    public JCaret(int blinkPeriod) {
        this(blinkPeriod, DEFAULT_CARET_COLOR);
    }

    public JCaret(int blinkPeriod, Color caretColor) {
        if (blinkPeriod < 0) {
            throw new IllegalArgumentException("Error: Blink period can't be negative");
        }
        if (caretColor == null) {
            throw new NullPointerException("Error: Caret color can't be null");
        }
        this.m_caretTimer = new Timer(blinkPeriod, this.m_listener);
        this.m_caretTimer.setRepeats(true);
        this.m_caretTimer.start();
    }

    private void notifyListeners() {
        for (ICaretListener listener : this.m_listeners) {
            listener.caretStatusChanged(this);
        }
    }

    public void addCaretListener(ICaretListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void draw(Graphics g, int x, int y, int height) {
        if (g == null) {
            throw new NullPointerException("Error: Graphics context can't be null");
        }
        if (this.isVisible()) {
            Color oldColor = g.getColor();
            g.setColor(this.m_caretColor);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(oldColor);
        }
    }

    public boolean isVisible() {
        return this.m_isCaretVisible;
    }

    public void removeListener(ICaretListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setVisible(boolean isCaretVisible) {
        this.m_isCaretVisible = isCaretVisible;
        this.notifyListeners();
    }

    public void stop() {
        this.m_caretTimer.stop();
        this.m_caretTimer.removeActionListener(this.m_listener);
        this.setVisible(false);
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JCaret.this.m_isCaretVisible = !JCaret.this.m_isCaretVisible;
            JCaret.this.notifyListeners();
        }
    }
}

