/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.jhexview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import tv.porst.jhexview.ColoredRange;
import tv.porst.jhexview.ColoredRangeManager;
import tv.porst.jhexview.IColormap;
import tv.porst.jhexview.IDataChangedListener;
import tv.porst.jhexview.IDataProvider;
import tv.porst.jhexview.IHexViewListener;
import tv.porst.jhexview.IMenuCreator;
import tv.porst.splib.convert.ConvertHelpers;
import tv.porst.splib.gui.GuiHelpers;
import tv.porst.splib.gui.caret.ICaretListener;
import tv.porst.splib.gui.caret.JCaret;

public final class JHexView
extends JComponent {
    private static final long serialVersionUID = -2402458562501988128L;
    private static final int CHARACTERS_PER_BYTE = 2;
    private static final String[] HEX_BYTES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final int PADDING_OFFSETVIEW = 20;
    private static final int NIBBLES_PER_BYTE = 2;
    private final ArrayList<IHexViewListener> m_listeners = new ArrayList();
    private IDataProvider m_dataProvider;
    private int m_bytesPerRow = 16;
    private Font m_font = new Font(GuiHelpers.getMonospaceFont(), 0, 12);
    private long m_selectionStart = 0L;
    private long m_selectionLength = 0L;
    private Views m_activeView = Views.HEX_VIEW;
    private int m_hexViewWidth = 270;
    private int m_columnSpacing = 4;
    private int m_bytesPerColumn = 2;
    private Color m_bgColorOffset = Color.GRAY;
    private Color m_bgColorHex = Color.WHITE;
    private Color m_bgColorAscii = Color.WHITE;
    private Color m_fontColorOffsets = Color.WHITE;
    private Color m_fontColorHex1 = Color.BLUE;
    private Color m_fontColorHex2 = new Color(0x3399FF);
    private Color m_fontColorAscii = new Color(0x339900);
    private int m_rowHeight = 12;
    private int m_charWidth = 8;
    private final JScrollBar m_scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar m_horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private int m_firstRow = 0;
    private int m_firstColumn = 0;
    private long m_baseAddress = 0L;
    private int m_lastMouseX = 0;
    private int m_lastMouseY = 0;
    private boolean m_enabled = false;
    private final Color m_disabledColor = Color.GRAY;
    private final JCaret m_caret = new JCaret();
    private final int m_paddingHexLeft = 10;
    private final int m_paddingAsciiLeft = 10;
    private final int m_paddingTop = 16;
    private int m_charHeight = 8;
    private final Color m_colorHighlight = Color.LIGHT_GRAY;
    private DefinitionStatus m_status = DefinitionStatus.UNDEFINED;
    private IMenuCreator m_menuCreator;
    private AddressMode m_addressMode = AddressMode.HEXADECIMAL;
    private int m_offsetViewWidth;
    private final ColoredRangeManager[] m_coloredRanges = new ColoredRangeManager[10];
    private Graphics bufferGraphics;
    private BufferedImage img;
    private Timer m_updateTimer;
    private boolean m_firstDraw = true;
    private final InternalListener m_listener = new InternalListener();
    private final LeftAction m_leftAction = new LeftAction();
    private final RightAction m_rightAction = new RightAction();
    private final UpAction m_upAction = new UpAction();
    private final DownAction m_downAction = new DownAction();
    private final PageUpAction m_pageUpAction = new PageUpAction();
    private final PageDownAction m_pageDownAction = new PageDownAction();
    private final TabAction m_tabAction = new TabAction();
    private int m_lastHighlightedNibble;
    private IColormap m_colormap;
    private Color m_selectionColor = Color.YELLOW;
    private boolean m_flipBytes = false;

    public JHexView() {
        for (int i = 0; i < this.m_coloredRanges.length; ++i) {
            this.m_coloredRanges[i] = new ColoredRangeManager();
        }
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setFont(this.m_font);
        this.initListeners();
        this.initHotkeys();
        this.initScrollbar();
        this.img = new BufferedImage(this.getWidth() + 1 - this.m_scrollbar.getWidth(), this.getHeight() + 1 - this.m_horizontalScrollbar.getHeight(), 1);
        this.bufferGraphics = this.img.getGraphics();
        this.updateOffsetViewWidth();
        this.setEnabled(false);
    }

    private void calculateSizes() {
        this.m_rowHeight = this.getRowHeight(this.bufferGraphics);
        this.m_charHeight = this.getCharHeight(this.bufferGraphics);
        this.m_charWidth = this.getCharacterWidth(this.bufferGraphics);
    }

    private void changeBy(ActionEvent event, int length) {
        if (event.getModifiers() == 1) {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)length < 0L) {
                this.setSelectionLength(-this.getSelectionStart());
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)length < (long)(2 * this.m_dataProvider.getDataLength())) {
                this.setSelectionLength(this.getSelectionLength() + (long)length);
            } else {
                this.setSelectionLength((long)(2 * this.m_dataProvider.getDataLength()) - this.getSelectionStart());
            }
        } else {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)length < 0L) {
                this.setSelectionStart(0L);
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)length < (long)(2 * this.m_dataProvider.getDataLength())) {
                this.setSelectionStart(this.getSelectionStart() + this.getSelectionLength() + (long)length);
            } else {
                this.setSelectionStart(2 * this.m_dataProvider.getDataLength());
            }
            this.setSelectionLength(0L);
        }
        long newPosition = this.getSelectionStart() + this.getSelectionLength();
        if (newPosition < (long)(2 * this.getFirstVisibleByte())) {
            this.scrollToPosition(newPosition);
        } else if (newPosition >= (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()))) {
            long invisibleNibbles = newPosition - (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()));
            long scrollpos = (long)(2 * this.getFirstVisibleByte() + 2 * this.m_bytesPerRow) + invisibleNibbles;
            this.scrollToPosition(scrollpos);
        }
        this.m_caret.setVisible(true);
        this.repaint();
    }

    private void drawAsciiPanel(Graphics g) {
        int bytesToDraw;
        int initx;
        if (this.isEnabled()) {
            g.setColor(this.m_fontColorAscii);
        } else {
            g.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
        }
        int characterWidth = this.getCharacterWidth(g);
        int x = initx = this.getAsciiViewLeft() + 10;
        int y = 16;
        byte[] data = null;
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(this.getFirstVisibleOffset(), bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        long currentOffset = this.getFirstVisibleOffset();
        int i = 0;
        while (i < bytesToDraw) {
            ColoredRange range = this.findColoredRange(currentOffset);
            if (range != null && currentOffset + (long)bytesToDraw < range.getStart()) {
                range = null;
            }
            if (i != 0 && i % this.m_bytesPerRow == 0) {
                x = initx;
                y += this.m_rowHeight;
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                int c = data[i];
                c = ConvertHelpers.isPrintableCharacter((char)c) ? c : 46;
                String dataString = String.valueOf((char)c);
                if (this.isEnabled()) {
                    long normalizedOffset;
                    long l = normalizedOffset = this.m_flipBytes ? (currentOffset & (long)(-this.m_bytesPerColumn)) + (long)this.m_bytesPerColumn - currentOffset % (long)this.m_bytesPerColumn - 1L : currentOffset;
                    if (this.isSelectedOffset(normalizedOffset)) {
                        g.setColor(this.m_selectionColor);
                        g.fillRect(x, y - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        g.setColor(this.m_fontColorAscii);
                    } else if (range != null && range.containsOffset(currentOffset)) {
                        Color bgColor = range.getBackgroundColor();
                        if (bgColor != null) {
                            g.setColor(bgColor);
                        }
                        g.fillRect(x, y - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        g.setColor(range.getColor());
                    } else if (this.m_colormap != null && this.m_colormap.colorize(data, i)) {
                        Color backgroundColor = this.m_colormap.getBackgroundColor(data, i);
                        Color foregroundColor = this.m_colormap.getForegroundColor(data, i);
                        if (backgroundColor != null) {
                            g.setColor(backgroundColor);
                            g.fillRect(x, y - this.m_charHeight, this.m_charWidth, this.m_charHeight + 2);
                        }
                        if (foregroundColor != null) {
                            g.setColor(foregroundColor);
                        }
                    } else {
                        g.setColor(this.m_fontColorAscii);
                    }
                } else {
                    g.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
                }
                g.drawString(dataString, x, y);
            } else {
                g.drawString("?", x, y);
            }
            x += characterWidth;
            if (range != null && range.getStart() + (long)range.getSize() <= currentOffset && (range = this.findColoredRange(currentOffset)) != null && currentOffset + (long)bytesToDraw < range.getStart()) {
                range = null;
            }
            ++i;
            ++currentOffset;
        }
    }

    private void drawBackground(Graphics g) {
        g.setColor(this.m_bgColorOffset);
        g.fillRect(-this.m_firstColumn * this.m_charWidth, 0, this.m_offsetViewWidth, this.getHeight());
        g.setColor(this.m_bgColorHex);
        g.fillRect(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, 0, this.m_hexViewWidth, this.getHeight());
        g.setColor(this.m_bgColorAscii);
        g.fillRect(-this.m_firstColumn * this.m_charWidth + this.m_hexViewWidth + this.m_offsetViewWidth, 0, this.m_firstColumn * this.m_charWidth + this.getWidth() - (this.m_hexViewWidth + this.m_offsetViewWidth) - this.m_scrollbar.getWidth(), this.getHeight() - this.m_horizontalScrollbar.getHeight());
        g.setColor(Color.BLACK);
        g.drawLine(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, 0, -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth, this.getHeight());
        g.drawLine(-this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth + this.m_hexViewWidth, 0, -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth + this.m_hexViewWidth, this.getHeight());
    }

    private void drawCaret(Graphics g) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentOffset() < (long)this.getFirstVisibleByte() || this.getCurrentColumn() > this.getFirstVisibleByte() + this.getMaximumVisibleBytes()) {
            return;
        }
        int characterSize = this.getCharacterWidth(g);
        if (this.m_activeView == Views.HEX_VIEW) {
            this.drawCaretHexWindow(g, characterSize, this.m_rowHeight);
        } else {
            this.drawCaretAsciiWindow(g, characterSize, this.m_rowHeight);
        }
    }

    private void drawCaretAsciiWindow(Graphics g, int characterWidth, int characterHeight) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int currentCharacter = currentColumn / 2;
        int startLeft = 9 + this.m_offsetViewWidth + this.m_hexViewWidth;
        int x = -this.m_firstColumn * this.m_charWidth + startLeft + currentCharacter * characterWidth;
        int y = 19 - characterHeight + characterHeight * currentRow;
        this.m_caret.draw(g, x, y, characterHeight);
    }

    private void drawCaretHexWindow(Graphics g, int characterWidth, int characterHeight) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int startLeft = 9 + this.m_offsetViewWidth;
        int paddingColumns = currentColumn / (2 * this.m_bytesPerColumn) * this.m_columnSpacing;
        int x = -this.m_firstColumn * this.m_charWidth + startLeft + currentColumn * characterWidth + paddingColumns;
        int y = 19 - characterHeight + characterHeight * currentRow;
        this.m_caret.draw(g, x, y, characterHeight);
    }

    private void drawHexView(Graphics g) {
        int bytesToDraw;
        int firstX;
        int standardSize = 2 * this.getCharacterWidth(g);
        int x = firstX = -this.m_firstColumn * this.m_charWidth + 10 + this.m_offsetViewWidth;
        int y = 16;
        boolean evenColumn = true;
        byte[] data = null;
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(this.getFirstVisibleOffset(), bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        long currentOffset = this.getFirstVisibleOffset();
        int i = 0;
        while (i < bytesToDraw) {
            ColoredRange range = this.findColoredRange(currentOffset);
            if (i != 0) {
                if (i % this.m_bytesPerRow == 0) {
                    x = firstX;
                    y += this.m_rowHeight;
                    evenColumn = true;
                } else if (i % this.m_bytesPerColumn == 0) {
                    x += this.m_columnSpacing;
                    boolean bl = evenColumn = !evenColumn;
                }
            }
            if (this.isEnabled()) {
                if (this.isSelectedOffset(currentOffset)) {
                    g.setColor(this.m_selectionColor);
                    g.fillRect(x, y - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    g.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                } else if (range != null && range.containsOffset(currentOffset)) {
                    Color bgColor = range.getBackgroundColor();
                    if (bgColor != null) {
                        g.setColor(bgColor);
                    }
                    g.fillRect(x, y - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    g.setColor(range.getColor());
                } else if (this.m_colormap != null && this.m_colormap.colorize(data, i)) {
                    Color backgroundColor = this.m_colormap.getBackgroundColor(data, i);
                    Color foregroundColor = this.m_colormap.getForegroundColor(data, i);
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRect(x, y - this.m_charHeight, 2 * this.m_charWidth, this.m_charHeight + 2);
                    }
                    if (foregroundColor != null) {
                        g.setColor(foregroundColor);
                    }
                } else {
                    g.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                }
            } else {
                g.setColor(this.m_disabledColor != this.m_bgColorHex ? this.m_disabledColor : Color.WHITE);
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                int columnBytes = Math.min(this.m_dataProvider.getDataLength() - i, this.m_bytesPerColumn);
                int dataPosition = this.m_flipBytes ? i / this.m_bytesPerColumn * this.m_bytesPerColumn + (columnBytes - i % columnBytes - 1) : i;
                g.drawString(HEX_BYTES[data[dataPosition] & 0xFF], x, y);
            } else {
                g.drawString("??", x, y);
            }
            x += standardSize;
            ++i;
            ++currentOffset;
        }
    }

    private void drawMouseOverHighlighting(Graphics g) {
        Rectangle r;
        Views lastHighlightedView;
        g.setColor(this.m_colorHighlight);
        this.m_lastHighlightedNibble = this.getNibbleAtCoordinate(this.m_lastMouseX, this.m_lastMouseY);
        if (this.m_lastHighlightedNibble == -1) {
            return;
        }
        Views views = lastHighlightedView = this.m_lastMouseX >= this.getAsciiViewLeft() ? Views.ASCII_VIEW : Views.HEX_VIEW;
        if (lastHighlightedView == Views.HEX_VIEW) {
            r = this.getNibbleBoundsHex(this.m_lastHighlightedNibble);
            g.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
        } else if (lastHighlightedView == Views.ASCII_VIEW) {
            int first = 2 * this.m_lastHighlightedNibble / 2;
            Rectangle r2 = this.getNibbleBoundsHex(first);
            g.fillRect((int)r2.getX(), (int)r2.getY(), (int)r2.getWidth(), (int)r2.getHeight());
            r2 = this.getNibbleBoundsHex(first + 1);
            g.fillRect((int)r2.getX(), (int)r2.getY(), (int)r2.getWidth(), (int)r2.getHeight());
        }
        r = this.getByteBoundsAscii(this.m_lastHighlightedNibble);
        g.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    private void drawOffsets(Graphics g) {
        if (this.isEnabled()) {
            g.setColor(this.m_fontColorOffsets);
        } else {
            g.setColor(this.m_disabledColor != this.m_bgColorOffset ? this.m_disabledColor : Color.WHITE);
        }
        int x = -this.m_firstColumn * this.m_charWidth + 10;
        int bytesToDraw = this.getMaximumVisibleBytes();
        String formatString = this.m_addressMode == AddressMode.HEXADECIMAL ? " %04X" : "%05d";
        for (int i = 0; i < bytesToDraw; i += this.m_bytesPerRow) {
            long address = this.m_baseAddress + (long)(this.m_firstRow * this.m_bytesPerRow) + (long)i;
            String offsetString = String.format(formatString, address);
            int currentRow = i / this.m_bytesPerRow;
            g.drawString(offsetString, x, 16 + currentRow * this.m_rowHeight);
        }
    }

    private ColoredRange findColoredRange(long currentOffset) {
        for (ColoredRangeManager element : this.m_coloredRanges) {
            ColoredRange range = element.findRangeWith(currentOffset);
            if (range == null) continue;
            return range;
        }
        return null;
    }

    private int getAsciiViewLeft() {
        return this.getHexViewLeft() + this.getHexViewWidth();
    }

    private Rectangle getByteBoundsAscii(int position) {
        if (position < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (position > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int relativePosition = (position - 2 * this.getFirstVisibleByte()) / 2;
        int row = relativePosition / this.m_bytesPerRow;
        int character = relativePosition % this.m_bytesPerRow;
        int x = this.getAsciiViewLeft() + 10 + character * this.m_charWidth;
        int y = 16 - this.m_charHeight + row * this.m_rowHeight;
        return new Rectangle(x, y, this.m_charWidth, this.m_charHeight);
    }

    private int getBytesToDraw() {
        int firstVisibleByte = this.getFirstVisibleByte();
        int maxBytes = this.getMaximumVisibleBytes();
        int restBytes = this.m_dataProvider.getDataLength() - firstVisibleByte;
        return Math.min(maxBytes, restBytes);
    }

    private int getCharacterWidth(Graphics g) {
        return (int)g.getFontMetrics().getStringBounds("0", g).getWidth();
    }

    private int getCharHeight(Graphics g) {
        return g.getFontMetrics().getAscent();
    }

    private int getColumnSize() {
        return 2 * this.m_bytesPerColumn * this.m_charWidth + this.m_columnSpacing;
    }

    private int getCurrentColumn() {
        return (int)this.getCurrentNibble() % (2 * this.m_bytesPerRow);
    }

    private long getCurrentNibble() {
        return this.getSelectionStart() + this.getSelectionLength();
    }

    private int getCurrentRow() {
        return (int)this.getCurrentNibble() / (2 * this.m_bytesPerRow);
    }

    private int getEarlierBytes() {
        return this.m_firstRow * this.m_bytesPerRow;
    }

    private int getFirstVisibleByte() {
        return this.m_firstRow * this.m_bytesPerRow;
    }

    private int getHexViewLeft() {
        return -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth;
    }

    private int getMaximumVisibleBytes() {
        return this.getNumberOfVisibleRows() * this.m_bytesPerRow;
    }

    private int getNibbleAtCoordinate(int x, int y) {
        if (this.m_dataProvider == null) {
            return -1;
        }
        if (x < this.getHexViewLeft() + 10) {
            return -1;
        }
        if (y >= 16 - this.m_font.getSize()) {
            if (x >= this.getHexViewLeft() && x < this.getHexViewLeft() + this.getHexViewWidth()) {
                return this.getNibbleAtCoordinatesHex(x, y);
            }
            if (x >= this.getAsciiViewLeft()) {
                return this.getNibbleAtCoordinatesAscii(x, y);
            }
        }
        return -1;
    }

    private int getNibbleAtCoordinatesAscii(int x, int y) {
        int normalizedX = x - (this.getAsciiViewLeft() + 10);
        if (normalizedX < 0) {
            return -1;
        }
        int row = (y - (16 - this.m_charHeight)) / this.m_rowHeight;
        int earlierPositions = 2 * this.getEarlierBytes();
        if (normalizedX / this.m_charWidth >= this.m_bytesPerRow) {
            return -1;
        }
        int character = 2 * (normalizedX / this.m_charWidth);
        int position = earlierPositions + 2 * row * this.m_bytesPerRow + character;
        if (position >= 2 * this.m_dataProvider.getDataLength()) {
            return -1;
        }
        return position;
    }

    private int getNibbleAtCoordinatesHex(int x, int y) {
        int columnSize;
        int normalizedX = x - (this.getHexViewLeft() + 10);
        int column = normalizedX / (columnSize = this.getColumnSize());
        if (column >= this.m_bytesPerRow / this.m_bytesPerColumn) {
            return -1;
        }
        int xInColumn = normalizedX % columnSize;
        int nibbleInColumn = xInColumn / this.m_charWidth;
        if (nibbleInColumn >= 2 * this.m_bytesPerColumn) {
            return -1;
        }
        int row = (y - (16 - this.m_charHeight)) / this.m_rowHeight;
        int earlierPositions = 2 * this.getEarlierBytes();
        int position = earlierPositions + 2 * (row * this.m_bytesPerRow + column * this.m_bytesPerColumn) + nibbleInColumn;
        if (position >= 2 * this.m_dataProvider.getDataLength()) {
            return -1;
        }
        return position;
    }

    private Rectangle getNibbleBoundsHex(int position) {
        if (position < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (position > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int relativePosition = position - 2 * this.getFirstVisibleByte();
        int columnSize = this.getColumnSize();
        int row = relativePosition / (2 * this.m_bytesPerRow);
        int column = relativePosition % (2 * this.m_bytesPerRow) / (2 * this.m_bytesPerColumn);
        int nibble = relativePosition % (2 * this.m_bytesPerRow) % (2 * this.m_bytesPerColumn);
        int x = this.getHexViewLeft() + 10 + column * columnSize + nibble * this.m_charWidth;
        int y = 16 - this.m_charHeight + row * this.m_rowHeight;
        return new Rectangle(x, y, this.m_charWidth, this.m_charHeight);
    }

    private int getNumberOfVisibleRows() {
        int rawHeight = this.getHeight() - 16 - this.m_horizontalScrollbar.getHeight();
        return rawHeight / this.m_rowHeight + (rawHeight % this.m_rowHeight == 0 ? 0 : 1);
    }

    private int getRowHeight(Graphics g) {
        return g.getFontMetrics().getHeight();
    }

    private long getSelectionStart() {
        return this.m_selectionStart;
    }

    private void initHotkeys() {
        this.setFocusTraversalKeys(0, new HashSet());
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "LEFT");
        actionMap.put("LEFT", this.m_leftAction);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "shift LEFT");
        actionMap.put("shift LEFT", this.m_leftAction);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "RIGHT");
        actionMap.put("RIGHT", this.m_rightAction);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "shift RIGHT");
        actionMap.put("shift RIGHT", this.m_rightAction);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "UP");
        actionMap.put("UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), "shift UP");
        actionMap.put("shift UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "DOWN");
        actionMap.put("DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), "shift DOWN");
        actionMap.put("shift DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "PAGE_DOWN");
        actionMap.put("PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke("shift PAGE_DOWN"), "shift PAGE_DOWN");
        actionMap.put("shift PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "PAGE_UP");
        actionMap.put("PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke("shift PAGE_UP"), "shift PAGE_UP");
        actionMap.put("shift PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke("TAB"), "TAB");
        actionMap.put("TAB", this.m_tabAction);
    }

    private void initListeners() {
        this.addMouseListener(this.m_listener);
        this.addMouseMotionListener(this.m_listener);
        this.addMouseWheelListener(this.m_listener);
        this.addFocusListener(this.m_listener);
        this.addComponentListener(this.m_listener);
        this.addKeyListener(this.m_listener);
        this.m_caret.addCaretListener(this.m_listener);
    }

    private void initScrollbar() {
        this.m_scrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_scrollbar, "East");
        this.m_horizontalScrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_horizontalScrollbar, "South");
    }

    private boolean isDataAvailable() {
        return this.m_dataProvider != null;
    }

    private boolean isInsideAsciiView(int x, int y) {
        return y >= 16 - this.m_font.getSize() && x >= this.getAsciiViewLeft();
    }

    private boolean isInsideHexView(int x, int y) {
        return y >= 16 - this.m_font.getSize() && x >= this.getHexViewLeft() && x < this.getHexViewLeft() + this.getHexViewWidth();
    }

    private boolean isPositionVisible(long position) {
        int firstVisible = this.getFirstVisibleByte();
        int lastVisible = firstVisible + this.getMaximumVisibleBytes() - 1;
        return position >= (long)(2 * firstVisible) && position <= (long)(2 * lastVisible);
    }

    private boolean isSelectedOffset(long currentOffset) {
        currentOffset -= this.m_baseAddress;
        if (this.getSelectionLength() == 0L) {
            return false;
        }
        if (this.getSelectionLength() > 0L) {
            return currentOffset >= this.getSelectionStart() / 2L && 2L * currentOffset < this.getSelectionStart() + this.getSelectionLength();
        }
        return currentOffset >= (this.getSelectionStart() + this.getSelectionLength()) / 2L && 2L * currentOffset < this.getSelectionStart();
    }

    private void resetBufferedGraphic() {
        this.bufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.bufferGraphics.setFont(this.m_font);
    }

    private void scrollToPosition(long position) {
        this.m_scrollbar.setValue((int)position / (2 * this.m_bytesPerRow));
    }

    private void setCurrentPosition(long newPosition) {
        this.m_selectionStart = newPosition;
        if (!this.isPositionVisible(this.getSelectionStart())) {
            this.scrollToPosition(this.getSelectionStart());
        }
        for (IHexViewListener listener : this.m_listeners) {
            listener.selectionChanged(this.getSelectionStart(), 1L);
        }
    }

    private void setScrollBarMaximum() {
        if (this.m_dataProvider == null) {
            this.m_scrollbar.setMaximum(1);
            this.m_horizontalScrollbar.setMaximum(1);
        } else {
            int visibleRows = this.getNumberOfVisibleRows();
            int totalRows = this.m_dataProvider.getDataLength() / this.m_bytesPerRow;
            int scrollRange = 2 + totalRows - visibleRows;
            if (scrollRange < 0) {
                scrollRange = 0;
                this.m_scrollbar.setValue(0);
                this.m_scrollbar.setEnabled(false);
            } else {
                this.m_scrollbar.setEnabled(true);
            }
            this.m_scrollbar.setMaximum(scrollRange);
            int totalWidth = this.getAsciiViewLeft() + 10 + this.m_charWidth * this.m_bytesPerRow;
            int realWidth = this.getWidth() - this.m_scrollbar.getWidth();
            if (realWidth >= totalWidth) {
                this.m_horizontalScrollbar.setValue(0);
                this.m_horizontalScrollbar.setEnabled(false);
            } else {
                this.m_horizontalScrollbar.setMaximum((totalWidth - realWidth) / this.m_charWidth + 1);
                this.m_horizontalScrollbar.setEnabled(true);
            }
        }
    }

    private void setSelectionStart(long selectionStart) {
        this.m_selectionStart = selectionStart;
        for (IHexViewListener listener : this.m_listeners) {
            listener.selectionChanged(this.m_selectionStart, this.m_selectionLength);
        }
    }

    private void updateHexViewWidth() {
        this.m_hexViewWidth = 15 + this.getColumnSize() * this.getBytesPerRow() / this.getBytesPerColumn();
    }

    private void updateOffsetViewWidth() {
        int addressBytes = this.m_addressMode == AddressMode.HEXADECIMAL ? 5 : 5;
        this.m_offsetViewWidth = 20 + this.m_charWidth * addressBytes;
    }

    private void updatePreferredSize() {
        int width = this.m_offsetViewWidth + this.m_hexViewWidth + 18 * this.m_charWidth + this.m_scrollbar.getWidth();
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics gx) {
        int bytesToDraw;
        super.paintComponent(gx);
        this.resetBufferedGraphic();
        this.calculateSizes();
        this.updateOffsetViewWidth();
        if (this.m_firstDraw) {
            this.m_firstDraw = false;
            this.updateHexViewWidth();
            this.updatePreferredSize();
        }
        this.drawBackground(this.bufferGraphics);
        this.drawOffsets(this.bufferGraphics);
        if (this.isEnabled()) {
            this.drawMouseOverHighlighting(this.bufferGraphics);
        }
        if (this.m_status == DefinitionStatus.DEFINED && this.m_dataProvider != null && (bytesToDraw = this.getBytesToDraw()) != 0 && !this.m_dataProvider.hasData(this.getFirstVisibleOffset(), bytesToDraw)) {
            this.setDefinitionStatus(DefinitionStatus.UNDEFINED);
            this.setEnabled(false);
            if (this.m_updateTimer != null) {
                this.m_updateTimer.setRepeats(false);
                this.m_updateTimer.stop();
            }
            this.m_updateTimer = new Timer(1000, new WaitingForDataAction(this.getFirstVisibleOffset(), bytesToDraw));
            this.m_updateTimer.setRepeats(true);
            this.m_updateTimer.start();
            return;
        }
        if (this.isDataAvailable() || this.m_status == DefinitionStatus.UNDEFINED) {
            this.drawHexView(this.bufferGraphics);
            this.drawAsciiPanel(this.bufferGraphics);
            if (this.m_caret.isVisible() && this.hasFocus()) {
                this.drawCaret(this.bufferGraphics);
            }
        }
        gx.drawImage(this.img, 0, 0, this);
    }

    public void addHexListener(IHexViewListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void colorize(int level, long offset, int size, Color color, Color bgcolor) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Error: Offset can't be negative");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Error: Size must be positive");
        }
        if (level < 0 || level >= this.m_coloredRanges.length) {
            throw new IllegalArgumentException("Error: Invalid level");
        }
        this.m_coloredRanges[level].addRange(new ColoredRange(offset, size, color, bgcolor));
        this.repaint();
    }

    public void dispose() {
        this.removeMouseListener(this.m_listener);
        this.removeMouseMotionListener(this.m_listener);
        this.removeMouseWheelListener(this.m_listener);
        this.removeFocusListener(this.m_listener);
        this.removeComponentListener(this.m_listener);
        this.removeKeyListener(this.m_listener);
        this.m_caret.removeListener(this.m_listener);
        this.m_caret.stop();
    }

    public boolean doFlipBytes() {
        return this.m_flipBytes;
    }

    public AddressMode getAddressMode() {
        return this.m_addressMode;
    }

    public Color getBackgroundColorAsciiView() {
        return this.m_bgColorAscii;
    }

    public Color getBackgroundColorHexView() {
        return this.m_bgColorHex;
    }

    public Color getBackgroundColorOffsetView() {
        return this.m_bgColorOffset;
    }

    public long getBaseAddress() {
        return this.m_baseAddress;
    }

    public int getBytesPerColumn() {
        return this.m_bytesPerColumn;
    }

    public int getBytesPerRow() {
        return this.m_bytesPerRow;
    }

    public int getColumnSpacing() {
        return this.m_columnSpacing;
    }

    public long getCurrentOffset() {
        long currentOffset = this.m_baseAddress + this.getCurrentNibble() / 2L;
        return this.m_flipBytes ? (currentOffset & (long)(-this.m_bytesPerColumn)) + (long)this.m_bytesPerColumn - currentOffset % (long)this.m_bytesPerColumn - 1L : currentOffset;
    }

    public IDataProvider getData() {
        return this.m_dataProvider;
    }

    public DefinitionStatus getDefinitionStatus() {
        return this.m_status;
    }

    public long getFirstSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.m_baseAddress + this.m_selectionStart) / 2L;
        }
        return (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) / 2L;
    }

    public long getFirstVisibleOffset() {
        return this.getBaseAddress() + (long)this.getFirstVisibleByte();
    }

    public Color getFontColorAsciiView() {
        return this.m_fontColorAscii;
    }

    public Color getFontColorHexView1() {
        return this.m_fontColorHex1;
    }

    public Color getFontColorHexView2() {
        return this.m_fontColorHex2;
    }

    public Color getFontColorOffsetView() {
        return this.m_fontColorOffsets;
    }

    public int getFontSize() {
        return this.m_font.getSize();
    }

    public int getHexViewWidth() {
        return this.m_hexViewWidth;
    }

    public long getLastOffset() {
        return this.getBaseAddress() + (long)this.m_dataProvider.getDataLength();
    }

    public long getLastSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) / 2L + (this.m_baseAddress + this.m_selectionStart + this.m_selectionLength) % 2L;
        }
        return (this.m_baseAddress + this.m_selectionStart) / 2L + (this.m_baseAddress + this.m_selectionStart) % 2L;
    }

    public long getSelectionLength() {
        return this.m_selectionLength;
    }

    public int getVisibleBytes() {
        int visibleBytes = this.getMaximumVisibleBytes();
        if (this.m_dataProvider.getDataLength() - this.getFirstVisibleByte() >= visibleBytes) {
            return visibleBytes;
        }
        return this.m_dataProvider.getDataLength() - this.getFirstVisibleByte();
    }

    public void gotoOffset(long offset) {
        if (this.m_dataProvider == null) {
            throw new IllegalStateException("Error: No data provider active");
        }
        if (this.getCurrentOffset() == offset) {
            if (!this.isPositionVisible(this.getSelectionStart())) {
                this.scrollToPosition(this.getSelectionStart());
            }
            return;
        }
        long realOffset = offset - this.m_baseAddress;
        if (realOffset < 0L || realOffset >= (long)this.m_dataProvider.getDataLength()) {
            throw new IllegalArgumentException("Error: Invalid offset");
        }
        this.setCurrentPosition(2L * realOffset);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void removeHexListener(IHexViewListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.m_listeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    public void setAddressMode(AddressMode mode) {
        if (mode == null) {
            throw new NullPointerException("Error: Address mode can't be null");
        }
        this.m_addressMode = mode;
        this.updateOffsetViewWidth();
        this.updatePreferredSize();
    }

    public void setBackgroundColorAsciiView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorAscii = color;
        this.repaint();
    }

    public void setBackgroundColorHexView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorHex = color;
        this.repaint();
    }

    public void setBackgroundColorOffsetView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorOffset = color;
        this.repaint();
    }

    public void setBaseAddress(long baseAddress) {
        if (baseAddress < 0L) {
            throw new IllegalArgumentException("Error: Base address can't be negative");
        }
        this.m_baseAddress = baseAddress;
        this.repaint();
    }

    public void setBytesPerColumn(int bytes) {
        if (bytes <= 0) {
            throw new IllegalArgumentException("Error: Number of bytes must be positive");
        }
        if (bytes > this.m_bytesPerRow) {
            throw new IllegalArgumentException("Error: Number of bytes can't be more than the number of bytes per row");
        }
        this.m_bytesPerColumn = bytes;
        this.updateHexViewWidth();
        this.updatePreferredSize();
        this.repaint();
    }

    public void setBytesPerRow(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Error: Value must be positive");
        }
        this.m_bytesPerRow = value;
        this.repaint();
    }

    public void setColormap(IColormap colormap) {
        this.m_colormap = colormap;
        this.repaint();
    }

    public void setColumnSpacing(int spacing) {
        if (spacing <= 0) {
            throw new IllegalArgumentException("Error: Spacing must be positive");
        }
        this.m_columnSpacing = spacing;
        this.repaint();
    }

    public void setCurrentOffset(long offset) {
        if (this.m_dataProvider == null) {
            return;
        }
        if (offset < this.getBaseAddress() || offset > this.getBaseAddress() + (long)this.m_dataProvider.getDataLength()) {
            throw new IllegalArgumentException("Error: Invalid offset");
        }
        this.setCurrentPosition(2L * (offset - this.m_baseAddress));
    }

    public void setData(IDataProvider data) {
        if (this.m_dataProvider != null) {
            this.m_dataProvider.removeListener(this.m_listener);
        }
        this.m_dataProvider = data;
        if (data != null) {
            this.m_dataProvider.addListener(this.m_listener);
        }
        this.setCurrentPosition(0L);
        this.setScrollBarMaximum();
        this.repaint();
    }

    public void setDefinitionStatus(DefinitionStatus status) {
        if (status == null) {
            throw new NullPointerException("Error: Definition status can't be null");
        }
        this.m_status = status;
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.m_enabled) {
            return;
        }
        this.m_enabled = enabled;
        this.repaint();
    }

    public void setFlipBytes(boolean flip) {
        if (this.m_flipBytes == flip) {
            return;
        }
        this.m_flipBytes = flip;
        this.repaint();
    }

    public void setFontColorAsciiView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_fontColorAscii = color;
        this.repaint();
    }

    public void setFontColorHexView1(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_fontColorHex1 = color;
        this.repaint();
    }

    public void setFontColorHexView2(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_fontColorHex2 = color;
        this.repaint();
    }

    public void setFontColorOffsetView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_fontColorOffsets = color;
        this.repaint();
    }

    public void setFontSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Error: Font size must be positive");
        }
        this.m_font = new Font(GuiHelpers.getMonospaceFont(), 0, size);
        this.setFont(this.m_font);
        this.m_firstDraw = true;
        this.repaint();
    }

    public void setHexViewWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Error: Width must be positive");
        }
        this.m_hexViewWidth = width;
        this.repaint();
    }

    public void setMenuCreator(IMenuCreator creator) {
        this.m_menuCreator = creator;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_selectionColor = color;
        this.repaint();
    }

    public void setSelectionLength(long selectionLength) {
        this.m_selectionLength = selectionLength;
        for (IHexViewListener listener : this.m_listeners) {
            listener.selectionChanged(this.m_selectionStart, this.m_selectionLength);
        }
        this.repaint();
    }

    public void uncolorize(int level, long offset, int size) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Error: Offset can't be negative");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Error: Size must be positive");
        }
        if (level < 0 || level >= this.m_coloredRanges.length) {
            throw new IllegalArgumentException("Error: Invalid level");
        }
        this.m_coloredRanges[level].removeRange(offset, size);
        this.repaint();
    }

    public void uncolorizeAll() {
        for (ColoredRangeManager coloredRange : this.m_coloredRanges) {
            coloredRange.clear();
        }
    }

    public void uncolorizeAll(int level) {
        this.m_coloredRanges[level].clear();
        this.repaint();
    }

    public static enum DefinitionStatus {
        DEFINED,
        UNDEFINED;

    }

    public static enum AddressMode {
        HEXADECIMAL,
        DECIMAL;

    }

    private class WaitingForDataAction
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_offset;
        private final int m_size;

        private WaitingForDataAction(long offset, int size) {
            this.m_offset = offset;
            this.m_size = size;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (JHexView.this.m_dataProvider.hasData(this.m_offset, this.m_size)) {
                JHexView.this.setEnabled(true);
                JHexView.this.setDefinitionStatus(DefinitionStatus.DEFINED);
                ((Timer)arg0.getSource()).stop();
            } else if (!JHexView.this.m_dataProvider.keepTrying()) {
                ((Timer)arg0.getSource()).stop();
            }
        }
    }

    private static enum Views {
        HEX_VIEW,
        ASCII_VIEW;

    }

    private class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -3513103611571283106L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, -2 * JHexView.this.m_bytesPerRow);
        }
    }

    private class TabAction
    extends AbstractAction {
        private static final long serialVersionUID = -3265020583339369531L;

        private TabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                JHexView.this.m_activeView = Views.ASCII_VIEW;
                JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() - JHexView.this.getSelectionStart() % 2L);
            } else {
                JHexView.this.m_activeView = Views.HEX_VIEW;
            }
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }
    }

    private class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998636L;

        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, JHexView.this.m_activeView == Views.HEX_VIEW ? 1 : 2);
        }
    }

    private class PageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -7424423002191015929L;

        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, -JHexView.this.getNumberOfVisibleRows() * JHexView.this.m_bytesPerRow * 2);
        }
    }

    private class PageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 490837791577654025L;

        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, JHexView.this.getNumberOfVisibleRows() * JHexView.this.m_bytesPerRow * 2);
        }
    }

    private class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = -9032577023548944503L;

        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, JHexView.this.m_activeView == Views.HEX_VIEW ? -1 : -2);
        }
    }

    private class InternalListener
    implements AdjustmentListener,
    MouseListener,
    MouseMotionListener,
    FocusListener,
    ICaretListener,
    IDataChangedListener,
    ComponentListener,
    KeyListener,
    MouseWheelListener {
        private InternalListener() {
        }

        private void keyPressedInAsciiView(KeyEvent arg0) {
            byte[] data = JHexView.this.m_dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.m_dataProvider.getDataLength() * 2)) {
                return;
            }
            data[0] = (byte)arg0.getKeyChar();
            JHexView.this.m_dataProvider.setData(JHexView.this.getCurrentOffset(), data);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 2L);
        }

        private void keyPressedInHexView(KeyEvent key) {
            byte[] data = JHexView.this.m_dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            long pos = JHexView.this.m_baseAddress + JHexView.this.getSelectionStart();
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.m_dataProvider.getDataLength() * 2)) {
                return;
            }
            int value = Character.digit(key.getKeyChar(), 16);
            if (value == -1) {
                return;
            }
            data[0] = pos % 2L == 0L ? (byte)(data[0] & 0xF | value << 4) : (byte)(data[0] & 0xF0 | value);
            JHexView.this.m_dataProvider.setData(JHexView.this.getCurrentOffset(), data);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 1L);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent arg0) {
            if (arg0.getSource() == JHexView.this.m_scrollbar) {
                JHexView.this.m_firstRow = arg0.getValue();
            } else {
                JHexView.this.m_firstColumn = arg0.getValue();
            }
            JHexView.this.repaint();
        }

        @Override
        public void caretStatusChanged(JCaret source) {
            JHexView.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
            JHexView.this.setScrollBarMaximum();
            int width = JHexView.this.getWidth() + 1 - JHexView.this.m_scrollbar.getWidth();
            int height = JHexView.this.getHeight() + 1 - JHexView.this.m_horizontalScrollbar.getHeight();
            width = Math.max(1, width);
            height = Math.max(1, height);
            JHexView.this.img = new BufferedImage(width, height, 1);
            JHexView.this.bufferGraphics = JHexView.this.img.getGraphics();
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }

        @Override
        public void dataChanged() {
            JHexView.this.setScrollBarMaximum();
            JHexView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            JHexView.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                if (JHexView.this.m_dataProvider.isEditable() && ConvertHelpers.isHexCharacter(arg0.getKeyChar())) {
                    this.keyPressedInHexView(arg0);
                }
            } else if (JHexView.this.m_dataProvider.isEditable() && ConvertHelpers.isPrintableCharacter(arg0.getKeyChar())) {
                this.keyPressedInAsciiView(arg0);
            }
            JHexView.this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int x = arg0.getX();
            int y = arg0.getY();
            if (y < 16 - (JHexView.this.m_rowHeight - JHexView.this.m_charHeight)) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() - 2 * JHexView.this.m_bytesPerRow);
                if (JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.m_bytesPerRow) < 0L) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.m_bytesPerRow));
            } else if (y >= JHexView.this.m_rowHeight * JHexView.this.getNumberOfVisibleRows()) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() + 2 * JHexView.this.m_bytesPerRow);
                if (JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.m_bytesPerRow) > 2L * ((long)JHexView.this.m_dataProvider.getDataLength() - JHexView.this.getSelectionStart())) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.m_bytesPerRow));
            } else {
                int position = JHexView.this.getNibbleAtCoordinate(x, y);
                if (position != -1) {
                    JHexView.this.setSelectionLength((long)position - JHexView.this.getSelectionStart());
                    JHexView.this.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            JHexView.this.m_lastMouseX = arg0.getX();
            JHexView.this.m_lastMouseY = arg0.getY();
            JHexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int position;
            int y;
            int x;
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (event.getButton() == 1 || event.getButton() == 3) {
                JHexView.this.m_selectionLength = 0L;
                JHexView.this.requestFocusInWindow();
                x = event.getX();
                y = event.getY();
                position = JHexView.this.getNibbleAtCoordinate(x, y);
                if (position != -1) {
                    JHexView.this.m_caret.setVisible(true);
                    JHexView.this.setCurrentPosition(position);
                    if (JHexView.this.isInsideHexView(x, y)) {
                        JHexView.this.m_activeView = Views.HEX_VIEW;
                    } else if (JHexView.this.isInsideAsciiView(x, y)) {
                        JHexView.this.m_activeView = Views.ASCII_VIEW;
                    }
                    JHexView.this.repaint();
                } else {
                    for (IHexViewListener listener : JHexView.this.m_listeners) {
                        listener.selectionChanged(JHexView.this.m_selectionStart, JHexView.this.m_selectionLength);
                    }
                    JHexView.this.repaint();
                }
            }
            if (event.getButton() == 3 && (position = JHexView.this.getNibbleAtCoordinate(x = event.getX(), y = event.getY())) != -1) {
                JPopupMenu menu;
                JHexView.this.m_caret.setVisible(true);
                if (JHexView.this.m_menuCreator != null && (menu = JHexView.this.m_menuCreator.createMenu(JHexView.this.getCurrentOffset())) != null) {
                    menu.show(JHexView.this, x, y);
                }
                JHexView.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int notches = e.getWheelRotation();
            JHexView.this.m_scrollbar.setValue(JHexView.this.m_scrollbar.getValue() + notches);
        }
    }

    private class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6501310447863685486L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JHexView.this.changeBy(arg0, 2 * JHexView.this.m_bytesPerRow);
        }
    }
}

