/*
 * Decompiled with CFR 0.152.
 */
package snapshots;

import machine.Keyboard;
import machine.MachineTypes;
import snapshots.AY8912State;
import snapshots.MemoryState;
import snapshots.Z80State;

public class SpectrumState {
    private MachineTypes spectrumModel;
    private Z80State z80;
    private MemoryState memory;
    private AY8912State ay8912;
    private int tstates;
    private int portFE;
    private int earBit;
    private int port7ffd;
    private int port1ffd;
    private int portFD;
    private byte numMicrodrives = 1;
    private boolean ULAPlusEnabled;
    private boolean ULAPlusActive;
    private boolean issue2;
    private boolean multiface;
    private boolean connectedLec;
    private boolean connectedIF1;
    private boolean enabledAY;
    private boolean enabledAYon48k;
    private Keyboard.JoystickModel joystick;
    private int[] ULAPlusPalette;
    private int paletteGroup;

    public MachineTypes getSpectrumModel() {
        return this.spectrumModel;
    }

    public void setSpectrumModel(MachineTypes spectrumModel) {
        this.spectrumModel = spectrumModel;
    }

    public Z80State getZ80State() {
        return this.z80;
    }

    public void setZ80State(Z80State z80) {
        this.z80 = z80;
    }

    public MemoryState getMemoryState() {
        return this.memory;
    }

    public void setMemoryState(MemoryState memory) {
        this.memory = memory;
    }

    public AY8912State getAY8912State() {
        return this.ay8912;
    }

    public void setAY8912State(AY8912State ay8912) {
        this.ay8912 = ay8912;
    }

    public int getTstates() {
        return this.tstates;
    }

    public void setTstates(int tstates) {
        this.tstates = tstates;
    }

    public int getEarBit() {
        return this.earBit;
    }

    public void setEarBit(int earBit) {
        this.earBit = earBit & 0xFF;
    }

    public int getPort7ffd() {
        return this.port7ffd;
    }

    public void setPort7ffd(int port7ffd) {
        this.port7ffd = port7ffd & 0xFF;
    }

    public int getPort1ffd() {
        return this.port1ffd;
    }

    public void setPort1ffd(int port1ffd) {
        this.port1ffd = port1ffd & 0xFF;
    }

    public boolean isULAPlusEnabled() {
        return this.ULAPlusEnabled;
    }

    public void setULAPlusEnabled(boolean ULAplusOn) {
        this.ULAPlusEnabled = ULAplusOn;
    }

    public boolean isULAPlusActive() {
        return this.ULAPlusActive;
    }

    public void setULAPlusActive(boolean ULAPlusActive) {
        this.ULAPlusActive = ULAPlusActive;
    }

    public int getPaletteGroup() {
        return this.paletteGroup;
    }

    public void setPaletteGroup(int paletteGroup) {
        this.paletteGroup = paletteGroup & 0xFF;
    }

    public int[] getULAPlusPalette() {
        return this.ULAPlusPalette;
    }

    public void setULAPlusPalette(int[] UlaPlusPalette) {
        this.ULAPlusPalette = UlaPlusPalette;
    }

    public boolean isIssue2() {
        return this.issue2;
    }

    public void setIssue2(boolean issue2) {
        this.issue2 = issue2;
    }

    public boolean isMultiface() {
        return this.multiface;
    }

    public void setMultiface(boolean multiface) {
        this.multiface = multiface;
    }

    public boolean isConnectedIF1() {
        return this.connectedIF1;
    }

    public void setConnectedIF1(boolean connectedIF1) {
        this.connectedIF1 = connectedIF1;
    }

    public byte getNumMicrodrives() {
        return this.numMicrodrives;
    }

    public void setNumMicrodrives(byte numMicrodrives) {
        if (numMicrodrives < 1 || numMicrodrives > 8) {
            numMicrodrives = (byte)8;
        }
        this.numMicrodrives = numMicrodrives;
    }

    public Keyboard.JoystickModel getJoystick() {
        return this.joystick;
    }

    public void setJoystick(Keyboard.JoystickModel joystick) {
        this.joystick = joystick;
    }

    public int getPortFE() {
        return this.portFE;
    }

    public void setPortFE(int portFE) {
        this.portFE = portFE;
    }

    public int getBorder() {
        return this.portFE & 7;
    }

    public void setBorder(int color) {
        this.portFE &= 0xF8;
        this.portFE |= color;
    }

    public boolean isEnabledAY() {
        return this.enabledAY;
    }

    public void setEnabledAY(boolean ayEnabled) {
        this.enabledAY = ayEnabled;
    }

    public boolean isEnabledAYon48k() {
        return this.enabledAYon48k;
    }

    public void setEnabledAYon48k(boolean enabledAYon48k) {
        this.enabledAYon48k = enabledAYon48k;
    }

    public boolean isConnectedLec() {
        return this.connectedLec;
    }

    public void setConnectedLec(boolean connectedLec) {
        this.connectedLec = connectedLec;
    }

    public int getPortFD() {
        return this.portFD;
    }

    public void setPortFD(int portFD) {
        this.portFD = portFD;
    }
}

