/*
 * Decompiled with CFR 0.152.
 */
package snapshots;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.Keyboard;
import machine.MachineTypes;
import snapshots.AY8912State;
import snapshots.MemoryState;
import snapshots.SnapshotException;
import snapshots.SnapshotFile;
import snapshots.SpectrumState;
import snapshots.Z80State;
import z80core.Z80;

public class SnapshotZ80
implements SnapshotFile {
    private BufferedInputStream fIn;
    private BufferedOutputStream fOut;
    private SpectrumState spectrum;
    private Z80State z80;
    private MemoryState memory;
    private AY8912State ay8912;

    private int uncompressZ80(byte[] buffer, int length) {
        int address = 0;
        try {
            while (this.fIn.available() > 0 && address < length) {
                int mem = this.fIn.read() & 0xFF;
                if (mem != 237) {
                    buffer[address++] = (byte)mem;
                    continue;
                }
                int mem2 = this.fIn.read() & 0xFF;
                if (mem2 != 237) {
                    buffer[address++] = -19;
                    buffer[address++] = (byte)mem2;
                    continue;
                }
                int nreps = this.fIn.read() & 0xFF;
                int value = this.fIn.read() & 0xFF;
                while (nreps-- > 0) {
                    buffer[address++] = (byte)value;
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SnapshotZ80.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
        return address;
    }

    private int countRepeatedByte(int page, int address, byte value) {
        int count;
        for (count = 0; address < 16384 && count < 254 && value == this.memory.readByte(page, address++); ++count) {
        }
        return count;
    }

    private int compressPageZ80(byte[] buffer, int page) {
        int address = 0;
        int addrDst = 0;
        while (address < 16384) {
            byte value = this.memory.readByte(page, address++);
            int nReps = this.countRepeatedByte(page, address, value);
            if (value == -19) {
                if (nReps == 0) {
                    buffer[addrDst++] = -19;
                    buffer[addrDst++] = this.memory.readByte(page, address++);
                    continue;
                }
                buffer[addrDst++] = -19;
                buffer[addrDst++] = -19;
                buffer[addrDst++] = (byte)(nReps + 1);
                buffer[addrDst++] = -19;
                address += nReps;
                continue;
            }
            if (nReps < 4) {
                buffer[addrDst++] = value;
                continue;
            }
            buffer[addrDst++] = -19;
            buffer[addrDst++] = -19;
            buffer[addrDst++] = (byte)(nReps + 1);
            buffer[addrDst++] = value;
            address += nReps;
        }
        return addrDst;
    }

    @Override
    public SpectrumState load(File filename) throws SnapshotException {
        this.spectrum = new SpectrumState();
        try {
            block94: {
                byte[] z80Header2;
                int hdrLen;
                int count;
                block96: {
                    boolean modifiedHW;
                    block95: {
                        block93: {
                            try {
                                this.fIn = new BufferedInputStream(new FileInputStream(filename));
                            }
                            catch (FileNotFoundException ex) {
                                throw new SnapshotException("OPEN_FILE_ERROR", ex);
                            }
                            if (this.fIn.available() < 30) {
                                throw new SnapshotException("FILE_SIZE_ERROR");
                            }
                            byte[] z80Header1 = new byte[30];
                            for (count = 0; count != -1 && count < z80Header1.length; count += this.fIn.read(z80Header1, count, z80Header1.length - count)) {
                            }
                            if (count != z80Header1.length) {
                                throw new SnapshotException("FILE_READ_ERROR");
                            }
                            this.z80 = new Z80State();
                            this.spectrum.setZ80State(this.z80);
                            this.z80.setRegA(z80Header1[0]);
                            this.z80.setRegF(z80Header1[1]);
                            this.z80.setRegC(z80Header1[2]);
                            this.z80.setRegB(z80Header1[3]);
                            this.z80.setRegL(z80Header1[4]);
                            this.z80.setRegH(z80Header1[5]);
                            this.z80.setRegPC(z80Header1[6] & 0xFF | z80Header1[7] << 8);
                            this.z80.setRegSP(z80Header1[8] & 0xFF | z80Header1[9] << 8);
                            this.z80.setRegI(z80Header1[10]);
                            int regR = z80Header1[11] & 0x7F;
                            if ((z80Header1[12] & 1) != 0) {
                                regR |= 0x80;
                            }
                            this.z80.setRegR(regR);
                            this.spectrum.setBorder(z80Header1[12] >>> 1 & 7);
                            this.z80.setRegE(z80Header1[13]);
                            this.z80.setRegD(z80Header1[14]);
                            this.z80.setRegCx(z80Header1[15]);
                            this.z80.setRegBx(z80Header1[16]);
                            this.z80.setRegEx(z80Header1[17]);
                            this.z80.setRegDx(z80Header1[18]);
                            this.z80.setRegLx(z80Header1[19]);
                            this.z80.setRegHx(z80Header1[20]);
                            this.z80.setRegAx(z80Header1[21]);
                            this.z80.setRegFx(z80Header1[22]);
                            this.z80.setRegIY(z80Header1[23] & 0xFF | z80Header1[24] << 8);
                            this.z80.setRegIX(z80Header1[25] & 0xFF | z80Header1[26] << 8);
                            this.z80.setIFF1(z80Header1[27] != 0);
                            this.z80.setIFF2(z80Header1[28] != 0);
                            switch (z80Header1[29] & 3) {
                                case 0: {
                                    this.z80.setIM(Z80.IntMode.IM0);
                                    break;
                                }
                                case 1: {
                                    this.z80.setIM(Z80.IntMode.IM1);
                                    break;
                                }
                                case 2: {
                                    this.z80.setIM(Z80.IntMode.IM2);
                                }
                            }
                            this.spectrum.setIssue2((z80Header1[29] & 4) != 0);
                            switch (z80Header1[29] & 0xC0) {
                                case 0: {
                                    this.spectrum.setJoystick(Keyboard.JoystickModel.CURSOR);
                                    break;
                                }
                                case 64: {
                                    this.spectrum.setJoystick(Keyboard.JoystickModel.KEMPSTON);
                                    break;
                                }
                                case 128: {
                                    this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR1);
                                    break;
                                }
                                case 192: {
                                    this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR2);
                                    break;
                                }
                                default: {
                                    this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
                                }
                            }
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                            if (this.z80.getRegPC() == 0) break block93;
                            byte[] pageBuffer = new byte[16384];
                            this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                            if ((z80Header1[12] & 0x20) == 0) {
                                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(pageBuffer, count, 16384 - count)) {
                                }
                                if (count != 16384) {
                                    throw new SnapshotException("FILE_READ_ERROR");
                                }
                                this.memory.setPageRam(5, pageBuffer);
                                pageBuffer = new byte[16384];
                                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(pageBuffer, count, 16384 - count)) {
                                }
                                if (count != 16384) {
                                    throw new SnapshotException("FILE_READ_ERROR");
                                }
                                this.memory.setPageRam(2, pageBuffer);
                                pageBuffer = new byte[16384];
                                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(pageBuffer, count, 16384 - count)) {
                                }
                                if (count != 16384) {
                                    throw new SnapshotException("FILE_READ_ERROR");
                                }
                                this.memory.setPageRam(0, pageBuffer);
                            } else {
                                byte[] buffer = new byte[49152];
                                int len = this.uncompressZ80(buffer, buffer.length);
                                if (len != 49152 || this.fIn.available() != 4) {
                                    throw new SnapshotException("FILE_READ_ERROR");
                                }
                                this.memory.setPageRam(5, Arrays.copyOfRange(buffer, 0, 16384));
                                this.memory.setPageRam(2, Arrays.copyOfRange(buffer, 16384, 32768));
                                this.memory.setPageRam(0, Arrays.copyOfRange(buffer, 32768, 49152));
                            }
                            break block94;
                        }
                        hdrLen = this.fIn.read() | this.fIn.read() << 8 & 0xFFFF;
                        if (hdrLen != 23 && hdrLen != 54 && hdrLen != 55) {
                            throw new SnapshotException("FILE_SIZE_ERROR");
                        }
                        z80Header2 = new byte[hdrLen];
                        for (count = 0; count != -1 && count < z80Header2.length; count += this.fIn.read(z80Header2, count, z80Header2.length - count)) {
                        }
                        if (count != z80Header2.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.z80.setRegPC(z80Header2[0] & 0xFF | z80Header2[1] << 8);
                        boolean bl = modifiedHW = (z80Header2[5] & 0x80) != 0;
                        if (hdrLen != 23) break block95;
                        switch (z80Header2[2] & 0xFF) {
                            case 0: {
                                if (modifiedHW) {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                                } else {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                                }
                                this.spectrum.setConnectedIF1(false);
                                break block96;
                            }
                            case 1: {
                                if (modifiedHW) {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                                } else {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                                }
                                this.spectrum.setConnectedIF1(true);
                                if ((z80Header2[4] & 0xFF) == 255) {
                                    this.memory.setIF1RomPaged(true);
                                }
                                break block96;
                            }
                            case 3: {
                                if (modifiedHW) {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                                } else {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                                }
                                this.spectrum.setConnectedIF1(false);
                                break block96;
                            }
                            case 4: {
                                if (modifiedHW) {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                                } else {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                                }
                                this.spectrum.setConnectedIF1(true);
                                if ((z80Header2[4] & 0xFF) == 255) {
                                    this.memory.setIF1RomPaged(true);
                                }
                                break block96;
                            }
                            case 7: {
                                if (modifiedHW) {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2A);
                                } else {
                                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS3);
                                }
                                break block96;
                            }
                            case 12: {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                                break block96;
                            }
                            case 13: {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2A);
                                break block96;
                            }
                            default: {
                                throw new SnapshotException("UNSUPPORTED_SNAPSHOT");
                            }
                        }
                    }
                    switch (z80Header2[2] & 0xFF) {
                        case 0: {
                            if (modifiedHW) {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                            } else {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                            }
                            this.spectrum.setConnectedIF1(false);
                            break;
                        }
                        case 1: {
                            if (modifiedHW) {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                            } else {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                            }
                            this.spectrum.setConnectedIF1(true);
                            if ((z80Header2[4] & 0xFF) != 255) break;
                            this.memory.setIF1RomPaged(true);
                            break;
                        }
                        case 4: {
                            if (modifiedHW) {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                            } else {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                            }
                            this.spectrum.setConnectedIF1(false);
                            break;
                        }
                        case 5: {
                            if (modifiedHW) {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                            } else {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                            }
                            this.spectrum.setConnectedIF1(true);
                            if ((z80Header2[4] & 0xFF) != 255) break;
                            this.memory.setIF1RomPaged(true);
                            break;
                        }
                        case 7: {
                            if (modifiedHW) {
                                this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2A);
                                break;
                            }
                            this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS3);
                            break;
                        }
                        case 12: {
                            this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                            break;
                        }
                        case 13: {
                            this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2A);
                            break;
                        }
                        default: {
                            throw new SnapshotException("UNSUPPORTED_SNAPSHOT");
                        }
                    }
                }
                this.spectrum.setPort7ffd(z80Header2[3]);
                this.spectrum.setEnabledAY(true);
                if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                    this.spectrum.setEnabledAYon48k((z80Header2[5] & 4) != 0);
                    this.spectrum.setEnabledAY(this.spectrum.isEnabledAYon48k());
                }
                this.spectrum.setEnabledAYon48k((z80Header2[5] & 4) != 0);
                this.ay8912 = new AY8912State();
                this.spectrum.setAY8912State(this.ay8912);
                this.ay8912.setAddressLatch(z80Header2[6]);
                int[] regAY = new int[16];
                for (int idx = 0; idx < 16; ++idx) {
                    regAY[idx] = z80Header2[7 + idx] & 0xFF;
                }
                this.ay8912.setRegAY(regAY);
                this.spectrum.setPort1ffd(hdrLen == 55 ? z80Header2[54] : 0);
                while (this.fIn.available() > 0) {
                    byte[] buffer = new byte[16384];
                    int blockLen = this.fIn.read() | this.fIn.read() << 8 & 0xFFFF;
                    int ramPage = this.fIn.read() & 0xFF;
                    if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                        switch (ramPage) {
                            case 4: {
                                ramPage = 2;
                                break;
                            }
                            case 5: {
                                ramPage = 0;
                                break;
                            }
                            case 8: {
                                ramPage = 5;
                            }
                        }
                    } else {
                        if (ramPage < 3 || ramPage > 10) continue;
                        ramPage -= 3;
                    }
                    if (blockLen == 65535) {
                        for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                        }
                        if (count != 16384) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.memory.setPageRam(ramPage, buffer);
                        continue;
                    }
                    int len = this.uncompressZ80(buffer, 16384);
                    if (len != 16384) {
                        throw new SnapshotException("FILE_READ_ERROR");
                    }
                    this.memory.setPageRam(ramPage, buffer);
                }
            }
            this.spectrum.setTstates(0);
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_READ_ERROR", ex);
        }
        finally {
            try {
                if (this.fIn != null) {
                    this.fIn.close();
                }
            }
            catch (IOException ex) {
                throw new SnapshotException("FILE_READ_ERROR", ex);
            }
        }
        return this.spectrum;
    }

    @Override
    public boolean save(File filename, SpectrumState state) throws SnapshotException {
        this.spectrum = state;
        this.z80 = this.spectrum.getZ80State();
        this.memory = this.spectrum.getMemoryState();
        this.ay8912 = this.spectrum.getAY8912State();
        try {
            int bufLen;
            try {
                this.fOut = new BufferedOutputStream(new FileOutputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            byte[] z80HeaderV3 = new byte[87];
            z80HeaderV3[0] = (byte)this.z80.getRegA();
            z80HeaderV3[1] = (byte)this.z80.getRegF();
            z80HeaderV3[2] = (byte)this.z80.getRegC();
            z80HeaderV3[3] = (byte)this.z80.getRegB();
            z80HeaderV3[4] = (byte)this.z80.getRegL();
            z80HeaderV3[5] = (byte)this.z80.getRegH();
            z80HeaderV3[8] = (byte)this.z80.getRegSP();
            z80HeaderV3[9] = (byte)(this.z80.getRegSP() >>> 8);
            z80HeaderV3[10] = (byte)this.z80.getRegI();
            z80HeaderV3[11] = (byte)(this.z80.getRegR() & 0x7F);
            z80HeaderV3[12] = (byte)(this.spectrum.getBorder() << 1);
            if (this.z80.getRegR() > 127) {
                z80HeaderV3[12] = (byte)(z80HeaderV3[12] | 1);
            }
            z80HeaderV3[13] = (byte)this.z80.getRegE();
            z80HeaderV3[14] = (byte)this.z80.getRegD();
            z80HeaderV3[15] = (byte)this.z80.getRegCx();
            z80HeaderV3[16] = (byte)this.z80.getRegBx();
            z80HeaderV3[17] = (byte)this.z80.getRegEx();
            z80HeaderV3[18] = (byte)this.z80.getRegDx();
            z80HeaderV3[19] = (byte)this.z80.getRegLx();
            z80HeaderV3[20] = (byte)this.z80.getRegHx();
            z80HeaderV3[21] = (byte)this.z80.getRegAx();
            z80HeaderV3[22] = (byte)this.z80.getRegFx();
            z80HeaderV3[23] = (byte)this.z80.getRegIY();
            z80HeaderV3[24] = (byte)(this.z80.getRegIY() >>> 8);
            z80HeaderV3[25] = (byte)this.z80.getRegIX();
            z80HeaderV3[26] = (byte)(this.z80.getRegIX() >>> 8);
            z80HeaderV3[27] = (byte)(this.z80.isIFF1() ? 1 : 0);
            z80HeaderV3[28] = (byte)(this.z80.isIFF2() ? 1 : 0);
            z80HeaderV3[29] = (byte)this.z80.getIM().ordinal();
            if (this.spectrum.isIssue2()) {
                z80HeaderV3[29] = (byte)(z80HeaderV3[29] | 4);
            }
            switch (this.spectrum.getJoystick()) {
                case NONE: 
                case CURSOR: {
                    break;
                }
                case KEMPSTON: {
                    z80HeaderV3[29] = (byte)(z80HeaderV3[29] | 0x40);
                    break;
                }
                case SINCLAIR1: {
                    z80HeaderV3[29] = (byte)(z80HeaderV3[29] | 0x80);
                    break;
                }
                case SINCLAIR2: {
                    z80HeaderV3[29] = (byte)(z80HeaderV3[29] | 0xC0);
                }
            }
            z80HeaderV3[30] = 55;
            z80HeaderV3[32] = (byte)this.z80.getRegPC();
            z80HeaderV3[33] = (byte)(this.z80.getRegPC() >>> 8);
            switch (this.spectrum.getSpectrumModel()) {
                case SPECTRUM16K: {
                    z80HeaderV3[37] = (byte)(z80HeaderV3[37] | 0x80);
                }
                case SPECTRUM48K: {
                    z80HeaderV3[34] = (byte)(this.spectrum.isConnectedIF1() ? 1 : 0);
                    break;
                }
                case SPECTRUM128K: {
                    z80HeaderV3[34] = (byte)(this.spectrum.isConnectedIF1() ? 5 : 4);
                    break;
                }
                case SPECTRUMPLUS2: {
                    z80HeaderV3[34] = 12;
                    break;
                }
                case SPECTRUMPLUS2A: {
                    z80HeaderV3[34] = 13;
                    break;
                }
                case SPECTRUMPLUS3: {
                    z80HeaderV3[34] = 7;
                }
            }
            if (this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUM48K) {
                z80HeaderV3[35] = (byte)this.spectrum.getPort7ffd();
            }
            if (this.memory.isIF1RomPaged()) {
                z80HeaderV3[36] = -1;
            }
            if (this.spectrum.isEnabledAY()) {
                z80HeaderV3[37] = (byte)(z80HeaderV3[37] | 4);
                z80HeaderV3[38] = (byte)this.ay8912.getAddressLatch();
                int[] regAY = this.ay8912.getRegAY();
                for (int reg = 0; reg < 16; ++reg) {
                    z80HeaderV3[39 + reg] = (byte)regAY[reg];
                }
            }
            if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                z80HeaderV3[86] = (byte)this.spectrum.getPort1ffd();
            }
            this.fOut.write(z80HeaderV3, 0, z80HeaderV3.length);
            byte[] buffer = new byte[16384];
            if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                bufLen = this.compressPageZ80(buffer, 5);
                if (bufLen == 16384) {
                    this.fOut.write(255);
                    this.fOut.write(255);
                } else {
                    this.fOut.write(bufLen);
                    this.fOut.write(bufLen >>> 8);
                }
                this.fOut.write(8);
                this.fOut.write(buffer, 0, bufLen);
                bufLen = this.compressPageZ80(buffer, 2);
                if (bufLen == 16384) {
                    this.fOut.write(255);
                    this.fOut.write(255);
                } else {
                    this.fOut.write(bufLen);
                    this.fOut.write(bufLen >>> 8);
                }
                this.fOut.write(4);
                this.fOut.write(buffer, 0, bufLen);
                bufLen = this.compressPageZ80(buffer, 0);
                if (bufLen == 16384) {
                    this.fOut.write(255);
                    this.fOut.write(255);
                } else {
                    this.fOut.write(bufLen);
                    this.fOut.write(bufLen >>> 8);
                }
                this.fOut.write(5);
                this.fOut.write(buffer, 0, bufLen);
            } else {
                for (int page = 0; page < 8; ++page) {
                    bufLen = this.compressPageZ80(buffer, page);
                    if (bufLen == 16384) {
                        this.fOut.write(255);
                        this.fOut.write(255);
                    } else {
                        this.fOut.write(bufLen);
                        this.fOut.write(bufLen >>> 8);
                    }
                    this.fOut.write(page + 3);
                    this.fOut.write(buffer, 0, bufLen);
                }
            }
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_WRITE_ERROR", ex);
        }
        finally {
            try {
                if (this.fOut != null) {
                    this.fOut.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SnapshotZ80.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }
}

