/*
 * Decompiled with CFR 0.152.
 */
package snapshots;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import machine.Keyboard;
import machine.MachineTypes;
import snapshots.AY8912State;
import snapshots.MemoryState;
import snapshots.SnapshotException;
import snapshots.SnapshotFile;
import snapshots.SpectrumState;
import snapshots.Z80State;
import z80core.Z80;

public class SnapshotSZX
implements SnapshotFile {
    private BufferedInputStream fIn;
    private BufferedOutputStream fOut;
    private SpectrumState spectrum;
    private Z80State z80;
    private MemoryState memory;
    private AY8912State ay8912;
    private boolean tapeEmbedded;
    private boolean tapeLinked;
    private byte[] tapeData;
    private int tapeBlock;
    private String tapeName;
    private String tapeExtension;
    private static final int ZXST_HEADER = 1414748250;
    private static final int ZXSTMID_16K = 0;
    private static final int ZXSTMID_48K = 1;
    private static final int ZXSTMID_128K = 2;
    private static final int ZXSTMID_PLUS2 = 3;
    private static final int ZXSTMID_PLUS2A = 4;
    private static final int ZXSTMID_PLUS3 = 5;
    private static final int ZXSTMID_PLUS3E = 6;
    private static final int ZXSTMID_PENTAGON128 = 7;
    private static final int ZXSTMID_TC2048 = 8;
    private static final int ZXSTMID_TC2068 = 9;
    private static final int ZXSTMID_SCORPION = 10;
    private static final int ZXSTMID_SE = 11;
    private static final int ZXSTMID_TS2068 = 12;
    private static final int ZXSTMID_PENTAGON512 = 13;
    private static final int ZXSTMID_PENTAGON1024 = 14;
    private static final int ZXSTMID_NTSC48K = 15;
    private static final int ZXSTMID_128KE = 16;
    private static final int ZXSTMF_ALTERNATETIMINGS = 1;
    private static final int ZXSTBID_ZXATASP = 1413568602;
    private static final int ZXSTAF_UPLOADJUMPER = 1;
    private static final int ZXSTAF_WRITEPROTECT = 2;
    private static final int ZXSTBID_ATARAM = 1347572801;
    private static final int ZXSTAF_COMPRESSED = 1;
    private static final int ZXSTBID_AY = 22849;
    private static final int ZXSTAYF_FULLERBOX = 1;
    private static final int ZXSTAYF_128AY = 2;
    private static final int ZXSTBID_ZXCF = 1178818650;
    private static final int ZXSTCF_UPLOADJUMPER = 1;
    private static final int ZXSTBID_CFRAM = 1347569219;
    private static final int ZXSTCRF_COMPRESSED = 1;
    private static final int ZXSTBID_COVOX = 1482051395;
    private static final int ZXSTBID_BETA128 = 942813506;
    private static final int ZXSTBETAF_CONNECTED = 1;
    private static final int ZXSTBETAF_CUSTOMROM = 2;
    private static final int ZXSTBETAF_PAGED = 4;
    private static final int ZXSTBETAF_AUTOBOOT = 8;
    private static final int ZXSTBETAF_SEEKLOWER = 16;
    private static final int ZXSTBETAF_COMPRESSED = 32;
    private static final int ZXSTBID_BETADISK = 1263748162;
    private static final int ZXSTBID_CREATOR = 1381257795;
    private static final int ZXSTBID_DOCK = 1262702404;
    private static final int ZXSTBID_DSKFILE = 4936516;
    private static final int ZXSTDSKF_COMPRESSED = 1;
    private static final int ZXSTDSKF_EMBEDDED = 2;
    private static final int ZXSTDSKF_SIDEB = 4;
    private static final int ZXSTBID_GS = 21319;
    private static final int ZXSTBID_GSRAMPAGE = 1347572551;
    private static final int ZXSTBID_KEYBOARD = 1113146699;
    private static final int ZXSTKF_ISSUE2 = 1;
    private static final int ZXSKJT_KEMPSTON = 0;
    private static final int ZXSKJT_FULLER = 1;
    private static final int ZXSKJT_CURSOR = 2;
    private static final int ZXSKJT_SINCLAIR1 = 3;
    private static final int ZXSKJT_SINCLAIR2 = 4;
    private static final int ZXSKJT_SPECTRUMPLUS = 5;
    private static final int ZXSKJT_TIMEX1 = 6;
    private static final int ZXSKJT_TIMEX2 = 7;
    private static final int ZXSKJT_NONE = 8;
    private static final int ZXSTBID_IF1 = 3229257;
    private static final int ZXSTIF1F_ENABLED = 1;
    private static final int ZXSTIF1F_COMPRESSED = 2;
    private static final int ZXSTIF1F_PAGED = 4;
    private static final int ZXSTBID_IF2ROM = 1379026505;
    private static final int ZXSTBID_JOYSTICK = 5853002;
    private static final int ZXSTJT_KEMPSTON = 0;
    private static final int ZXSTJT_FULLER = 1;
    private static final int ZXSTJT_CURSOR = 2;
    private static final int ZXSTJT_SINCLAIR1 = 3;
    private static final int ZXSTJT_SINCLAIR2 = 4;
    private static final int ZXSTJT_COMCOM = 5;
    private static final int ZXSTJT_TIMEX1 = 6;
    private static final int ZXSTJT_TIMEX2 = 7;
    private static final int ZXSTJT_DISABLED = 8;
    private static final int ZXSTBID_MICRODRIVE = 1448232013;
    private static final int ZXSTMDF_COMPRESSED = 1;
    private static final int ZXSTMDF_EMBEDDED = 2;
    private static final int ZXSTBID_MOUSE = 1297632577;
    private static final int ZXSTBID_MULTIFACE = 1162036813;
    private static final int ZXSTMFM_1 = 0;
    private static final int ZXSTMFM_128 = 1;
    private static final int ZXSTMF_PAGEDIN = 1;
    private static final int ZXSTMF_COMPRESSED = 2;
    private static final int ZXSTMF_SOFTWARELOCKOUT = 4;
    private static final int ZXSTMF_REDBUTTONDISABLED = 8;
    private static final int ZXSTMF_DISABLED = 16;
    private static final int ZXSTMF_16KRAMMODE = 32;
    private static final int ZXSTBID_RAMPAGE = 1347240274;
    private static final int ZXSTRF_COMPRESSED = 1;
    private static final int ZXSTBID_PLUS3DISK = 13099;
    private static final int ZXSTBID_PLUSD = 1146309712;
    private static final int ZXSTBID_PLUSDDISK = 1263748176;
    private static final int ZXSTBID_ROM = 5066578;
    private static final int ZXSTBID_TIMEXREGS = 1145848659;
    private static final int ZXSTBID_SIMPLEIDE = 1162103123;
    private static final int ZXSTBID_SPECDRUM = 1297437252;
    private static final int ZXSTBID_SPECREGS = 1380143187;
    private static final int ZXSTBID_ZXTAPE = 1162887508;
    private static final int ZXSTTP_EMBEDDED = 1;
    private static final int ZXSTTP_COMPRESSED = 2;
    private static final int ZXSTBID_USPEECH = 1162892117;
    private static final int ZXSTBID_ZXPRINTER = 1380997210;
    private static final int ZXSTBID_Z80REGS = 1378891866;
    private static final int ZXSTZF_EILAST = 1;
    private static final int ZXSTZF_HALTED = 2;
    private static final int ZXSTZF_FSET = 4;
    private static final int ZXSTBID_PALETTE = 1414810704;
    private static final int ZXSTPALETTE_DISABLED = 0;
    private static final int ZXSTPALETTE_ENABLED = 1;
    private static final int ZXSTBID_OPUS = 1398100047;
    private static final int ZXSTOPUSF_PAGED = 1;
    private static final int ZXSTOPUSF_COMPRESSED = 2;
    private static final int ZXSTOPUSF_SEEKLOWER = 4;
    private static final int ZXSTOPUSF_CUSTOMROM = 8;
    private static final int ZXSTBID_ODSK = 1263748175;
    private static final int ZXSTOPDT_OPD = 0;
    private static final int ZXSTOPDT_OPU = 1;
    private static final int ZXSTOPDT_FLOPPY0 = 2;
    private static final int ZXSTOPDT_FLOPPY1 = 3;
    private static final int ZXSTOPDF_EMBEDDED = 1;
    private static final int ZXSTOPDF_COMPRESSED = 2;
    private static final int ZXSTOPDF_WRITEPROTECT = 4;
    private static final int ZXSTBID_LEC = 4408652;
    private static final int ZXSTBID_LECRAMPAGE = 1347568460;
    private static final int ZXSTLCRPF_COMPRESSED = 1;
    private static final int ZXSTBID_SPECTRANET = 1413828179;
    private static final int ZXSTSNETF_PAGED = 1;
    private static final int ZXSTSNETF_PAGED_VIA_IO = 2;
    private static final int ZXSTSNETF_PROGRAMMABLE_TRAP_ACTIVE = 4;
    private static final int ZXSTSNETF_PROGRAMMABLE_TRAP_MSB = 8;
    private static final int ZXSTSNETF_ALL_DISABLED = 16;
    private static final int ZXSTSNETF_RST8_DISABLED = 32;
    private static final int ZXSTSNETF_DENY_DOWNSTREAM_A15 = 64;
    private static final int ZXSTSNETF_FLASH_COMPRESSED = 128;
    private static final int ZXSTSNETF_RAM_COMPRESSED = 256;

    public boolean isTapeEmbedded() {
        return this.tapeEmbedded;
    }

    public void setTapeEmbedded(boolean tapeEmbedded) {
        this.tapeEmbedded = tapeEmbedded;
    }

    public boolean isTapeLinked() {
        return this.tapeLinked;
    }

    public void setTapeLinked(boolean tapeLinked) {
        this.tapeLinked = tapeLinked;
    }

    public byte[] getTapeData() {
        return this.tapeData;
    }

    public void setTapeData(byte[] tapeData) {
        this.tapeData = tapeData;
    }

    public int getTapeBlock() {
        return this.tapeBlock;
    }

    public void setTapeBlock(int tapeBlock) {
        this.tapeBlock = tapeBlock & 0xFFFF;
    }

    public String getTapeName() {
        return this.tapeName;
    }

    public void setTapeName(String tapeName) {
        this.tapeName = tapeName;
    }

    public String getTapeExtension() {
        return this.tapeExtension;
    }

    public void setTapeExtension(String tapeExtension) {
        this.tapeExtension = tapeExtension;
    }

    private int dwMagicToInt(byte[] dwMagic) {
        int value0 = dwMagic[0] & 0xFF;
        int value1 = (dwMagic[1] & 0xFF) << 8;
        int value2 = (dwMagic[2] & 0xFF) << 16;
        int value3 = (dwMagic[3] & 0xFF) << 24;
        return value3 | value2 | value1 | value0;
    }

    @Override
    public SpectrumState load(File filename) throws SnapshotException {
        byte[] dwMagic = new byte[4];
        byte[] dwSize = new byte[4];
        this.spectrum = new SpectrumState();
        this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
        try {
            try {
                this.fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            int readed = this.fIn.read(dwMagic);
            if (readed != dwMagic.length || this.dwMagicToInt(dwMagic) != 1414748250) {
                throw new SnapshotException("NOT_SNAPSHOT_FILE");
            }
            readed = this.fIn.read(dwSize);
            if (readed != dwSize.length) {
                throw new SnapshotException("NOT_SNAPSHOT_FILE");
            }
            byte szxMajorVer = dwSize[0];
            byte szxMinorVer = dwSize[1];
            switch (dwSize[2] & 0xFF) {
                case 0: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                    break;
                }
                case 1: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                    break;
                }
                case 2: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                    break;
                }
                case 3: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2);
                    break;
                }
                case 4: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS2A);
                    break;
                }
                case 5: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUMPLUS3);
                    break;
                }
                default: {
                    throw new SnapshotException("UNSUPPORTED_SNAPSHOT");
                }
            }
            block53: while (this.fIn.available() > 0) {
                readed = this.fIn.read(dwMagic);
                if ((readed += this.fIn.read(dwSize)) != 8) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                int szxId = this.dwMagicToInt(dwMagic);
                int szxLen = this.dwMagicToInt(dwSize);
                if (szxLen < 1) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                switch (szxId) {
                    case 1381257795: {
                        byte[] chData;
                        byte[] szCreator = new byte[32];
                        readed = this.fIn.read(szCreator);
                        int majorVersion = this.fIn.read() + this.fIn.read() * 256;
                        int minorVersion = this.fIn.read() + this.fIn.read() * 256;
                        if ((szxLen -= 36) <= 0 || (readed = this.fIn.read(chData = new byte[szxLen])) == szxLen) continue block53;
                        throw new SnapshotException("FILE_READ_ERROR");
                    }
                    case 1378891866: {
                        if (szxLen != 37) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        byte[] z80Regs = new byte[szxLen];
                        readed = this.fIn.read(z80Regs);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.z80 = new Z80State();
                        this.spectrum.setZ80State(this.z80);
                        this.z80.setRegF(z80Regs[0]);
                        this.z80.setRegA(z80Regs[1]);
                        this.z80.setRegC(z80Regs[2]);
                        this.z80.setRegB(z80Regs[3]);
                        this.z80.setRegE(z80Regs[4]);
                        this.z80.setRegD(z80Regs[5]);
                        this.z80.setRegL(z80Regs[6]);
                        this.z80.setRegH(z80Regs[7]);
                        this.z80.setRegFx(z80Regs[8]);
                        this.z80.setRegAx(z80Regs[9]);
                        this.z80.setRegCx(z80Regs[10]);
                        this.z80.setRegBx(z80Regs[11]);
                        this.z80.setRegEx(z80Regs[12]);
                        this.z80.setRegDx(z80Regs[13]);
                        this.z80.setRegLx(z80Regs[14]);
                        this.z80.setRegHx(z80Regs[15]);
                        this.z80.setRegIX(z80Regs[16] & 0xFF | z80Regs[17] << 8);
                        this.z80.setRegIY(z80Regs[18] & 0xFF | z80Regs[19] << 8);
                        this.z80.setRegSP(z80Regs[20] & 0xFF | z80Regs[21] << 8);
                        this.z80.setRegPC(z80Regs[22] & 0xFF | z80Regs[23] << 8);
                        this.z80.setRegI(z80Regs[24]);
                        this.z80.setRegR(z80Regs[25]);
                        this.z80.setIFF1((z80Regs[26] & 1) != 0);
                        this.z80.setIFF2((z80Regs[27] & 1) != 0);
                        switch (z80Regs[28] & 3) {
                            case 0: {
                                this.z80.setIM(Z80.IntMode.IM0);
                                break;
                            }
                            case 1: {
                                this.z80.setIM(Z80.IntMode.IM1);
                                break;
                            }
                            case 2: {
                                this.z80.setIM(Z80.IntMode.IM2);
                            }
                        }
                        this.spectrum.setTstates((z80Regs[32] & 0xFF) << 24 | (z80Regs[31] & 0xFF) << 16 | (z80Regs[30] & 0xFF) << 8 | z80Regs[29] & 0xFF);
                        switch (z80Regs[34]) {
                            case 1: {
                                this.z80.setPendingEI(true);
                                break;
                            }
                            case 2: {
                                this.z80.setHalted(true);
                                break;
                            }
                            default: {
                                this.z80.setPendingEI(false);
                                this.z80.setHalted(false);
                            }
                        }
                        if (szxMajorVer == 1 && szxMinorVer > 3) {
                            this.z80.setMemPtr(z80Regs[35] & 0xFF | z80Regs[36] << 8);
                        }
                        if (szxMajorVer != 1 || szxMinorVer <= 4) continue block53;
                        this.z80.setFlagQ((z80Regs[34] & 4) != 0);
                        continue block53;
                    }
                    case 1380143187: {
                        if (szxLen != 8) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        byte[] specRegs = new byte[szxLen];
                        readed = this.fIn.read(specRegs);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.spectrum.setBorder(specRegs[0]);
                        this.spectrum.setPort7ffd(specRegs[1]);
                        this.spectrum.setPort1ffd(specRegs[2]);
                        continue block53;
                    }
                    case 1113146699: {
                        if (szxLen != 5) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        byte[] keyb = new byte[szxLen];
                        readed = this.fIn.read(keyb);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.spectrum.setIssue2((keyb[0] & 1) != 0);
                        switch (keyb[4] & 0xFF) {
                            case 0: {
                                this.spectrum.setJoystick(Keyboard.JoystickModel.KEMPSTON);
                                continue block53;
                            }
                            case 1: {
                                this.spectrum.setJoystick(Keyboard.JoystickModel.FULLER);
                                continue block53;
                            }
                            case 2: {
                                this.spectrum.setJoystick(Keyboard.JoystickModel.CURSOR);
                                continue block53;
                            }
                            case 3: {
                                this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR1);
                                continue block53;
                            }
                            case 4: {
                                this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR2);
                                continue block53;
                            }
                        }
                        this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
                        continue block53;
                    }
                    case 22849: {
                        if (szxLen != 18) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        byte[] ayRegs = new byte[szxLen];
                        readed = this.fIn.read(ayRegs);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.spectrum.setEnabledAY(true);
                        if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K && (ayRegs[0] & 2) == 0) {
                            this.spectrum.setEnabledAYon48k(false);
                        }
                        this.ay8912 = new AY8912State();
                        this.spectrum.setAY8912State(this.ay8912);
                        int[] regAY = new int[16];
                        this.ay8912.setAddressLatch(ayRegs[1]);
                        for (int idx = 0; idx < 16; ++idx) {
                            regAY[idx] = ayRegs[2 + idx] & 0xFF;
                        }
                        this.ay8912.setRegAY(regAY);
                        continue block53;
                    }
                    case 1347240274: {
                        int count;
                        byte[] ramPage;
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        if ((readed = this.fIn.read(ramPage = new byte[3])) != ramPage.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((szxLen -= 3) > 16384) {
                            throw new SnapshotException("SZX_RAMP_SIZE_ERROR");
                        }
                        byte[] chData = new byte[szxLen];
                        readed = this.fIn.read(chData);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((ramPage[0] & 1) == 0) {
                            this.memory.setPageRam(ramPage[2] & 7, chData);
                            continue block53;
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(chData);
                        InflaterInputStream iis = new InflaterInputStream(bais);
                        byte[] pageRAM = new byte[16384];
                        for (readed = 0; readed < pageRAM.length && (count = iis.read(pageRAM, readed, pageRAM.length - readed)) != -1; readed += count) {
                        }
                        iis.close();
                        if (readed != 16384) {
                            throw new SnapshotException("SZX_RAMP_SIZE_ERROR");
                        }
                        this.memory.setPageRam(ramPage[2] & 7, pageRAM);
                        continue block53;
                    }
                    case 1162036813: {
                        int count;
                        byte[] mf;
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        if ((readed = this.fIn.read(mf = new byte[2])) != mf.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((szxLen -= 2) > 16384) {
                            while (szxLen > 0) {
                                szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                            }
                            continue block53;
                        }
                        byte[] chData = new byte[szxLen];
                        readed = this.fIn.read(chData);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((mf[1] & 0x20) != 0) {
                            this.spectrum.setMultiface(false);
                            continue block53;
                        }
                        this.spectrum.setMultiface(true);
                        if ((mf[0] & 1) != 0) {
                            this.memory.setMf128on48k(true);
                        }
                        if ((mf[1] & 1) != 0) {
                            this.memory.setMultifacePaged(true);
                        }
                        if ((mf[1] & 4) != 0) {
                            this.memory.setMultifaceLocked(true);
                        }
                        if ((mf[1] & 2) == 0) {
                            if (chData.length == 8192) {
                                this.memory.setMultifaceRam(chData);
                                continue block53;
                            }
                            this.spectrum.setMultiface(false);
                            continue block53;
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(chData);
                        InflaterInputStream iis = new InflaterInputStream(bais);
                        byte[] mfRAM = new byte[8192];
                        for (readed = 0; readed < mfRAM.length && (count = iis.read(mfRAM, readed, mfRAM.length - readed)) != -1; readed += count) {
                        }
                        iis.close();
                        if (readed != mfRAM.length) {
                            System.out.println("Multiface RAM uncompress error!: " + readed);
                            this.spectrum.setMultiface(false);
                            continue block53;
                        }
                        this.memory.setMultifaceRam(mfRAM);
                        continue block53;
                    }
                    case 1414810704: {
                        if (szxLen != 66) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.spectrum.setULAPlusEnabled(true);
                        byte[] ULAplusRegs = new byte[szxLen];
                        readed = this.fIn.read(ULAplusRegs);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if (ULAplusRegs[0] == 1) {
                            this.spectrum.setULAPlusActive(true);
                        }
                        this.spectrum.setPaletteGroup(ULAplusRegs[1]);
                        int[] palette = new int[64];
                        for (int reg = 0; reg < 64; ++reg) {
                            palette[reg] = ULAplusRegs[2 + reg] & 0xFF;
                        }
                        this.spectrum.setULAPlusPalette(palette);
                        continue block53;
                    }
                    case 1162887508: {
                        InflaterInputStream iis;
                        ByteArrayInputStream bais;
                        byte[] chData;
                        byte[] tape = new byte[4];
                        readed = this.fIn.read(tape);
                        if (readed != tape.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        szxLen -= tape.length;
                        this.tapeBlock = tape[1] << 8 & 0xFF00 | tape[0] & 0xFF;
                        byte[] qword = new byte[4];
                        readed = this.fIn.read(qword);
                        if (readed != qword.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        szxLen -= qword.length;
                        int uSize = this.dwMagicToInt(qword);
                        readed = this.fIn.read(qword);
                        if (readed != qword.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        szxLen -= qword.length;
                        byte[] szFileExtension = new byte[16];
                        readed = this.fIn.read(szFileExtension);
                        if (readed != szFileExtension.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        szxLen -= szFileExtension.length;
                        if ((tape[2] & 1) != 0) {
                            int nChars;
                            for (nChars = 0; nChars < szFileExtension.length && szFileExtension[nChars] != 0; ++nChars) {
                            }
                            this.tapeExtension = new String(szFileExtension, 0, nChars);
                            this.tapeName = filename.getName();
                            chData = new byte[szxLen];
                            readed = this.fIn.read(chData);
                            if (readed != szxLen) {
                                throw new SnapshotException("FILE_READ_ERROR");
                            }
                            if ((tape[2] & 2) != 0) {
                                int count;
                                bais = new ByteArrayInputStream(chData);
                                iis = new InflaterInputStream(bais);
                                this.tapeData = new byte[uSize];
                                for (readed = 0; readed < this.tapeData.length && (count = iis.read(this.tapeData, readed, this.tapeData.length - readed)) != -1; readed += count) {
                                }
                                iis.close();
                                if (readed != uSize) {
                                    System.out.println("Tape uncompress error!");
                                    continue block53;
                                }
                            } else {
                                this.tapeData = chData;
                            }
                            this.tapeEmbedded = true;
                            continue block53;
                        }
                        chData = new byte[szxLen];
                        readed = this.fIn.read(chData);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.tapeName = new String(chData, 0, szxLen - 1);
                        this.tapeLinked = true;
                        continue block53;
                    }
                    case 1379026505: {
                        int count;
                        byte[] dwCartSize;
                        if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                            System.out.println("SZX Error: +2a/+3 snapshot with IF-2 block. Skipping...");
                            while (szxLen > 0) {
                                szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                            }
                            continue block53;
                        }
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        if ((readed = this.fIn.read(dwCartSize = new byte[4])) != dwCartSize.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        int romLen = this.dwMagicToInt(dwCartSize);
                        if (romLen > 16384) {
                            while (romLen > 0) {
                                romLen = (int)((long)romLen - this.fIn.skip(romLen));
                            }
                            continue block53;
                        }
                        byte[] chData = new byte[romLen];
                        readed = this.fIn.read(chData);
                        if (readed != chData.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if (romLen == 16384) {
                            this.memory.setIF2RomPaged(true);
                            this.memory.setIF2Rom(chData);
                            continue block53;
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(chData);
                        InflaterInputStream iis = new InflaterInputStream(bais);
                        byte[] IF2Rom = new byte[16384];
                        for (readed = 0; readed < IF2Rom.length && (count = iis.read(IF2Rom, readed, IF2Rom.length - readed)) != -1; readed += count) {
                        }
                        iis.close();
                        if (readed != IF2Rom.length) {
                            System.out.println("Rom uncompress error!");
                            continue block53;
                        }
                        this.memory.setIF2RomPaged(true);
                        this.memory.setIF2Rom(IF2Rom);
                        continue block53;
                    }
                    case 5853002: {
                        if (szxLen != 6) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        while (szxLen > 0) {
                            szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                        }
                        continue block53;
                    }
                    case 3229257: {
                        if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                            System.out.println("SZX Error: +2a/+3 snapshot with IF-1 block. Skipping...");
                            while (szxLen > 0) {
                                szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                            }
                            continue block53;
                        }
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        int if1Flags = this.fIn.read() + this.fIn.read() * 256;
                        szxLen -= 2;
                        this.spectrum.setConnectedIF1((if1Flags & 1) != 0);
                        this.memory.setIF1RomPaged((if1Flags & 4) != 0);
                        this.spectrum.setNumMicrodrives((byte)this.fIn.read());
                        --szxLen;
                        while (szxLen > 0) {
                            szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                        }
                        continue block53;
                    }
                    case 1448232013: {
                        while (szxLen > 0) {
                            szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                        }
                        continue block53;
                    }
                    case 4408652: {
                        byte[] lecHeader;
                        if (this.spectrum.getSpectrumModel() != MachineTypes.SPECTRUM48K) {
                            System.out.println("SZX Error: LEC Block with a Spectrum model != 48k");
                            while (szxLen > 0) {
                                szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                            }
                            continue block53;
                        }
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        if ((readed = this.fIn.read(lecHeader = new byte[2])) != lecHeader.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.spectrum.setConnectedLec(true);
                        this.memory.setPortFD(lecHeader[0]);
                        continue block53;
                    }
                    case 1347568460: {
                        int count;
                        byte[] lecPage;
                        if (this.memory == null) {
                            this.memory = new MemoryState();
                            this.spectrum.setMemoryState(this.memory);
                        }
                        if ((readed = this.fIn.read(lecPage = new byte[3])) != lecPage.length) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((szxLen -= 3) > 32768) {
                            throw new SnapshotException("SZX_RAMP_SIZE_ERROR");
                        }
                        byte[] chData = new byte[szxLen];
                        readed = this.fIn.read(chData);
                        if (readed != szxLen) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        if ((lecPage[0] & 1) == 0) {
                            this.memory.setLecPageRam(lecPage[2] & 0xF, chData);
                            continue block53;
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(chData);
                        InflaterInputStream iis = new InflaterInputStream(bais);
                        byte[] lecRAM = new byte[32768];
                        for (readed = 0; readed < lecRAM.length && (count = iis.read(lecRAM, readed, lecRAM.length - readed)) != -1; readed += count) {
                        }
                        iis.close();
                        if (readed != 32768) {
                            throw new SnapshotException("SZX_RAMP_SIZE_ERROR");
                        }
                        this.memory.setLecPageRam(lecPage[2] & 0xF, lecRAM);
                        continue block53;
                    }
                    case 13099: 
                    case 21319: 
                    case 4936516: 
                    case 5066578: 
                    case 942813506: 
                    case 1145848659: 
                    case 1146309712: 
                    case 1162103123: 
                    case 1162892117: 
                    case 1178818650: 
                    case 1262702404: 
                    case 1263748162: 
                    case 1263748175: 
                    case 1263748176: 
                    case 1297437252: 
                    case 1297632577: 
                    case 1347569219: 
                    case 1347572551: 
                    case 1347572801: 
                    case 1380997210: 
                    case 1398100047: 
                    case 1413568602: 
                    case 1413828179: 
                    case 1482051395: {
                        while (szxLen > 0) {
                            szxLen = (int)((long)szxLen - this.fIn.skip(szxLen));
                        }
                        String blockID = new String(dwMagic);
                        System.out.println(String.format("SZX block ID '%s' readed but not emulated. Skipping...", blockID));
                        continue block53;
                    }
                }
                String header = new String(dwMagic);
                System.out.println(String.format("Unknown SZX block ID: %s", header));
                throw new SnapshotException("FILE_READ_ERROR");
            }
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_READ_ERROR");
        }
        finally {
            try {
                if (this.fIn != null) {
                    this.fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SnapshotSZX.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.spectrum;
    }

    @Override
    public boolean save(File filename, SpectrumState state) throws SnapshotException {
        this.spectrum = state;
        this.z80 = this.spectrum.getZ80State();
        this.memory = this.spectrum.getMemoryState();
        this.ay8912 = this.spectrum.getAY8912State();
        try {
            int pageLen;
            DeflaterOutputStream dos;
            ByteArrayOutputStream baos;
            byte[] ram;
            try {
                this.fOut = new BufferedOutputStream(new FileOutputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            String blockID = "ZXST";
            this.fOut.write(blockID.getBytes("US-ASCII"));
            this.fOut.write(1);
            this.fOut.write(5);
            switch (this.spectrum.getSpectrumModel()) {
                case SPECTRUM16K: {
                    this.fOut.write(0);
                    break;
                }
                case SPECTRUM48K: {
                    this.fOut.write(1);
                    break;
                }
                case SPECTRUM128K: {
                    this.fOut.write(2);
                    break;
                }
                case SPECTRUMPLUS2: {
                    this.fOut.write(3);
                    break;
                }
                case SPECTRUMPLUS2A: {
                    this.fOut.write(4);
                    break;
                }
                case SPECTRUMPLUS3: {
                    this.fOut.write(5);
                }
            }
            this.fOut.write(0);
            blockID = "CRTR";
            this.fOut.write(blockID.getBytes("US-ASCII"));
            this.fOut.write(37);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            blockID = "JSpeccy v0.93";
            byte[] szCreator = new byte[32];
            System.arraycopy(blockID.getBytes("US-ASCII"), 0, szCreator, 0, blockID.getBytes("US-ASCII").length);
            this.fOut.write(szCreator);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(89);
            this.fOut.write(0);
            blockID = "Z80R";
            this.fOut.write(blockID.getBytes("US-ASCII"));
            this.fOut.write(37);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            byte[] z80r = new byte[37];
            z80r[0] = (byte)this.z80.getRegF();
            z80r[1] = (byte)this.z80.getRegA();
            z80r[2] = (byte)this.z80.getRegC();
            z80r[3] = (byte)this.z80.getRegB();
            z80r[4] = (byte)this.z80.getRegE();
            z80r[5] = (byte)this.z80.getRegD();
            z80r[6] = (byte)this.z80.getRegL();
            z80r[7] = (byte)this.z80.getRegH();
            z80r[8] = (byte)this.z80.getRegFx();
            z80r[9] = (byte)this.z80.getRegAx();
            z80r[10] = (byte)this.z80.getRegCx();
            z80r[11] = (byte)this.z80.getRegBx();
            z80r[12] = (byte)this.z80.getRegEx();
            z80r[13] = (byte)this.z80.getRegDx();
            z80r[14] = (byte)this.z80.getRegLx();
            z80r[15] = (byte)this.z80.getRegHx();
            z80r[16] = (byte)this.z80.getRegIX();
            z80r[17] = (byte)(this.z80.getRegIX() >>> 8);
            z80r[18] = (byte)this.z80.getRegIY();
            z80r[19] = (byte)(this.z80.getRegIY() >>> 8);
            z80r[20] = (byte)this.z80.getRegSP();
            z80r[21] = (byte)(this.z80.getRegSP() >>> 8);
            z80r[22] = (byte)this.z80.getRegPC();
            z80r[23] = (byte)(this.z80.getRegPC() >>> 8);
            z80r[24] = (byte)this.z80.getRegI();
            z80r[25] = (byte)this.z80.getRegR();
            if (this.z80.isIFF1()) {
                z80r[26] = 1;
            }
            if (this.z80.isIFF2()) {
                z80r[27] = 1;
            }
            z80r[28] = (byte)this.z80.getIM().ordinal();
            z80r[29] = (byte)this.spectrum.getTstates();
            z80r[30] = (byte)(this.spectrum.getTstates() >>> 8);
            z80r[31] = (byte)(this.spectrum.getTstates() >>> 16);
            z80r[32] = (byte)(this.spectrum.getTstates() >>> 24);
            if (this.z80.isPendingEI()) {
                z80r[34] = 1;
            }
            if (this.z80.isHalted()) {
                z80r[34] = 2;
            }
            if (this.z80.isFlagQ()) {
                z80r[34] = (byte)(z80r[34] | 4);
            }
            z80r[35] = (byte)this.z80.getMemPtr();
            z80r[36] = (byte)(this.z80.getMemPtr() >>> 8);
            this.fOut.write(z80r);
            blockID = "SPCR";
            this.fOut.write(blockID.getBytes("US-ASCII"));
            this.fOut.write(8);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            byte[] specr = new byte[8];
            specr[0] = (byte)this.spectrum.getBorder();
            specr[1] = (byte)this.spectrum.getPort7ffd();
            specr[2] = (byte)this.spectrum.getPort1ffd();
            this.fOut.write(specr);
            boolean[] save = new boolean[8];
            switch (this.spectrum.getSpectrumModel()) {
                case SPECTRUM16K: {
                    save[5] = true;
                    break;
                }
                case SPECTRUM48K: {
                    save[5] = true;
                    save[2] = true;
                    save[0] = true;
                    break;
                }
                default: {
                    Arrays.fill(save, true);
                }
            }
            for (int page = 0; page < 8; ++page) {
                if (!save[page]) continue;
                ram = this.memory.getPageRam(page);
                baos = new ByteArrayOutputStream();
                dos = new DeflaterOutputStream(baos);
                dos.write(ram, 0, ram.length);
                dos.close();
                blockID = "RAMP";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                pageLen = baos.size() + 3;
                this.fOut.write(pageLen);
                this.fOut.write(pageLen >>> 8);
                this.fOut.write(pageLen >>> 16);
                this.fOut.write(pageLen >>> 24);
                this.fOut.write(1);
                this.fOut.write(0);
                this.fOut.write(page);
                baos.writeTo(this.fOut);
            }
            blockID = "KEYB";
            this.fOut.write(blockID.getBytes("US-ASCII"));
            this.fOut.write(5);
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            if (this.spectrum.isIssue2()) {
                this.fOut.write(1);
            } else {
                this.fOut.write(0);
            }
            this.fOut.write(0);
            this.fOut.write(0);
            this.fOut.write(0);
            switch (this.spectrum.getJoystick()) {
                case NONE: {
                    this.fOut.write(8);
                    break;
                }
                case KEMPSTON: {
                    this.fOut.write(0);
                    break;
                }
                case SINCLAIR1: {
                    this.fOut.write(3);
                    break;
                }
                case SINCLAIR2: {
                    this.fOut.write(4);
                    break;
                }
                case CURSOR: {
                    this.fOut.write(2);
                    break;
                }
                case FULLER: {
                    this.fOut.write(1);
                }
            }
            if (this.spectrum.isEnabledAY()) {
                blockID = "AY\u0000\u0000";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                this.fOut.write(18);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                    this.fOut.write(2);
                } else {
                    this.fOut.write(0);
                }
                this.fOut.write(this.ay8912.getAddressLatch());
                int[] regAY = this.ay8912.getRegAY();
                for (int reg = 0; reg < 16; ++reg) {
                    this.fOut.write(regAY[reg]);
                }
            }
            if (this.spectrum.isULAPlusEnabled()) {
                blockID = "PLTT";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                this.fOut.write(66);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                if (this.spectrum.isULAPlusActive()) {
                    this.fOut.write(1);
                } else {
                    this.fOut.write(0);
                }
                this.fOut.write(this.spectrum.getPaletteGroup());
                int[] palette = this.spectrum.getULAPlusPalette();
                for (int color = 0; color < 64; ++color) {
                    this.fOut.write(palette[color]);
                }
            }
            if (this.spectrum.isMultiface()) {
                blockID = "MFCE";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                byte[] mfRam = this.memory.getMultifaceRam();
                baos = new ByteArrayOutputStream();
                dos = new DeflaterOutputStream(baos);
                dos.write(mfRam, 0, mfRam.length);
                dos.close();
                pageLen = baos.size() + 2;
                this.fOut.write(pageLen);
                this.fOut.write(pageLen >> 8);
                this.fOut.write(pageLen >> 16);
                this.fOut.write(pageLen >> 24);
                if (this.memory.isMf128on48k()) {
                    this.fOut.write(1);
                } else {
                    this.fOut.write(0);
                }
                int mfFlags = 2;
                if (this.memory.isMultifacePaged()) {
                    mfFlags |= 1;
                }
                if (this.memory.isMultifaceLocked() && (this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUM48K || this.memory.isMultifacePaged())) {
                    mfFlags |= 4;
                }
                this.fOut.write(mfFlags);
                baos.writeTo(this.fOut);
            }
            if (this.memory.isIF2RomPaged() && this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
                blockID = "IF2R";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                byte[] if2Rom = this.memory.getIF2Rom();
                baos = new ByteArrayOutputStream();
                dos = new DeflaterOutputStream(baos);
                dos.write(if2Rom, 0, if2Rom.length);
                dos.close();
                pageLen = baos.size() + 4;
                this.fOut.write(pageLen);
                this.fOut.write(pageLen >>> 8);
                this.fOut.write(pageLen >>> 16);
                this.fOut.write(pageLen >>> 24);
                pageLen = baos.size();
                this.fOut.write(pageLen);
                this.fOut.write(pageLen >>> 8);
                this.fOut.write(pageLen >>> 16);
                this.fOut.write(pageLen >>> 24);
                baos.writeTo(this.fOut);
            }
            if (this.tapeLinked && !this.tapeEmbedded) {
                blockID = "TAPE";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                int blockLen = 28 + this.tapeName.length() + 1;
                this.fOut.write(blockLen);
                this.fOut.write(blockLen >>> 8);
                this.fOut.write(blockLen >>> 16);
                this.fOut.write(blockLen >>> 24);
                this.fOut.write(this.tapeBlock);
                this.fOut.write(this.tapeBlock >>> 8);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                blockLen = this.tapeName.length() + 1;
                this.fOut.write(blockLen);
                this.fOut.write(blockLen >>> 8);
                this.fOut.write(blockLen >>> 16);
                this.fOut.write(blockLen >>> 24);
                byte[] szFileExtension = new byte[16];
                this.fOut.write(szFileExtension);
                this.fOut.write(this.tapeName.getBytes("US-ASCII"));
                this.fOut.write(0);
            }
            if (!this.tapeLinked && this.tapeEmbedded) {
                blockID = "TAPE";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                File tapeFile = new File(this.tapeName);
                this.fIn = new BufferedInputStream(new FileInputStream(tapeFile));
                this.tapeData = new byte[this.fIn.available()];
                this.fIn.read(this.tapeData);
                baos = new ByteArrayOutputStream();
                dos = new DeflaterOutputStream(baos);
                dos.write(this.tapeData, 0, this.tapeData.length);
                dos.close();
                int blockLen = 28 + baos.size();
                this.fOut.write(blockLen);
                this.fOut.write(blockLen >>> 8);
                this.fOut.write(blockLen >>> 16);
                this.fOut.write(blockLen >>> 24);
                this.fOut.write(this.tapeBlock);
                this.fOut.write(this.tapeBlock >>> 8);
                this.fOut.write(3);
                this.fOut.write(0);
                this.fOut.write(this.tapeData.length);
                this.fOut.write(this.tapeData.length >>> 8);
                this.fOut.write(this.tapeData.length >>> 16);
                this.fOut.write(this.tapeData.length >>> 24);
                blockLen = baos.size();
                this.fOut.write(blockLen);
                this.fOut.write(blockLen >>> 8);
                this.fOut.write(blockLen >>> 16);
                this.fOut.write(blockLen >>> 24);
                byte[] szFileExtension = new byte[16];
                szFileExtension[0] = 116;
                if (this.tapeName.toLowerCase().endsWith("tzx")) {
                    szFileExtension[1] = 122;
                    szFileExtension[2] = 120;
                } else {
                    szFileExtension[1] = 97;
                    szFileExtension[2] = 112;
                }
                this.fOut.write(szFileExtension);
                baos.writeTo(this.fOut);
            }
            if (this.spectrum.isConnectedIF1() && this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
                blockID = "IF1\u0000";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                this.fOut.write(40);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                int if1Flag = 1;
                if (this.memory.isIF1RomPaged()) {
                    if1Flag = (byte)(if1Flag | 4);
                }
                this.fOut.write(if1Flag);
                this.fOut.write(this.spectrum.getNumMicrodrives());
                byte[] reserved = new byte[38];
                this.fOut.write(reserved);
            }
            if (this.spectrum.isConnectedLec() && this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUM48K) {
                blockID = "LEC\u0000";
                this.fOut.write(blockID.getBytes("US-ASCII"));
                this.fOut.write(2);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(0);
                this.fOut.write(this.memory.getPortFD());
                this.fOut.write(16);
                blockID = "LCRP";
                for (int page = 0; page < 16; ++page) {
                    if (this.spectrum.getMemoryState().getLecPageRam(page) == null) continue;
                    ram = this.memory.getLecPageRam(page);
                    baos = new ByteArrayOutputStream();
                    dos = new DeflaterOutputStream(baos);
                    dos.write(ram, 0, ram.length);
                    dos.close();
                    this.fOut.write(blockID.getBytes("US-ASCII"));
                    int pageLen2 = baos.size() + 3;
                    this.fOut.write(pageLen2);
                    this.fOut.write(pageLen2 >>> 8);
                    this.fOut.write(pageLen2 >>> 16);
                    this.fOut.write(pageLen2 >>> 24);
                    this.fOut.write(1);
                    this.fOut.write(0);
                    this.fOut.write(page);
                    baos.writeTo(this.fOut);
                }
            }
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_WRITE_ERROR", ex);
        }
        finally {
            try {
                if (this.fOut != null) {
                    this.fOut.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SnapshotSZX.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }
}

