/*
 * Decompiled with CFR 0.152.
 */
package snapshots;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import machine.Keyboard;
import machine.MachineTypes;
import snapshots.MemoryState;
import snapshots.SnapshotException;
import snapshots.SnapshotFile;
import snapshots.SpectrumState;
import snapshots.Z80State;
import z80core.Z80;

public class SnapshotSP
implements SnapshotFile {
    private BufferedInputStream fIn;
    private SpectrumState spectrum;
    private Z80State z80;
    private MemoryState memory;

    @Override
    public SpectrumState load(File filename) throws SnapshotException {
        this.spectrum = new SpectrumState();
        try {
            int count;
            try {
                this.fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            int spLen = this.fIn.available();
            switch (spLen) {
                case 16422: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM16K);
                    break;
                }
                case 49190: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                    break;
                }
                default: {
                    throw new SnapshotException("FILE_SIZE_ERROR");
                }
            }
            byte[] spHeader = new byte[38];
            for (count = 0; count != -1 && count < spHeader.length; count += this.fIn.read(spHeader, count, spHeader.length - count)) {
            }
            if (count != spHeader.length || spHeader[0] != 83 || spHeader[1] != 80) {
                throw new SnapshotException("FILE_SIZE_ERROR");
            }
            spLen = spHeader[2] & 0xFF | (spHeader[3] & 0xFF) << 8;
            int start = spHeader[4] & 0xFF | (spHeader[5] & 0xFF) << 8;
            if (spLen != 16384 && spLen != 49152 || start != 16384) {
                throw new SnapshotException("FILE_SIZE_ERROR");
            }
            this.z80 = new Z80State();
            this.spectrum.setZ80State(this.z80);
            this.z80.setRegC(spHeader[6]);
            this.z80.setRegB(spHeader[7]);
            this.z80.setRegE(spHeader[8]);
            this.z80.setRegD(spHeader[9]);
            this.z80.setRegL(spHeader[10]);
            this.z80.setRegH(spHeader[11]);
            this.z80.setRegF(spHeader[12]);
            this.z80.setRegA(spHeader[13]);
            this.z80.setRegIX(spHeader[14] & 0xFF | spHeader[15] << 8);
            this.z80.setRegIY(spHeader[16] & 0xFF | spHeader[17] << 8);
            this.z80.setRegCx(spHeader[18]);
            this.z80.setRegBx(spHeader[19]);
            this.z80.setRegEx(spHeader[20]);
            this.z80.setRegDx(spHeader[21]);
            this.z80.setRegLx(spHeader[22]);
            this.z80.setRegHx(spHeader[23]);
            this.z80.setRegFx(spHeader[24]);
            this.z80.setRegAx(spHeader[25]);
            this.z80.setRegR(spHeader[26]);
            this.z80.setRegI(spHeader[27]);
            this.z80.setRegSP(spHeader[28] & 0xFF | spHeader[29] << 8);
            this.z80.setRegPC(spHeader[30] & 0xFF | spHeader[31] << 8);
            this.spectrum.setBorder(spHeader[34] & 0xFF);
            this.z80.setIFF1((spHeader[36] & 1) != 0);
            this.z80.setIFF2((spHeader[36] & 4) != 0);
            if ((spHeader[36] & 8) != 0) {
                this.z80.setIM(Z80.IntMode.IM0);
            } else if ((spHeader[36] & 2) != 0) {
                this.z80.setIM(Z80.IntMode.IM2);
            } else {
                this.z80.setIM(Z80.IntMode.IM1);
            }
            this.memory = new MemoryState();
            this.spectrum.setMemoryState(this.memory);
            byte[] buffer = new byte[16384];
            for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
            }
            if (count != 16384) {
                throw new SnapshotException("FILE_READ_ERROR");
            }
            this.memory.setPageRam(5, buffer);
            if (spLen == 49152) {
                buffer = new byte[16384];
                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                }
                if (count != 16384) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                this.memory.setPageRam(2, buffer);
                buffer = new byte[16384];
                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                }
                if (count != 16384) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                this.memory.setPageRam(0, buffer);
            }
            this.spectrum.setEnabledAY(false);
            this.spectrum.setIssue2(false);
            this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
            this.spectrum.setTstates(0);
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_READ_ERROR", ex);
        }
        finally {
            try {
                if (this.fIn != null) {
                    this.fIn.close();
                }
            }
            catch (IOException ex) {
                throw new SnapshotException("FILE_READ_ERROR", ex);
            }
        }
        return this.spectrum;
    }

    @Override
    public boolean save(File filename, SpectrumState state) throws SnapshotException {
        throw new SnapshotException("FILE_WRITE_ERROR");
    }
}

