/*
 * Decompiled with CFR 0.152.
 */
package snapshots;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.Keyboard;
import machine.MachineTypes;
import snapshots.AY8912State;
import snapshots.MemoryState;
import snapshots.SnapshotException;
import snapshots.SnapshotFile;
import snapshots.SpectrumState;
import snapshots.Z80State;
import z80core.Z80;

public class SnapshotSNA
implements SnapshotFile {
    private BufferedInputStream fIn;
    private BufferedOutputStream fOut;
    private SpectrumState spectrum;
    private Z80State z80;
    private MemoryState memory;
    private AY8912State ay8912;

    @Override
    public SpectrumState load(File filename) throws SnapshotException {
        this.spectrum = new SpectrumState();
        try {
            int count;
            try {
                this.fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            int snaLen = this.fIn.available();
            switch (snaLen) {
                case 49179: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM48K);
                    break;
                }
                case 131103: 
                case 147487: {
                    this.spectrum.setSpectrumModel(MachineTypes.SPECTRUM128K);
                    break;
                }
                default: {
                    throw new SnapshotException("FILE_SIZE_ERROR");
                }
            }
            byte[] snaHeader = new byte[27];
            for (count = 0; count != -1 && count < snaHeader.length; count += this.fIn.read(snaHeader, count, snaHeader.length - count)) {
            }
            if (count != snaHeader.length) {
                throw new SnapshotException("FILE_READ_ERROR");
            }
            this.z80 = new Z80State();
            this.spectrum.setZ80State(this.z80);
            this.z80.setRegI(snaHeader[0]);
            this.z80.setRegLx(snaHeader[1]);
            this.z80.setRegHx(snaHeader[2]);
            this.z80.setRegEx(snaHeader[3]);
            this.z80.setRegDx(snaHeader[4]);
            this.z80.setRegCx(snaHeader[5]);
            this.z80.setRegBx(snaHeader[6]);
            this.z80.setRegFx(snaHeader[7]);
            this.z80.setRegAx(snaHeader[8]);
            this.z80.setRegL(snaHeader[9]);
            this.z80.setRegH(snaHeader[10]);
            this.z80.setRegE(snaHeader[11]);
            this.z80.setRegD(snaHeader[12]);
            this.z80.setRegC(snaHeader[13]);
            this.z80.setRegB(snaHeader[14]);
            this.z80.setRegIY(snaHeader[15] & 0xFF | snaHeader[16] << 8);
            this.z80.setRegIX(snaHeader[17] & 0xFF | snaHeader[18] << 8);
            boolean intEnabled = (snaHeader[19] & 4) != 0;
            this.z80.setIFF1(intEnabled);
            this.z80.setIFF2(intEnabled);
            this.z80.setRegR(snaHeader[20]);
            this.z80.setRegF(snaHeader[21]);
            this.z80.setRegA(snaHeader[22]);
            this.z80.setRegSP(snaHeader[23] & 0xFF | snaHeader[24] << 8);
            switch (snaHeader[25] & 3) {
                case 0: {
                    this.z80.setIM(Z80.IntMode.IM0);
                    break;
                }
                case 1: {
                    this.z80.setIM(Z80.IntMode.IM1);
                    break;
                }
                case 2: {
                    this.z80.setIM(Z80.IntMode.IM2);
                }
            }
            this.spectrum.setBorder(snaHeader[26]);
            this.memory = new MemoryState();
            this.spectrum.setMemoryState(this.memory);
            byte[] buffer = new byte[16384];
            for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
            }
            if (count != 16384) {
                throw new SnapshotException("FILE_READ_ERROR");
            }
            this.memory.setPageRam(5, buffer);
            buffer = new byte[16384];
            for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
            }
            if (count != 16384) {
                throw new SnapshotException("FILE_READ_ERROR");
            }
            this.memory.setPageRam(2, buffer);
            if (snaLen == 49179) {
                buffer = new byte[16384];
                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                }
                if (count != 16384) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                this.memory.setPageRam(0, buffer);
                this.z80.setRegPC(114);
                this.spectrum.setEnabledAY(false);
            } else {
                int trDos;
                boolean[] loaded = new boolean[8];
                buffer = new byte[16384];
                for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                }
                if (count != 16384) {
                    throw new SnapshotException("FILE_READ_ERROR");
                }
                loaded[5] = true;
                loaded[2] = true;
                this.z80.setRegPC(this.fIn.read() | this.fIn.read() << 8);
                this.spectrum.setPort7ffd(this.fIn.read());
                int page = this.spectrum.getPort7ffd() & 7;
                if (page != 2 && page != 5) {
                    this.memory.setPageRam(page, buffer);
                    loaded[page] = true;
                }
                if ((trDos = this.fIn.read()) == 1) {
                    throw new SnapshotException("NOT_SNAPSHOT_FILE");
                }
                for (page = 0; page < 8; ++page) {
                    if (!loaded[page]) {
                        buffer = new byte[16384];
                        for (count = 0; count != -1 && count < 16384; count += this.fIn.read(buffer, count, 16384 - count)) {
                        }
                        if (count != 16384) {
                            throw new SnapshotException("FILE_READ_ERROR");
                        }
                        this.memory.setPageRam(page, buffer);
                    }
                    this.spectrum.setEnabledAY(true);
                    this.spectrum.setEnabledAYon48k(false);
                    int[] regAY = new int[16];
                    this.ay8912 = new AY8912State();
                    this.spectrum.setAY8912State(this.ay8912);
                    this.ay8912.setAddressLatch(0);
                    this.ay8912.setRegAY(regAY);
                }
            }
            this.spectrum.setIssue2(false);
            this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
            this.spectrum.setTstates(0);
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_READ_ERROR", ex);
        }
        finally {
            try {
                if (this.fIn != null) {
                    this.fIn.close();
                }
            }
            catch (IOException ex) {
                throw new SnapshotException("FILE_READ_ERROR", ex);
            }
        }
        return this.spectrum;
    }

    @Override
    public boolean save(File filename, SpectrumState state) throws SnapshotException {
        this.spectrum = state;
        this.z80 = this.spectrum.getZ80State();
        this.memory = this.spectrum.getMemoryState();
        if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K && this.z80.getRegSP() < 16386) {
            throw new SnapshotException("SNA_REGSP_ERROR");
        }
        if (this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUM48K && this.spectrum.getSpectrumModel() != MachineTypes.SPECTRUM128K) {
            throw new SnapshotException("SNA_DONT_SUPPORT_PLUS3");
        }
        try {
            byte[] buffer;
            try {
                this.fOut = new BufferedOutputStream(new FileOutputStream(filename));
            }
            catch (FileNotFoundException ex) {
                throw new SnapshotException("OPEN_FILE_ERROR", ex);
            }
            byte[] snaHeader = new byte[27];
            snaHeader[0] = (byte)this.z80.getRegI();
            snaHeader[1] = (byte)this.z80.getRegLx();
            snaHeader[2] = (byte)this.z80.getRegHx();
            snaHeader[3] = (byte)this.z80.getRegEx();
            snaHeader[4] = (byte)this.z80.getRegDx();
            snaHeader[5] = (byte)this.z80.getRegCx();
            snaHeader[6] = (byte)this.z80.getRegBx();
            snaHeader[7] = (byte)this.z80.getRegFx();
            snaHeader[8] = (byte)this.z80.getRegAx();
            snaHeader[9] = (byte)this.z80.getRegL();
            snaHeader[10] = (byte)this.z80.getRegH();
            snaHeader[11] = (byte)this.z80.getRegE();
            snaHeader[12] = (byte)this.z80.getRegD();
            snaHeader[13] = (byte)this.z80.getRegC();
            snaHeader[14] = (byte)this.z80.getRegB();
            snaHeader[15] = (byte)this.z80.getRegIY();
            snaHeader[16] = (byte)(this.z80.getRegIY() >>> 8);
            snaHeader[17] = (byte)this.z80.getRegIX();
            snaHeader[18] = (byte)(this.z80.getRegIX() >>> 8);
            snaHeader[19] = (byte)(this.z80.isIFF2() ? 4 : 0);
            snaHeader[20] = (byte)this.z80.getRegR();
            snaHeader[21] = (byte)this.z80.getRegF();
            snaHeader[22] = (byte)this.z80.getRegA();
            int regSP = this.z80.getRegSP();
            if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                regSP = regSP - 2 & 0xFFFF;
            }
            snaHeader[23] = (byte)regSP;
            snaHeader[24] = (byte)(regSP >>> 8);
            snaHeader[25] = (byte)this.z80.getIM().ordinal();
            snaHeader[26] = (byte)this.spectrum.getBorder();
            this.fOut.write(snaHeader, 0, snaHeader.length);
            if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                buffer = new byte[49152];
                System.arraycopy(this.memory.getPageRam(5), 0, buffer, 0, 16384);
                System.arraycopy(this.memory.getPageRam(2), 0, buffer, 16384, 16384);
                System.arraycopy(this.memory.getPageRam(0), 0, buffer, 32768, 16384);
                buffer[regSP -= 16384] = (byte)this.z80.getRegPC();
                regSP = regSP + 1 & 0xFFFF;
                buffer[regSP] = (byte)(this.z80.getRegPC() >>> 8);
                this.fOut.write(buffer, 0, buffer.length);
            }
            if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUM128K) {
                buffer = this.memory.getPageRam(5);
                this.fOut.write(buffer, 0, buffer.length);
                buffer = this.memory.getPageRam(2);
                this.fOut.write(buffer, 0, buffer.length);
                buffer = this.memory.getPageRam(this.spectrum.getPort7ffd() & 7);
                this.fOut.write(buffer, 0, buffer.length);
                boolean[] saved = new boolean[8];
                saved[5] = true;
                saved[2] = true;
                this.fOut.write(this.z80.getRegPC());
                this.fOut.write(this.z80.getRegPC() >>> 8);
                this.fOut.write(this.spectrum.getPort7ffd());
                this.fOut.write(0);
                saved[this.spectrum.getPort7ffd() & 7] = true;
                for (int page = 0; page < 8; ++page) {
                    if (saved[page]) continue;
                    buffer = this.memory.getPageRam(page);
                    this.fOut.write(buffer, 0, buffer.length);
                }
            }
        }
        catch (IOException ex) {
            throw new SnapshotException("FILE_WRITE_ERROR", ex);
        }
        finally {
            try {
                if (this.fOut != null) {
                    this.fOut.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SnapshotSNA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }
}

