/*
 * Decompiled with CFR 0.152.
 */
package machine;

import configuration.JSpeccySettingsType;
import configuration.SpectrumType;
import gui.JSpeccyScreen;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import joystickinput.JoystickRaw;
import machine.AY8912;
import machine.Audio;
import machine.Clock;
import machine.ClockTimeoutListener;
import machine.Interface1;
import machine.Keyboard;
import machine.MachineTypes;
import machine.Memory;
import machine.SpectrumTimer;
import snapshots.SpectrumState;
import utilities.Tape;
import utilities.TapeStateListener;
import z80core.MemIoOps;
import z80core.NotifyOps;
import z80core.Z80;

public class Spectrum
implements Runnable,
MemIoOps,
NotifyOps {
    private final Z80 z80;
    private final Memory memory;
    private final Clock clock;
    private final boolean[] contendedRamPage;
    private final boolean[] contendedIOPage;
    private int portFE;
    private int earBit;
    private int port7ffd;
    private int port1ffd;
    private int issueMask;
    private int kmouseX;
    private int kmouseY;
    private int kmouseW;
    private long framesByInt;
    private long speedometer;
    private long speed;
    private long prevSpeed;
    private boolean muted;
    private boolean enabledAY;
    private boolean kmouseEnabled;
    private final byte[] delayTstates;
    public MachineTypes spectrumModel;
    public int firstBorderUpdate;
    public int lastBorderUpdate;
    public int borderMode;
    private final Timer timerFrame;
    private SpectrumTimer taskFrame;
    private JSpeccyScreen jscr;
    private final Keyboard keyboard;
    private final Audio audio;
    private final AY8912 ay8912;
    private Tape tape;
    private volatile boolean paused;
    private volatile boolean acceleratedLoading;
    private volatile boolean enabledSound;
    private boolean resetPending;
    private boolean autoLoadTape;
    private JLabel speedLabel;
    private Keyboard.JoystickModel joystickModel;
    private JoystickRaw joystick1;
    private JoystickRaw joystick2;
    private final JSpeccySettingsType settings;
    private final SpectrumType specSettings;
    private boolean issue2;
    private boolean saveTrap;
    private boolean loadTrap;
    private boolean flashload;
    private boolean connectedIF1;
    private final Interface1 if1;
    private static final int LAST_K = 23560;
    private static final int FLAGS = 23611;
    static final int SPEAKER_VOLUME = -24576;
    private int speaker;
    private static final int[] sp_volt = new int[4];
    public static final int[] Paleta;
    private static final int[] Paper;
    private static final int[] Ink;
    public final int[] scr2attr;
    private final int[] attr2scr;
    private final int[] bufAddr;
    private final int[] scanLineTable;
    private final int[] scrAddr;
    private final boolean[] dirtyByte;
    private final int[] states2scr;
    private final int[] states2border;
    int[] stepStates;
    private int step;
    private final int NO_EVENT = 19088743;
    private int nextEvent;
    private int LEFT_BORDER;
    private int RIGHT_BORDER;
    private int SCREEN_WIDTH;
    private int TOP_BORDER;
    private int BOTTOM_BORDER;
    private int SCREEN_HEIGHT;
    private int flash;
    private BufferedImage tvImage;
    private BufferedImage inProgressImage;
    private int[] dataInProgress;
    private Graphics2D gcTvImage;
    private int lastChgBorder;
    private boolean screenDirty;
    private boolean borderDirty;
    private boolean borderChanged;
    private boolean borderUpdated;
    private int firstScanLine;
    private int lastScanLine;
    private int leftCol;
    private int rightCol;
    private int[][] ULAPlusPalette;
    private int paletteGroup;
    private boolean ULAPlusActive;
    private int[][] ULAPlusPrecompPalette;
    private final Rectangle screenRect;
    private int firstBorderPix;
    private int lastBorderPix;
    private final Rectangle borderRect;

    public Spectrum(JSpeccySettingsType config) {
        block3: {
            this.contendedRamPage = new boolean[4];
            this.contendedIOPage = new boolean[4];
            this.earBit = 191;
            this.kmouseX = 0;
            this.kmouseY = 0;
            this.delayTstates = new byte[MachineTypes.SPECTRUM128K.tstatesFrame + 200];
            this.scr2attr = new int[6144];
            this.attr2scr = new int[768];
            this.bufAddr = new int[6144];
            this.scanLineTable = new int[6144];
            this.scrAddr = new int[192];
            this.dirtyByte = new boolean[6144];
            this.states2scr = new int[MachineTypes.SPECTRUM128K.tstatesFrame + 100];
            this.states2border = new int[MachineTypes.SPECTRUM128K.tstatesFrame + 100];
            this.stepStates = new int[6144];
            this.NO_EVENT = 19088743;
            this.nextEvent = 19088743;
            this.LEFT_BORDER = 32;
            this.RIGHT_BORDER = 32;
            this.SCREEN_WIDTH = this.LEFT_BORDER + 256 + this.RIGHT_BORDER;
            this.TOP_BORDER = 24;
            this.BOTTOM_BORDER = 24;
            this.SCREEN_HEIGHT = this.TOP_BORDER + 192 + this.BOTTOM_BORDER;
            this.flash = 127;
            this.screenRect = new Rectangle();
            this.borderRect = new Rectangle();
            this.clock = Clock.getInstance();
            this.settings = config;
            this.specSettings = this.settings.getSpectrumSettings();
            this.z80 = new Z80(this, this);
            this.memory = new Memory(this.settings);
            this.initGFX();
            this.speedometer = 0L;
            this.framesByInt = 1L;
            this.portFE = 0;
            this.port7ffd = 0;
            this.ay8912 = new AY8912();
            this.audio = new Audio(this.settings.getAY8912Settings());
            this.muted = this.specSettings.isMutedSound();
            this.enabledSound = false;
            this.paused = true;
            this.borderMode = 1;
            this.if1 = new Interface1(this.settings.getInterface1Settings());
            if (System.getProperty("os.name").contains("Linux")) {
                try {
                    this.joystick1 = new JoystickRaw(0);
                    this.joystick1.start();
                    this.joystick2 = new JoystickRaw(1);
                    this.joystick2.start();
                }
                catch (IOException ex) {
                    if (this.joystick1 != null || this.joystick2 != null) break block3;
                    System.out.println("No physical joystick found!");
                }
            }
        }
        this.keyboard = new Keyboard(this.settings.getKeyboardJoystickSettings(), this.joystick1, this.joystick2);
        this.resetPending = false;
        this.timerFrame = new Timer("SpectrumClock", true);
    }

    public final SpectrumState getSpectrumState() {
        SpectrumState state = new SpectrumState();
        state.setSpectrumModel(this.spectrumModel);
        state.setZ80State(this.z80.getZ80State());
        state.setMemoryState(this.memory.getMemoryState());
        state.setConnectedLec(this.specSettings.isLecEnabled());
        state.setEarBit(this.earBit);
        state.setPortFE(this.portFE);
        state.setJoystick(this.joystickModel);
        if (this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUM48K) {
            state.setPort7ffd(this.port7ffd);
            if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                state.setPort1ffd(this.port1ffd);
            }
        } else {
            state.setIssue2(this.issue2);
        }
        state.setEnabledAY(this.enabledAY);
        if (this.enabledAY) {
            state.setAY8912State(this.ay8912.getAY8912State());
        }
        state.setConnectedIF1(this.connectedIF1);
        if (this.connectedIF1) {
            state.setNumMicrodrives(this.settings.getInterface1Settings().getMicrodriveUnits());
        }
        state.setMultiface(this.specSettings.isMultifaceEnabled());
        state.setULAPlusEnabled(this.specSettings.isULAplus());
        if (this.specSettings.isULAplus()) {
            state.setULAPlusActive(this.ULAPlusActive);
            state.setPaletteGroup(this.paletteGroup);
            int[] palette = new int[64];
            System.arraycopy(this.ULAPlusPalette[0], 0, palette, 0, 16);
            System.arraycopy(this.ULAPlusPalette[1], 0, palette, 16, 16);
            System.arraycopy(this.ULAPlusPalette[2], 0, palette, 32, 16);
            System.arraycopy(this.ULAPlusPalette[3], 0, palette, 48, 16);
            state.setULAPlusPalette(palette);
        }
        state.setTstates(this.clock.getTstates());
        return state;
    }

    public final void setSpectrumState(SpectrumState state) {
        this.selectHardwareModel(state.getSpectrumModel());
        this.z80.setZ80State(state.getZ80State());
        this.memory.setMemoryState(state.getMemoryState());
        this.specSettings.setLecEnabled(state.isConnectedLec());
        this.earBit = state.getEarBit();
        this.portFE = state.getPortFE();
        if (this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUM48K) {
            this.port7ffd = state.getPort7ffd();
            if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                this.port1ffd = state.getPort1ffd();
                this.memory.setPort1ffd(this.port1ffd);
                this.memory.setPort7ffd(this.port7ffd);
                if (this.memory.isPlus3RamMode()) {
                    switch (this.port1ffd & 6) {
                        case 0: {
                            Arrays.fill(this.contendedRamPage, false);
                            break;
                        }
                        case 2: {
                            Arrays.fill(this.contendedRamPage, true);
                            break;
                        }
                        case 4: 
                        case 6: {
                            Arrays.fill(this.contendedRamPage, true);
                            this.contendedRamPage[3] = false;
                        }
                    }
                } else {
                    this.contendedRamPage[2] = false;
                    this.contendedRamPage[0] = false;
                    this.contendedRamPage[1] = true;
                    this.contendedRamPage[3] = this.memory.getPlus3HighPage() > 3;
                }
            } else {
                this.memory.setPort7ffd(this.port7ffd);
                this.contendedIOPage[3] = (this.port7ffd & 1) != 0;
                this.contendedRamPage[3] = this.contendedIOPage[3];
            }
        }
        this.keyboard.reset();
        this.setJoystick(state.getJoystick());
        this.settings.getKeyboardJoystickSettings().setIssue2(state.isIssue2());
        this.enabledAY = state.isEnabledAY();
        if (this.enabledAY) {
            this.ay8912.setSpectrumModel(this.spectrumModel);
            this.ay8912.setAY8912State(state.getAY8912State());
            this.settings.getSpectrumSettings().setAYEnabled48K(state.isEnabledAYon48k());
        }
        this.settings.getInterface1Settings().setConnectedIF1(state.isConnectedIF1());
        if (state.isConnectedIF1()) {
            this.settings.getInterface1Settings().setMicrodriveUnits(state.getNumMicrodrives());
        }
        this.specSettings.setMultifaceEnabled(state.isMultiface());
        this.specSettings.setULAplus(state.isULAPlusEnabled());
        if (state.isULAPlusEnabled()) {
            this.ULAPlusActive = state.isULAPlusActive();
            this.paletteGroup = state.getPaletteGroup();
            int[] palette = state.getULAPlusPalette();
            for (int register = 0; register < 64; ++register) {
                int color;
                this.ULAPlusPalette[register >>> 4][register & 0xF] = color = palette[register];
                this.precompULAplusColor(register, color);
            }
        } else {
            this.ULAPlusActive = false;
        }
        this.clock.setTstates(state.getTstates());
        this.step = 0;
        while (this.step < this.stepStates.length && this.stepStates[this.step] < state.getTstates()) {
            ++this.step;
        }
        this.nextEvent = this.step < this.stepStates.length ? this.stepStates[this.step] : 19088743;
        this.loadConfigVars();
        if (this.memory.isConnectedLEC()) {
            this.pageLec(state.getMemoryState().getPortFD());
        }
    }

    public void selectHardwareModel(int model) {
        switch (model) {
            case 0: {
                this.selectHardwareModel(MachineTypes.SPECTRUM16K);
                break;
            }
            case 2: {
                this.selectHardwareModel(MachineTypes.SPECTRUM128K);
                break;
            }
            case 3: {
                this.selectHardwareModel(MachineTypes.SPECTRUMPLUS2);
                break;
            }
            case 4: {
                this.selectHardwareModel(MachineTypes.SPECTRUMPLUS2A);
                break;
            }
            case 5: {
                this.selectHardwareModel(MachineTypes.SPECTRUMPLUS3);
                break;
            }
            default: {
                this.selectHardwareModel(MachineTypes.SPECTRUM48K);
            }
        }
    }

    public void selectHardwareModel(MachineTypes hardwareModel) {
        if (this.tape != null && this.tape.isTapePlaying()) {
            this.tape.stop();
        }
        this.disableSound();
        this.spectrumModel = hardwareModel;
        this.clock.setSpectrumModel(this.spectrumModel);
        this.memory.reset(this.spectrumModel);
        if (this.tape != null) {
            this.tape.setSpectrumModel(this.spectrumModel);
        }
        this.contendedIOPage[0] = false;
        this.contendedRamPage[0] = false;
        this.contendedIOPage[1] = true;
        this.contendedRamPage[1] = true;
        this.contendedIOPage[2] = false;
        this.contendedRamPage[2] = false;
        this.contendedIOPage[3] = false;
        this.contendedRamPage[3] = false;
        switch (this.spectrumModel.codeModel) {
            case SPECTRUM48K: {
                this.buildScreenTables48k();
                this.enabledAY = this.specSettings.isAYEnabled48K();
                this.connectedIF1 = this.settings.getInterface1Settings().isConnectedIF1();
                break;
            }
            case SPECTRUM128K: {
                this.buildScreenTables128k();
                this.enabledAY = true;
                this.connectedIF1 = this.settings.getInterface1Settings().isConnectedIF1();
                break;
            }
            case SPECTRUMPLUS3: {
                this.buildScreenTablesPlus3();
                this.enabledAY = true;
                this.contendedIOPage[1] = false;
                this.connectedIF1 = false;
            }
        }
        this.step = 0;
        this.nextEvent = this.stepStates[0];
        this.enableSound();
    }

    public final void loadConfigVars() {
        this.issue2 = this.settings.getKeyboardJoystickSettings().isIssue2();
        if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
            this.issueMask = this.issue2 ? 24 : 16;
            this.enabledAY = this.specSettings.isAYEnabled48K();
        } else {
            this.issueMask = 16;
        }
        this.keyboard.setMapPCKeys(this.settings.getKeyboardJoystickSettings().isMapPCKeys());
        this.z80.setBreakpoint(102, this.specSettings.isMultifaceEnabled());
        this.saveTrap = this.settings.getTapeSettings().isEnableSaveTraps();
        this.z80.setBreakpoint(1232, this.saveTrap);
        this.loadTrap = this.settings.getTapeSettings().isEnableLoadTraps();
        this.z80.setBreakpoint(1366, this.loadTrap);
        this.flashload = this.settings.getTapeSettings().isFlashLoad();
        this.if1.setNumDrives(this.settings.getInterface1Settings().getMicrodriveUnits());
        this.connectedIF1 = this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3 ? this.settings.getInterface1Settings().isConnectedIF1() : false;
        this.z80.setBreakpoint(8, this.connectedIF1);
        this.z80.setBreakpoint(1792, this.connectedIF1);
        this.z80.setBreakpoint(5896, this.connectedIF1);
        if (this.specSettings.isLecEnabled() && this.spectrumModel == MachineTypes.SPECTRUM48K) {
            this.memory.setConnectedLEC(true);
            if (this.memory.isLecPaged()) {
                this.pageLec(this.memory.getPortFD());
            } else {
                this.unpageLec();
            }
        } else {
            this.memory.setConnectedLEC(false);
        }
    }

    public void startEmulation() {
        if (!this.paused) {
            return;
        }
        this.audio.reset();
        this.invalidateScreen(true);
        this.lastChgBorder = this.firstBorderUpdate;
        this.drawFrame();
        this.jscr.repaint();
        this.paused = false;
        this.enableSound();
        if (!this.enabledSound) {
            this.taskFrame = new SpectrumTimer(this);
            this.timerFrame.scheduleAtFixedRate((TimerTask)this.taskFrame, 10L, 20L);
        }
    }

    public void stopEmulation() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        if (this.enabledSound) {
            this.disableSound();
        } else {
            this.taskFrame.cancel();
            this.taskFrame = null;
        }
    }

    public void reset() {
        this.resetPending = true;
        this.z80.setPinReset();
        this.tape.stop();
    }

    private void doReset() {
        this.clock.reset();
        this.z80.reset();
        if (this.memory.isLecPaged()) {
            this.unpageLec();
        }
        this.memory.reset(this.spectrumModel);
        this.ay8912.reset();
        this.audio.reset();
        this.keyboard.reset();
        if (this.connectedIF1) {
            this.if1.reset();
        }
        this.port1ffd = 0;
        this.port7ffd = 0;
        this.portFE = 0;
        this.kmouseY = 0;
        this.kmouseX = 0;
        this.kmouseW = 255;
        this.kmouseEnabled = true;
        this.ULAPlusActive = false;
        this.paletteGroup = 0;
        this.step = 0;
        this.invalidateScreen(true);
        this.resetPending = false;
    }

    public void hardReset() {
        this.resetPending = true;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void triggerNMI() {
        this.z80.triggerNMI();
    }

    public MachineTypes getSpectrumModel() {
        return this.spectrumModel;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public boolean getMapPCKeys() {
        return this.keyboard.isMapPCKeys();
    }

    public void setMapPCKeys(boolean state) {
        this.keyboard.setMapPCKeys(state);
    }

    public Keyboard.JoystickModel getJoystick() {
        return this.joystickModel;
    }

    public void setJoystick(Keyboard.JoystickModel type) {
        this.joystickModel = type;
        this.keyboard.setJoystickModel(type);
        this.kmouseY = 0;
        this.kmouseX = 0;
        this.kmouseW = 255;
    }

    public void setJoystick(int model) {
        this.keyboard.setJoystickModel(model);
        this.joystickModel = this.keyboard.getJoystickModel();
        this.kmouseY = 0;
        this.kmouseX = 0;
        this.kmouseW = 255;
    }

    public void setTape(Tape player) {
        this.tape = player;
        this.tape.setZ80Cpu(this.z80);
        this.tape.setSpectrumModel(this.spectrumModel);
        this.tape.addTapeChangedListener(new TapeChangedListener());
    }

    public void setSpeedLabel(JLabel speed) {
        this.speedLabel = speed;
    }

    public void setScreenComponent(JSpeccyScreen jScr) {
        this.jscr = jScr;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void autoLoadTape() {
        this.autoLoadTape = true;
        this.reset();
    }

    private void doAutoLoadTape() {
        this.autoLoadTape = false;
        Runnable task = () -> {
            try {
                long endFrame;
                Thread.sleep(1100L);
                long l = endFrame = this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM48K ? 100L : 70L;
                while (this.clock.getFrames() < endFrame) {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                if (endFrame == 100L) {
                    this.memory.writeByte(23560, (byte)-17);
                    this.memory.writeByte(23611, (byte)(this.memory.readByte(23611) | 0x20));
                    Thread.sleep(30L);
                    this.memory.writeByte(23560, (byte)34);
                    this.memory.writeByte(23611, (byte)(this.memory.readByte(23611) | 0x20));
                    Thread.sleep(30L);
                    this.memory.writeByte(23560, (byte)34);
                    this.memory.writeByte(23611, (byte)(this.memory.readByte(23611) | 0x20));
                    Thread.sleep(30L);
                }
                this.memory.writeByte(23560, (byte)13);
                this.memory.writeByte(23611, (byte)(this.memory.readByte(23611) | 0x20));
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
            }
        };
        new Thread(task).start();
    }

    @Override
    public synchronized void run() {
        while (true) {
            if (this.paused || !this.enabledSound) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (this.paused) continue;
            }
            if (this.acceleratedLoading) {
                this.acceleratedLoading = false;
                this.stopEmulation();
                this.acceleratedLoading();
                this.startEmulation();
            }
            this.generateFrame();
            this.drawFrame();
            if (!this.enabledSound) continue;
            this.audio.sendAudioFrame();
        }
    }

    public synchronized void generateFrame() {
        int regI;
        if (this.resetPending) {
            this.doReset();
            if (this.autoLoadTape) {
                this.doAutoLoadTape();
            }
        }
        long counter = this.framesByInt;
        this.lastBorderPix = 0;
        this.rightCol = 0;
        this.lastScanLine = 0;
        this.firstBorderPix = this.dataInProgress.length;
        this.firstScanLine = 191;
        this.leftCol = 31;
        this.lastChgBorder = this.firstBorderUpdate;
        do {
            if (this.clock.getTstates() < this.spectrumModel.lengthINT) {
                this.z80.setINTLine(true);
                this.z80.execute(this.spectrumModel.lengthINT);
            }
            this.z80.setINTLine(false);
            while (this.step < this.stepStates.length) {
                this.z80.execute(this.stepStates[this.step]);
                if (this.clock.getTstates() < this.nextEvent) continue;
                this.updateScreen(this.clock.getTstates());
            }
            this.z80.execute(this.spectrumModel.tstatesFrame);
            if (this.enabledSound) {
                if (this.enabledAY) {
                    this.ay8912.updateAY(this.spectrumModel.tstatesFrame);
                }
                this.audio.updateAudio(this.spectrumModel.tstatesFrame, this.speaker);
                this.audio.endFrame();
            }
            this.clock.endFrame();
            this.step = 0;
            this.nextEvent = this.stepStates[0];
            if (!this.ULAPlusActive && this.clock.getFrames() % 16L == 0L) {
                this.toggleFlash();
            }
            if (this.clock.getFrames() % 50L != 0L) continue;
            long now = System.currentTimeMillis() / 10L;
            this.speed = 10000L / (now - this.speedometer);
            this.speedometer = now;
            if (this.speed == this.prevSpeed) continue;
            this.prevSpeed = this.speed;
            SwingUtilities.invokeLater(() -> this.speedLabel.setText(String.format("%5d%%", this.speed)));
        } while (--counter > 0L);
        if (this.specSettings.isEmulate128KBug() && this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM128K && ((regI = this.z80.getRegI()) >= 64 && regI <= 127 || this.spectrumModel == MachineTypes.SPECTRUM128K && regI > 191 && this.contendedRamPage[3])) {
            System.out.println(String.format("Incompatible program with 128k. Register I = 0x%02X. Reset!", regI));
            this.z80.reset();
        }
    }

    public synchronized void drawFrame() {
        if (this.borderUpdated || this.borderChanged) {
            this.borderChanged = this.borderUpdated;
            this.borderUpdated = false;
            this.updateBorder(this.lastBorderUpdate);
            if (this.borderDirty) {
                this.borderDirty = false;
                this.gcTvImage.drawImage((Image)this.inProgressImage, 0, 0, null);
                int zoom = this.jscr.getZoom();
                int fbl = this.firstBorderPix / this.SCREEN_WIDTH;
                this.borderRect.x = 0;
                this.borderRect.y = fbl * zoom;
                this.borderRect.width = this.SCREEN_WIDTH * zoom;
                this.borderRect.height = (this.lastBorderPix / this.SCREEN_WIDTH - fbl + zoom) * zoom;
                if (this.screenDirty) {
                    this.screenDirty = false;
                    this.gcTvImage.drawImage((Image)this.inProgressImage, 0, 0, null);
                    this.screenRect.x = (this.LEFT_BORDER + this.leftCol * 8) * zoom - zoom;
                    this.screenRect.y = (this.TOP_BORDER + this.firstScanLine) * zoom - zoom;
                    this.screenRect.width = (this.rightCol - this.leftCol + 1) * 8 * zoom + zoom * 2;
                    this.screenRect.height = (this.lastScanLine - this.firstScanLine + 1) * zoom + zoom * 2;
                    this.jscr.repaint(this.borderRect.union(this.screenRect));
                } else {
                    this.jscr.repaint(this.borderRect);
                }
                return;
            }
        }
        if (this.screenDirty) {
            this.screenDirty = false;
            this.gcTvImage.drawImage((Image)this.inProgressImage, 0, 0, null);
            int zoom = this.jscr.getZoom();
            this.screenRect.x = (this.LEFT_BORDER + this.leftCol * 8) * zoom - zoom;
            this.screenRect.y = (this.TOP_BORDER + this.firstScanLine) * zoom - zoom;
            this.screenRect.width = (this.rightCol - this.leftCol + 1) * 8 * zoom + zoom * 2;
            this.screenRect.height = (this.lastScanLine - this.firstScanLine + 1) * zoom + zoom * 2;
            this.jscr.repaint(this.screenRect);
        }
    }

    private synchronized void acceleratedLoading() {
        this.lastBorderPix = 0;
        this.lastScanLine = 0;
        this.firstBorderPix = this.dataInProgress.length;
        this.firstScanLine = 191;
        this.leftCol = 31;
        this.rightCol = 0;
        this.lastChgBorder = this.firstBorderUpdate;
        this.nextEvent = 19088743;
        do {
            long startFrame = this.clock.getFrames();
            long end = System.currentTimeMillis() + 200L;
            do {
                this.z80.setINTLine(true);
                this.z80.execute(this.spectrumModel.lengthINT);
                this.z80.setINTLine(false);
                this.z80.execute(this.spectrumModel.tstatesFrame);
                this.clock.endFrame();
            } while (this.tape.isTapePlaying() && System.currentTimeMillis() <= end);
            if (this.LEFT_BORDER > 0) {
                this.updateBorder(this.lastBorderUpdate);
            }
            this.step = 0;
            this.updateScreen(this.spectrumModel.lastScrUpdate);
            this.gcTvImage.drawImage((Image)this.inProgressImage, 0, 0, null);
            this.jscr.repaint();
            this.lastBorderPix = 0;
            this.rightCol = 0;
            this.lastScanLine = 0;
            this.firstBorderPix = this.dataInProgress.length;
            this.firstScanLine = 191;
            this.leftCol = 31;
            this.lastChgBorder = this.firstBorderUpdate;
            this.speed = this.clock.getFrames() - startFrame;
            if (this.speed == this.prevSpeed) continue;
            this.prevSpeed = this.speed;
            SwingUtilities.invokeLater(() -> this.speedLabel.setText(String.format("%5d%%", Math.abs(this.speed * 10L))));
        } while (this.tape.isTapePlaying());
        this.step = 0;
        this.lastBorderPix = 0;
        this.rightCol = 0;
        this.lastScanLine = 0;
        this.firstBorderPix = this.dataInProgress.length;
        this.firstScanLine = 191;
        this.leftCol = 31;
        this.lastChgBorder = this.firstBorderUpdate;
        this.updateScreen(this.spectrumModel.lastScrUpdate);
        this.borderUpdated = true;
        this.step = 0;
        this.nextEvent = this.stepStates[0];
    }

    @Override
    public int fetchOpcode(int address) {
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 4);
        } else {
            this.clock.addTstates(4);
        }
        return this.memory.readByte(address) & 0xFF;
    }

    @Override
    public int peek8(int address) {
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
        } else {
            this.clock.addTstates(3);
        }
        return this.memory.readByte(address) & 0xFF;
    }

    @Override
    public void poke8(int address, int value) {
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
            if (this.memory.isScreenByteModified(address, (byte)value)) {
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
                this.notifyScreenWrite(address);
            }
        } else {
            this.clock.addTstates(3);
        }
        this.memory.writeByte(address, (byte)value);
    }

    @Override
    public int peek16(int address) {
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
        } else {
            this.clock.addTstates(3);
        }
        int lsb = this.memory.readByte(address) & 0xFF;
        address = address + 1 & 0xFFFF;
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
        } else {
            this.clock.addTstates(3);
        }
        return this.memory.readByte(address) << 8 & 0xFF00 | lsb;
    }

    @Override
    public void poke16(int address, int word) {
        byte lsb = (byte)word;
        byte msb = (byte)(word >>> 8);
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
            if (this.memory.isScreenByteModified(address, lsb)) {
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
                this.notifyScreenWrite(address);
            }
        } else {
            this.clock.addTstates(3);
        }
        this.memory.writeByte(address, lsb);
        address = address + 1 & 0xFFFF;
        if (this.contendedRamPage[address >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
            if (this.memory.isScreenByteModified(address, msb)) {
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
                this.notifyScreenWrite(address);
            }
        } else {
            this.clock.addTstates(3);
        }
        this.memory.writeByte(address, msb);
    }

    @Override
    public void contendedStates(int address, int tstates) {
        if (this.contendedRamPage[address >>> 14] && this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
            for (int idx = 0; idx < tstates; ++idx) {
                this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 1);
            }
        } else {
            this.clock.addTstates(tstates);
        }
    }

    @Override
    public int inPort(int port) {
        this.preIO(port);
        this.postIO(port);
        if (this.connectedIF1) {
            if ((port & 0x18) == 0) {
                return this.if1.readDataPort();
            }
            if ((port & 0x18) == 8) {
                return this.if1.readControlPort();
            }
            if ((port & 0x18) == 16) {
                return this.if1.readLanPort();
            }
        }
        if (this.specSettings.isMultifaceEnabled()) {
            switch (this.spectrumModel.codeModel) {
                case SPECTRUM48K: {
                    if (this.specSettings.isMf128On48K()) {
                        if ((port & 0xFF) == 191 && !this.memory.isMultifaceLocked()) {
                            this.memory.pageMultiface();
                        }
                        if ((port & 0xFF) != 63 || !this.memory.isMultifacePaged()) break;
                        this.memory.unpageMultiface();
                        break;
                    }
                    if ((port & 0xFF) == 159) {
                        this.memory.pageMultiface();
                    }
                    if ((port & 0xFF) != 31 || !this.memory.isMultifacePaged()) break;
                    this.memory.unpageMultiface();
                    break;
                }
                case SPECTRUM128K: {
                    if ((port & 0xFF) == 191 && !this.memory.isMultifaceLocked()) {
                        if (port == 447 && !this.memory.isMultifaceLocked() && this.memory.isMultifacePaged()) {
                            return this.port7ffd;
                        }
                        this.memory.pageMultiface();
                    }
                    if ((port & 0xFF) != 63 || !this.memory.isMultifacePaged()) break;
                    this.memory.unpageMultiface();
                    break;
                }
                case SPECTRUMPLUS3: {
                    if ((port & 0xFF) == 191 && this.memory.isMultifacePaged()) {
                        this.memory.unpageMultiface();
                    }
                    if ((port & 0xFF) != 63) break;
                    if (port == 32575 && !this.memory.isMultifaceLocked() && this.memory.isMultifacePaged()) {
                        return this.port7ffd;
                    }
                    if (port == 7999 && !this.memory.isMultifaceLocked() && this.memory.isMultifacePaged()) {
                        return this.port1ffd;
                    }
                    if (this.memory.isMultifaceLocked()) break;
                    this.memory.pageMultiface();
                }
            }
        }
        if (this.joystickModel == Keyboard.JoystickModel.KEMPSTON && (port & 0x20) == 0) {
            if (this.kmouseEnabled && this.joystick1 != null) {
                switch (port & 0x85FF) {
                    case 34015: {
                        return this.port7ffd;
                    }
                    case 32991: {
                        short waxis;
                        int status = this.joystick1.getButtonMask();
                        int buttons = 15;
                        if ((status & 0x400) != 0) {
                            buttons &= 0xFD;
                        }
                        if ((status & 0x800) != 0) {
                            buttons &= 0xFE;
                        }
                        if ((status & 4) != 0) {
                            buttons &= 0xFB;
                        }
                        if ((waxis = this.joystick1.getAxisValue(3)) > 0) {
                            this.kmouseW -= 16;
                        }
                        if (waxis < 0) {
                            this.kmouseW += 16;
                        }
                        return buttons | this.kmouseW & 0xF0;
                    }
                    case 33247: {
                        short xaxis = this.joystick1.getAxisValue(0);
                        if (xaxis != 0) {
                            this.kmouseX = this.kmouseX + xaxis / 6553 & 0xFF;
                        }
                        return this.kmouseX;
                    }
                    case 34271: {
                        short yaxis = this.joystick1.getAxisValue(1);
                        if (yaxis != 0) {
                            this.kmouseY = this.kmouseY - yaxis / 6553 & 0xFF;
                        }
                        return this.kmouseY;
                    }
                }
                return this.keyboard.readKempstonPort();
            }
            return this.keyboard.readKempstonPort() & 0x1F;
        }
        if (this.joystickModel == Keyboard.JoystickModel.FULLER && (port & 0xFF) == 127) {
            return this.keyboard.readFullerPort();
        }
        if ((port & 1) == 0) {
            this.earBit = this.tape.getEarBit();
            if (this.joystick1 == null || this.tape.isTapeRunning()) {
                return this.keyboard.readKeyboardPort(port, false) & this.earBit;
            }
            return this.keyboard.readKeyboardPort(port, true) & this.earBit;
        }
        if (this.enabledAY) {
            if ((port & 0xC002) == 49152) {
                return this.ay8912.readRegister();
            }
            if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3 && (port & 0xC002) == 32768) {
                return this.ay8912.readRegister();
            }
            if (this.joystickModel == Keyboard.JoystickModel.FULLER && (port & 0xFF) == 63) {
                return this.ay8912.readRegister();
            }
        }
        if (this.specSettings.isULAplus() && (port & 0x4004) == 16384) {
            if (this.paletteGroup == 64) {
                return this.ULAPlusActive ? 1 : 0;
            }
            return this.ULAPlusPalette[this.paletteGroup >>> 4][this.paletteGroup & 0xF];
        }
        int floatbus = 255;
        if (this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
            if (this.clock.getTstates() < this.spectrumModel.firstScrByte || this.clock.getTstates() > this.spectrumModel.lastScrUpdate) {
                return 255;
            }
            int col = this.clock.getTstates() % this.spectrumModel.tstatesLine - this.spectrumModel.outOffset;
            if (col > 124) {
                return 255;
            }
            int row = this.clock.getTstates() / this.spectrumModel.tstatesLine - this.spectrumModel.upBorderWidth;
            switch (col % 8) {
                case 0: {
                    int addr = this.scrAddr[row] + col / 4;
                    floatbus = this.memory.readScreenByte(addr & 0x1FFF);
                    break;
                }
                case 1: {
                    int addr = this.scr2attr[this.scrAddr[row] + col / 4 & 0x1FFF];
                    floatbus = this.memory.readScreenByte(addr);
                    break;
                }
                case 2: {
                    int addr = this.scrAddr[row] + col / 4 + 1;
                    floatbus = this.memory.readScreenByte(addr & 0x1FFF);
                    break;
                }
                case 3: {
                    int addr = this.scr2attr[this.scrAddr[row] + col / 4 + 1 & 0x1FFF];
                    floatbus = this.memory.readScreenByte(addr);
                }
            }
            if ((port & 0x8002) == 0 && this.spectrumModel == MachineTypes.SPECTRUM128K) {
                this.memory.setPort7ffd(floatbus);
                if ((this.port7ffd & 8) != (floatbus & 8)) {
                    this.invalidateScreen(true);
                }
                this.contendedIOPage[3] = (floatbus & 1) != 0;
                this.contendedRamPage[3] = this.contendedIOPage[3];
                this.port7ffd = floatbus;
            }
        }
        return floatbus & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outPort(int port, int value) {
        this.preIO(port);
        try {
            if (this.specSettings.isLecEnabled() && (port & 2) == 0 && this.spectrumModel == MachineTypes.SPECTRUM48K) {
                if ((value & 0x80) != 0) {
                    this.pageLec(value);
                } else {
                    this.unpageLec();
                }
                return;
            }
            if (this.connectedIF1) {
                if ((port & 0x18) == 0) {
                    this.if1.writeDataPort(value);
                    return;
                }
                if ((port & 0x18) == 8) {
                    this.if1.writeControlPort(value);
                    return;
                }
                if ((port & 0x18) == 16) {
                    this.if1.writeLanPort(value);
                    return;
                }
            }
            if (this.specSettings.isMultifaceEnabled() && this.memory.isMultifacePaged() && this.z80.getRegPC() < 16384) {
                if ((port & 0xFF) == 63) {
                    this.memory.setMultifaceLocked(true);
                }
                if ((port & 0xFF) == 191) {
                    this.memory.setMultifaceLocked(false);
                }
            }
            if ((port & 1) == 0) {
                if ((this.portFE & 7) != (value & 7) && this.LEFT_BORDER > 0) {
                    this.updateBorder(this.clock.getTstates());
                    this.borderUpdated = true;
                }
                if (!this.tape.isTapePlaying()) {
                    int spkMic = sp_volt[value >> 3 & 3];
                    if (this.enabledSound && spkMic != this.speaker) {
                        this.audio.updateAudio(this.clock.getTstates(), this.speaker);
                        this.speaker = spkMic;
                    }
                    if (this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
                        this.tape.setEarBit((value & this.issueMask) != 0);
                    }
                }
                if (this.tape.isTapeRecording() && ((this.portFE ^ value) & 8) != 0) {
                    this.tape.recordPulse((this.portFE & 8) != 0);
                }
                this.portFE = value;
                return;
            }
            if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM128K && (port & 0x8002) == 0) {
                if (((this.port7ffd ^ value) & 8) != 0) {
                    this.updateScreen(this.clock.getTstates());
                    this.invalidateScreen(true);
                }
                this.memory.setPort7ffd(value);
                this.contendedIOPage[3] = (value & 1) != 0;
                this.contendedRamPage[3] = this.contendedIOPage[3];
                this.port7ffd = value;
                return;
            }
            if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                if ((port & 0xC002) == 16384) {
                    if (((this.port7ffd ^ value) & 8) != 0) {
                        this.updateScreen(this.clock.getTstates() + 1);
                        this.invalidateScreen(true);
                    }
                    this.memory.setPort7ffd(value);
                    this.contendedRamPage[3] = this.memory.getPlus3HighPage() > 3;
                    this.port7ffd = value;
                    return;
                }
                if ((port & 0xF002) == 4096) {
                    this.memory.setPort1ffd(value);
                    if (this.memory.isPlus3RamMode()) {
                        switch (value & 6) {
                            case 0: {
                                Arrays.fill(this.contendedRamPage, false);
                                break;
                            }
                            case 2: {
                                Arrays.fill(this.contendedRamPage, true);
                                break;
                            }
                            case 4: 
                            case 6: {
                                Arrays.fill(this.contendedRamPage, true);
                                this.contendedRamPage[3] = false;
                            }
                        }
                    } else {
                        this.contendedRamPage[2] = false;
                        this.contendedRamPage[0] = false;
                        this.contendedRamPage[1] = true;
                        this.contendedRamPage[3] = this.memory.getPlus3HighPage() > 3;
                    }
                    this.port1ffd = value;
                    return;
                }
            }
            if (this.enabledAY && (port & 0x8002) == 32768) {
                if ((port & 0x4000) != 0) {
                    this.ay8912.setAddressLatch(value);
                } else {
                    if (this.enabledSound && this.ay8912.getAddressLatch() < 14) {
                        this.ay8912.updateAY(this.clock.getTstates());
                    }
                    this.ay8912.writeRegister(value);
                }
                return;
            }
            if (this.enabledAY && this.joystickModel == Keyboard.JoystickModel.FULLER && this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUM48K) {
                if ((port & 0xFF) == 63) {
                    this.ay8912.setAddressLatch(value);
                    return;
                }
                if ((port & 0xFF) == 95) {
                    if (this.enabledSound && this.ay8912.getAddressLatch() < 14) {
                        this.ay8912.updateAY(this.clock.getTstates());
                    }
                    this.ay8912.writeRegister(value);
                    return;
                }
            }
            if (this.specSettings.isULAplus() && (port & 4) == 0) {
                if ((port & 0x4000) == 0) {
                    if ((value & 0x40) != 0) {
                        this.paletteGroup = 64;
                    } else {
                        this.paletteGroup = value & 0x3F;
                        this.invalidateScreen(true);
                    }
                } else if (this.paletteGroup == 64) {
                    this.ULAPlusActive = (value & 1) != 0;
                    this.invalidateScreen(true);
                } else {
                    if (this.paletteGroup > 7 && this.paletteGroup < 16 && this.LEFT_BORDER > 0) {
                        this.borderUpdated = true;
                        this.updateBorder(this.clock.getTstates());
                    }
                    this.ULAPlusPalette[this.paletteGroup >>> 4][this.paletteGroup & 0xF] = value;
                    this.precompULAplusColor(this.paletteGroup, value);
                }
            }
            if (this.joystickModel == Keyboard.JoystickModel.KEMPSTON && (port & 0x85FF) == 1247) {
                this.kmouseEnabled = (value & 0x80) == 0;
            }
        }
        finally {
            this.postIO(port);
        }
    }

    private void preIO(int port) {
        if (this.contendedIOPage[port >>> 14]) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 1);
            if (this.clock.getTstates() >= this.nextEvent) {
                this.updateScreen(this.clock.getTstates());
            }
        } else {
            this.clock.addTstates(1);
        }
    }

    private void postIO(int port) {
        if (this.spectrumModel.codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
            this.clock.addTstates(3);
            return;
        }
        if (this.specSettings.isULAplus() && (port & 4) == 0) {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
            if (this.clock.getTstates() >= this.nextEvent) {
                this.updateScreen(this.clock.getTstates());
            }
            return;
        }
        if ((port & 1) != 0) {
            if (this.contendedIOPage[port >>> 14]) {
                this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 1);
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
                this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 1);
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
                this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 1);
                if (this.clock.getTstates() >= this.nextEvent) {
                    this.updateScreen(this.clock.getTstates());
                }
            } else {
                this.clock.addTstates(3);
            }
        } else {
            this.clock.addTstates(this.delayTstates[this.clock.getTstates()] + 3);
            if (this.clock.getTstates() >= this.nextEvent) {
                this.updateScreen(this.clock.getTstates());
            }
        }
    }

    @Override
    public void execDone() {
    }

    @Override
    public int atAddress(int address, int opcode) {
        switch (address) {
            case 8: 
            case 5896: {
                if (!this.connectedIF1) break;
                this.memory.pageIF1Rom();
                return this.memory.readByte(address) & 0xFF;
            }
            case 1792: {
                if (!this.connectedIF1) break;
                this.memory.unpageIF1Rom();
                break;
            }
            case 102: {
                if (!this.specSettings.isMultifaceEnabled() || this.memory.isPlus3RamMode()) break;
                this.memory.setMultifaceLocked(false);
                this.memory.pageMultiface();
                return this.memory.readByte(address) & 0xFF;
            }
            case 1232: {
                if (!this.saveTrap || !this.memory.isSpectrumRom() || !this.tape.isTapeReady() || !this.tape.saveTapeBlock(this.memory)) break;
                return 201;
            }
            case 1366: {
                if (!this.loadTrap || !this.memory.isSpectrumRom() || !this.tape.isTapeReady()) break;
                if (this.flashload && this.tape.flashLoad(this.memory)) {
                    this.invalidateScreen(true);
                    return 201;
                }
                this.tape.play();
            }
        }
        return opcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(File filename) {
        FilterOutputStream fOut = null;
        if (filename.getName().toLowerCase().endsWith(".scr")) {
            try {
                fOut = new BufferedOutputStream(new FileOutputStream(filename));
                for (int addr = 0; addr < 6912; ++addr) {
                    ((BufferedOutputStream)fOut).write(this.memory.readScreenByte(addr));
                }
                if (this.ULAPlusActive) {
                    for (int palette = 0; palette < 4; ++palette) {
                        for (int color = 0; color < 16; ++color) {
                            ((BufferedOutputStream)fOut).write(this.ULAPlusPalette[palette][color]);
                        }
                    }
                }
            }
            catch (FileNotFoundException excpt) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, excpt);
            }
            catch (IOException ioExcpt) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ioExcpt);
            }
            finally {
                try {
                    if (fOut != null) {
                        fOut.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return;
        }
        if (filename.getName().toLowerCase().endsWith(".png")) {
            try {
                ImageIO.write((RenderedImage)this.tvImage, "png", filename);
            }
            catch (IOException ioExcpt) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ioExcpt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadScreen(File filename) {
        BufferedInputStream fIn = null;
        if (filename.getName().toLowerCase().endsWith(".scr")) {
            try {
                int palette;
                fIn = new BufferedInputStream(new FileInputStream(filename));
                if (fIn.available() != 6912 && fIn.available() != 6976) {
                    boolean bl = false;
                    return bl;
                }
                for (int addr = 16384; addr < 23296; ++addr) {
                    this.memory.writeByte(addr, (byte)(fIn.read() & 0xFF));
                }
                this.ULAPlusActive = false;
                this.specSettings.setULAplus(false);
                if (fIn.available() == 64) {
                    this.ULAPlusActive = true;
                    this.specSettings.setULAplus(true);
                    for (palette = 0; palette < 4; ++palette) {
                        for (int color = 0; color < 16; ++color) {
                            int value;
                            this.ULAPlusPalette[palette][color] = value = fIn.read() & 0xFF;
                            int blue = (value & 3) << 1;
                            if ((value & 1) == 1) {
                                blue |= 1;
                            }
                            blue = blue << 5 | blue << 2 | blue & 3;
                            int red = (value & 0x1C) >> 2;
                            red = red << 5 | red << 2 | red & 3;
                            int green = (value & 0xE0) >> 5;
                            green = green << 5 | green << 2 | green & 3;
                            this.ULAPlusPrecompPalette[palette][color] = red << 16 | green << 8 | blue;
                        }
                    }
                }
                palette = 1;
                return palette != 0;
            }
            catch (FileNotFoundException excpt) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, excpt);
            }
            catch (IOException ioExcpt) {
                Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ioExcpt);
            }
            finally {
                try {
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return false;
    }

    public boolean isMuteSound() {
        return this.muted;
    }

    public void muteSound(boolean state) {
        this.muted = state;
        if (this.muted) {
            this.disableSound();
        } else {
            this.enableSound();
        }
    }

    private void enableSound() {
        if (this.paused || this.muted || this.enabledSound || this.framesByInt > 1L) {
            return;
        }
        this.audio.open(this.spectrumModel, this.ay8912, this.enabledAY, this.settings.getSpectrumSettings().isHifiSound() ? 48000 : 32000);
        if (!this.paused && this.taskFrame != null) {
            this.taskFrame.cancel();
            this.taskFrame = null;
        }
        this.enabledSound = true;
    }

    private void disableSound() {
        if (!this.enabledSound) {
            return;
        }
        this.enabledSound = false;
        this.audio.endFrame();
        this.audio.close();
        if (!this.paused) {
            this.taskFrame = new SpectrumTimer(this);
            this.timerFrame.scheduleAtFixedRate((TimerTask)this.taskFrame, 10L, 20L);
        }
    }

    public void changeSpeed(int speed) {
        if (speed > 1) {
            this.disableSound();
            this.framesByInt = speed;
        } else {
            this.framesByInt = 1L;
            this.invalidateScreen(true);
            this.enableSound();
        }
    }

    static void setvol() {
        Spectrum.sp_volt[0] = 0;
        Spectrum.sp_volt[1] = 0;
        Spectrum.sp_volt[2] = -24576;
        Spectrum.sp_volt[3] = -31948;
    }

    private void initGFX() {
        int address;
        int scan;
        this.tvImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        this.gcTvImage = this.tvImage.createGraphics();
        this.inProgressImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        this.dataInProgress = ((DataBufferInt)this.inProgressImage.getRaster().getDataBuffer()).getBankData()[0];
        this.lastChgBorder = 0;
        Arrays.fill(this.dirtyByte, true);
        this.screenDirty = false;
        this.borderChanged = this.LEFT_BORDER > 0;
        this.ULAPlusPalette = new int[4][16];
        this.ULAPlusPrecompPalette = new int[4][16];
        this.ULAPlusActive = false;
        this.paletteGroup = 0;
        for (int linea = 0; linea < 24; ++linea) {
            int lsb = (linea & 7) << 5;
            int msb = linea & 0x18;
            int addr = (msb << 8) + lsb;
            int idx = linea << 3;
            scan = 0;
            while (scan < 8) {
                this.scrAddr[scan + idx] = 16384 + addr;
                ++scan;
                addr += 256;
            }
        }
        for (address = 16384; address < 22528; ++address) {
            int row = (address & 0xE0) >>> 5 | (address & 0x1800) >>> 8;
            int col = address & 0x1F;
            scan = (address & 0x700) >>> 8;
            this.scanLineTable[address & 0x1FFF] = row * 2048 + scan * 256 + col * 8 >>> 8;
            this.bufAddr[address & 0x1FFF] = row * this.SCREEN_WIDTH * 8 + (scan + this.TOP_BORDER) * this.SCREEN_WIDTH + col * 8 + this.LEFT_BORDER;
            this.scr2attr[address & 0x1FFF] = 6144 + row * 32 + col;
        }
        for (address = 22528; address < 23296; ++address) {
            this.attr2scr[address & 0x3FF] = 0x4000 | (address & 0x300) << 3 | address & 0xFF;
        }
    }

    public BufferedImage getTvImage() {
        return this.tvImage;
    }

    public void setBorderMode(int mode) {
        if (this.borderMode == mode) {
            return;
        }
        this.borderMode = mode;
        switch (mode) {
            case 0: {
                this.BOTTOM_BORDER = 0;
                this.TOP_BORDER = 0;
                this.RIGHT_BORDER = 0;
                this.LEFT_BORDER = 0;
                break;
            }
            case 2: {
                this.LEFT_BORDER = 48;
                this.RIGHT_BORDER = 48;
                this.TOP_BORDER = 48;
                this.BOTTOM_BORDER = 56;
                break;
            }
            case 3: {
                this.LEFT_BORDER = 64;
                this.RIGHT_BORDER = 64;
                this.TOP_BORDER = 56;
                this.BOTTOM_BORDER = 56;
                break;
            }
            default: {
                this.LEFT_BORDER = 32;
                this.RIGHT_BORDER = 32;
                this.TOP_BORDER = 24;
                this.BOTTOM_BORDER = 24;
            }
        }
        this.SCREEN_WIDTH = this.LEFT_BORDER + 256 + this.RIGHT_BORDER;
        this.SCREEN_HEIGHT = this.TOP_BORDER + 192 + this.BOTTOM_BORDER;
        this.tvImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        if (this.gcTvImage != null) {
            this.gcTvImage.dispose();
        }
        this.gcTvImage = this.tvImage.createGraphics();
        this.inProgressImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        this.dataInProgress = ((DataBufferInt)this.inProgressImage.getRaster().getDataBuffer()).getBankData()[0];
        for (int address = 16384; address < 22528; ++address) {
            int row = (address & 0xE0) >>> 5 | (address & 0x1800) >>> 8;
            int col = address & 0x1F;
            int scan = (address & 0x700) >>> 8;
            this.bufAddr[address & 0x1FFF] = row * this.SCREEN_WIDTH * 8 + (scan + this.TOP_BORDER) * this.SCREEN_WIDTH + col * 8 + this.LEFT_BORDER;
        }
        switch (this.spectrumModel.codeModel) {
            case SPECTRUM128K: {
                this.buildScreenTables128k();
                break;
            }
            case SPECTRUMPLUS3: {
                this.buildScreenTablesPlus3();
                break;
            }
            default: {
                this.buildScreenTables48k();
            }
        }
    }

    public void toggleFlash() {
        this.flash ^= 0x80;
        for (int addrAttr = 6144; addrAttr < 6912; ++addrAttr) {
            if (this.memory.readScreenByte(addrAttr) >= 0) continue;
            this.notifyScreenWrite(addrAttr);
        }
    }

    private int tStatesToScrPix48k(int tstates) {
        int row = (tstates %= this.spectrumModel.tstatesFrame) / this.spectrumModel.tstatesLine;
        int col = tstates % this.spectrumModel.tstatesLine;
        if (row < 64 - this.TOP_BORDER - 1 || row > 256 + this.BOTTOM_BORDER - 1) {
            return -255151942;
        }
        if (row == 64 - this.TOP_BORDER - 1 && col < 200 + (24 - this.LEFT_BORDER / 2)) {
            return -255151942;
        }
        if (row == 256 + this.BOTTOM_BORDER - 1 && col > 127 + this.RIGHT_BORDER / 2) {
            return -255151942;
        }
        if (col > 127 + this.RIGHT_BORDER / 2 && col < 200 + (24 - this.LEFT_BORDER / 2)) {
            return -255151942;
        }
        if (row > 63 && row < 256 && col < 128) {
            return -255151942;
        }
        if (col > 176) {
            ++row;
            col -= 200 + (24 - this.LEFT_BORDER / 2);
        } else {
            col += this.RIGHT_BORDER / 2 - (this.RIGHT_BORDER - this.LEFT_BORDER) / 2;
        }
        return (row -= 64 - this.TOP_BORDER) * this.SCREEN_WIDTH + col * 2;
    }

    private int tStatesToScrPix128k(int tstates) {
        int row = (tstates %= this.spectrumModel.tstatesFrame) / this.spectrumModel.tstatesLine;
        int col = tstates % this.spectrumModel.tstatesLine;
        if (row < 63 - this.TOP_BORDER - 1 || row > 255 + this.BOTTOM_BORDER - 1) {
            return -255151942;
        }
        if (row == 63 - this.TOP_BORDER - 1 && col < 204 + (24 - this.LEFT_BORDER / 2)) {
            return -255151942;
        }
        if (row == 255 + this.BOTTOM_BORDER - 1 && col > 127 + this.RIGHT_BORDER / 2) {
            return -255151942;
        }
        if (col > 127 + this.RIGHT_BORDER / 2 && col < 204 + (24 - this.LEFT_BORDER / 2)) {
            return -255151942;
        }
        if (row > 62 && row < 255 && col < 128) {
            return -255151942;
        }
        if (col > 176) {
            ++row;
            col -= 204 + (24 - this.LEFT_BORDER / 2);
        } else {
            col += this.RIGHT_BORDER / 2 - (this.RIGHT_BORDER - this.LEFT_BORDER) / 2;
        }
        return (row -= 63 - this.TOP_BORDER) * this.SCREEN_WIDTH + col * 2;
    }

    private void updateBorder(int tstates) {
        if (tstates < this.lastChgBorder || this.lastChgBorder > this.lastBorderUpdate) {
            return;
        }
        int nowColor = this.ULAPlusActive ? this.ULAPlusPrecompPalette[0][this.portFE & 7 | 8] : Paleta[this.portFE & 7];
        tstates += this.spectrumModel.outBorderOffset;
        tstates &= 0xFFFFFC;
        while (this.lastChgBorder < tstates && this.lastChgBorder < this.lastBorderUpdate) {
            int idxColor = this.states2border[this.lastChgBorder];
            this.lastChgBorder += 4;
            if (idxColor == -255151942 || nowColor == this.dataInProgress[idxColor]) continue;
            this.dataInProgress[idxColor] = nowColor;
            this.dataInProgress[idxColor + 1] = nowColor;
            this.dataInProgress[idxColor + 2] = nowColor;
            this.dataInProgress[idxColor + 3] = nowColor;
            this.dataInProgress[idxColor + 4] = nowColor;
            this.dataInProgress[idxColor + 5] = nowColor;
            this.dataInProgress[idxColor + 6] = nowColor;
            this.dataInProgress[idxColor + 7] = nowColor;
            this.borderDirty = true;
            if (this.firstBorderPix > idxColor) {
                this.firstBorderPix = idxColor;
            }
            this.lastBorderPix = idxColor;
        }
        this.lastChgBorder = tstates;
    }

    public void updateScreen(int tstates) {
        while (this.step < this.stepStates.length && this.stepStates[this.step] <= tstates) {
            int paper;
            int ink;
            int column;
            int fromAddr;
            if (!this.dirtyByte[fromAddr = this.states2scr[this.stepStates[this.step++]] & 0x1FFF]) continue;
            int scan = this.scanLineTable[fromAddr];
            if (this.firstScanLine > scan) {
                this.firstScanLine = scan;
            }
            if (this.lastScanLine < scan) {
                this.lastScanLine = scan;
            }
            if ((column = fromAddr & 0x1F) < this.leftCol) {
                this.leftCol = column;
            }
            if (column > this.rightCol) {
                this.rightCol = column;
            }
            byte scrByte = this.memory.readScreenByte(fromAddr);
            int attr = this.memory.readScreenByte(this.scr2attr[fromAddr]) & 0xFF;
            int addrBuf = this.bufAddr[fromAddr];
            if (this.ULAPlusActive) {
                ink = this.ULAPlusPrecompPalette[attr >>> 6][attr & 7];
                paper = this.ULAPlusPrecompPalette[attr >>> 6][(attr & 0x38) >>> 3 | 8];
            } else {
                if (attr > 127) {
                    attr &= this.flash;
                }
                ink = Ink[attr];
                paper = Paper[attr];
            }
            for (int mask = 128; mask != 0; mask >>= 1) {
                this.dataInProgress[addrBuf++] = (scrByte & mask) != 0 ? ink : paper;
            }
            this.dirtyByte[fromAddr] = false;
            this.screenDirty = true;
        }
        this.nextEvent = this.step < this.stepStates.length ? this.stepStates[this.step] : 19088743;
    }

    private void notifyScreenWrite(int address) {
        if ((address &= 0x1FFF) < 6144) {
            this.dirtyByte[address] = true;
        } else {
            int addr = this.attr2scr[address & 0x3FF] & 0x1FFF;
            this.dirtyByte[addr] = true;
            this.dirtyByte[addr + 256] = true;
            this.dirtyByte[addr + 512] = true;
            this.dirtyByte[addr + 768] = true;
            this.dirtyByte[addr + 1024] = true;
            this.dirtyByte[addr + 1280] = true;
            this.dirtyByte[addr + 1536] = true;
            this.dirtyByte[addr + 1792] = true;
        }
    }

    public void invalidateScreen(boolean invalidateBorder) {
        this.borderChanged = this.LEFT_BORDER > 0 && invalidateBorder;
        Arrays.fill(this.dirtyByte, true);
    }

    private void buildScreenTables48k() {
        int tstates;
        this.firstBorderUpdate = (64 - this.TOP_BORDER) * this.spectrumModel.tstatesLine - this.LEFT_BORDER / 2;
        this.lastBorderUpdate = (255 + this.BOTTOM_BORDER) * this.spectrumModel.tstatesLine + 128 + this.RIGHT_BORDER;
        Arrays.fill(this.states2scr, 0);
        this.step = 0;
        for (tstates = this.spectrumModel.firstScrByte; tstates < 57248; tstates += 4) {
            int col = tstates % this.spectrumModel.tstatesLine / 4;
            if (col > 31) continue;
            int scan = tstates / this.spectrumModel.tstatesLine - this.spectrumModel.upBorderWidth;
            this.states2scr[tstates + 2] = this.scrAddr[scan] + col;
            this.stepStates[this.step++] = tstates + 2;
        }
        Arrays.fill(this.states2border, -255151942);
        for (tstates = this.firstBorderUpdate; tstates < this.lastBorderUpdate; tstates += 4) {
            this.states2border[tstates] = this.tStatesToScrPix48k(tstates);
            this.states2border[tstates + 1] = this.states2border[tstates];
            this.states2border[tstates + 2] = this.states2border[tstates];
            this.states2border[tstates + 3] = this.states2border[tstates];
        }
        Arrays.fill(this.delayTstates, (byte)0);
        for (int idx = 14335; idx < 57247; idx += this.spectrumModel.tstatesLine) {
            for (int ndx = 0; ndx < 128; ndx += 8) {
                int frame = idx + ndx;
                this.delayTstates[frame++] = 6;
                this.delayTstates[frame++] = 5;
                this.delayTstates[frame++] = 4;
                this.delayTstates[frame++] = 3;
                this.delayTstates[frame++] = 2;
                this.delayTstates[frame++] = 1;
                this.delayTstates[frame++] = 0;
                this.delayTstates[frame++] = 0;
            }
        }
    }

    private void buildScreenTables128k() {
        int tstates;
        this.firstBorderUpdate = (63 - this.TOP_BORDER) * this.spectrumModel.tstatesLine - this.RIGHT_BORDER / 2;
        this.lastBorderUpdate = (254 + this.BOTTOM_BORDER) * this.spectrumModel.tstatesLine + 128 + this.RIGHT_BORDER;
        Arrays.fill(this.states2scr, 0);
        this.step = 0;
        for (tstates = 14364; tstates < this.spectrumModel.lastScrUpdate; tstates += 4) {
            int col = tstates % this.spectrumModel.tstatesLine / 4;
            if (col > 31) continue;
            int scan = tstates / this.spectrumModel.tstatesLine - this.spectrumModel.upBorderWidth;
            this.states2scr[tstates] = this.scrAddr[scan] + col;
            this.stepStates[this.step++] = tstates;
        }
        Arrays.fill(this.states2border, -255151942);
        for (tstates = this.firstBorderUpdate; tstates < this.lastBorderUpdate; tstates += 4) {
            this.states2border[tstates] = this.tStatesToScrPix128k(tstates);
            this.states2border[tstates + 1] = this.states2border[tstates];
            this.states2border[tstates + 2] = this.states2border[tstates];
            this.states2border[tstates + 3] = this.states2border[tstates];
        }
        Arrays.fill(this.delayTstates, (byte)0);
        for (int idx = 14361; idx < 58037; idx += this.spectrumModel.tstatesLine) {
            for (int ndx = 0; ndx < 128; ndx += 8) {
                int frame = idx + ndx;
                this.delayTstates[frame++] = 6;
                this.delayTstates[frame++] = 5;
                this.delayTstates[frame++] = 4;
                this.delayTstates[frame++] = 3;
                this.delayTstates[frame++] = 2;
                this.delayTstates[frame++] = 1;
                this.delayTstates[frame++] = 0;
                this.delayTstates[frame++] = 0;
            }
        }
    }

    private void buildScreenTablesPlus3() {
        int tstates;
        this.firstBorderUpdate = (63 - this.TOP_BORDER) * this.spectrumModel.tstatesLine - this.RIGHT_BORDER / 2;
        this.lastBorderUpdate = (254 + this.BOTTOM_BORDER) * this.spectrumModel.tstatesLine + 128 + this.RIGHT_BORDER;
        Arrays.fill(this.states2scr, 0);
        this.step = 0;
        for (tstates = this.spectrumModel.firstScrByte; tstates < this.spectrumModel.lastScrUpdate; tstates += 4) {
            int col = tstates % this.spectrumModel.tstatesLine / 4;
            if (col > 31) continue;
            int scan = tstates / this.spectrumModel.tstatesLine - this.spectrumModel.upBorderWidth;
            this.states2scr[tstates + 2] = this.scrAddr[scan] + col;
            this.stepStates[this.step++] = tstates + 2;
        }
        Arrays.fill(this.states2border, -255151942);
        for (tstates = this.firstBorderUpdate; tstates < this.lastBorderUpdate; tstates += 4) {
            this.states2border[tstates] = this.tStatesToScrPix128k(tstates);
            this.states2border[tstates + 1] = this.states2border[tstates];
            this.states2border[tstates + 2] = this.states2border[tstates];
            this.states2border[tstates + 3] = this.states2border[tstates];
        }
        Arrays.fill(this.delayTstates, (byte)0);
        for (int idx = 14361; idx < 58036; idx += this.spectrumModel.tstatesLine) {
            for (int ndx = 0; ndx < 128; ndx += 8) {
                int frame = idx + ndx;
                this.delayTstates[frame++] = 1;
                this.delayTstates[frame++] = 0;
                this.delayTstates[frame++] = 7;
                this.delayTstates[frame++] = 6;
                this.delayTstates[frame++] = 5;
                this.delayTstates[frame++] = 4;
                this.delayTstates[frame++] = 3;
                this.delayTstates[frame++] = 2;
            }
        }
    }

    private void precompULAplusColor(int register, int color) {
        int blue = (color & 3) << 1;
        if ((color & 1) == 1) {
            blue |= 1;
        }
        blue = blue << 5 | blue << 2 | blue & 3;
        int red = (color & 0x1C) >> 2;
        red = red << 5 | red << 2 | red & 3;
        int green = (color & 0xE0) >> 5;
        green = green << 5 | green << 2 | green & 3;
        this.ULAPlusPrecompPalette[register >>> 4][register & 0xF] = red << 16 | green << 8 | blue;
    }

    public boolean startRecording() {
        return this.tape.startRecording();
    }

    public boolean stopRecording() {
        if (!this.tape.isTapeRecording()) {
            return false;
        }
        this.tape.recordPulse((this.portFE & 8) != 0);
        this.tape.stopRecording();
        return true;
    }

    public boolean isIF2RomInserted() {
        return this.memory.isIF2RomPaged();
    }

    public boolean insertIF2Rom(File filename) {
        return this.memory.insertIF2Rom(filename);
    }

    public void ejectIF2Rom() {
        this.memory.extractIF2Rom();
    }

    public Interface1 getInterface1() {
        return this.if1;
    }

    public boolean isIF1Connected() {
        return this.connectedIF1;
    }

    private void pageLec(int value) {
        if (!this.memory.isLecPaged()) {
            this.contendedIOPage[1] = false;
            this.contendedRamPage[1] = false;
            this.z80.setBreakpoint(102, false);
            this.z80.setBreakpoint(1232, false);
            this.z80.setBreakpoint(1366, false);
            if (this.connectedIF1) {
                this.z80.setBreakpoint(8, false);
                this.z80.setBreakpoint(1792, false);
                this.z80.setBreakpoint(5896, false);
            }
            this.enabledAY = false;
            this.saveTrap = false;
            this.loadTrap = false;
        }
        this.memory.setPortFD(value);
    }

    private void unpageLec() {
        this.memory.setPortFD(0);
        this.contendedIOPage[1] = true;
        this.contendedRamPage[1] = true;
        this.z80.setBreakpoint(102, this.specSettings.isMultifaceEnabled());
        this.saveTrap = this.settings.getTapeSettings().isEnableSaveTraps();
        this.z80.setBreakpoint(1232, this.saveTrap);
        this.loadTrap = this.settings.getTapeSettings().isEnableLoadTraps();
        this.z80.setBreakpoint(1366, this.loadTrap);
        if (this.connectedIF1) {
            this.z80.setBreakpoint(8, this.connectedIF1);
            this.z80.setBreakpoint(1792, this.connectedIF1);
            this.z80.setBreakpoint(5896, this.connectedIF1);
        }
        this.enabledAY = this.settings.getSpectrumSettings().isAYEnabled48K();
    }

    static {
        Spectrum.setvol();
        Paleta = new int[]{0, 192, 0xC00000, 0xC000C0, 49152, 49344, 0xC0C000, 0xC0C0C0, 0, 255, 0xFF0000, 0xFF00FF, 65280, 65535, 0xFFFF00, 0xFFFFFF};
        Paper = new int[256];
        Ink = new int[256];
        for (int idx = 0; idx < 256; ++idx) {
            int ink = idx & 7 | ((idx & 0x40) != 0 ? 8 : 0);
            int paper = idx >>> 3 & 7 | ((idx & 0x40) != 0 ? 8 : 0);
            if (idx < 128) {
                Spectrum.Ink[idx] = Paleta[ink];
                Spectrum.Paper[idx] = Paleta[paper];
                continue;
            }
            Spectrum.Ink[idx] = Paleta[paper];
            Spectrum.Paper[idx] = Paleta[ink];
        }
    }

    private class TapeChangedListener
    implements TapeStateListener,
    ClockTimeoutListener {
        boolean listenerInstalled = false;

        private TapeChangedListener() {
        }

        @Override
        public void stateChanged(Tape.TapeState state) {
            switch (state) {
                case PLAY: {
                    if (Spectrum.this.paused) break;
                    if (Spectrum.this.settings.getTapeSettings().isAccelerateLoading()) {
                        Spectrum.this.acceleratedLoading = true;
                        break;
                    }
                    if (!Spectrum.this.specSettings.isLoadingNoise() || !Spectrum.this.enabledSound) break;
                    this.listenerInstalled = true;
                    Spectrum.this.clock.addClockTimeoutListener(this);
                    break;
                }
                case STOP: {
                    if (!this.listenerInstalled) break;
                    Spectrum.this.clock.removeClockTimeoutListener(this);
                    this.listenerInstalled = false;
                }
            }
        }

        @Override
        public void clockTimeout() {
            int spkMic;
            if (!Spectrum.this.enabledSound) {
                return;
            }
            int n = spkMic = Spectrum.this.tape.getEarBit() == 191 ? -8000 : 8000;
            if (spkMic != Spectrum.this.speaker) {
                Spectrum.this.audio.updateAudio(Spectrum.this.clock.getTstates(), Spectrum.this.speaker);
                Spectrum.this.speaker = spkMic;
            }
        }
    }
}

