/*
 * Decompiled with CFR 0.152.
 */
package machine;

import configuration.JSpeccySettingsType;
import configuration.MemoryType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.MachineTypes;
import machine.Spectrum;
import snapshots.MemoryState;
import tv.porst.jhexview.IDataChangedListener;
import tv.porst.jhexview.IDataProvider;

public final class Memory {
    private final int PAGE_SIZE = 8192;
    private final byte[][] Rom48k = new byte[2][8192];
    private final byte[][] IF2Rom = new byte[2][8192];
    private final byte[][] Rom128k = new byte[4][8192];
    private final byte[][] RomPlus2 = new byte[4][8192];
    private final byte[][] RomPlus2a = new byte[8][8192];
    private final byte[][] RomPlus3 = new byte[8][8192];
    private final byte[][] IF1Rom = new byte[1][8192];
    private final byte[][] Ram = new byte[16][8192];
    private final byte[] fakeROM = new byte[8192];
    private final byte[][] readPages = new byte[8][];
    private final byte[][] writePages = new byte[8][];
    private final byte[][] mfROM = new byte[3][8192];
    private final byte[] mfRAM = new byte[8192];
    private byte[][] lecRam;
    private int screenPage;
    private int highPage;
    private int bankM;
    private int bankP;
    private int portFD;
    private int activePageLEC;
    private boolean IF1RomPaged;
    private boolean IF2RomPaged;
    private boolean model128k;
    private boolean pagingLocked;
    private boolean plus3RamMode;
    private boolean multifacePaged;
    private boolean multifaceLocked;
    private MachineTypes spectrumModel = null;
    private final JSpeccySettingsType settings;
    private final Random random;
    private int pageModeBrowser = 0;
    private MemoryDataProvider memoryDataProvider;

    public Memory(JSpeccySettingsType memSettings) {
        this.settings = memSettings;
        this.random = new Random();
        this.loadRoms();
        this.IF2RomPaged = false;
        this.reset(MachineTypes.SPECTRUM48K);
    }

    public MachineTypes getSpectrumModel() {
        return this.spectrumModel;
    }

    public MemoryState getMemoryState() {
        MemoryState state = new MemoryState();
        switch (this.spectrumModel) {
            case SPECTRUM16K: {
                state.setPageRam(5, this.savePage(5));
                break;
            }
            case SPECTRUM48K: {
                state.setPageRam(5, this.savePage(5));
                state.setPageRam(2, this.savePage(2));
                state.setPageRam(0, this.savePage(0));
                if (this.lecRam == null) break;
                state.setPortFD(this.portFD);
                for (int page = 0; page < 16; ++page) {
                    state.setLecPageRam(page, this.savePageLec(page));
                }
                break;
            }
            default: {
                for (int page = 0; page < 8; ++page) {
                    state.setPageRam(page, this.savePage(page));
                }
            }
        }
        state.setIF2RomPaged(this.IF2RomPaged);
        if (this.IF2RomPaged) {
            state.setIF2Rom(this.saveIF2Rom());
        }
        state.setMf128on48k(this.settings.getSpectrumSettings().isMf128On48K());
        state.setMultifaceRam(this.saveMFRam());
        state.setMultifacePaged(this.multifacePaged);
        state.setMultifaceLocked(this.multifaceLocked);
        state.setIF1RomPaged(this.IF1RomPaged);
        return state;
    }

    public void setMemoryState(MemoryState state) {
        if (this.IF2RomPaged) {
            this.extractIF2Rom();
        }
        switch (this.spectrumModel) {
            case SPECTRUM16K: {
                this.loadPage(5, state.getPageRam(5));
                break;
            }
            case SPECTRUM48K: {
                this.loadPage(5, state.getPageRam(5));
                this.loadPage(2, state.getPageRam(2));
                this.loadPage(0, state.getPageRam(0));
                if (state.getLecPageRam(0) != null) {
                    this.setConnectedLEC(true);
                    for (int page = 0; page < 16; ++page) {
                        this.loadPageLec(page, state.getLecPageRam(page));
                    }
                    break;
                }
                this.setConnectedLEC(false);
                break;
            }
            default: {
                for (int page = 0; page < 8; ++page) {
                    this.loadPage(page, state.getPageRam(page));
                }
            }
        }
        if (state.isIF2RomPaged() && this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
            this.loadIF2Rom(state.getIF2Rom());
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
        }
        this.settings.getSpectrumSettings().setMf128On48K(state.isMf128on48k());
        if (state.getMultifaceRam() != null) {
            this.loadMFRam(state.getMultifaceRam());
        }
        if (state.isMultifacePaged()) {
            this.pageMultiface();
        }
        this.multifaceLocked = state.isMultifaceLocked();
        if (this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3 && state.isIF1RomPaged()) {
            this.pageIF1Rom();
        }
    }

    public byte readScreenByte(int address) {
        return this.Ram[this.screenPage][address];
    }

    public byte readByte(int address) {
        return this.readPages[address >>> 13][address & 0x1FFF];
    }

    public void writeByte(int address, byte value) {
        this.writePages[address >>> 13][address & 0x1FFF] = value;
    }

    public byte readByte(int page, int address) {
        page <<= 1;
        if (address < 8192) {
            return this.Ram[page][address];
        }
        return this.Ram[page + 1][address & 0x1FFF];
    }

    public void writeByte(int page, int address, byte value) {
        page <<= 1;
        if (address < 8192) {
            this.Ram[page][address] = value;
        } else {
            this.Ram[page + 1][address & 0x1FFF] = value;
        }
    }

    public void loadPage(int page, byte[] buffer) {
        System.arraycopy(buffer, 0, this.Ram[page <<= 1], 0, 8192);
        System.arraycopy(buffer, 8192, this.Ram[page + 1], 0, 8192);
    }

    public byte[] savePage(int page) {
        byte[] buffer = new byte[16384];
        System.arraycopy(this.Ram[page <<= 1], 0, buffer, 0, 8192);
        System.arraycopy(this.Ram[page + 1], 0, buffer, 8192, 8192);
        return buffer;
    }

    public void loadMFRam(byte[] buffer) {
        System.arraycopy(buffer, 0, this.mfRAM, 0, this.mfRAM.length);
    }

    public byte[] saveMFRam() {
        byte[] buffer = new byte[8192];
        System.arraycopy(this.mfRAM, 0, buffer, 0, buffer.length);
        return buffer;
    }

    public void loadIF2Rom(byte[] rom) {
        System.arraycopy(rom, 0, this.IF2Rom[0], 0, this.IF2Rom[0].length);
        System.arraycopy(rom, 8192, this.IF2Rom[1], 0, this.IF2Rom[1].length);
        this.IF2RomPaged = true;
    }

    public byte[] saveIF2Rom() {
        byte[] buffer = new byte[16384];
        System.arraycopy(this.IF2Rom[0], 0, buffer, 0, this.IF2Rom[0].length);
        System.arraycopy(this.IF2Rom[1], 0, buffer, 8192, this.IF2Rom[1].length);
        return buffer;
    }

    public void loadPageLec(int page, byte[] ram) {
        if (this.lecRam == null) {
            throw new NullPointerException("No reserved LEC ram pages!");
        }
        System.arraycopy(ram, 0, this.lecRam[page <<= 2], 0, this.lecRam[0].length);
        System.arraycopy(ram, 8192, this.lecRam[page + 1], 0, this.lecRam[0].length);
        System.arraycopy(ram, 16384, this.lecRam[page + 2], 0, this.lecRam[0].length);
        System.arraycopy(ram, 24576, this.lecRam[page + 3], 0, this.lecRam[0].length);
    }

    public byte[] savePageLec(int page) {
        if (this.lecRam == null) {
            throw new NullPointerException("No reserved LEC ram pages!");
        }
        byte[] ram = new byte[32768];
        System.arraycopy(this.lecRam[page <<= 2], 0, ram, 0, this.lecRam[0].length);
        System.arraycopy(this.lecRam[page + 1], 0, ram, 8192, this.lecRam[0].length);
        System.arraycopy(this.lecRam[page + 2], 0, ram, 16384, this.lecRam[0].length);
        System.arraycopy(this.lecRam[page + 3], 0, ram, 24576, this.lecRam[0].length);
        return ram;
    }

    private void setMemoryMap16k() {
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
        } else {
            this.readPages[0] = this.Rom48k[0];
            this.readPages[1] = this.Rom48k[1];
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        this.writePages[2] = this.Ram[10];
        this.readPages[2] = this.writePages[2];
        this.writePages[3] = this.Ram[11];
        this.readPages[3] = this.writePages[3];
        this.readPages[5] = this.Ram[4];
        this.readPages[4] = this.readPages[5];
        this.readPages[7] = this.Ram[4];
        this.readPages[6] = this.readPages[7];
        this.writePages[5] = this.fakeROM;
        this.writePages[4] = this.fakeROM;
        this.writePages[7] = this.fakeROM;
        this.writePages[6] = this.fakeROM;
        Arrays.fill(this.Ram[4], (byte)-1);
        this.screenPage = 10;
        this.model128k = false;
    }

    private void setMemoryMap48k() {
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
        } else {
            this.readPages[0] = this.Rom48k[0];
            this.readPages[1] = this.Rom48k[1];
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        this.writePages[2] = this.Ram[10];
        this.readPages[2] = this.writePages[2];
        this.writePages[3] = this.Ram[11];
        this.readPages[3] = this.writePages[3];
        this.writePages[4] = this.Ram[4];
        this.readPages[4] = this.writePages[4];
        this.writePages[5] = this.Ram[5];
        this.readPages[5] = this.writePages[5];
        this.writePages[6] = this.Ram[0];
        this.readPages[6] = this.writePages[6];
        this.writePages[7] = this.Ram[1];
        this.readPages[7] = this.writePages[7];
        this.screenPage = 10;
        this.model128k = false;
    }

    private void setMemoryMap128k() {
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
        } else {
            this.readPages[0] = this.Rom128k[0];
            this.readPages[1] = this.Rom128k[1];
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        this.writePages[2] = this.Ram[10];
        this.readPages[2] = this.writePages[2];
        this.writePages[3] = this.Ram[11];
        this.readPages[3] = this.writePages[3];
        this.writePages[4] = this.Ram[4];
        this.readPages[4] = this.writePages[4];
        this.writePages[5] = this.Ram[5];
        this.readPages[5] = this.writePages[5];
        this.writePages[6] = this.Ram[0];
        this.readPages[6] = this.writePages[6];
        this.writePages[7] = this.Ram[1];
        this.readPages[7] = this.writePages[7];
        this.screenPage = 10;
        this.highPage = 0;
        this.model128k = true;
        this.bankM = 0;
    }

    private void setMemoryMapPlus2() {
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
        } else {
            this.readPages[0] = this.RomPlus2[0];
            this.readPages[1] = this.RomPlus2[1];
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        this.writePages[2] = this.Ram[10];
        this.readPages[2] = this.writePages[2];
        this.writePages[3] = this.Ram[11];
        this.readPages[3] = this.writePages[3];
        this.writePages[4] = this.Ram[4];
        this.readPages[4] = this.writePages[4];
        this.writePages[5] = this.Ram[5];
        this.readPages[5] = this.writePages[5];
        this.writePages[6] = this.Ram[0];
        this.readPages[6] = this.writePages[6];
        this.writePages[7] = this.Ram[1];
        this.readPages[7] = this.writePages[7];
        this.screenPage = 10;
        this.highPage = 0;
        this.model128k = true;
        this.bankM = 0;
    }

    private void setMemoryMapPlus3() {
        if (this.spectrumModel == MachineTypes.SPECTRUMPLUS3) {
            this.readPages[0] = this.RomPlus3[0];
            this.readPages[1] = this.RomPlus3[1];
        } else {
            this.readPages[0] = this.RomPlus2a[0];
            this.readPages[1] = this.RomPlus2a[1];
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        this.writePages[2] = this.Ram[10];
        this.readPages[2] = this.writePages[2];
        this.writePages[3] = this.Ram[11];
        this.readPages[3] = this.writePages[3];
        this.writePages[4] = this.Ram[4];
        this.readPages[4] = this.writePages[4];
        this.writePages[5] = this.Ram[5];
        this.readPages[5] = this.writePages[5];
        this.writePages[6] = this.Ram[0];
        this.readPages[6] = this.writePages[6];
        this.writePages[7] = this.Ram[1];
        this.readPages[7] = this.writePages[7];
        this.screenPage = 10;
        this.highPage = 0;
        this.model128k = true;
        this.bankP = 0;
        this.bankM = 0;
    }

    public void setPort7ffd(int port7ffd) {
        if (this.pagingLocked) {
            return;
        }
        this.bankM = port7ffd & 0xFF;
        int n = this.screenPage = (port7ffd & 8) == 0 ? 10 : 14;
        if (this.plus3RamMode) {
            return;
        }
        this.highPage = port7ffd & 7;
        this.writePages[6] = this.Ram[this.highPage << 1];
        this.readPages[6] = this.writePages[6];
        this.writePages[7] = this.Ram[(this.highPage << 1) + 1];
        this.readPages[7] = this.writePages[7];
        if (this.IF1RomPaged || this.multifacePaged || this.IF2RomPaged && this.spectrumModel.codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
            return;
        }
        switch (this.spectrumModel) {
            case SPECTRUM128K: {
                if ((port7ffd & 0x10) == 0) {
                    this.readPages[0] = this.Rom128k[0];
                    this.readPages[1] = this.Rom128k[1];
                    break;
                }
                this.readPages[0] = this.Rom128k[2];
                this.readPages[1] = this.Rom128k[3];
                break;
            }
            case SPECTRUMPLUS2: {
                if ((port7ffd & 0x10) == 0) {
                    this.readPages[0] = this.RomPlus2[0];
                    this.readPages[1] = this.RomPlus2[1];
                    break;
                }
                this.readPages[0] = this.RomPlus2[2];
                this.readPages[1] = this.RomPlus2[3];
                break;
            }
            case SPECTRUMPLUS2A: 
            case SPECTRUMPLUS3: {
                this.doPagingPlus3();
            }
        }
        this.pagingLocked = (port7ffd & 0x20) != 0;
    }

    public void setPort1ffd(int port1ffd) {
        if (this.pagingLocked) {
            return;
        }
        this.bankP = port1ffd & 7;
        this.doPagingPlus3();
    }

    private void doPagingPlus3() {
        if ((this.bankP & 1) == 0) {
            if (this.multifacePaged) {
                return;
            }
            int rom = (this.bankM & 0x10) >>> 3 | this.bankP & 4;
            if (this.spectrumModel == MachineTypes.SPECTRUMPLUS3) {
                this.readPages[0] = this.RomPlus3[rom];
                this.readPages[1] = this.RomPlus3[rom + 1];
            } else {
                this.readPages[0] = this.RomPlus2a[rom];
                this.readPages[1] = this.RomPlus2a[rom + 1];
            }
            this.writePages[1] = this.fakeROM;
            this.writePages[0] = this.fakeROM;
            if (this.plus3RamMode) {
                this.writePages[2] = this.Ram[10];
                this.readPages[2] = this.writePages[2];
                this.writePages[3] = this.Ram[11];
                this.readPages[3] = this.writePages[3];
                this.writePages[4] = this.Ram[4];
                this.readPages[4] = this.writePages[4];
                this.writePages[5] = this.Ram[5];
                this.readPages[5] = this.writePages[5];
                this.highPage = this.bankM & 7;
                this.writePages[6] = this.Ram[this.highPage * 2];
                this.readPages[6] = this.writePages[6];
                this.writePages[7] = this.Ram[this.highPage * 2 + 1];
                this.readPages[7] = this.writePages[7];
                this.plus3RamMode = false;
            }
        } else {
            this.plus3RamMode = true;
            switch (this.bankP & 6) {
                case 0: {
                    this.writePages[0] = this.Ram[0];
                    this.readPages[0] = this.writePages[0];
                    this.writePages[1] = this.Ram[1];
                    this.readPages[1] = this.writePages[1];
                    this.writePages[2] = this.Ram[2];
                    this.readPages[2] = this.writePages[2];
                    this.writePages[3] = this.Ram[3];
                    this.readPages[3] = this.writePages[3];
                    this.writePages[4] = this.Ram[4];
                    this.readPages[4] = this.writePages[4];
                    this.writePages[5] = this.Ram[5];
                    this.readPages[5] = this.writePages[5];
                    this.writePages[6] = this.Ram[6];
                    this.readPages[6] = this.writePages[6];
                    this.writePages[7] = this.Ram[7];
                    this.readPages[7] = this.writePages[7];
                    this.highPage = 3;
                    break;
                }
                case 2: {
                    this.writePages[0] = this.Ram[8];
                    this.readPages[0] = this.writePages[0];
                    this.writePages[1] = this.Ram[9];
                    this.readPages[1] = this.writePages[1];
                    this.writePages[2] = this.Ram[10];
                    this.readPages[2] = this.writePages[2];
                    this.writePages[3] = this.Ram[11];
                    this.readPages[3] = this.writePages[3];
                    this.writePages[4] = this.Ram[12];
                    this.readPages[4] = this.writePages[4];
                    this.writePages[5] = this.Ram[13];
                    this.readPages[5] = this.writePages[5];
                    this.writePages[6] = this.Ram[14];
                    this.readPages[6] = this.writePages[6];
                    this.writePages[7] = this.Ram[15];
                    this.readPages[7] = this.writePages[7];
                    this.highPage = 7;
                    break;
                }
                case 4: {
                    this.writePages[0] = this.Ram[8];
                    this.readPages[0] = this.writePages[0];
                    this.writePages[1] = this.Ram[9];
                    this.readPages[1] = this.writePages[1];
                    this.writePages[2] = this.Ram[10];
                    this.readPages[2] = this.writePages[2];
                    this.writePages[3] = this.Ram[11];
                    this.readPages[3] = this.writePages[3];
                    this.writePages[4] = this.Ram[12];
                    this.readPages[4] = this.writePages[4];
                    this.writePages[5] = this.Ram[13];
                    this.readPages[5] = this.writePages[5];
                    this.writePages[6] = this.Ram[6];
                    this.readPages[6] = this.writePages[6];
                    this.writePages[7] = this.Ram[7];
                    this.readPages[7] = this.writePages[7];
                    this.highPage = 3;
                    break;
                }
                case 6: {
                    this.writePages[0] = this.Ram[8];
                    this.readPages[0] = this.writePages[0];
                    this.writePages[1] = this.Ram[9];
                    this.readPages[1] = this.writePages[1];
                    this.writePages[2] = this.Ram[14];
                    this.readPages[2] = this.writePages[2];
                    this.writePages[3] = this.Ram[15];
                    this.readPages[3] = this.writePages[3];
                    this.writePages[4] = this.Ram[12];
                    this.readPages[4] = this.writePages[4];
                    this.writePages[5] = this.Ram[13];
                    this.readPages[5] = this.writePages[5];
                    this.writePages[6] = this.Ram[6];
                    this.readPages[6] = this.writePages[6];
                    this.writePages[7] = this.Ram[7];
                    this.readPages[7] = this.writePages[7];
                    this.highPage = 3;
                }
            }
        }
    }

    public int getPlus3HighPage() {
        return this.highPage;
    }

    public boolean isPlus3RamMode() {
        return this.plus3RamMode;
    }

    public boolean isPagingLocked() {
        return this.pagingLocked;
    }

    public boolean isSpectrumRom() {
        if (this.multifacePaged || this.IF1RomPaged || this.IF2RomPaged) {
            return false;
        }
        boolean res = false;
        switch (this.spectrumModel.codeModel) {
            case SPECTRUM48K: {
                res = !this.isLecPaged();
                break;
            }
            case SPECTRUM128K: {
                res = (this.bankM & 0x10) != 0;
                break;
            }
            case SPECTRUMPLUS3: {
                if (this.plus3RamMode) break;
                res = ((this.bankM & 0x10) >>> 3 | this.bankP & 4) == 6;
            }
        }
        return res;
    }

    public boolean isScreenByte(int addr) {
        if (this.plus3RamMode) {
            switch (this.bankP & 6) {
                case 0: {
                    return false;
                }
                case 4: {
                    return addr > 16383 && addr < 23296 && this.screenPage == 10;
                }
                case 6: {
                    return addr > 16383 && addr < 23296 && this.screenPage == 14;
                }
            }
        }
        switch (addr >>> 13) {
            case 2: {
                return addr < 23296 && this.screenPage == 10;
            }
            case 6: {
                return addr < 56064 && this.highPage << 1 == this.screenPage;
            }
        }
        return false;
    }

    public boolean isScreenByteModified(int address, byte value) {
        return this.readPages[address >>> 13][address & 0x1FFF] != value && this.isScreenByte(address);
    }

    public boolean isModel128k() {
        return this.model128k;
    }

    public void reset(MachineTypes model) {
        this.multifacePaged = false;
        this.IF1RomPaged = false;
        this.multifaceLocked = true;
        this.plus3RamMode = false;
        this.pagingLocked = false;
        this.activePageLEC = 0;
        this.portFD = 0;
        if (this.spectrumModel != model) {
            this.spectrumModel = model;
            for (byte[] Ram1 : this.Ram) {
                this.random.nextBytes(Ram1);
            }
            this.random.nextBytes(this.mfRAM);
        }
        switch (this.spectrumModel) {
            case SPECTRUM16K: {
                this.setMemoryMap16k();
                break;
            }
            case SPECTRUM48K: {
                this.setMemoryMap48k();
                break;
            }
            case SPECTRUM128K: {
                this.setMemoryMap128k();
                break;
            }
            case SPECTRUMPLUS2: {
                this.setMemoryMapPlus2();
                break;
            }
            case SPECTRUMPLUS2A: 
            case SPECTRUMPLUS3: {
                this.setMemoryMapPlus3();
            }
        }
    }

    public void pageMultiface() {
        if (this.multifacePaged || this.plus3RamMode) {
            return;
        }
        this.multifacePaged = true;
        switch (this.spectrumModel.codeModel) {
            case SPECTRUM48K: {
                if (this.settings.getSpectrumSettings().isMf128On48K()) {
                    this.readPages[0] = this.mfROM[1];
                    break;
                }
                this.readPages[0] = this.mfROM[0];
                break;
            }
            case SPECTRUM128K: {
                this.readPages[0] = this.mfROM[1];
                break;
            }
            case SPECTRUMPLUS3: {
                this.readPages[0] = this.mfROM[2];
            }
        }
        this.writePages[1] = this.mfRAM;
        this.readPages[1] = this.mfRAM;
    }

    public void unpageMultiface() {
        if (!this.multifacePaged) {
            return;
        }
        this.multifacePaged = false;
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
            return;
        }
        if (this.IF1RomPaged) {
            this.readPages[1] = this.IF1Rom[0];
            this.readPages[0] = this.readPages[1];
            return;
        }
        switch (this.spectrumModel) {
            case SPECTRUM16K: 
            case SPECTRUM48K: {
                this.readPages[0] = this.Rom48k[0];
                this.readPages[1] = this.Rom48k[1];
                break;
            }
            case SPECTRUM128K: {
                if (this.pagingLocked) {
                    this.readPages[0] = this.Rom128k[2];
                    this.readPages[1] = this.Rom128k[3];
                    break;
                }
                this.setPort7ffd(this.bankM);
                break;
            }
            case SPECTRUMPLUS2: {
                if (this.pagingLocked) {
                    this.readPages[0] = this.RomPlus2[2];
                    this.readPages[1] = this.RomPlus2[3];
                    break;
                }
                this.setPort7ffd(this.bankM);
                break;
            }
            case SPECTRUMPLUS2A: 
            case SPECTRUMPLUS3: {
                if (this.pagingLocked) {
                    this.readPages[0] = this.RomPlus3[6];
                    this.readPages[1] = this.RomPlus3[7];
                    break;
                }
                this.setPort7ffd(this.bankM);
            }
        }
    }

    public boolean isMultifacePaged() {
        return this.multifacePaged;
    }

    public void setMultifaceLocked(boolean state) {
        this.multifaceLocked = state;
    }

    public boolean isMultifaceLocked() {
        return this.multifaceLocked;
    }

    public boolean insertIF2Rom(File filename) {
        if (!this.loadIF2Rom(filename)) {
            return false;
        }
        this.IF2RomPaged = true;
        return true;
    }

    public void extractIF2Rom() {
        this.IF2RomPaged = false;
    }

    public boolean isIF2RomPaged() {
        return this.IF2RomPaged;
    }

    public void pageIF1Rom() {
        if (this.IF1RomPaged) {
            return;
        }
        this.IF1RomPaged = true;
        this.readPages[1] = this.IF1Rom[0];
        this.readPages[0] = this.readPages[1];
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
    }

    public void unpageIF1Rom() {
        if (!this.IF1RomPaged) {
            return;
        }
        this.IF1RomPaged = false;
        if (this.IF2RomPaged) {
            this.readPages[0] = this.IF2Rom[0];
            this.readPages[1] = this.IF2Rom[1];
            this.writePages[1] = this.fakeROM;
            this.writePages[0] = this.fakeROM;
            return;
        }
        if (this.multifacePaged) {
            switch (this.spectrumModel.codeModel) {
                case SPECTRUM48K: {
                    if (this.settings.getSpectrumSettings().isMf128On48K()) {
                        this.readPages[0] = this.mfROM[1];
                        break;
                    }
                    this.readPages[0] = this.mfROM[0];
                    break;
                }
                case SPECTRUM128K: {
                    this.readPages[0] = this.mfROM[1];
                    break;
                }
                case SPECTRUMPLUS3: {
                    this.readPages[0] = this.mfROM[2];
                }
            }
            this.writePages[1] = this.mfRAM;
            this.readPages[1] = this.mfRAM;
            return;
        }
        this.writePages[1] = this.fakeROM;
        this.writePages[0] = this.fakeROM;
        switch (this.spectrumModel) {
            case SPECTRUM16K: 
            case SPECTRUM48K: {
                this.readPages[0] = this.Rom48k[0];
                this.readPages[1] = this.Rom48k[1];
                break;
            }
            case SPECTRUM128K: {
                if (this.pagingLocked) {
                    this.readPages[0] = this.Rom128k[2];
                    this.readPages[1] = this.Rom128k[3];
                    break;
                }
                this.setPort7ffd(this.bankM);
                break;
            }
            case SPECTRUMPLUS2: {
                if (this.pagingLocked) {
                    this.readPages[0] = this.RomPlus2[2];
                    this.readPages[1] = this.RomPlus2[3];
                    break;
                }
                this.setPort7ffd(this.bankM);
            }
        }
    }

    public boolean isIF1RomPaged() {
        return this.IF1RomPaged;
    }

    public void setConnectedLEC(boolean state) {
        if (state && this.lecRam != null) {
            return;
        }
        if (state) {
            this.lecRam = new byte[64][];
            for (int page = 0; page < 60; ++page) {
                this.lecRam[page] = new byte[8192];
            }
            this.lecRam[60] = this.Ram[4];
            this.lecRam[61] = this.Ram[5];
            this.lecRam[62] = this.Ram[0];
            this.lecRam[63] = this.Ram[1];
        } else {
            this.lecRam = null;
        }
    }

    public boolean isConnectedLEC() {
        return this.lecRam != null;
    }

    public void setPortFD(int value) {
        if (this.lecRam == null) {
            return;
        }
        this.portFD = value;
        if ((value & 0x80) == 0) {
            this.activePageLEC = 0;
            this.setMemoryMap48k();
            if (this.IF1RomPaged) {
                this.IF1RomPaged = false;
                this.pageIF1Rom();
            }
            if (this.multifacePaged) {
                this.multifacePaged = false;
                this.pageMultiface();
            }
        } else {
            this.activePageLEC = (((value &= 0x78) & 0x70) >>> 4 | value & 8) & 0xF;
            value = this.activePageLEC <<= 2;
            this.writePages[0] = this.lecRam[value++];
            this.readPages[0] = this.writePages[0];
            this.writePages[1] = this.lecRam[value++];
            this.readPages[1] = this.writePages[1];
            this.writePages[2] = this.lecRam[value++];
            this.readPages[2] = this.writePages[2];
            this.writePages[3] = this.lecRam[value];
            this.readPages[3] = this.writePages[3];
        }
    }

    public boolean isLecPaged() {
        return (this.portFD & 0x80) != 0;
    }

    public int getPortFD() {
        return this.portFD;
    }

    public void loadRoms() {
        MemoryType conf = this.settings.getMemorySettings();
        String romsDirectory = conf.getRomsDirectory();
        if (!romsDirectory.isEmpty() && !romsDirectory.endsWith("/")) {
            romsDirectory = romsDirectory + "/";
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRom48K(), this.Rom48k, 0, 16384)) {
            this.loadRomAsResource("/roms/spectrum.rom", this.Rom48k, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomIF1(), this.IF1Rom, 0, 8192)) {
            this.loadRomAsResource("/roms/if1.rom", this.IF1Rom, 0, 8192);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRom128K0(), this.Rom128k, 0, 16384)) {
            this.loadRomAsResource("/roms/128-0.rom", this.Rom128k, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRom128K1(), this.Rom128k, 2, 16384)) {
            this.loadRomAsResource("/roms/128-1.rom", this.Rom128k, 2, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus20(), this.RomPlus2, 0, 16384)) {
            this.loadRomAsResource("/roms/plus2-0.rom", this.RomPlus2, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus21(), this.RomPlus2, 2, 16384)) {
            this.loadRomAsResource("/roms/plus2-1.rom", this.RomPlus2, 2, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus2A0(), this.RomPlus2a, 0, 16384)) {
            this.loadRomAsResource("/roms/plus2a-0.rom", this.RomPlus2a, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus2A1(), this.RomPlus2a, 2, 16384)) {
            this.loadRomAsResource("/roms/plus2a-1.rom", this.RomPlus2a, 2, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus2A2(), this.RomPlus2a, 4, 16384)) {
            this.loadRomAsResource("/roms/plus2a-2.rom", this.RomPlus2a, 4, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus2A3(), this.RomPlus2a, 6, 16384)) {
            this.loadRomAsResource("/roms/plus2a-3.rom", this.RomPlus2a, 6, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus30(), this.RomPlus3, 0, 16384)) {
            this.loadRomAsResource("/roms/plus3-0.rom", this.RomPlus3, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus31(), this.RomPlus3, 2, 16384)) {
            this.loadRomAsResource("/roms/plus3-1.rom", this.RomPlus3, 2, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus32(), this.RomPlus3, 4, 16384)) {
            this.loadRomAsResource("/roms/plus3-2.rom", this.RomPlus3, 4, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomPlus33(), this.RomPlus3, 6, 16384)) {
            this.loadRomAsResource("/roms/plus3-3.rom", this.RomPlus3, 6, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomMF1(), this.mfROM, 0, 8192)) {
            this.loadRomAsResource("/roms/mf1.rom", this.mfROM, 0, 8192);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomMF128(), this.mfROM, 1, 8192)) {
            this.loadRomAsResource("/roms/mf128.rom", this.mfROM, 1, 8192);
        }
        if (!this.loadRomAsFile(romsDirectory + conf.getRomMFPlus3(), this.mfROM, 2, 8192)) {
            this.loadRomAsResource("/roms/mfplus3.rom", this.mfROM, 2, 8192);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsResource(String filename, byte[][] rom, int page, int size) {
        InputStream inRom = Spectrum.class.getResourceAsStream(filename);
        boolean res = false;
        if (inRom == null) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            return false;
        }
        try {
            for (int frag = 0; frag < size / 8192; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 8192; count += inRom.read(rom[page + frag], count, 8192 - count)) {
                }
                if (count != 8192) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                inRom.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_RESOURCE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsFile(String filename, byte[][] rom, int page, int size) {
        BufferedInputStream fIn = null;
        boolean res = false;
        try {
            try {
                fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
                System.out.println(String.format("%s: %s", msg, filename));
                boolean bl = false;
                try {
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException ex2) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex2);
                }
                return bl;
            }
            for (int frag = 0; frag < size / 8192; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 8192; count += fIn.read(rom[page + frag], count, 8192 - count)) {
                }
                if (count != 8192) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Spectrum.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_FILE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIF2Rom(File filename) {
        BufferedInputStream fIn = null;
        try {
            try {
                fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                boolean bl = false;
                try {
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException ex2) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex2);
                }
                return bl;
            }
            if (fIn.available() > 16384) {
                boolean ex = false;
                return ex;
            }
            Arrays.fill(this.IF2Rom[0], (byte)-1);
            Arrays.fill(this.IF2Rom[1], (byte)-1);
            int readed = fIn.read(this.IF2Rom[0], 0, 8192);
            if (readed == -1) {
                boolean bl = false;
                return bl;
            }
            if (readed < 8192) {
                boolean bl = true;
                return bl;
            }
            if (fIn.available() > 0 && (readed = fIn.read(this.IF2Rom[1], 0, 8192)) == -1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    public void setPageModeBrowser(int page) {
        this.pageModeBrowser = page;
    }

    public MemoryDataProvider getMemoryDataProvider() {
        if (this.memoryDataProvider == null) {
            this.memoryDataProvider = new MemoryDataProvider();
        }
        return this.memoryDataProvider;
    }

    private class MemoryDataProvider
    implements IDataProvider {
        private MemoryDataProvider() {
        }

        @Override
        public void addListener(IDataChangedListener hexView) {
        }

        @Override
        public byte[] getData() {
            byte[] ram;
            if (Memory.this.pageModeBrowser > 7) {
                ram = new byte[65536];
                System.arraycopy(Memory.this.readPages[0], 0, ram, 0, 8192);
                System.arraycopy(Memory.this.readPages[1], 0, ram, 8192, 8192);
                System.arraycopy(Memory.this.readPages[2], 0, ram, 16384, 8192);
                System.arraycopy(Memory.this.readPages[3], 0, ram, 24576, 8192);
                System.arraycopy(Memory.this.readPages[4], 0, ram, 32768, 8192);
                System.arraycopy(Memory.this.readPages[5], 0, ram, 40960, 8192);
                System.arraycopy(Memory.this.readPages[6], 0, ram, 49152, 8192);
                System.arraycopy(Memory.this.readPages[7], 0, ram, 53248, 8192);
            } else {
                ram = new byte[16384];
                System.arraycopy(Memory.this.Ram[Memory.this.pageModeBrowser << 1], 0, ram, 0, 8192);
                System.arraycopy(Memory.this.Ram[(Memory.this.pageModeBrowser << 1) + 1], 0, ram, 8192, 8192);
            }
            return ram;
        }

        @Override
        public byte[] getData(long offset, int length) {
            byte[] ram = new byte[length];
            if (Memory.this.pageModeBrowser > 7) {
                for (int addr = 0; addr < length; ++addr) {
                    ram[addr] = Memory.this.readByte((int)((long)addr + offset));
                }
            } else {
                for (int addr = 0; addr < length; ++addr) {
                    ram[addr] = Memory.this.readByte(Memory.this.pageModeBrowser, (int)((long)addr + offset));
                }
            }
            return ram;
        }

        @Override
        public int getDataLength() {
            return Memory.this.pageModeBrowser > 7 ? 65536 : 16384;
        }

        @Override
        public boolean hasData(long start, int length) {
            return true;
        }

        @Override
        public boolean isEditable() {
            return true;
        }

        @Override
        public boolean keepTrying() {
            return false;
        }

        @Override
        public void removeListener(IDataChangedListener listener) {
        }

        @Override
        public void setData(long offset, byte[] data) {
            if (Memory.this.pageModeBrowser > 7) {
                for (int addr = 0; addr < data.length; ++addr) {
                    Memory.this.writeByte((int)((long)addr + offset), data[addr]);
                }
            } else {
                for (int addr = 0; addr < data.length; ++addr) {
                    Memory.this.writeByte(Memory.this.pageModeBrowser, (int)((long)addr + offset), data[addr]);
                }
            }
        }
    }
}

