/*
 * Decompiled with CFR 0.152.
 */
package machine;

import configuration.KeyboardJoystickType;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import joystickinput.JoystickRaw;

public class Keyboard
implements KeyListener {
    private final int[] rowKey = new int[8];
    private int sjs1;
    private int sjs2;
    private boolean shiftPressed;
    private boolean mapPCKeys;
    private final boolean winBug;
    private final KeyEvent[] keyEventPending = new KeyEvent[8];
    private int kempston;
    private int fuller;
    private JoystickModel joystickModel;
    private JoystickModel shadowJoystick;
    private final JoystickRaw joystick1;
    private final JoystickRaw joystick2;
    private static final int KEY_PRESSED_BIT0 = 254;
    private static final int KEY_PRESSED_BIT1 = 253;
    private static final int KEY_PRESSED_BIT2 = 251;
    private static final int KEY_PRESSED_BIT3 = 247;
    private static final int KEY_PRESSED_BIT4 = 239;
    private static final int KEY_PRESSED_BIT7 = 127;
    private static final int KEY_RELEASED_BIT0 = 1;
    private static final int KEY_RELEASED_BIT1 = 2;
    private static final int KEY_RELEASED_BIT2 = 4;
    private static final int KEY_RELEASED_BIT3 = 8;
    private static final int KEY_RELEASED_BIT4 = 16;
    private static final int KEY_RELEASED_BIT5 = 32;
    private static final int KEY_RELEASED_BIT6 = 64;
    private static final int KEY_RELEASED_BIT7 = 128;

    public Keyboard(KeyboardJoystickType config, JoystickRaw joy1, JoystickRaw joy2) {
        this.reset();
        this.setJoystickModel(config.getJoystickModel());
        this.mapPCKeys = config.isMapPCKeys();
        this.winBug = System.getProperty("os.name").contains("Windows");
        this.joystick1 = joy1;
        this.joystick2 = joy2;
    }

    public final void reset() {
        Arrays.fill(this.rowKey, 255);
        this.shiftPressed = false;
        this.kempston = 0;
        this.fuller = 255;
        this.sjs2 = 255;
        this.sjs1 = 255;
        Arrays.fill(this.keyEventPending, null);
    }

    public final JoystickModel getJoystickModel() {
        return this.joystick1 == null ? this.joystickModel : this.shadowJoystick;
    }

    public final void setJoystickModel(JoystickModel model) {
        this.kempston = 0;
        this.fuller = 255;
        this.sjs2 = 255;
        this.sjs1 = 255;
        if (this.joystick1 != null) {
            this.shadowJoystick = model;
            switch (this.shadowJoystick) {
                case SINCLAIR1: {
                    this.joystickModel = this.joystick2 == null ? JoystickModel.SINCLAIR2 : JoystickModel.NONE;
                    break;
                }
                case SINCLAIR2: {
                    this.joystickModel = this.joystick2 == null ? JoystickModel.SINCLAIR1 : JoystickModel.NONE;
                    break;
                }
                default: {
                    this.joystickModel = JoystickModel.NONE;
                    break;
                }
            }
        } else {
            this.joystickModel = model;
            this.shadowJoystick = JoystickModel.NONE;
        }
    }

    public final void setJoystickModel(int model) {
        switch (model) {
            case 1: {
                this.setJoystickModel(JoystickModel.KEMPSTON);
                break;
            }
            case 2: {
                this.setJoystickModel(JoystickModel.SINCLAIR1);
                break;
            }
            case 3: {
                this.setJoystickModel(JoystickModel.SINCLAIR2);
                break;
            }
            case 4: {
                this.setJoystickModel(JoystickModel.CURSOR);
                break;
            }
            case 5: {
                this.setJoystickModel(JoystickModel.FULLER);
                break;
            }
            default: {
                this.setJoystickModel(JoystickModel.NONE);
            }
        }
    }

    public boolean isMapPCKeys() {
        return this.mapPCKeys;
    }

    public void setMapPCKeys(boolean state) {
        this.mapPCKeys = state;
        this.shiftPressed = false;
        Arrays.fill(this.keyEventPending, null);
    }

    public int readKempstonPort() {
        if (this.joystick1 == null) {
            return this.kempston;
        }
        int buttons = 0;
        short coord = this.joystick1.getAxisValue(0);
        if (coord > 24575) {
            buttons |= 1;
        } else if (coord < -24575) {
            buttons |= 2;
        }
        coord = this.joystick1.getAxisValue(1);
        if (coord > 24575) {
            buttons |= 4;
        } else if (coord < -24575) {
            buttons |= 8;
        }
        int state = this.joystick1.getButtonMask();
        if (state == 0) {
            return buttons;
        }
        if ((state & 0x6000) != 0) {
            buttons |= 0x10;
        }
        if ((state & 0x8000) != 0) {
            buttons |= 0x20;
        }
        if ((state & 0x1000) != 0) {
            buttons |= 0x40;
        }
        return buttons;
    }

    public int readFullerPort() {
        if (this.joystick1 == null) {
            return this.fuller;
        }
        int state = this.joystick1.getButtonMask();
        if (state == 0) {
            return 255;
        }
        int buttons = 255;
        if ((state & 0x20) != 0) {
            buttons &= 0xEF;
        }
        if ((state & 0x80) != 0) {
            buttons &= 0xFB;
        }
        if ((state & 0x40) != 0) {
            buttons &= 0xFD;
        }
        if ((state & 0x10) != 0) {
            buttons &= 0xFE;
        }
        if ((state & 0xF000) != 0) {
            buttons &= 0x7F;
        }
        return buttons;
    }

    private void joystickToSJS1(int state) {
        this.sjs1 = 255;
        if (state == 0) {
            return;
        }
        if ((state & 0x80) != 0) {
            this.sjs1 &= 0xEF;
        }
        if ((state & 0x20) != 0) {
            this.sjs1 &= 0xF7;
        }
        if ((state & 0x40) != 0) {
            this.sjs1 &= 0xFB;
        }
        if ((state & 0x10) != 0) {
            this.sjs1 &= 0xFD;
        }
        if ((state & 0xF000) != 0) {
            this.sjs1 &= 0xFE;
        }
    }

    private void joystickToSJS2(int state) {
        this.sjs2 = 255;
        if (state == 0) {
            return;
        }
        if ((state & 0x80) != 0) {
            this.sjs2 &= 0xFE;
        }
        if ((state & 0x20) != 0) {
            this.sjs2 &= 0xFD;
        }
        if ((state & 0x40) != 0) {
            this.sjs2 &= 0xFB;
        }
        if ((state & 0x10) != 0) {
            this.sjs2 &= 0xF7;
        }
        if ((state & 0xF000) != 0) {
            this.sjs2 &= 0xEF;
        }
    }

    private void joystickToCursor() {
        this.sjs2 = 255;
        this.sjs1 = 255;
        int state = this.joystick1.getButtonMask();
        if (state == 0) {
            return;
        }
        if ((state & 0x80) != 0) {
            this.sjs2 &= 0xEF;
        }
        if ((state & 0x20) != 0) {
            this.sjs1 &= 0xFB;
        }
        if ((state & 0x40) != 0) {
            this.sjs1 &= 0xEF;
        }
        if ((state & 0x10) != 0) {
            this.sjs1 &= 0xF7;
        }
        if ((state & 0xF000) != 0) {
            this.sjs1 &= 0xFE;
        }
    }

    public int readKeyboardPort(int port, boolean mapJoysticks) {
        int keys = 255;
        int res = port >>> 8;
        if (mapJoysticks && this.joystick1 != null) {
            switch (this.shadowJoystick) {
                case KEMPSTON: {
                    if (this.joystick2 == null || res != 239) break;
                    this.joystickToSJS1(this.joystick2.getButtonMask());
                    break;
                }
                case SINCLAIR1: {
                    if (res == 239) {
                        this.joystickToSJS1(this.joystick1.getButtonMask());
                    }
                    if (this.joystick2 == null || res != 247) break;
                    this.joystickToSJS2(this.joystick2.getButtonMask());
                    break;
                }
                case SINCLAIR2: {
                    if (res == 247) {
                        this.joystickToSJS2(this.joystick1.getButtonMask());
                    }
                    if (this.joystick2 == null || res != 239) break;
                    this.joystickToSJS1(this.joystick2.getButtonMask());
                    break;
                }
                case CURSOR: {
                    this.joystickToCursor();
                }
            }
        }
        switch (res) {
            case 127: {
                return this.rowKey[7];
            }
            case 191: {
                return this.rowKey[6];
            }
            case 223: {
                return this.rowKey[5];
            }
            case 239: {
                return this.rowKey[4] & this.sjs1;
            }
            case 247: {
                return this.rowKey[3] & this.sjs2;
            }
            case 251: {
                return this.rowKey[2];
            }
            case 253: {
                return this.rowKey[1];
            }
            case 254: {
                return this.rowKey[0];
            }
        }
        res = ~res & 0xFF;
        int row = 0;
        int mask = 1;
        while (row < 8) {
            if ((res & mask) != 0) {
                keys &= this.rowKey[row];
            }
            ++row;
            mask <<= 1;
        }
        return keys;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        char keychar;
        if (this.mapPCKeys && (keychar = evt.getKeyChar()) != '\uffff' && !evt.isAltDown() && this.pressedKeyChar(keychar)) {
            for (int key = 0; key < this.keyEventPending.length; ++key) {
                if (this.keyEventPending[key] != null) continue;
                this.keyEventPending[key] = evt;
                break;
            }
            return;
        }
        int key = evt.getKeyCode();
        if (this.winBug && key == 18 && (evt.getModifiersEx() == 640 || evt.getKeyLocation() == 3)) {
            key = 65406;
            this.rowKey[7] = this.rowKey[7] | 2;
        } else if (evt.isAltDown() && !evt.isControlDown()) {
            return;
        }
        block0 : switch (key) {
            case 32: {
                this.rowKey[7] = this.rowKey[7] & 0xFE;
                break;
            }
            case 17: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                break;
            }
            case 77: {
                this.rowKey[7] = this.rowKey[7] & 0xFB;
                break;
            }
            case 78: {
                this.rowKey[7] = this.rowKey[7] & 0xF7;
                break;
            }
            case 66: {
                this.rowKey[7] = this.rowKey[7] & 0xEF;
                break;
            }
            case 10: {
                this.rowKey[6] = this.rowKey[6] & 0xFE;
                break;
            }
            case 76: {
                this.rowKey[6] = this.rowKey[6] & 0xFD;
                break;
            }
            case 75: {
                this.rowKey[6] = this.rowKey[6] & 0xFB;
                break;
            }
            case 74: {
                this.rowKey[6] = this.rowKey[6] & 0xF7;
                break;
            }
            case 72: {
                this.rowKey[6] = this.rowKey[6] & 0xEF;
                break;
            }
            case 80: {
                this.rowKey[5] = this.rowKey[5] & 0xFE;
                break;
            }
            case 79: {
                this.rowKey[5] = this.rowKey[5] & 0xFD;
                break;
            }
            case 73: {
                this.rowKey[5] = this.rowKey[5] & 0xFB;
                break;
            }
            case 85: {
                this.rowKey[5] = this.rowKey[5] & 0xF7;
                break;
            }
            case 89: {
                this.rowKey[5] = this.rowKey[5] & 0xEF;
                break;
            }
            case 48: {
                this.rowKey[4] = this.rowKey[4] & 0xFE;
                break;
            }
            case 57: {
                this.rowKey[4] = this.rowKey[4] & 0xFD;
                break;
            }
            case 56: {
                this.rowKey[4] = this.rowKey[4] & 0xFB;
                break;
            }
            case 55: {
                this.rowKey[4] = this.rowKey[4] & 0xF7;
                break;
            }
            case 54: {
                this.rowKey[4] = this.rowKey[4] & 0xEF;
                break;
            }
            case 49: {
                this.rowKey[3] = this.rowKey[3] & 0xFE;
                break;
            }
            case 50: {
                this.rowKey[3] = this.rowKey[3] & 0xFD;
                break;
            }
            case 51: {
                this.rowKey[3] = this.rowKey[3] & 0xFB;
                break;
            }
            case 52: {
                this.rowKey[3] = this.rowKey[3] & 0xF7;
                break;
            }
            case 53: {
                this.rowKey[3] = this.rowKey[3] & 0xEF;
                break;
            }
            case 81: {
                this.rowKey[2] = this.rowKey[2] & 0xFE;
                break;
            }
            case 87: {
                this.rowKey[2] = this.rowKey[2] & 0xFD;
                break;
            }
            case 69: {
                this.rowKey[2] = this.rowKey[2] & 0xFB;
                break;
            }
            case 82: {
                this.rowKey[2] = this.rowKey[2] & 0xF7;
                break;
            }
            case 84: {
                this.rowKey[2] = this.rowKey[2] & 0xEF;
                break;
            }
            case 65: {
                this.rowKey[1] = this.rowKey[1] & 0xFE;
                break;
            }
            case 83: {
                this.rowKey[1] = this.rowKey[1] & 0xFD;
                break;
            }
            case 68: {
                this.rowKey[1] = this.rowKey[1] & 0xFB;
                break;
            }
            case 70: {
                this.rowKey[1] = this.rowKey[1] & 0xF7;
                break;
            }
            case 71: {
                this.rowKey[1] = this.rowKey[1] & 0xEF;
                break;
            }
            case 16: {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.shiftPressed = true;
                break;
            }
            case 90: {
                this.rowKey[0] = this.rowKey[0] & 0xFD;
                break;
            }
            case 88: {
                this.rowKey[0] = this.rowKey[0] & 0xFB;
                break;
            }
            case 67: {
                this.rowKey[0] = this.rowKey[0] & 0xF7;
                break;
            }
            case 86: {
                this.rowKey[0] = this.rowKey[0] & 0xEF;
                break;
            }
            case 8: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] & 0xFE;
                }
                this.rowKey[4] = this.rowKey[4] & 0xFE;
                break;
            }
            case 44: {
                this.rowKey[7] = this.rowKey[7] & 0xF5;
                break;
            }
            case 46: {
                this.rowKey[7] = this.rowKey[7] & 0xF9;
                break;
            }
            case 45: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xF7;
                break;
            }
            case 521: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xFB;
                break;
            }
            case 61: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xFD;
                break;
            }
            case 520: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xFB;
                break;
            }
            case 47: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[0] = this.rowKey[0] & 0xEF;
                break;
            }
            case 59: {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xFD;
                break;
            }
            case 20: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] & 0xFE;
                }
                this.rowKey[3] = this.rowKey[3] & 0xFD;
                break;
            }
            case 27: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] & 0xFE;
                }
                this.rowKey[7] = this.rowKey[7] & 0xFE;
                break;
            }
            case 37: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] & 0xFE;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[3] = this.rowKey[3] & 0xEF;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston |= 2;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] & 0xEF;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] & 0xFE;
                        break;
                    }
                    case FULLER: {
                        this.fuller &= 0xFB;
                    }
                }
                break;
            }
            case 40: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] & 0xFE;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] & 0xEF;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston |= 4;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] & 0xFB;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] & 0xFB;
                        break;
                    }
                    case FULLER: {
                        this.fuller &= 0xFD;
                    }
                }
                break;
            }
            case 38: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] & 0xFE;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] & 0xF7;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston |= 8;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] & 0xFD;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] & 0xF7;
                        break;
                    }
                    case FULLER: {
                        this.fuller &= 0xFE;
                    }
                }
                break;
            }
            case 39: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] & 0xFE;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] & 0xFB;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston |= 1;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] & 0xF7;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] & 0xFD;
                        break;
                    }
                    case FULLER: {
                        this.fuller &= 0xF7;
                    }
                }
                break;
            }
            case 157: 
            case 65406: {
                switch (this.joystickModel) {
                    case NONE: {
                        break block0;
                    }
                    case KEMPSTON: {
                        this.kempston |= 0x10;
                        break block0;
                    }
                    case SINCLAIR1: 
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] & 0xFE;
                        break block0;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] & 0xEF;
                        break block0;
                    }
                    case FULLER: {
                        this.fuller &= 0x7F;
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        char keychar;
        if (this.mapPCKeys && (keychar = evt.getKeyChar()) != '\uffff' && !evt.isAltDown()) {
            for (int key = 0; key < this.keyEventPending.length; ++key) {
                if (this.keyEventPending[key] == null || evt.getKeyCode() != this.keyEventPending[key].getKeyCode()) continue;
                keychar = this.keyEventPending[key].getKeyChar();
                this.keyEventPending[key] = null;
            }
            if (this.releasedKeyChar(keychar)) {
                return;
            }
        }
        int key = evt.getKeyCode();
        if (this.winBug && (key == 17 && evt.getModifiersEx() == 512 || key == 18 && evt.getKeyLocation() == 3)) {
            key = 65406;
        } else if (evt.isAltDown() && !evt.isControlDown()) {
            return;
        }
        block0 : switch (key) {
            case 32: {
                this.rowKey[7] = this.rowKey[7] | 1;
                break;
            }
            case 17: {
                this.rowKey[7] = this.rowKey[7] | 2;
                break;
            }
            case 77: {
                this.rowKey[7] = this.rowKey[7] | 4;
                break;
            }
            case 78: {
                this.rowKey[7] = this.rowKey[7] | 8;
                break;
            }
            case 66: {
                this.rowKey[7] = this.rowKey[7] | 0x10;
                break;
            }
            case 10: {
                this.rowKey[6] = this.rowKey[6] | 1;
                break;
            }
            case 76: {
                this.rowKey[6] = this.rowKey[6] | 2;
                break;
            }
            case 75: {
                this.rowKey[6] = this.rowKey[6] | 4;
                break;
            }
            case 74: {
                this.rowKey[6] = this.rowKey[6] | 8;
                break;
            }
            case 72: {
                this.rowKey[6] = this.rowKey[6] | 0x10;
                break;
            }
            case 80: {
                this.rowKey[5] = this.rowKey[5] | 1;
                break;
            }
            case 79: {
                this.rowKey[5] = this.rowKey[5] | 2;
                break;
            }
            case 73: {
                this.rowKey[5] = this.rowKey[5] | 4;
                break;
            }
            case 85: {
                this.rowKey[5] = this.rowKey[5] | 8;
                break;
            }
            case 89: {
                this.rowKey[5] = this.rowKey[5] | 0x10;
                break;
            }
            case 48: {
                this.rowKey[4] = this.rowKey[4] | 1;
                break;
            }
            case 57: {
                this.rowKey[4] = this.rowKey[4] | 2;
                break;
            }
            case 56: {
                this.rowKey[4] = this.rowKey[4] | 4;
                break;
            }
            case 55: {
                this.rowKey[4] = this.rowKey[4] | 8;
                break;
            }
            case 54: {
                this.rowKey[4] = this.rowKey[4] | 0x10;
                break;
            }
            case 49: {
                this.rowKey[3] = this.rowKey[3] | 1;
                break;
            }
            case 50: {
                this.rowKey[3] = this.rowKey[3] | 2;
                break;
            }
            case 51: {
                this.rowKey[3] = this.rowKey[3] | 4;
                break;
            }
            case 52: {
                this.rowKey[3] = this.rowKey[3] | 8;
                break;
            }
            case 53: {
                this.rowKey[3] = this.rowKey[3] | 0x10;
                break;
            }
            case 81: {
                this.rowKey[2] = this.rowKey[2] | 1;
                break;
            }
            case 87: {
                this.rowKey[2] = this.rowKey[2] | 2;
                break;
            }
            case 69: {
                this.rowKey[2] = this.rowKey[2] | 4;
                break;
            }
            case 82: {
                this.rowKey[2] = this.rowKey[2] | 8;
                break;
            }
            case 84: {
                this.rowKey[2] = this.rowKey[2] | 0x10;
                break;
            }
            case 65: {
                this.rowKey[1] = this.rowKey[1] | 1;
                break;
            }
            case 83: {
                this.rowKey[1] = this.rowKey[1] | 2;
                break;
            }
            case 68: {
                this.rowKey[1] = this.rowKey[1] | 4;
                break;
            }
            case 70: {
                this.rowKey[1] = this.rowKey[1] | 8;
                break;
            }
            case 71: {
                this.rowKey[1] = this.rowKey[1] | 0x10;
                break;
            }
            case 16: {
                if (!this.shiftPressed) break;
                this.rowKey[0] = this.rowKey[0] | 1;
                this.shiftPressed = false;
                break;
            }
            case 90: {
                this.rowKey[0] = this.rowKey[0] | 2;
                break;
            }
            case 88: {
                this.rowKey[0] = this.rowKey[0] | 4;
                break;
            }
            case 67: {
                this.rowKey[0] = this.rowKey[0] | 8;
                break;
            }
            case 86: {
                this.rowKey[0] = this.rowKey[0] | 0x10;
                break;
            }
            case 8: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] | 1;
                }
                this.rowKey[4] = this.rowKey[4] | 1;
                break;
            }
            case 44: {
                this.rowKey[7] = this.rowKey[7] | 0xA;
                break;
            }
            case 46: {
                this.rowKey[7] = this.rowKey[7] | 6;
                break;
            }
            case 45: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 8;
                break;
            }
            case 521: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 4;
                break;
            }
            case 61: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 2;
                break;
            }
            case 520: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 4;
                break;
            }
            case 47: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[0] = this.rowKey[0] | 0x10;
                break;
            }
            case 59: {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 2;
                break;
            }
            case 20: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] | 1;
                }
                this.rowKey[3] = this.rowKey[3] | 2;
                break;
            }
            case 27: {
                if (!this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] | 1;
                }
                this.rowKey[7] = this.rowKey[7] | 1;
                break;
            }
            case 37: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] | 1;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[3] = this.rowKey[3] | 0x10;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston &= 0xFD;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] | 0x10;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] | 1;
                        break;
                    }
                    case FULLER: {
                        this.fuller |= 4;
                    }
                }
                break;
            }
            case 40: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] | 1;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] | 0x10;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston &= 0xFB;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] | 4;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] | 4;
                        break;
                    }
                    case FULLER: {
                        this.fuller |= 2;
                    }
                }
                break;
            }
            case 38: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] | 1;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] | 8;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston &= 0xF7;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] | 2;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] | 8;
                        break;
                    }
                    case FULLER: {
                        this.fuller |= 1;
                    }
                }
                break;
            }
            case 39: {
                switch (this.joystickModel) {
                    case NONE: {
                        if (!this.shiftPressed) {
                            this.rowKey[0] = this.rowKey[0] | 1;
                        }
                    }
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] | 4;
                        break;
                    }
                    case KEMPSTON: {
                        this.kempston &= 0xFE;
                        break;
                    }
                    case SINCLAIR1: {
                        this.rowKey[4] = this.rowKey[4] | 8;
                        break;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] | 2;
                        break;
                    }
                    case FULLER: {
                        this.fuller |= 8;
                    }
                }
                break;
            }
            case 157: 
            case 65406: {
                switch (this.joystickModel) {
                    case NONE: {
                        break block0;
                    }
                    case KEMPSTON: {
                        this.kempston &= 0xEF;
                        break block0;
                    }
                    case SINCLAIR1: 
                    case CURSOR: {
                        this.rowKey[4] = this.rowKey[4] | 1;
                        break block0;
                    }
                    case SINCLAIR2: {
                        this.rowKey[3] = this.rowKey[3] | 0x10;
                        break block0;
                    }
                    case FULLER: {
                        this.fuller |= 0x80;
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    private boolean pressedKeyChar(char keyChar) {
        boolean done = true;
        if (this.shiftPressed) {
            this.rowKey[0] = this.rowKey[0] | 1;
        }
        switch (keyChar) {
            case '!': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xFE;
                break;
            }
            case '\"': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xFE;
                break;
            }
            case '#': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xFB;
                break;
            }
            case '$': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xF7;
                break;
            }
            case '%': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xEF;
                break;
            }
            case '&': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[4] = this.rowKey[4] & 0xEF;
                break;
            }
            case '\'': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[4] = this.rowKey[4] & 0xF7;
                break;
            }
            case '(': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[4] = this.rowKey[4] & 0xFB;
                break;
            }
            case ')': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[4] = this.rowKey[4] & 0xFD;
                break;
            }
            case '*': {
                this.rowKey[7] = this.rowKey[7] & 0xED;
                break;
            }
            case '+': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xFB;
                break;
            }
            case ',': {
                this.rowKey[7] = this.rowKey[7] & 0xF5;
                break;
            }
            case '-': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xF7;
                break;
            }
            case '.': {
                this.rowKey[7] = this.rowKey[7] & 0xF9;
                break;
            }
            case '/': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[0] = this.rowKey[0] & 0xEF;
                break;
            }
            case '0': {
                this.rowKey[4] = this.rowKey[4] & 0xFE;
                break;
            }
            case '1': {
                this.rowKey[3] = this.rowKey[3] & 0xFE;
                break;
            }
            case '2': {
                this.rowKey[3] = this.rowKey[3] & 0xFD;
                break;
            }
            case '3': {
                this.rowKey[3] = this.rowKey[3] & 0xFB;
                break;
            }
            case '4': {
                this.rowKey[3] = this.rowKey[3] & 0xF7;
                break;
            }
            case '5': {
                this.rowKey[3] = this.rowKey[3] & 0xEF;
                break;
            }
            case '6': {
                this.rowKey[4] = this.rowKey[4] & 0xEF;
                break;
            }
            case '7': {
                this.rowKey[4] = this.rowKey[4] & 0xF7;
                break;
            }
            case '8': {
                this.rowKey[4] = this.rowKey[4] & 0xFB;
                break;
            }
            case '9': {
                this.rowKey[4] = this.rowKey[4] & 0xFD;
                break;
            }
            case ':': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[0] = this.rowKey[0] & 0xFD;
                break;
            }
            case ';': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xFD;
                break;
            }
            case '<': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[2] = this.rowKey[2] & 0xF7;
                break;
            }
            case '=': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[6] = this.rowKey[6] & 0xFD;
                break;
            }
            case '>': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[2] = this.rowKey[2] & 0xEF;
                break;
            }
            case '?': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[0] = this.rowKey[0] & 0xF7;
                break;
            }
            case '@': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[3] = this.rowKey[3] & 0xFD;
                break;
            }
            case 'A': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[1] = this.rowKey[1] & 0xFE;
                break;
            }
            case 'B': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[7] = this.rowKey[7] & 0xEF;
                break;
            }
            case 'C': {
                this.rowKey[0] = this.rowKey[0] & 0xF6;
                break;
            }
            case 'D': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[1] = this.rowKey[1] & 0xFB;
                break;
            }
            case 'E': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[2] = this.rowKey[2] & 0xFB;
                break;
            }
            case 'F': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[1] = this.rowKey[1] & 0xF7;
                break;
            }
            case 'G': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[1] = this.rowKey[1] & 0xEF;
                break;
            }
            case 'H': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[6] = this.rowKey[6] & 0xEF;
                break;
            }
            case 'I': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[5] = this.rowKey[5] & 0xFB;
                break;
            }
            case 'J': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[6] = this.rowKey[6] & 0xF7;
                break;
            }
            case 'K': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[6] = this.rowKey[6] & 0xFB;
                break;
            }
            case 'L': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[6] = this.rowKey[6] & 0xFD;
                break;
            }
            case 'M': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[7] = this.rowKey[7] & 0xFB;
                break;
            }
            case 'N': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[7] = this.rowKey[7] & 0xF7;
                break;
            }
            case 'O': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[5] = this.rowKey[5] & 0xFD;
                break;
            }
            case 'P': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[5] = this.rowKey[5] & 0xFE;
                break;
            }
            case 'Q': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[2] = this.rowKey[2] & 0xFE;
                break;
            }
            case 'R': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[2] = this.rowKey[2] & 0xF7;
                break;
            }
            case 'S': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[1] = this.rowKey[1] & 0xFD;
                break;
            }
            case 'T': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[2] = this.rowKey[2] & 0xEF;
                break;
            }
            case 'U': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[5] = this.rowKey[5] & 0xF7;
                break;
            }
            case 'V': {
                this.rowKey[0] = this.rowKey[0] & 0xEE;
                break;
            }
            case 'W': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[2] = this.rowKey[2] & 0xFD;
                break;
            }
            case 'X': {
                this.rowKey[0] = this.rowKey[0] & 0xFA;
                break;
            }
            case 'Y': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[5] = this.rowKey[5] & 0xEF;
                break;
            }
            case 'Z': {
                this.rowKey[0] = this.rowKey[0] & 0xFC;
                break;
            }
            case '[': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xEF;
                break;
            }
            case '\\': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[1] = this.rowKey[1] & 0xFB;
                break;
            }
            case ']': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xF7;
                break;
            }
            case '_': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[4] = this.rowKey[4] & 0xFE;
                break;
            }
            case 'a': {
                this.rowKey[1] = this.rowKey[1] & 0xFE;
                break;
            }
            case 'b': {
                this.rowKey[7] = this.rowKey[7] & 0xEF;
                break;
            }
            case 'c': {
                this.rowKey[0] = this.rowKey[0] & 0xF7;
                break;
            }
            case 'd': {
                this.rowKey[1] = this.rowKey[1] & 0xFB;
                break;
            }
            case 'e': {
                this.rowKey[2] = this.rowKey[2] & 0xFB;
                break;
            }
            case 'f': {
                this.rowKey[1] = this.rowKey[1] & 0xF7;
                break;
            }
            case 'g': {
                this.rowKey[1] = this.rowKey[1] & 0xEF;
                break;
            }
            case 'h': {
                this.rowKey[6] = this.rowKey[6] & 0xEF;
                break;
            }
            case 'i': {
                this.rowKey[5] = this.rowKey[5] & 0xFB;
                break;
            }
            case 'j': {
                this.rowKey[6] = this.rowKey[6] & 0xF7;
                break;
            }
            case 'k': {
                this.rowKey[6] = this.rowKey[6] & 0xFB;
                break;
            }
            case 'l': {
                this.rowKey[6] = this.rowKey[6] & 0xFD;
                break;
            }
            case 'm': {
                this.rowKey[7] = this.rowKey[7] & 0xFB;
                break;
            }
            case 'n': {
                this.rowKey[7] = this.rowKey[7] & 0xF7;
                break;
            }
            case 'o': {
                this.rowKey[5] = this.rowKey[5] & 0xFD;
                break;
            }
            case 'p': {
                this.rowKey[5] = this.rowKey[5] & 0xFE;
                break;
            }
            case 'q': {
                this.rowKey[2] = this.rowKey[2] & 0xFE;
                break;
            }
            case 'r': {
                this.rowKey[2] = this.rowKey[2] & 0xF7;
                break;
            }
            case 's': {
                this.rowKey[1] = this.rowKey[1] & 0xFD;
                break;
            }
            case 't': {
                this.rowKey[2] = this.rowKey[2] & 0xEF;
                break;
            }
            case 'u': {
                this.rowKey[5] = this.rowKey[5] & 0xF7;
                break;
            }
            case 'v': {
                this.rowKey[0] = this.rowKey[0] & 0xEF;
                break;
            }
            case 'w': {
                this.rowKey[2] = this.rowKey[2] & 0xFD;
                break;
            }
            case 'x': {
                this.rowKey[0] = this.rowKey[0] & 0xFB;
                break;
            }
            case 'y': {
                this.rowKey[5] = this.rowKey[5] & 0xEF;
                break;
            }
            case 'z': {
                this.rowKey[0] = this.rowKey[0] & 0xFD;
                break;
            }
            case '{': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[1] = this.rowKey[1] & 0xF7;
                break;
            }
            case '|': 
            case '\u00a6': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[1] = this.rowKey[1] & 0xFD;
                break;
            }
            case '}': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[1] = this.rowKey[1] & 0xEF;
                break;
            }
            case '~': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[1] = this.rowKey[1] & 0xFE;
                break;
            }
            case '\u00a9': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[5] = this.rowKey[5] & 0xFE;
                break;
            }
            case '`': 
            case '\u00a1': 
            case '\u00a7': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[3] = this.rowKey[3] & 0xFE;
                break;
            }
            case '\u00ac': 
            case '\u00b1': 
            case '\u00bf': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[4] = this.rowKey[4] & 0xFD;
                break;
            }
            case '\u00a3': {
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                this.rowKey[0] = this.rowKey[0] & 0xFB;
                break;
            }
            case '\u00ba': {
                this.rowKey[0] = this.rowKey[0] & 0xFE;
                this.rowKey[7] = this.rowKey[7] & 0xFD;
                break;
            }
            default: {
                if (this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] & 0xFE;
                }
                done = false;
            }
        }
        return done;
    }

    private boolean releasedKeyChar(char keyChar) {
        boolean done = true;
        switch (keyChar) {
            case '!': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 1;
                break;
            }
            case '\"': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 1;
                break;
            }
            case '#': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 4;
                break;
            }
            case '$': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 8;
                break;
            }
            case '%': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 0x10;
                break;
            }
            case '&': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[4] = this.rowKey[4] | 0x10;
                break;
            }
            case '\'': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[4] = this.rowKey[4] | 8;
                break;
            }
            case '(': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[4] = this.rowKey[4] | 4;
                break;
            }
            case ')': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[4] = this.rowKey[4] | 2;
                break;
            }
            case '*': {
                this.rowKey[7] = this.rowKey[7] | 0x12;
                break;
            }
            case '+': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 4;
                break;
            }
            case ',': {
                this.rowKey[7] = this.rowKey[7] | 0xA;
                break;
            }
            case '-': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 8;
                break;
            }
            case '.': {
                this.rowKey[7] = this.rowKey[7] | 6;
                break;
            }
            case '/': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[0] = this.rowKey[0] | 0x10;
                break;
            }
            case '0': {
                this.rowKey[4] = this.rowKey[4] | 1;
                break;
            }
            case '1': {
                this.rowKey[3] = this.rowKey[3] | 1;
                break;
            }
            case '2': {
                this.rowKey[3] = this.rowKey[3] | 2;
                break;
            }
            case '3': {
                this.rowKey[3] = this.rowKey[3] | 4;
                break;
            }
            case '4': {
                this.rowKey[3] = this.rowKey[3] | 8;
                break;
            }
            case '5': {
                this.rowKey[3] = this.rowKey[3] | 0x10;
                break;
            }
            case '6': {
                this.rowKey[4] = this.rowKey[4] | 0x10;
                break;
            }
            case '7': {
                this.rowKey[4] = this.rowKey[4] | 8;
                break;
            }
            case '8': {
                this.rowKey[4] = this.rowKey[4] | 4;
                break;
            }
            case '9': {
                this.rowKey[4] = this.rowKey[4] | 2;
                break;
            }
            case ':': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[0] = this.rowKey[0] | 2;
                break;
            }
            case ';': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 2;
                break;
            }
            case '<': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[2] = this.rowKey[2] | 8;
                break;
            }
            case '=': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[6] = this.rowKey[6] | 2;
                break;
            }
            case '>': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[2] = this.rowKey[2] | 0x10;
                break;
            }
            case '?': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[0] = this.rowKey[0] | 8;
                break;
            }
            case '@': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[3] = this.rowKey[3] | 2;
                break;
            }
            case 'A': {
                this.rowKey[1] = this.rowKey[1] | 1;
                break;
            }
            case 'B': {
                this.rowKey[7] = this.rowKey[7] | 0x10;
                break;
            }
            case 'C': {
                this.rowKey[0] = this.rowKey[0] | 8;
                break;
            }
            case 'D': {
                this.rowKey[1] = this.rowKey[1] | 4;
                break;
            }
            case 'E': {
                this.rowKey[2] = this.rowKey[2] | 4;
                break;
            }
            case 'F': {
                this.rowKey[1] = this.rowKey[1] | 8;
                break;
            }
            case 'G': {
                this.rowKey[1] = this.rowKey[1] | 0x10;
                break;
            }
            case 'H': {
                this.rowKey[6] = this.rowKey[6] | 0x10;
                break;
            }
            case 'I': {
                this.rowKey[5] = this.rowKey[5] | 4;
                break;
            }
            case 'J': {
                this.rowKey[6] = this.rowKey[6] | 8;
                break;
            }
            case 'K': {
                this.rowKey[6] = this.rowKey[6] | 4;
                break;
            }
            case 'L': {
                this.rowKey[6] = this.rowKey[6] | 2;
                break;
            }
            case 'M': {
                this.rowKey[7] = this.rowKey[7] | 4;
                break;
            }
            case 'N': {
                this.rowKey[7] = this.rowKey[7] | 8;
                break;
            }
            case 'O': {
                this.rowKey[5] = this.rowKey[5] | 2;
                break;
            }
            case 'P': {
                this.rowKey[5] = this.rowKey[5] | 1;
                break;
            }
            case 'Q': {
                this.rowKey[2] = this.rowKey[2] | 1;
                break;
            }
            case 'R': {
                this.rowKey[2] = this.rowKey[2] | 8;
                break;
            }
            case 'S': {
                this.rowKey[1] = this.rowKey[1] | 2;
                break;
            }
            case 'T': {
                this.rowKey[2] = this.rowKey[2] | 0x10;
                break;
            }
            case 'U': {
                this.rowKey[5] = this.rowKey[5] | 8;
                break;
            }
            case 'V': {
                this.rowKey[0] = this.rowKey[0] | 0x10;
                break;
            }
            case 'W': {
                this.rowKey[2] = this.rowKey[2] | 2;
                break;
            }
            case 'X': {
                this.rowKey[0] = this.rowKey[0] | 4;
                break;
            }
            case 'Y': {
                this.rowKey[5] = this.rowKey[5] | 0x10;
                break;
            }
            case 'Z': {
                this.rowKey[0] = this.rowKey[0] | 2;
                break;
            }
            case '[': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 0x10;
                break;
            }
            case '\\': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[1] = this.rowKey[1] | 4;
                break;
            }
            case ']': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 8;
                break;
            }
            case '_': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[4] = this.rowKey[4] | 1;
                break;
            }
            case 'a': {
                this.rowKey[1] = this.rowKey[1] | 1;
                break;
            }
            case 'b': {
                this.rowKey[7] = this.rowKey[7] | 0x10;
                break;
            }
            case 'c': {
                this.rowKey[0] = this.rowKey[0] | 8;
                break;
            }
            case 'd': {
                this.rowKey[1] = this.rowKey[1] | 4;
                break;
            }
            case 'e': {
                this.rowKey[2] = this.rowKey[2] | 4;
                break;
            }
            case 'f': {
                this.rowKey[1] = this.rowKey[1] | 8;
                break;
            }
            case 'g': {
                this.rowKey[1] = this.rowKey[1] | 0x10;
                break;
            }
            case 'h': {
                this.rowKey[6] = this.rowKey[6] | 0x10;
                break;
            }
            case 'i': {
                this.rowKey[5] = this.rowKey[5] | 4;
                break;
            }
            case 'j': {
                this.rowKey[6] = this.rowKey[6] | 8;
                break;
            }
            case 'k': {
                this.rowKey[6] = this.rowKey[6] | 4;
                break;
            }
            case 'l': {
                this.rowKey[6] = this.rowKey[6] | 2;
                break;
            }
            case 'm': {
                this.rowKey[7] = this.rowKey[7] | 4;
                break;
            }
            case 'n': {
                this.rowKey[7] = this.rowKey[7] | 8;
                break;
            }
            case 'o': {
                this.rowKey[5] = this.rowKey[5] | 2;
                break;
            }
            case 'p': {
                this.rowKey[5] = this.rowKey[5] | 1;
                break;
            }
            case 'q': {
                this.rowKey[2] = this.rowKey[2] | 1;
                break;
            }
            case 'r': {
                this.rowKey[2] = this.rowKey[2] | 8;
                break;
            }
            case 's': {
                this.rowKey[1] = this.rowKey[1] | 2;
                break;
            }
            case 't': {
                this.rowKey[2] = this.rowKey[2] | 0x10;
                break;
            }
            case 'u': {
                this.rowKey[5] = this.rowKey[5] | 8;
                break;
            }
            case 'v': {
                this.rowKey[0] = this.rowKey[0] | 0x10;
                break;
            }
            case 'w': {
                this.rowKey[2] = this.rowKey[2] | 2;
                break;
            }
            case 'x': {
                this.rowKey[0] = this.rowKey[0] | 4;
                break;
            }
            case 'y': {
                this.rowKey[5] = this.rowKey[5] | 0x10;
                break;
            }
            case 'z': {
                this.rowKey[0] = this.rowKey[0] | 2;
                break;
            }
            case '{': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[1] = this.rowKey[1] | 8;
                break;
            }
            case '|': 
            case '\u00a6': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[1] = this.rowKey[1] | 2;
                break;
            }
            case '}': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[1] = this.rowKey[1] | 0x10;
                break;
            }
            case '~': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[1] = this.rowKey[1] | 1;
                break;
            }
            case '\u00a9': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[5] = this.rowKey[5] | 1;
                break;
            }
            case '`': 
            case '\u00a1': 
            case '\u00a7': {
                this.rowKey[3] = this.rowKey[3] | 1;
                break;
            }
            case '\u00ac': 
            case '\u00b1': 
            case '\u00bf': {
                this.rowKey[4] = this.rowKey[4] | 2;
                break;
            }
            case '\u00a3': {
                this.rowKey[7] = this.rowKey[7] | 2;
                this.rowKey[0] = this.rowKey[0] | 4;
                break;
            }
            case '\u00ba': {
                this.rowKey[0] = this.rowKey[0] | 1;
                this.rowKey[7] = this.rowKey[7] | 2;
                break;
            }
            default: {
                if (this.shiftPressed) {
                    this.rowKey[0] = this.rowKey[0] & 0xFE;
                }
                done = false;
            }
        }
        return done;
    }

    public static enum JoystickModel {
        NONE,
        KEMPSTON,
        SINCLAIR1,
        SINCLAIR2,
        CURSOR,
        FULLER;

    }
}

