/*
 * Decompiled with CFR 0.152.
 */
package machine;

import configuration.Interface1Type;
import java.io.File;
import java.util.ArrayList;
import machine.Clock;
import machine.Interface1DriveListener;
import utilities.Microdrive;

public class Interface1 {
    private static final int CTRL_IN_WRPROT = 1;
    private static final int CTRL_IN_SYNC = 2;
    private static final int CTRL_IN_GAP = 4;
    private static final int CTRL_IN_DTR = 8;
    private static final int CTRL_OUT_COMMSDATA = 1;
    private static final int CTRL_OUT_COMMSCLK = 2;
    private static final int CTRL_OUT_RW = 4;
    private static final int CTRL_OUT_ERASE = 8;
    private static final int CTRL_OUT_CTS = 16;
    private static final int CTRL_OUT_WAIT = 32;
    private static final int RSN_IN_NET = 1;
    private static final int RSN_IN_TXDATA = 128;
    private static final int RSN_OUT_NET_RXDATA = 1;
    private int mdrFlipFlop;
    private int mdrSelected;
    private byte numMicrodrives;
    private final Microdrive[] microdrive;
    private boolean commsClk;
    private final Clock clock;
    private final Interface1Type settings;
    private int lan;
    private final ArrayList<Interface1DriveListener> driveListeners = new ArrayList();

    public Interface1(Interface1Type if1settings) {
        this.clock = Clock.getInstance();
        this.settings = if1settings;
        this.mdrFlipFlop = 0;
        this.mdrSelected = 0;
        this.numMicrodrives = this.settings.getMicrodriveUnits();
        this.microdrive = new Microdrive[8];
        for (int mdr = 0; mdr < 8; ++mdr) {
            this.microdrive[mdr] = new Microdrive();
        }
        this.commsClk = false;
        this.lan = 0;
    }

    public void addInterface1DriveListener(Interface1DriveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.driveListeners.contains(listener)) {
            this.driveListeners.add(listener);
        }
    }

    public void removeInterface1DriveListener(Interface1DriveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.driveListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    public void fireDriveSelected(int unit) {
        for (Interface1DriveListener listener : this.driveListeners) {
            listener.driveSelected(unit);
        }
    }

    public void fireDriveWrited(int unit) {
        for (Interface1DriveListener listener : this.driveListeners) {
            listener.driveModified(unit);
        }
    }

    public int readControlPort() {
        if (this.mdrFlipFlop != 0 && this.microdrive[this.mdrSelected].isCartridge()) {
            return this.microdrive[this.mdrSelected].readStatus();
        }
        return 244;
    }

    public int readDataPort() {
        if (this.mdrFlipFlop != 0 && this.microdrive[this.mdrSelected].isCartridge()) {
            return this.microdrive[this.mdrSelected].readData();
        }
        return 255;
    }

    public int readLanPort() {
        return this.lan;
    }

    public void writeControlPort(int value) {
        if ((value & 2) == 0 && this.commsClk) {
            this.mdrFlipFlop <<= 1;
            if ((value & 1) == 0) {
                this.mdrFlipFlop |= 1;
            }
            this.mdrFlipFlop &= 0xFF;
            switch (this.mdrFlipFlop) {
                case 1: {
                    this.mdrSelected = 0;
                    break;
                }
                case 2: {
                    this.mdrSelected = 1;
                    break;
                }
                case 4: {
                    this.mdrSelected = 2;
                    break;
                }
                case 8: {
                    this.mdrSelected = 3;
                    break;
                }
                case 16: {
                    this.mdrSelected = 4;
                    break;
                }
                case 32: {
                    this.mdrSelected = 5;
                    break;
                }
                case 64: {
                    this.mdrSelected = 6;
                    break;
                }
                case 128: {
                    this.mdrSelected = 7;
                }
            }
            if (this.mdrFlipFlop != 0) {
                this.microdrive[this.mdrSelected].selected();
                this.fireDriveSelected(this.mdrSelected + 1);
            } else {
                this.fireDriveSelected(0);
            }
        }
        if (this.mdrFlipFlop != 0) {
            this.microdrive[this.mdrSelected].writeControl(value);
        }
        this.commsClk = (value & 2) != 0;
    }

    public void writeDataPort(int value) {
        if (this.mdrFlipFlop != 0 && this.microdrive[this.mdrSelected].isCartridge()) {
            if (!this.microdrive[this.mdrSelected].isModified()) {
                this.fireDriveWrited(this.mdrSelected + 1);
            }
            this.microdrive[this.mdrSelected].writeData(value);
        }
    }

    public void writeLanPort(int value) {
        this.lan = value;
    }

    public void reset() {
        this.mdrFlipFlop = 0;
        this.fireDriveSelected(0);
    }

    public boolean isCartridge(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].isCartridge();
    }

    public boolean isModified(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].isModified();
    }

    public byte getNumDrives() {
        return this.numMicrodrives;
    }

    public void setNumDrives(byte drives) {
        if (drives < 1 || drives > 8) {
            drives = (byte)8;
        }
        this.numMicrodrives = drives;
    }

    public boolean isWriteProtected(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].isWriteProtected();
    }

    public void setWriteProtected(int drive, boolean state) {
        if (drive < 0 || drive > 7) {
            return;
        }
        this.microdrive[drive].setWriteProtected(state);
    }

    public String getFilename(int drive) {
        if (drive < 0 || drive > 7) {
            return null;
        }
        return this.microdrive[drive].getFilename();
    }

    public String getAbsolutePath(int drive) {
        if (drive < 0 || drive > 7) {
            return null;
        }
        return this.microdrive[drive].getAbsolutePath();
    }

    public boolean insertNew(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].insertNew(this.settings.getCartridgeSize());
    }

    public boolean insertFile(int drive, File filename) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].insertFromFile(filename);
    }

    public boolean eject(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].eject();
    }

    public boolean save(int drive) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].save();
    }

    public boolean save(int drive, File name) {
        if (drive < 0 || drive > 7) {
            return false;
        }
        return this.microdrive[drive].save(name);
    }

    public boolean hasDirtyCartridges() {
        boolean res = false;
        for (int drive = 0; drive < this.numMicrodrives; ++drive) {
            if (!this.microdrive[drive].isModified()) continue;
            res = true;
            break;
        }
        return res;
    }

    public boolean isDriveRunning(int drive) {
        if (drive < 0 || drive > 7 || this.mdrFlipFlop == 0) {
            return false;
        }
        return this.mdrSelected == drive;
    }

    public int getDriveRunning() {
        if (this.mdrFlipFlop == 0) {
            return 0;
        }
        return this.mdrSelected;
    }

    public void setDriveRunning(int drive, boolean state) {
        if (drive < 0 || drive > 7 || !state) {
            return;
        }
        this.mdrFlipFlop = 1 << drive;
        this.mdrSelected = drive;
    }

    public int getDrivePos(int drive) {
        if (drive < 0 || drive > 7) {
            return -1;
        }
        return this.microdrive[drive].getCartridgePos();
    }

    public void setDrivePos(int drive, int offset) {
        if (drive < 0 || drive > 7) {
            return;
        }
        this.microdrive[drive].setCartridgePos(offset);
    }

    public int getPreambleRem(int drive) {
        if (drive < 0 || drive > 7) {
            return -1;
        }
        return -1;
    }

    public void setPreambleRem(int drive, int offset) {
        if (drive < 0 || drive > 7) {
            return;
        }
    }
}

