/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.ConcurrentModificationException;
import java.util.concurrent.CopyOnWriteArrayList;
import machine.ClockTimeoutListener;
import machine.MachineTypes;

public class Clock {
    private static final Clock instance = new Clock();
    private MachineTypes spectrumModel = MachineTypes.SPECTRUM48K;
    private int tstates;
    private long frames;
    private int timeout;
    private final CopyOnWriteArrayList<ClockTimeoutListener> clockListeners = new CopyOnWriteArrayList();

    private Clock() {
    }

    public static Clock getInstance() {
        return instance;
    }

    public void addClockTimeoutListener(ClockTimeoutListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.clockListeners.contains(listener)) {
            this.clockListeners.add(listener);
        }
    }

    public void removeClockTimeoutListener(ClockTimeoutListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.clockListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
        if (this.clockListeners.isEmpty()) {
            this.timeout = 0;
        }
    }

    public void setSpectrumModel(MachineTypes spectrumModel) {
        this.spectrumModel = spectrumModel;
        this.reset();
    }

    public int getTstates() {
        return this.tstates;
    }

    public void setTstates(int states) {
        this.tstates = states;
        this.timeout = 0;
        this.frames = 0;
    }

    public void addTstates(int states) {
        this.tstates += states;
        if (this.timeout > 0) {
            this.timeout -= states;
            if (this.timeout <= 0) {
                int res = this.timeout;
                for (ClockTimeoutListener listener : this.clockListeners) {
                    listener.clockTimeout();
                }
                if (this.timeout > 0) {
                    this.timeout += res;
                }
            }
        }
    }

    public long getFrames() {
        return this.frames;
    }

    public void endFrame() {
        ++this.frames;
        this.tstates %= this.spectrumModel.tstatesFrame;
    }

    public long getAbsTstates() {
        return this.frames * (long)this.spectrumModel.tstatesFrame + (long)this.tstates;
    }

    public void reset() {
        this.tstates = 0;
        this.timeout = 0;
        this.frames = 0;
    }

    public void setTimeout(int ntstates) {
        if (this.timeout > 0) {
            throw new ConcurrentModificationException("A timeout is in progress. Can't set another timeout!");
        }
        this.timeout = ntstates > 10 ? ntstates : 10;
    }

    public String toString() {
        return String.format("Frame: %d, t-states: %d", this.frames, this.tstates);
    }
}

