/*
 * Decompiled with CFR 0.152.
 */
package machine;

import configuration.AY8912Type;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import machine.AY8912;
import machine.MachineTypes;

class Audio {
    private int samplingFrequency;
    private SourceDataLine line;
    private DataLine.Info infoDataLine;
    private AudioFormat fmt;
    private final byte[] buf = new byte[4096];
    private final int[] beeper = new int[1024];
    private final int[] ayBufA = new int[1024];
    private final int[] ayBufB = new int[1024];
    private final int[] ayBufC = new int[1024];
    private int ptrBeeper;
    private int ptrBuf;
    private int level;
    private int lastLevel;
    private int audiotstates;
    private int samplesPerFrame;
    private int frameSize;
    private int soundMode;
    private int channels;
    private long timeRem;
    private long step;
    private MachineTypes spectrumModel;
    private boolean enabledAY;
    private final AY8912Type settings;
    private AY8912 ay;

    Audio(AY8912Type ayConf) {
        this.settings = ayConf;
        this.line = null;
    }

    synchronized void open(MachineTypes model, AY8912 ay8912, boolean hasAY, int freq) {
        this.samplingFrequency = freq;
        this.soundMode = this.settings.getSoundMode();
        if (this.soundMode < 0 || this.soundMode > 3) {
            this.soundMode = 0;
        }
        int n = this.channels = this.soundMode > 0 ? 2 : 1;
        if (this.line == null) {
            try {
                this.fmt = new AudioFormat(this.samplingFrequency, 16, this.channels, true, false);
                this.infoDataLine = new DataLine.Info(SourceDataLine.class, this.fmt);
                this.line = (SourceDataLine)AudioSystem.getLine(this.infoDataLine);
            }
            catch (LineUnavailableException excpt) {
                Logger.getLogger(Audio.class.getName()).log(Level.SEVERE, null, excpt);
            }
            this.enabledAY = hasAY;
            this.timeRem = 0L;
            this.samplesPerFrame = this.samplingFrequency / 50;
            this.frameSize = this.samplesPerFrame * 2 * this.channels;
            if (model != this.spectrumModel) {
                this.spectrumModel = model;
                ay8912.setSpectrumModel(this.spectrumModel);
            }
            this.step = (long)((double)this.spectrumModel.tstatesFrame / (double)this.samplesPerFrame * 100000.0);
            this.ptrBuf = 0;
            this.ptrBeeper = 0;
            this.audiotstates = 0;
            this.lastLevel = 0;
            this.level = 0;
            ay8912.setMaxAmplitude(this.soundMode == 0 ? 10900 : 16350);
            switch (this.soundMode) {
                case 2: {
                    ay8912.setBufferChannels(this.ayBufA, this.ayBufC, this.ayBufB);
                    break;
                }
                case 3: {
                    ay8912.setBufferChannels(this.ayBufB, this.ayBufA, this.ayBufC);
                    break;
                }
                default: {
                    ay8912.setBufferChannels(this.ayBufA, this.ayBufB, this.ayBufC);
                }
            }
            if (this.enabledAY) {
                ay8912.setAudioFreq(this.samplingFrequency);
                ay8912.startPlay();
                this.ay = ay8912;
            }
            try {
                if (System.getProperty("os.name").contains("Linux")) {
                    this.line.open(this.fmt, this.frameSize);
                } else {
                    this.line.open(this.fmt, this.frameSize * 2);
                }
                this.line.start();
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(Audio.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    synchronized void close() {
        if (this.line != null) {
            this.line.flush();
            this.line.stop();
            this.line.close();
            this.line = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateAudio(int tstates, int value) {
        this.audiotstates += (tstates -= this.audiotstates);
        long time = (long)tstates * 100000L;
        int[] nArray = this.beeper;
        synchronized (this.beeper) {
            if (this.timeRem > 0L) {
                long diff = this.step - this.timeRem;
                if (time >= diff) {
                    time -= diff;
                    if (value != 0) {
                        this.level = (int)((float)this.level + (float)diff / (float)this.step * (float)value);
                    }
                    this.lastLevel += this.level - this.lastLevel >> 1;
                    this.beeper[this.ptrBeeper++] = this.lastLevel;
                } else {
                    this.timeRem += time;
                    if (value != 0) {
                        this.level = (int)((float)this.level + (float)time / (float)this.step * (float)value);
                    }
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
            }
            while (time >= this.step) {
                this.lastLevel += value - this.lastLevel >> 1;
                this.beeper[this.ptrBeeper++] = this.lastLevel;
                time -= this.step;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.timeRem = time;
            this.level = value != 0 && time > 0L ? (int)((float)time / (float)this.step * (float)value) : 0;
            return;
        }
    }

    public synchronized void flush() {
        this.ptrBeeper = 0;
        this.lastLevel = 0;
        this.level = 0;
        this.timeRem = 0L;
        if (this.line != null) {
            this.line.flush();
        }
    }

    public synchronized void sendAudioFrame() {
        if (this.line != null) {
            this.line.write(this.buf, 0, this.frameSize);
        }
    }

    public synchronized void endFrame() {
        if (this.ptrBeeper == 0) {
            return;
        }
        if (this.soundMode == 0) {
            this.endFrameMono();
        } else {
            this.endFrameStereo();
        }
        this.ptrBuf = 0;
        if (this.enabledAY) {
            this.ay.endFrame();
        }
        this.ptrBeeper = 0;
        this.audiotstates = 0;
    }

    private void endFrameMono() {
        if (this.enabledAY) {
            for (int idx = 0; idx < this.samplesPerFrame; ++idx) {
                int sample = this.beeper[idx] + this.ayBufA[idx] + this.ayBufB[idx] + this.ayBufC[idx];
                this.buf[this.ptrBuf++] = (byte)sample;
                this.buf[this.ptrBuf++] = (byte)(sample >>> 8);
            }
        } else {
            for (int idx = 0; idx < this.samplesPerFrame; ++idx) {
                this.buf[this.ptrBuf++] = (byte)this.beeper[idx];
                this.buf[this.ptrBuf++] = (byte)(this.beeper[idx] >>> 8);
            }
        }
    }

    private void endFrameStereo() {
        if (this.enabledAY) {
            for (int idx = 0; idx < this.samplesPerFrame; ++idx) {
                int center = (int)((double)this.ayBufB[idx] * 0.7);
                int side = (int)((double)this.ayBufC[idx] * 0.3);
                int sampleL = this.beeper[idx] + this.ayBufA[idx] + center + side;
                side = (int)((double)this.ayBufA[idx] * 0.3);
                int sampleR = this.beeper[idx] + side + center + this.ayBufC[idx];
                this.buf[this.ptrBuf++] = (byte)sampleL;
                this.buf[this.ptrBuf++] = (byte)(sampleL >>> 8);
                this.buf[this.ptrBuf++] = (byte)sampleR;
                this.buf[this.ptrBuf++] = (byte)(sampleR >>> 8);
            }
        } else {
            for (int idx = 0; idx < this.samplesPerFrame; ++idx) {
                byte lsb = (byte)this.beeper[idx];
                byte msb = (byte)(this.beeper[idx] >>> 8);
                this.buf[this.ptrBuf++] = lsb;
                this.buf[this.ptrBuf++] = msb;
                this.buf[this.ptrBuf++] = lsb;
                this.buf[this.ptrBuf++] = msb;
            }
        }
    }

    public void reset() {
        this.audiotstates = 0;
        this.ptrBeeper = 0;
        this.lastLevel = 0;
        this.level = 0;
        this.timeRem = 0L;
        Arrays.fill(this.buf, (byte)0);
        Arrays.fill(this.beeper, 0);
    }
}

