/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.Arrays;
import machine.MachineTypes;
import snapshots.AY8912State;

public final class AY8912 {
    private static final int FineToneA = 0;
    private static final int CoarseToneA = 1;
    private static final int FineToneB = 2;
    private static final int CoarseToneB = 3;
    private static final int FineToneC = 4;
    private static final int CoarseToneC = 5;
    private static final int NoisePeriod = 6;
    private static final int Mixer = 7;
    private static final int AmplitudeA = 8;
    private static final int AmplitudeB = 9;
    private static final int AmplitudeC = 10;
    private static final int FineEnvelope = 11;
    private static final int CoarseEnvelope = 12;
    private static final int EnvelopeShapeCycle = 13;
    private static final int IOPortA = 14;
    private static final int IOPortB = 15;
    private static final int TONE_A = 1;
    private static final int TONE_B = 2;
    private static final int TONE_C = 4;
    private static final int NOISE_A = 8;
    private static final int NOISE_B = 16;
    private static final int NOISE_C = 32;
    private static final int ENVELOPE = 16;
    private static final int HOLD = 1;
    private static final int ALTERNATE = 2;
    private static final int ATTACK = 4;
    private static final int CONTINUE = 8;
    private int periodA;
    private int periodB;
    private int periodC;
    private int periodN;
    private int counterA;
    private int counterB;
    private int counterC;
    private int amplitudeA;
    private int amplitudeB;
    private int amplitudeC;
    private int counterN;
    private int rng;
    private int envelopePeriod;
    private int envelopeCounter;
    private boolean Continue;
    private boolean Attack;
    private boolean Hold;
    private boolean Alternate;
    private int amplitudeEnv;
    private int maxAmplitude = 10900;
    private int addressLatch;
    private final int[] regAY = new int[16];
    private static final double[] volumeRate = new double[]{0.0, 0.0137, 0.0205, 0.0291, 0.0423, 0.0618, 0.0847, 0.1369, 0.1691, 0.2647, 0.3527, 0.4499, 0.5704, 0.6873, 0.8482, 1.0};
    private final int[] volumeLevel = new int[16];
    private int[] bufA;
    private int[] bufB;
    private int[] bufC;
    private int pbuf;
    private int FREQ;
    private long step;
    private long stepCounter;
    private double stepRate;
    private boolean toneA;
    private boolean toneB;
    private boolean toneC;
    private boolean toneN;
    private boolean disableToneA;
    private boolean disableToneB;
    private boolean disableToneC;
    private boolean disableNoiseA;
    private boolean disableNoiseB;
    private boolean disableNoiseC;
    private boolean envA;
    private boolean envB;
    private boolean envC;
    private int volumeA;
    private int volumeB;
    private int volumeC;
    private int audiotstates;
    private int samplesPerFrame;
    private MachineTypes spectrumModel;

    AY8912() {
        for (int idx = 0; idx < this.volumeLevel.length; ++idx) {
            this.volumeLevel[idx] = (int)((double)this.maxAmplitude * volumeRate[idx]);
        }
    }

    public AY8912State getAY8912State() {
        AY8912State state = new AY8912State();
        state.setAddressLatch(this.addressLatch);
        int[] regs = new int[16];
        System.arraycopy(this.regAY, 0, regs, 0, this.regAY.length);
        state.setRegAY(regs);
        return state;
    }

    public void setAY8912State(AY8912State state) {
        int[] ay = state.getRegAY();
        for (int reg = 0; reg < 16; ++reg) {
            this.addressLatch = reg;
            this.writeRegister(ay[reg]);
        }
        this.addressLatch = state.getAddressLatch();
    }

    public void setSpectrumModel(MachineTypes model) {
        if (this.spectrumModel != model) {
            this.spectrumModel = model;
            this.reset();
        }
        if (this.samplesPerFrame != 0) {
            double tmp = (double)this.spectrumModel.tstatesFrame / (double)this.samplesPerFrame;
            this.step = (long)(tmp * 100000.0);
            this.stepRate = tmp / 16.0;
        }
    }

    public void setMaxAmplitude(int amplitude) {
        this.maxAmplitude = amplitude;
        for (int idx = 0; idx < this.volumeLevel.length; ++idx) {
            this.volumeLevel[idx] = (int)((double)this.maxAmplitude * volumeRate[idx]);
        }
    }

    public void setAudioFreq(int freq) {
        this.FREQ = freq;
        this.samplesPerFrame = this.FREQ / 50;
        double tmp = (double)this.spectrumModel.tstatesFrame / (double)this.samplesPerFrame;
        this.step = (long)(tmp * 100000.0);
        this.stepRate = tmp / 16.0;
    }

    public int getAddressLatch() {
        return this.addressLatch;
    }

    public void setAddressLatch(int value) {
        this.addressLatch = value & 0xF;
    }

    public int readRegister() {
        if (this.addressLatch >= 14 && (this.regAY[7] >> this.addressLatch - 8 & 1) == 0) {
            return 255;
        }
        return this.regAY[this.addressLatch];
    }

    public void writeRegister(int value) {
        switch (this.addressLatch) {
            case 0: 
            case 1: {
                this.regAY[this.addressLatch] = value & (this.addressLatch == 0 ? 255 : 15);
                this.periodA = this.regAY[1] << 8 | this.regAY[0];
                break;
            }
            case 2: 
            case 3: {
                this.regAY[this.addressLatch] = value & (this.addressLatch == 2 ? 255 : 15);
                this.periodB = this.regAY[3] << 8 | this.regAY[2];
                break;
            }
            case 4: 
            case 5: {
                this.regAY[this.addressLatch] = value & (this.addressLatch == 4 ? 255 : 15);
                this.periodC = this.regAY[5] << 8 | this.regAY[4];
                break;
            }
            case 6: {
                this.regAY[6] = value & 0x1F;
                break;
            }
            case 7: {
                this.regAY[7] = value & 0xFF;
                this.disableToneA = (value & 1) != 0;
                this.disableToneB = (value & 2) != 0;
                this.disableToneC = (value & 4) != 0;
                this.disableNoiseA = (value & 8) != 0;
                this.disableNoiseB = (value & 0x10) != 0;
                this.disableNoiseC = (value & 0x20) != 0;
                break;
            }
            case 8: {
                this.regAY[8] = value & 0x1F;
                boolean bl = this.envA = (value & 0x10) != 0;
                if (this.envA) {
                    this.amplitudeA = this.volumeLevel[this.amplitudeEnv];
                    break;
                }
                this.amplitudeA = this.volumeLevel[value & 0xF];
                break;
            }
            case 9: {
                this.regAY[9] = value & 0x1F;
                boolean bl = this.envB = (value & 0x10) != 0;
                if (this.envB) {
                    this.amplitudeB = this.volumeLevel[this.amplitudeEnv];
                    break;
                }
                this.amplitudeB = this.volumeLevel[value & 0xF];
                break;
            }
            case 10: {
                this.regAY[10] = value & 0x1F;
                boolean bl = this.envC = (value & 0x10) != 0;
                if (this.envC) {
                    this.amplitudeC = this.volumeLevel[this.amplitudeEnv];
                    break;
                }
                this.amplitudeC = this.volumeLevel[value & 0xF];
                break;
            }
            case 11: 
            case 12: {
                this.regAY[this.addressLatch] = value & 0xFF;
                this.envelopePeriod = this.regAY[12] << 8 | this.regAY[11];
                if (this.envelopePeriod == 0) {
                    this.envelopePeriod = 2;
                    break;
                }
                this.envelopePeriod <<= 1;
                break;
            }
            case 13: {
                this.regAY[13] = value & 0xF;
                this.Hold = (value & 1) != 0;
                this.Alternate = (value & 2) != 0;
                this.Attack = (value & 4) != 0;
                this.amplitudeEnv = this.Attack ? 0 : 15;
                this.Continue = true;
                this.envelopeCounter = 0;
                if (this.envA) {
                    this.amplitudeA = this.volumeLevel[this.amplitudeEnv];
                }
                if (this.envB) {
                    this.amplitudeB = this.volumeLevel[this.amplitudeEnv];
                }
                if (!this.envC) break;
                this.amplitudeC = this.volumeLevel[this.amplitudeEnv];
                break;
            }
            case 14: 
            case 15: {
                this.regAY[this.addressLatch] = value & 0xFF;
            }
        }
    }

    public void updateAY(int tstates) {
        while (this.audiotstates < tstates) {
            this.audiotstates += 16;
            if (++this.counterA >= this.periodA) {
                this.toneA = !this.toneA;
                this.counterA = 0;
            }
            if (++this.counterB >= this.periodB) {
                this.toneB = !this.toneB;
                this.counterB = 0;
            }
            if (++this.counterC >= this.periodC) {
                this.toneC = !this.toneC;
                this.counterC = 0;
            }
            if (++this.counterN >= this.periodN) {
                this.counterN = 0;
                this.periodN = this.regAY[6];
                if (this.periodN == 0) {
                    this.periodN = 1;
                }
                this.periodN <<= 1;
                if ((this.rng + 1 & 2) != 0) {
                    boolean bl = this.toneN = !this.toneN;
                }
                if ((this.rng & 1) != 0) {
                    this.rng ^= 0x24000;
                }
                this.rng >>>= 1;
            }
            if (this.Continue && ++this.envelopeCounter >= this.envelopePeriod) {
                this.envelopeCounter = 0;
                this.amplitudeEnv = this.Attack ? ++this.amplitudeEnv : --this.amplitudeEnv;
                if ((this.amplitudeEnv & 0x10) != 0) {
                    if ((this.regAY[13] & 8) == 0) {
                        this.amplitudeEnv = 0;
                        this.Continue = false;
                    } else {
                        if (this.Alternate) {
                            boolean bl = this.Attack = !this.Attack;
                        }
                        if (this.Hold) {
                            this.amplitudeEnv = this.Attack ? 15 : 0;
                            this.Continue = false;
                        } else {
                            int n = this.amplitudeEnv = this.Attack ? 0 : 15;
                        }
                    }
                }
                if (this.envA) {
                    this.amplitudeA = this.volumeLevel[this.amplitudeEnv];
                }
                if (this.envB) {
                    this.amplitudeB = this.volumeLevel[this.amplitudeEnv];
                }
                if (this.envC) {
                    this.amplitudeC = this.volumeLevel[this.amplitudeEnv];
                }
            }
            long diff = this.step - this.stepCounter;
            this.stepCounter += 1600000L;
            if (diff > 1600000L) {
                if ((this.toneA || this.disableToneA) && (this.toneN || this.disableNoiseA)) {
                    this.volumeA += this.amplitudeA;
                }
                if ((this.toneB || this.disableToneB) && (this.toneN || this.disableNoiseB)) {
                    this.volumeB += this.amplitudeB;
                }
                if (!this.toneC && !this.disableToneC || !this.toneN && !this.disableNoiseC) continue;
                this.volumeC += this.amplitudeC;
                continue;
            }
            double percent = (double)diff / 1600000.0;
            int lastA = 0;
            int lastB = 0;
            int lastC = 0;
            if ((this.toneA || this.disableToneA) && (this.toneN || this.disableNoiseA)) {
                lastA = (int)((double)this.amplitudeA * percent);
            }
            if ((this.toneB || this.disableToneB) && (this.toneN || this.disableNoiseB)) {
                lastB = (int)((double)this.amplitudeB * percent);
            }
            if ((this.toneC || this.disableToneC) && (this.toneN || this.disableNoiseC)) {
                lastC = (int)((double)this.amplitudeC * percent);
            }
            this.stepCounter -= this.step;
            this.bufA[this.pbuf] = (int)((double)(this.volumeA + lastA) / this.stepRate);
            this.bufB[this.pbuf] = (int)((double)(this.volumeB + lastB) / this.stepRate);
            this.bufC[this.pbuf] = (int)((double)(this.volumeC + lastC) / this.stepRate);
            ++this.pbuf;
            this.volumeA = lastA > 0 ? this.amplitudeA - lastA : 0;
            this.volumeB = lastB > 0 ? this.amplitudeB - lastB : 0;
            this.volumeC = lastC > 0 ? this.amplitudeC - lastC : 0;
        }
    }

    public void endFrame() {
        this.pbuf = 0;
        this.audiotstates -= this.spectrumModel.tstatesFrame;
    }

    public void reset() {
        this.periodN = 1;
        this.periodC = 1;
        this.periodB = 1;
        this.periodA = 1;
        this.counterN = 0;
        this.counterC = 0;
        this.counterB = 0;
        this.counterA = 0;
        this.amplitudeEnv = 0;
        this.amplitudeC = 0;
        this.amplitudeB = 0;
        this.amplitudeA = 0;
        this.volumeC = 0;
        this.volumeB = 0;
        this.volumeA = 0;
        this.envelopePeriod = 0;
        this.addressLatch = 0;
        this.toneN = false;
        this.toneC = false;
        this.toneB = false;
        this.toneA = false;
        this.rng = 1;
        Arrays.fill(this.regAY, 0);
        this.regAY[7] = 255;
        this.Attack = false;
        this.Continue = false;
        this.startPlay();
    }

    public void startPlay() {
        this.pbuf = 0;
        this.audiotstates = 0;
        this.stepCounter = 0L;
        if (this.bufA != null) {
            Arrays.fill(this.bufA, 0);
        }
        if (this.bufB != null) {
            Arrays.fill(this.bufB, 0);
        }
        if (this.bufC != null) {
            Arrays.fill(this.bufC, 0);
        }
    }

    public void setBufferChannels(int[] bChanA, int[] bChanB, int[] bChanC) {
        this.bufA = bChanA;
        this.bufB = bChanB;
        this.bufC = bChanC;
    }

    public int getSampleCount() {
        return this.pbuf;
    }
}

