/*
 * Decompiled with CFR 0.152.
 */
package joystickinput;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import joystickinput.JoystickRawListener;

public class JoystickRaw
implements Runnable {
    private static boolean helperLoaded;
    private static final int EVENT_BUFFER = 64;
    private static final int STRUCT_EVENT_SIZE = 8;
    private static final int JOYSTICK_BUFFER_SIZE = 512;
    private byte[] eventBuffer = new byte[512];
    private static final int TIMESTAMP_OFFSET = 0;
    private static final int VALUE_OFFSET = 4;
    private static final int TYPE_OFFSET = 6;
    private static final int NUMBER_OFFSET = 7;
    private static final int JS_EVENT_BUTTON = 1;
    private static final int JS_EVENT_AXIS = 2;
    private static final int JS_EVENT_INIT = 128;
    private static final int JS_EVENT_INIT_BUTTON = 129;
    private static final int JS_EVENT_INIT_AXIS = 130;
    private static final int MAX_BUTTONS = 32;
    private static final int MAX_AXIS = 32;
    private final boolean[] buttonState = new boolean[32];
    private final int[] buttonMasks = new int[32];
    private final short[] axisValue = new short[32];
    private int numButtons;
    private int numAxis;
    private int buttonMask;
    private int joystickId;
    private String joystickName;
    private boolean run;
    private final ArrayList<JoystickRawListener> buttonListeners;
    private final ArrayList<JoystickRawListener> axisListeners;
    private String deviceName;

    public JoystickRaw(int id) throws FileNotFoundException, IOException {
        this.deviceName = "/dev/input/js" + id;
        this.joystickId = id;
        this.buttonListeners = new ArrayList();
        this.axisListeners = new ArrayList();
        for (int idx = 0; idx < this.buttonState.length; ++idx) {
            this.buttonMasks[idx] = 1 << idx;
        }
        if (helperLoaded) {
            this.numButtons = this.getNumButtonsHelper(id);
            this.numAxis = this.getNumAxisHelper(id);
            this.joystickName = this.toStringHelper(id);
            System.out.println(String.format("From JNI: buttons %d, axis %d", this.numButtons, this.numAxis));
            System.out.println(String.format("From JNI: joystick name: %s", this.joystickName));
        }
        if (!helperLoaded || this.numButtons == -1) {
            this.joystickName = "Linux Joystick Driver";
            this.numAxis = 0;
            this.numButtons = 0;
            int count = 0;
            try (DataInputStream deviceData = new DataInputStream(new FileInputStream(this.deviceName));){
                count = deviceData.read(this.eventBuffer);
                if (count == -1) {
                    return;
                }
            }
            catch (IOException ex) {
                throw new FileNotFoundException(String.format("Joystick device %s not found", this.deviceName));
            }
            block19: for (int idx = 0; idx < count; idx += 8) {
                int type = this.eventBuffer[idx + 6] & 0xFF;
                switch (type) {
                    case 1: 
                    case 2: {
                        continue block19;
                    }
                    case 129: {
                        ++this.numButtons;
                        continue block19;
                    }
                    case 130: {
                        ++this.numAxis;
                        continue block19;
                    }
                    default: {
                        System.out.println("Unknown event received!");
                    }
                }
            }
        }
        if (this.numButtons > 32) {
            this.numButtons = 32;
        }
        if (this.numAxis > 32) {
            this.numAxis = 32;
        }
    }

    public void addButtonListener(JoystickRawListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.buttonListeners.contains(listener)) {
            this.buttonListeners.add(listener);
        }
    }

    public void removeButtonListener(JoystickRawListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.buttonListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    public void addAxisListener(JoystickRawListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.axisListeners.contains(listener)) {
            this.axisListeners.add(listener);
        }
    }

    public void removeAxisListener(JoystickRawListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (!this.axisListeners.remove(listener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block27: {
            try {
                deviceData = new DataInputStream(new FileInputStream(this.deviceName));
                var2_3 = null;
                ** try [egrp 1[TRYBLOCK] [5, 6 : 21->419)] { 
lbl5:
                // 1 sources

                break block27;
lbl6:
                // 1 sources

                catch (Throwable var3_6) {
                    var2_3 = var3_6;
                    throw var3_6;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JoystickRaw.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        block19: while (true) {
            if (this.run == false) return;
            count = deviceData.read(this.eventBuffer);
            if (count == -1) {
                return;
            }
            idx = 0;
            while (true) {
                if (idx >= count) continue block19;
                type = this.eventBuffer[idx + 6] & 255;
                number = this.eventBuffer[idx + 7] & 255;
                switch (type) {
                    case 1: 
                    case 129: {
                        state = this.eventBuffer[idx + 4] != 0;
                        var8_11 = this.buttonState;
                        // MONITORENTER : this.buttonState
                        this.buttonState[number] = state;
                        this.buttonMask = state ? (this.buttonMask |= this.buttonMasks[number]) : (this.buttonMask &= ~this.buttonMasks[number]);
                        // MONITOREXIT : var8_11
                        if (type != 1) break;
                        var8_11 = this.buttonListeners.iterator();
                        while (var8_11.hasNext()) {
                            listener = (JoystickRawListener)var8_11.next();
                            listener.buttonEvent(this.joystickId, number, state);
                        }
                        break;
                    }
                    case 2: 
                    case 130: {
                        value = (short)(this.eventBuffer[idx + 4 + 1] << 8 | this.eventBuffer[idx + 4] & 255);
                        var9_13 = this.axisValue;
                        // MONITORENTER : this.axisValue
                        this.axisValue[number] = value;
                        // MONITOREXIT : var9_13
                        if (type != 2) break;
                        var9_13 = this.axisListeners.iterator();
                        while (var9_13.hasNext()) {
                            listener = (JoystickRawListener)var9_13.next();
                            listener.axisEvent(this.joystickId, number, value);
                        }
                        break;
                    }
                    default: {
                        System.out.println("Unknown event received!");
                    }
                }
                idx += 8;
            }
            break;
        }
lbl55:
        // 1 sources

        finally {
            if (deviceData != null) {
                if (var2_3 != null) {
                    try {
                        deviceData.close();
                    }
                    catch (Throwable var3_5) {
                        var2_3.addSuppressed(var3_5);
                    }
                } else {
                    deviceData.close();
                }
            }
        }
    }

    public void start() {
        if (this.run) {
            return;
        }
        this.run = true;
        new Thread((Runnable)this, "JoystickThread " + this.deviceName).start();
    }

    public void stop() {
        this.run = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getButtonMask() {
        boolean[] blArray = this.buttonState;
        synchronized (this.buttonState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.buttonMask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getButtonState(int index) {
        if (index < 0 || index >= this.numButtons) {
            throw new IndexOutOfBoundsException("Button out of range");
        }
        boolean[] blArray = this.buttonState;
        synchronized (this.buttonState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.buttonState[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getAxisValue(int index) {
        if (index < 0 || index >= this.numAxis) {
            throw new IndexOutOfBoundsException("Axis out of range");
        }
        short[] sArray = this.axisValue;
        synchronized (this.axisValue) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.axisValue[index];
        }
    }

    private native int getNumButtonsHelper(int var1);

    public int getNumButtons() {
        return this.numButtons;
    }

    private native int getNumAxisHelper(int var1);

    public int getNumAxis() {
        return this.numAxis;
    }

    private native String toStringHelper(int var1);

    public String toString() {
        return this.joystickName;
    }

    public int getJoystickId() {
        return this.joystickId;
    }

    static {
        try {
            if (System.getProperty("os.arch").contains("amd64")) {
                System.loadLibrary("JoystickHelper-64");
            } else {
                System.loadLibrary("JoystickHelper-32");
            }
            helperLoaded = true;
        }
        catch (UnsatisfiedLinkError ex) {
            helperLoaded = false;
        }
    }
}

