/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuration.JSpeccySettingsType;
import configuration.ObjectFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBElement;

public class SettingsDialog
extends JPanel {
    private JSpeccySettingsType settings;
    private JDialog settingsDialog;
    private JPanel AY8912Panel;
    private JRadioButton AYABCMode;
    private JRadioButton AYACBMode;
    private JRadioButton AYBACMode;
    private JPanel AYEnabled48k;
    private JRadioButton AYMonoMode;
    private JPanel AYStereoMode;
    private ButtonGroup AYStereoModeButtonGroup;
    private JPanel IF1PanelTab;
    private JCheckBox ULAplus;
    private JCheckBox acceleratedLoad;
    private JPanel audioPanel;
    private JCheckBox autoLoadTape;
    private JCheckBox autoSaveOnExit;
    private JPanel autoSavePanel;
    private JCheckBox autosaveConfigOnExit;
    private JPanel buttonPanel;
    private JSpinner cartridgeSizeSpinner;
    private JButton closeButton;
    private JCheckBox confirmActions;
    private JCheckBox connectedIF1;
    private JLabel connectedIF1InfoLabel;
    private JPanel connectedIF1Panel;
    private JPanel defaultModelPanel;
    private JPanel emulatorPanelTab;
    private JCheckBox enableLoadTraps;
    private JCheckBox enableSaveTraps;
    private JCheckBox enabledAY48k;
    private JCheckBox flashLoad;
    private JPanel hardwarePanelTab;
    private JCheckBox hifiSound;
    private JRadioButton highSampling;
    private JPanel highSpeedPanel;
    private JCheckBox invertedEar;
    private JRadioButton issue2;
    private JRadioButton issue3;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTabbedPane jTabbedPane1;
    private JComboBox joystick;
    private JPanel joystickPanel;
    private JPanel keyboard48kPanel;
    private ButtonGroup keyboardButtonGroup;
    private JLabel keyboardIssueInfoLabel;
    private JPanel keyboardPanelTab;
    private JCheckBox lecEnabled;
    private JPanel lecEnabledPanel;
    private JLabel lecInfoLabel;
    private JPanel lecInfoPanel;
    private JPanel lecPanelTab;
    private JPanel loadPanel;
    private JCheckBox loadingNoise;
    private JRadioButton lowSampling;
    private JPanel mapPCKeyPanel;
    private JCheckBox mapPCKeys;
    private JPanel mdrPanel;
    private JRadioButton multiface128RadioButton;
    private JCheckBox multifaceEnabled;
    private ButtonGroup multifaceModelButtonGroup;
    private JPanel multifaceModelPanel;
    private JRadioButton multifaceOneRadioButton;
    private JPanel multifacePanel;
    private JPanel multifacePanelTab;
    private JLabel numBlocksInfoLabel;
    private JPanel numBlocksInfoPanel;
    private JPanel numBlocksPanel;
    private JLabel numDrivesLabel;
    private JPanel numDrivesPanel;
    private JSpinner numDrivesSpinner;
    private JLabel numSectorsLabel;
    private ButtonGroup samplingButtonGroup;
    private JPanel samplingPanel;
    private JPanel savePanel;
    private JButton saveSettingsButton;
    private JCheckBox soundMuted;
    private JPanel soundPanelTab;
    private JComboBox spectrumModel;
    private JSlider speed;
    private JPanel tapePanelTab;
    private JPanel videoPanel;
    private JCheckBox zoomCheckbox;
    private JLabel zoomLabel;
    private JPanel zoomPanel;
    private JSlider zoomSlider;

    public SettingsDialog(JSpeccySettingsType userSettings) {
        this.initComponents();
        this.settings = userSettings;
    }

    private void updateUserSettings() {
        this.spectrumModel.setSelectedIndex(this.settings.getSpectrumSettings().getDefaultModel());
        this.soundMuted.setSelected(this.settings.getSpectrumSettings().isMutedSound());
        this.loadingNoise.setSelected(this.settings.getSpectrumSettings().isLoadingNoise());
        this.hifiSound.setSelected(this.settings.getSpectrumSettings().isHifiSound());
        this.enableLoadTraps.setSelected(this.settings.getTapeSettings().isEnableLoadTraps());
        this.acceleratedLoad.setSelected(this.settings.getTapeSettings().isAccelerateLoading());
        this.flashLoad.setSelected(this.settings.getTapeSettings().isFlashLoad());
        this.flashLoad.setEnabled(this.settings.getTapeSettings().isEnableLoadTraps());
        this.autoLoadTape.setSelected(this.settings.getTapeSettings().isAutoLoadTape());
        this.ULAplus.setSelected(this.settings.getSpectrumSettings().isULAplus());
        this.joystick.setSelectedIndex(this.settings.getKeyboardJoystickSettings().getJoystickModel());
        this.enabledAY48k.setSelected(this.settings.getSpectrumSettings().isAYEnabled48K());
        this.speed.setValue(this.settings.getSpectrumSettings().getFramesInt());
        this.zoomCheckbox.setSelected(this.settings.getSpectrumSettings().isZoomed());
        this.zoomSlider.setValue(this.settings.getSpectrumSettings().getZoom());
        if (this.settings.getKeyboardJoystickSettings().isIssue2()) {
            this.issue2.setSelected(true);
        } else {
            this.issue3.setSelected(true);
        }
        this.mapPCKeys.setSelected(this.settings.getKeyboardJoystickSettings().isMapPCKeys());
        this.enableSaveTraps.setSelected(this.settings.getTapeSettings().isEnableSaveTraps());
        if (this.settings.getTapeSettings().isHighSamplingFreq()) {
            this.highSampling.setSelected(true);
        } else {
            this.lowSampling.setSelected(true);
        }
        switch (this.settings.getAY8912Settings().getSoundMode()) {
            case 1: {
                this.AYABCMode.setSelected(true);
                break;
            }
            case 2: {
                this.AYACBMode.setSelected(true);
                break;
            }
            case 3: {
                this.AYBACMode.setSelected(true);
                break;
            }
            default: {
                this.AYMonoMode.setSelected(true);
            }
        }
        this.multifaceEnabled.setSelected(this.settings.getSpectrumSettings().isMultifaceEnabled());
        if (this.settings.getSpectrumSettings().isMf128On48K()) {
            this.multiface128RadioButton.setSelected(true);
        } else {
            this.multifaceOneRadioButton.setSelected(true);
        }
        this.connectedIF1.setSelected(this.settings.getInterface1Settings().isConnectedIF1());
        this.numDrivesSpinner.setValue(this.settings.getInterface1Settings().getMicrodriveUnits());
        this.cartridgeSizeSpinner.setValue(this.settings.getInterface1Settings().getCartridgeSize());
        this.autoSaveOnExit.setSelected(this.settings.getSpectrumSettings().isHibernateMode());
        this.lecEnabled.setSelected(this.settings.getSpectrumSettings().isLecEnabled());
        this.confirmActions.setSelected(this.settings.getEmulatorSettings().isConfirmActions());
        this.autosaveConfigOnExit.setSelected(this.settings.getEmulatorSettings().isAutosaveConfigOnExit());
        this.invertedEar.setSelected(this.settings.getTapeSettings().isInvertedEar());
    }

    public boolean showDialog(Component parent, String title) {
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.settingsDialog == null) {
            this.settingsDialog = new JDialog(owner, true);
            this.settingsDialog.getContentPane().add(this);
            this.settingsDialog.pack();
        }
        this.updateUserSettings();
        this.settingsDialog.setTitle(title);
        this.settingsDialog.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.keyboardButtonGroup = new ButtonGroup();
        this.samplingButtonGroup = new ButtonGroup();
        this.AYStereoModeButtonGroup = new ButtonGroup();
        this.multifaceModelButtonGroup = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.saveSettingsButton = new JButton();
        this.closeButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.hardwarePanelTab = new JPanel();
        this.defaultModelPanel = new JPanel();
        this.spectrumModel = new JComboBox();
        this.videoPanel = new JPanel();
        this.ULAplus = new JCheckBox();
        this.zoomPanel = new JPanel();
        this.zoomCheckbox = new JCheckBox();
        this.zoomLabel = new JLabel();
        this.zoomSlider = new JSlider();
        this.highSpeedPanel = new JPanel();
        this.speed = new JSlider();
        this.autoSavePanel = new JPanel();
        this.autoSaveOnExit = new JCheckBox();
        this.soundPanelTab = new JPanel();
        this.audioPanel = new JPanel();
        this.soundMuted = new JCheckBox();
        this.loadingNoise = new JCheckBox();
        this.hifiSound = new JCheckBox();
        this.AY8912Panel = new JPanel();
        this.AYEnabled48k = new JPanel();
        this.enabledAY48k = new JCheckBox();
        this.AYStereoMode = new JPanel();
        this.AYMonoMode = new JRadioButton();
        this.AYABCMode = new JRadioButton();
        this.AYACBMode = new JRadioButton();
        this.AYBACMode = new JRadioButton();
        this.tapePanelTab = new JPanel();
        this.loadPanel = new JPanel();
        this.enableLoadTraps = new JCheckBox();
        this.flashLoad = new JCheckBox();
        this.acceleratedLoad = new JCheckBox();
        this.autoLoadTape = new JCheckBox();
        this.invertedEar = new JCheckBox();
        this.savePanel = new JPanel();
        this.enableSaveTraps = new JCheckBox();
        this.samplingPanel = new JPanel();
        this.lowSampling = new JRadioButton();
        this.highSampling = new JRadioButton();
        this.keyboardPanelTab = new JPanel();
        this.keyboard48kPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.keyboardIssueInfoLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.issue2 = new JRadioButton();
        this.issue3 = new JRadioButton();
        this.mapPCKeyPanel = new JPanel();
        this.mapPCKeys = new JCheckBox();
        this.joystickPanel = new JPanel();
        this.joystick = new JComboBox();
        this.multifacePanelTab = new JPanel();
        this.multifacePanel = new JPanel();
        this.multifaceEnabled = new JCheckBox();
        this.multifaceModelPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.multifaceOneRadioButton = new JRadioButton();
        this.multiface128RadioButton = new JRadioButton();
        this.IF1PanelTab = new JPanel();
        this.connectedIF1Panel = new JPanel();
        this.connectedIF1InfoLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.connectedIF1 = new JCheckBox();
        this.mdrPanel = new JPanel();
        this.numDrivesPanel = new JPanel();
        this.numDrivesLabel = new JLabel();
        this.numDrivesSpinner = new JSpinner();
        this.numBlocksInfoPanel = new JPanel();
        this.numBlocksInfoLabel = new JLabel();
        this.numBlocksPanel = new JPanel();
        this.numSectorsLabel = new JLabel();
        this.cartridgeSizeSpinner = new JSpinner();
        this.lecPanelTab = new JPanel();
        this.lecInfoPanel = new JPanel();
        this.lecInfoLabel = new JLabel();
        this.lecEnabledPanel = new JPanel();
        this.lecEnabled = new JCheckBox();
        this.emulatorPanelTab = new JPanel();
        this.confirmActions = new JCheckBox();
        this.autosaveConfigOnExit = new JCheckBox();
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(440, 400));
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.saveSettingsButton.setText(bundle.getString("SettingsDialog.saveSettingsButton.text"));
        this.saveSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.saveSettingsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveSettingsButton);
        this.closeButton.setText(bundle.getString("CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.add((Component)this.buttonPanel, "Last");
        this.jTabbedPane1.setCursor(new Cursor(0));
        this.hardwarePanelTab.setLayout(new BoxLayout(this.hardwarePanelTab, 3));
        this.defaultModelPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.defaultModePanel.border.text")));
        this.spectrumModel.setModel(new DefaultComboBoxModel<String>(new String[]{"Spectrum 16k", "Spectrum 48k", "Spectrum 128k", "Spectrum +2", "Spectrum +2A", "Spectrum +3"}));
        this.spectrumModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.spectrumModelActionPerformed(evt);
            }
        });
        this.defaultModelPanel.add(this.spectrumModel);
        this.hardwarePanelTab.add(this.defaultModelPanel);
        this.videoPanel.setBorder(BorderFactory.createTitledBorder("Video"));
        this.videoPanel.setLayout(new GridLayout(2, 1));
        this.ULAplus.setText(bundle.getString("SettingsDialog.hardwarePanel.ULAplus.text"));
        this.ULAplus.setPreferredSize(new Dimension(440, 24));
        this.ULAplus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.ULAplusActionPerformed(evt);
            }
        });
        this.videoPanel.add(this.ULAplus);
        this.zoomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.zoomPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 53));
        this.zoomPanel.setPreferredSize(new Dimension(100, 53));
        this.zoomPanel.setLayout(new GridLayout(1, 3));
        this.zoomCheckbox.setText(bundle.getString("SettingsDialog.hardwarePanel.zoomCheckbox.text"));
        this.zoomCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.zoomCheckboxActionPerformed(evt);
            }
        });
        this.zoomPanel.add(this.zoomCheckbox);
        this.zoomLabel.setHorizontalAlignment(0);
        this.zoomLabel.setText(bundle.getString("SettingsDialog.hardwarePanel.zoomLabel.text"));
        this.zoomPanel.add(this.zoomLabel);
        this.zoomSlider.setMajorTickSpacing(1);
        this.zoomSlider.setMaximum(4);
        this.zoomSlider.setMinimum(2);
        this.zoomSlider.setPaintLabels(true);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.setValue(2);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsDialog.this.zoomSliderStateChanged(evt);
            }
        });
        this.zoomPanel.add(this.zoomSlider);
        this.videoPanel.add(this.zoomPanel);
        this.hardwarePanelTab.add(this.videoPanel);
        this.highSpeedPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.highSpeedPanel.border.text")));
        this.speed.setMajorTickSpacing(1);
        this.speed.setMaximum(10);
        this.speed.setMinimum(2);
        this.speed.setPaintLabels(true);
        this.speed.setPaintTicks(true);
        this.speed.setSnapToTicks(true);
        this.speed.setPreferredSize(new Dimension(300, 43));
        this.speed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsDialog.this.speedStateChanged(evt);
            }
        });
        this.highSpeedPanel.add(this.speed);
        this.hardwarePanelTab.add(this.highSpeedPanel);
        this.autoSavePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.autoSavePanel.border.text")));
        this.autoSaveOnExit.setText(bundle.getString("SettingsDialog.autoSaveOnExit.text"));
        this.autoSaveOnExit.setToolTipText(bundle.getString("SettingsDialog.autoSaveOnExit.tooltip.text"));
        this.autoSaveOnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.autoSaveOnExitActionPerformed(evt);
            }
        });
        this.autoSavePanel.add(this.autoSaveOnExit);
        this.hardwarePanelTab.add(this.autoSavePanel);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.hardwarePanel.TabTitle"), this.hardwarePanelTab);
        this.soundPanelTab.setLayout(new GridLayout(2, 0));
        this.audioPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.audioPanel.border.text")));
        this.audioPanel.setLayout(new GridLayout(3, 0));
        this.soundMuted.setText(bundle.getString("SettingsDialog.soundPanel.soundMuted.text"));
        this.soundMuted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.soundMutedActionPerformed(evt);
            }
        });
        this.audioPanel.add(this.soundMuted);
        this.loadingNoise.setText(bundle.getString("SettingsDialog.soundPanel.loadingNoise.text"));
        this.loadingNoise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.loadingNoiseActionPerformed(evt);
            }
        });
        this.audioPanel.add(this.loadingNoise);
        this.hifiSound.setText(bundle.getString("SettingsDialog.audioPanel.hifiSound.text"));
        this.hifiSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.hifiSoundActionPerformed(evt);
            }
        });
        this.audioPanel.add(this.hifiSound);
        this.soundPanelTab.add(this.audioPanel);
        this.AY8912Panel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.AY8912Panel.border.text")));
        this.AY8912Panel.setLayout(new GridLayout(1, 2));
        this.AYEnabled48k.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.AYEnabled48kPanel.border.text")));
        this.enabledAY48k.setText(bundle.getString("SettingsDialog.soundPanel.enabledAY48k.text"));
        this.enabledAY48k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.enabledAY48kActionPerformed(evt);
            }
        });
        this.AYEnabled48k.add(this.enabledAY48k);
        this.AY8912Panel.add(this.AYEnabled48k);
        this.AYStereoMode.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.AYStereoMode.border.text")));
        this.AYStereoMode.setLayout(new GridLayout(4, 0));
        this.AYStereoModeButtonGroup.add(this.AYMonoMode);
        this.AYMonoMode.setSelected(true);
        this.AYMonoMode.setText(bundle.getString("SettingsDialog.AYMonoMode.RadioButton.text"));
        this.AYMonoMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.AYMonoModeActionPerformed(evt);
            }
        });
        this.AYStereoMode.add(this.AYMonoMode);
        this.AYStereoModeButtonGroup.add(this.AYABCMode);
        this.AYABCMode.setText(bundle.getString("SettingsDialog.AYABCMode.RadioButton.text"));
        this.AYABCMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.AYABCModeActionPerformed(evt);
            }
        });
        this.AYStereoMode.add(this.AYABCMode);
        this.AYStereoModeButtonGroup.add(this.AYACBMode);
        this.AYACBMode.setText(bundle.getString("SettingsDialog.AYACBMode.RadioButton.text"));
        this.AYACBMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.AYACBModeActionPerformed(evt);
            }
        });
        this.AYStereoMode.add(this.AYACBMode);
        this.AYStereoModeButtonGroup.add(this.AYBACMode);
        this.AYBACMode.setText(bundle.getString("SettingsDialog.AYBACMode.RadioButton.text"));
        this.AYBACMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.AYBACModeActionPerformed(evt);
            }
        });
        this.AYStereoMode.add(this.AYBACMode);
        this.AY8912Panel.add(this.AYStereoMode);
        this.soundPanelTab.add(this.AY8912Panel);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.soundPanel.TabTitle"), this.soundPanelTab);
        this.tapePanelTab.setLayout(new GridLayout(2, 0));
        this.loadPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.loadPanel.border.text")));
        this.loadPanel.setLayout(new GridLayout(5, 1));
        this.enableLoadTraps.setText(bundle.getString("SettingsDialog.tapePanel.enableLoadTraps.text"));
        this.enableLoadTraps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.enableLoadTrapsActionPerformed(evt);
            }
        });
        this.loadPanel.add(this.enableLoadTraps);
        this.flashLoad.setText(bundle.getString("SettingsDialog.tapePanel.flashload.text"));
        this.flashLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.flashLoadActionPerformed(evt);
            }
        });
        this.loadPanel.add(this.flashLoad);
        this.acceleratedLoad.setText(bundle.getString("SettingsDialog.tapePanel.acceleratedLoad.text"));
        this.acceleratedLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.acceleratedLoadActionPerformed(evt);
            }
        });
        this.loadPanel.add(this.acceleratedLoad);
        this.autoLoadTape.setText(bundle.getString("SettingsDialog.tapePanel.autoLoadTape.text"));
        this.autoLoadTape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.autoLoadTapeActionPerformed(evt);
            }
        });
        this.loadPanel.add(this.autoLoadTape);
        this.invertedEar.setText(bundle.getString("SettingsDialog.tapePanel.invertedEar.text"));
        this.invertedEar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.invertedEarActionPerformed(evt);
            }
        });
        this.loadPanel.add(this.invertedEar);
        this.tapePanelTab.add(this.loadPanel);
        this.savePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.savePanel.border.text")));
        this.savePanel.setLayout(new GridLayout(1, 2));
        this.enableSaveTraps.setSelected(true);
        this.enableSaveTraps.setText(bundle.getString("SettingsDialog.savePanel.enableSaveTraps.text"));
        this.enableSaveTraps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.enableSaveTrapsActionPerformed(evt);
            }
        });
        this.savePanel.add(this.enableSaveTraps);
        this.samplingPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.highSamplingFreq.border.text")));
        this.samplingPanel.setLayout(new GridLayout(2, 1));
        this.samplingButtonGroup.add(this.lowSampling);
        this.lowSampling.setSelected(true);
        this.lowSampling.setText("DRB (44.1 kHz)");
        this.lowSampling.setToolTipText("Direct Recording Block");
        this.lowSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.lowSamplingActionPerformed(evt);
            }
        });
        this.samplingPanel.add(this.lowSampling);
        this.samplingButtonGroup.add(this.highSampling);
        this.highSampling.setText("CSW Z-RLE (48 kHz)");
        this.highSampling.setToolTipText("<html>Compressed Square Wave<br>Run Lenght Encoding</html>");
        this.highSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.highSamplingActionPerformed(evt);
            }
        });
        this.samplingPanel.add(this.highSampling);
        this.savePanel.add(this.samplingPanel);
        this.tapePanelTab.add(this.savePanel);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.tapePanel.TabTitle"), this.tapePanelTab);
        this.keyboardPanelTab.setLayout(new BoxLayout(this.keyboardPanelTab, 3));
        this.keyboard48kPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.keyboard48kPanel.title.text")));
        this.keyboard48kPanel.setLayout(new BoxLayout(this.keyboard48kPanel, 3));
        this.keyboardIssueInfoLabel.setHorizontalAlignment(0);
        this.keyboardIssueInfoLabel.setText(bundle.getString("SettingsDialog.keyboardIssueInfoLabel.text"));
        this.jPanel3.add(this.keyboardIssueInfoLabel);
        this.keyboard48kPanel.add(this.jPanel3);
        this.keyboardButtonGroup.add(this.issue2);
        this.issue2.setText(bundle.getString("SettingsDialog.issue2RadioButton.text"));
        this.issue2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.issue2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.issue2);
        this.keyboardButtonGroup.add(this.issue3);
        this.issue3.setSelected(true);
        this.issue3.setText(bundle.getString("SettingsDialog.issue3RadioButton.text"));
        this.issue3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.issue2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.issue3);
        this.keyboard48kPanel.add(this.jPanel2);
        this.keyboardPanelTab.add(this.keyboard48kPanel);
        this.mapPCKeyPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.mapPCKeysPanel.TabTitle")));
        this.mapPCKeys.setText(bundle.getString("SettingsDialog.mapPCKEysPanel.enabled.text"));
        this.mapPCKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.mapPCKeysActionPerformed(evt);
            }
        });
        this.mapPCKeyPanel.add(this.mapPCKeys);
        this.keyboardPanelTab.add(this.mapPCKeyPanel);
        this.joystickPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.joystickPanel.border.text")));
        this.joystick.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Kempston", "Sinclair 1", "Sinclair 2", "Cursor/AGF/Protek", "Fuller"}));
        this.joystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.joystickActionPerformed(evt);
            }
        });
        this.joystickPanel.add(this.joystick);
        this.keyboardPanelTab.add(this.joystickPanel);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.keyboardPanel.TabTitle"), this.keyboardPanelTab);
        this.multifacePanelTab.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.MultifacePanel.border.text")));
        this.multifacePanelTab.setLayout(new BoxLayout(this.multifacePanelTab, 3));
        this.multifaceEnabled.setText(bundle.getString("SettingsDialog.multifacePanel.enabled.text"));
        this.multifaceEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.multifaceEnabledActionPerformed(evt);
            }
        });
        this.multifacePanel.add(this.multifaceEnabled);
        this.multifacePanelTab.add(this.multifacePanel);
        this.multifaceModelPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.MultifaceModelPanel.border.text")));
        this.multifaceModelPanel.setLayout(new GridLayout(2, 0));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(bundle.getString("SettingsDialog.MultifaceModelPanel.label.text"));
        this.multifaceModelPanel.add(this.jLabel2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.MultifaceModelPanelRadioButton.border.text")));
        this.jPanel1.setLayout(new GridLayout(2, 0));
        this.multifaceModelButtonGroup.add(this.multifaceOneRadioButton);
        this.multifaceOneRadioButton.setSelected(true);
        this.multifaceOneRadioButton.setText(bundle.getString("SettingsDialog.multifaceOne.RadioButton.text"));
        this.multifaceOneRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.multifaceOneRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.multifaceOneRadioButton);
        this.multifaceModelButtonGroup.add(this.multiface128RadioButton);
        this.multiface128RadioButton.setText(bundle.getString("SettingsDialog.multiface128.RadioButton.text"));
        this.multiface128RadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.multifaceOneRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.multiface128RadioButton);
        this.multifaceModelPanel.add(this.jPanel1);
        this.multifacePanelTab.add(this.multifaceModelPanel);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.multifacePanel.TabTitle"), this.multifacePanelTab);
        this.IF1PanelTab.setLayout(new GridLayout(2, 1));
        this.connectedIF1Panel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.connectedIF1.border.text")));
        this.connectedIF1Panel.setLayout(new GridLayout(2, 0));
        this.connectedIF1InfoLabel.setHorizontalAlignment(0);
        this.connectedIF1InfoLabel.setText(bundle.getString("SettingsDialog.connectedIF1InfoLabel.text"));
        this.connectedIF1Panel.add(this.connectedIF1InfoLabel);
        this.connectedIF1.setText(bundle.getString("SettingsDialog.connectedIF1Panel.enabled.text"));
        this.connectedIF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.connectedIF1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.connectedIF1);
        this.connectedIF1Panel.add(this.jPanel4);
        this.IF1PanelTab.add(this.connectedIF1Panel);
        this.mdrPanel.setBorder(BorderFactory.createTitledBorder("ZX Microdrives"));
        this.mdrPanel.setLayout(new GridLayout(3, 1));
        this.numDrivesLabel.setText(bundle.getString("SettingsDialog.mdrPanel.numDrivesLabel.text"));
        this.numDrivesPanel.add(this.numDrivesLabel);
        this.numDrivesSpinner.setModel(new SpinnerNumberModel((Number)8, Byte.valueOf((byte)1), Byte.valueOf((byte)8), (Number)1));
        this.numDrivesSpinner.setPreferredSize(new Dimension(40, 20));
        this.numDrivesSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsDialog.this.numDrivesSpinnerStateChanged(evt);
            }
        });
        this.numDrivesPanel.add(this.numDrivesSpinner);
        this.mdrPanel.add(this.numDrivesPanel);
        this.numBlocksInfoLabel.setText(bundle.getString("SettingsDialog.numBlocksInfoLabel.text"));
        this.numBlocksInfoPanel.add(this.numBlocksInfoLabel);
        this.mdrPanel.add(this.numBlocksInfoPanel);
        this.numSectorsLabel.setText(bundle.getString("SettingsDialog.mdrPanel.numSectorsLabel.text"));
        this.numBlocksPanel.add(this.numSectorsLabel);
        this.cartridgeSizeSpinner.setModel(new SpinnerNumberModel(180, 10, 253, 1));
        this.cartridgeSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsDialog.this.cartridgeSizeSpinnerStateChanged(evt);
            }
        });
        this.numBlocksPanel.add(this.cartridgeSizeSpinner);
        this.mdrPanel.add(this.numBlocksPanel);
        this.IF1PanelTab.add(this.mdrPanel);
        this.jTabbedPane1.addTab("Interface I", this.IF1PanelTab);
        this.lecPanelTab.setLayout(new BoxLayout(this.lecPanelTab, 3));
        this.lecInfoPanel.setMaximumSize(new Dimension(400, 640));
        this.lecInfoPanel.setPreferredSize(new Dimension(400, 100));
        this.lecInfoPanel.setLayout(new BoxLayout(this.lecInfoPanel, 2));
        this.lecInfoLabel.setText(bundle.getString("SettingsDialog.lecPanelTab.lecInfoLabel.text"));
        this.lecInfoLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 640));
        this.lecInfoLabel.setPreferredSize(new Dimension(380, 288));
        this.lecInfoPanel.add(this.lecInfoLabel);
        this.lecPanelTab.add(this.lecInfoPanel);
        this.lecEnabledPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 160));
        this.lecEnabled.setText(bundle.getString("SettingsDialog.lecPanelTab.lecEnabledLabel.text"));
        this.lecEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.lecEnabledActionPerformed(evt);
            }
        });
        this.lecEnabledPanel.add(this.lecEnabled);
        this.lecPanelTab.add(this.lecEnabledPanel);
        this.jTabbedPane1.addTab("LEC", this.lecPanelTab);
        this.emulatorPanelTab.setBorder(BorderFactory.createTitledBorder(bundle.getString("SettingsDialog.emulatorTab.border.text")));
        this.emulatorPanelTab.setLayout(new GridLayout(9, 0));
        this.confirmActions.setText(bundle.getString("SettingsDialog.confirmActions.text"));
        this.confirmActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.confirmActionsActionPerformed(evt);
            }
        });
        this.emulatorPanelTab.add(this.confirmActions);
        this.autosaveConfigOnExit.setText(bundle.getString("SettingsDialog.autosaveConfigOnExit.text"));
        this.autosaveConfigOnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.autosaveConfigOnExitActionPerformed(evt);
            }
        });
        this.emulatorPanelTab.add(this.autosaveConfigOnExit);
        this.jTabbedPane1.addTab(bundle.getString("SettingsDialog.emulatorPanel.title.text"), this.emulatorPanelTab);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.settingsDialog.setVisible(false);
    }

    private void spectrumModelActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setDefaultModel(this.spectrumModel.getSelectedIndex());
    }

    private void ULAplusActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setULAplus(this.ULAplus.isSelected());
    }

    private void speedStateChanged(ChangeEvent evt) {
        this.settings.getSpectrumSettings().setFramesInt(this.speed.getValue());
    }

    private void issue2ActionPerformed(ActionEvent evt) {
        this.settings.getKeyboardJoystickSettings().setIssue2(this.issue2.isSelected());
    }

    private void joystickActionPerformed(ActionEvent evt) {
        this.settings.getKeyboardJoystickSettings().setJoystickModel(this.joystick.getSelectedIndex());
    }

    private void saveSettingsButtonActionPerformed(ActionEvent evt) {
        ResourceBundle bundle;
        int ret;
        if (this.settings.getEmulatorSettings().isConfirmActions() && (ret = JOptionPane.showConfirmDialog(this, (bundle = ResourceBundle.getBundle("gui/Bundle")).getString("ARE_YOU_SURE_QUESTION"), bundle.getString("SAVE_SETTINGS_QUESTION"), 0, 3)) == 1) {
            return;
        }
        try {
            BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
            JAXBElement<JSpeccySettingsType> confElement = new ObjectFactory().createJSpeccySettings(this.settings);
            JAXB.marshal(confElement, (OutputStream)fOut);
            try {
                fOut.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void soundMutedActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setMutedSound(this.soundMuted.isSelected());
    }

    private void loadingNoiseActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setLoadingNoise(this.loadingNoise.isSelected());
    }

    private void enabledAY48kActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setAYEnabled48K(this.enabledAY48k.isSelected());
    }

    private void enableLoadTrapsActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setEnableLoadTraps(this.enableLoadTraps.isSelected());
        this.flashLoad.setEnabled(this.settings.getTapeSettings().isEnableLoadTraps());
    }

    private void acceleratedLoadActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setAccelerateLoading(this.acceleratedLoad.isSelected());
    }

    private void enableSaveTrapsActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setEnableSaveTraps(this.enableSaveTraps.isSelected());
    }

    private void lowSamplingActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setHighSamplingFreq(false);
    }

    private void highSamplingActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setHighSamplingFreq(true);
    }

    private void AYMonoModeActionPerformed(ActionEvent evt) {
        this.settings.getAY8912Settings().setSoundMode(0);
    }

    private void AYABCModeActionPerformed(ActionEvent evt) {
        this.settings.getAY8912Settings().setSoundMode(1);
    }

    private void AYACBModeActionPerformed(ActionEvent evt) {
        this.settings.getAY8912Settings().setSoundMode(2);
    }

    private void AYBACModeActionPerformed(ActionEvent evt) {
        this.settings.getAY8912Settings().setSoundMode(3);
    }

    private void multifaceEnabledActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setMultifaceEnabled(this.multifaceEnabled.isSelected());
    }

    private void multifaceOneRadioButtonActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setMf128On48K(this.multiface128RadioButton.isSelected());
    }

    private void hifiSoundActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setHifiSound(this.hifiSound.isSelected());
    }

    private void connectedIF1ActionPerformed(ActionEvent evt) {
        this.settings.getInterface1Settings().setConnectedIF1(this.connectedIF1.isSelected());
    }

    private void numDrivesSpinnerStateChanged(ChangeEvent evt) {
        this.settings.getInterface1Settings().setMicrodriveUnits(((SpinnerNumberModel)this.numDrivesSpinner.getModel()).getNumber().byteValue());
    }

    private void cartridgeSizeSpinnerStateChanged(ChangeEvent evt) {
        this.settings.getInterface1Settings().setCartridgeSize(((SpinnerNumberModel)this.cartridgeSizeSpinner.getModel()).getNumber().intValue());
    }

    private void mapPCKeysActionPerformed(ActionEvent evt) {
        this.settings.getKeyboardJoystickSettings().setMapPCKeys(this.mapPCKeys.isSelected());
    }

    private void flashLoadActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setFlashLoad(this.flashLoad.isSelected());
    }

    private void autoSaveOnExitActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setHibernateMode(this.autoSaveOnExit.isSelected());
    }

    private void lecEnabledActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setLecEnabled(this.lecEnabled.isSelected());
    }

    private void zoomSliderStateChanged(ChangeEvent evt) {
        this.settings.getSpectrumSettings().setZoom(this.zoomSlider.getValue());
    }

    private void zoomCheckboxActionPerformed(ActionEvent evt) {
        this.settings.getSpectrumSettings().setZoomed(this.zoomCheckbox.isSelected());
    }

    private void autoLoadTapeActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setAutoLoadTape(this.autoLoadTape.isSelected());
    }

    private void confirmActionsActionPerformed(ActionEvent evt) {
        this.settings.getEmulatorSettings().setConfirmActions(this.confirmActions.isSelected());
    }

    private void autosaveConfigOnExitActionPerformed(ActionEvent evt) {
        this.settings.getEmulatorSettings().setAutosaveConfigOnExit(this.autosaveConfigOnExit.isSelected());
    }

    private void invertedEarActionPerformed(ActionEvent evt) {
        this.settings.getTapeSettings().setInvertedEar(this.invertedEar.isSelected());
    }
}

