/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import machine.Interface1;
import machine.Interface1DriveListener;

public class MicrodriveDialog
extends JPanel {
    private JDialog microdriveDialog;
    private Interface1 if1;
    private MicrodriveTableModel tableModel;
    private JFileChooser cartridgeDlg;
    private File currentDir;
    FileNameExtensionFilter mdrExtension;
    FileNameExtensionFilter mdvExtension;
    private JButton closeButton;
    private JMenuItem driveNumber;
    private JMenuItem ejectCartridge;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JLabel messageLabel;
    private JPanel messageLabelPanel;
    private JTable microdrivesTable;
    private JMenuItem newCartridge;
    private JMenuItem openCartridge;
    private JPopupMenu popupMenu;
    private JMenuItem saveAsCartridge;
    private JMenuItem saveCartridge;

    public MicrodriveDialog(Interface1 handler) {
        this.if1 = handler;
        this.tableModel = new MicrodriveTableModel();
        this.initComponents();
        PopupListener popupListener = new PopupListener();
        this.microdrivesTable.addMouseListener(popupListener);
        this.microdrivesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int row = MicrodriveDialog.this.microdrivesTable.rowAtPoint(evt.getPoint());
                MicrodriveDialog.this.microdrivesTable.setToolTipText(MicrodriveDialog.this.if1.getAbsolutePath(row));
            }
        });
        this.if1.addInterface1DriveListener(new Interface1DriveListener(){

            @Override
            public void driveSelected(int drive) {
            }

            @Override
            public void driveModified(int drive) {
                MicrodriveDialog.this.tableModel.fireTableRowsUpdated(--drive, drive);
                MicrodriveDialog.this.microdrivesTable.getSelectionModel().setSelectionInterval(drive, drive);
            }
        });
        this.microdrivesTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.microdrivesTable.getColumnModel().getColumn(2).setPreferredWidth(25);
        this.microdrivesTable.getColumnModel().getColumn(3).setPreferredWidth(25);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.mdrExtension = new FileNameExtensionFilter(bundle.getString("CARTRIDGE_MDRV_TYPE"), "mdr", "mdv");
        this.mdvExtension = new FileNameExtensionFilter(bundle.getString("CARTRIDGE_MDV_TYPE"), "mdv");
    }

    public boolean showDialog(Component parent, String title) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.microdriveDialog == null) {
            this.microdriveDialog = new JDialog(owner, false);
            this.microdriveDialog.getContentPane().add(this);
            this.microdriveDialog.pack();
        }
        this.microdriveDialog.setTitle(title);
        this.microdriveDialog.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.driveNumber = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.newCartridge = new JMenuItem();
        this.openCartridge = new JMenuItem();
        this.ejectCartridge = new JMenuItem();
        this.saveCartridge = new JMenuItem();
        this.saveAsCartridge = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.microdrivesTable = new JTable();
        this.messageLabelPanel = new JPanel();
        this.messageLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.closeButton = new JButton();
        this.filler2 = new Box.Filler(new Dimension(25, 25), new Dimension(25, 25), new Dimension(25, 25));
        this.driveNumber.setText("jMenuItem1");
        this.driveNumber.setEnabled(false);
        this.popupMenu.add(this.driveNumber);
        this.popupMenu.add(this.jSeparator1);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.newCartridge.setText(bundle.getString("MicrodriveDialog.popupMenu.newCartridge.text"));
        this.newCartridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.newCartridgeActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.newCartridge);
        this.openCartridge.setText(bundle.getString("MicrodriveDialog.popupMenu.openCartridge.text"));
        this.openCartridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.openCartridgeActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.openCartridge);
        this.ejectCartridge.setText(bundle.getString("MicrodriveDialog.popupMenu.ejectCartridge.text"));
        this.ejectCartridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.ejectCartridgeActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.ejectCartridge);
        this.saveCartridge.setText(bundle.getString("MicrodriveDialog.popupMenu.saveCartridge.text"));
        this.saveCartridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.saveCartridgeActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.saveCartridge);
        this.saveAsCartridge.setText(bundle.getString("MicrodriveDialog.popupMenu.saveAsCartridge.text"));
        this.saveAsCartridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.saveAsCartridgeActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.saveAsCartridge);
        this.setPreferredSize(new Dimension(500, 210));
        this.setLayout(new BoxLayout(this, 3));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.microdrivesTable.setModel(this.tableModel);
        this.microdrivesTable.setSelectionMode(0);
        this.microdrivesTable.getTableHeader().setResizingAllowed(false);
        this.microdrivesTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.microdrivesTable);
        this.jPanel1.add(this.jScrollPane1);
        this.add(this.jPanel1);
        this.messageLabelPanel.setPreferredSize(new Dimension(473, 50));
        this.messageLabelPanel.setLayout(new BoxLayout(this.messageLabelPanel, 2));
        this.messageLabel.setForeground(new Color(255, 0, 0));
        this.messageLabel.setText(bundle.getString("MicrodriveDialog.messageLabel.text"));
        this.messageLabelPanel.add(this.messageLabel);
        this.add(this.messageLabelPanel);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel2.add(this.filler1);
        this.closeButton.setText(bundle.getString("MicrodriveDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicrodriveDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.closeButton);
        this.jPanel2.add(this.filler2);
        this.add(this.jPanel2);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.microdriveDialog.setVisible(false);
    }

    private void newCartridgeActionPerformed(ActionEvent evt) {
        int row = this.microdrivesTable.getSelectedRow();
        this.if1.insertNew(row);
        this.tableModel.fireTableRowsUpdated(row, row);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        JOptionPane.showConfirmDialog(this.microdriveDialog.getContentPane(), bundle.getString("NEW_CARTRIDGE_WARNING"), bundle.getString("NEW_CARTRIDGE_WARNING_TITLE"), -1, 1);
    }

    private void openCartridgeActionPerformed(ActionEvent evt) {
        int row = this.microdrivesTable.getSelectedRow();
        if (this.cartridgeDlg == null) {
            this.cartridgeDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.currentDir = this.cartridgeDlg.getCurrentDirectory();
            this.cartridgeDlg.addChoosableFileFilter(this.mdrExtension);
            this.cartridgeDlg.addChoosableFileFilter(this.mdvExtension);
        } else {
            this.cartridgeDlg.setCurrentDirectory(this.currentDir);
        }
        this.cartridgeDlg.setFileFilter(this.mdrExtension);
        int status = this.cartridgeDlg.showOpenDialog(this);
        if (status == 0) {
            this.currentDir = this.cartridgeDlg.getCurrentDirectory();
            if (!this.if1.insertFile(row, this.cartridgeDlg.getSelectedFile())) {
                ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                JOptionPane.showMessageDialog(this, bundle.getString("LOAD_CARTRIDGE_ERROR"), bundle.getString("LOAD_CARTRIDGE_ERROR_TITLE"), 0);
            }
            this.tableModel.fireTableRowsUpdated(row, row);
        }
    }

    private void ejectCartridgeActionPerformed(ActionEvent evt) {
        int row = this.microdrivesTable.getSelectedRow();
        if (this.if1.isModified(row)) {
            ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
            int ret = JOptionPane.showConfirmDialog(this.microdriveDialog.getContentPane(), bundle.getString("EJECT_CARTRIDGE_MSG"), bundle.getString("EJECT_CARTRIDGE_TITLE"), 0, 2);
            if (ret == 1) {
                return;
            }
        }
        this.if1.eject(row);
        this.tableModel.fireTableRowsUpdated(row, row);
    }

    private void saveCartridgeActionPerformed(ActionEvent evt) {
        int row = this.microdrivesTable.getSelectedRow();
        this.if1.save(row);
        this.tableModel.fireTableRowsUpdated(row, row);
    }

    private void saveAsCartridgeActionPerformed(ActionEvent evt) {
        int row = this.microdrivesTable.getSelectedRow();
        if (this.cartridgeDlg == null) {
            this.cartridgeDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.cartridgeDlg.addChoosableFileFilter(this.mdrExtension);
            this.cartridgeDlg.addChoosableFileFilter(this.mdvExtension);
            this.currentDir = this.cartridgeDlg.getCurrentDirectory();
        } else {
            this.cartridgeDlg.setCurrentDirectory(this.currentDir);
        }
        this.cartridgeDlg.setFileFilter(this.mdvExtension);
        int status = this.cartridgeDlg.showSaveDialog(this);
        if (status == 0) {
            this.currentDir = this.cartridgeDlg.getCurrentDirectory();
            if (this.mdvExtension.accept(this.cartridgeDlg.getSelectedFile())) {
                this.if1.save(row, this.cartridgeDlg.getSelectedFile());
            } else {
                String saveName = this.cartridgeDlg.getSelectedFile().getAbsolutePath() + ".mdv";
                this.if1.save(row, new File(saveName));
            }
            this.tableModel.fireTableRowsUpdated(row, row);
        }
    }

    private class MicrodriveTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return MicrodriveDialog.this.if1.getNumDrives();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return String.format("%4d", row + 1);
                }
                case 1: {
                    ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                    if (!MicrodriveDialog.this.if1.isCartridge(row)) {
                        return bundle.getString("MicrodriveDialog.tableModel.nocartridge.txt");
                    }
                    String name = MicrodriveDialog.this.if1.getFilename(row);
                    if (name == null) {
                        name = bundle.getString("MicrodriveDialog.tableModel.nofilename.txt");
                    }
                    return name;
                }
                case 2: {
                    return MicrodriveDialog.this.if1.isWriteProtected(row);
                }
                case 3: {
                    return MicrodriveDialog.this.if1.isModified(row);
                }
            }
            return "NOT EXISTENT COLUMN!";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                Boolean state = (Boolean)value;
                MicrodriveDialog.this.if1.setWriteProtected(row, state);
                this.fireTableRowsUpdated(row, row);
            }
        }

        @Override
        public String getColumnName(int col) {
            String msg;
            ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
            switch (col) {
                case 0: {
                    msg = bundle.getString("MicrodriveDialog.tableModel.column0.txt");
                    break;
                }
                case 1: {
                    msg = bundle.getString("MicrodriveDialog.tableModel.column1.txt");
                    break;
                }
                case 2: {
                    msg = bundle.getString("MicrodriveDialog.tableModel.column2.txt");
                    break;
                }
                case 3: {
                    msg = bundle.getString("MicrodriveDialog.tableModel.column3.txt");
                    break;
                }
                default: {
                    msg = "COLUMN ERROR!";
                }
            }
            return msg;
        }
    }

    public class PopupListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent evt) {
            this.showPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.showPopup(evt);
        }

        private void showPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                if (MicrodriveDialog.this.microdrivesTable.getSelectedRowCount() == 0) {
                    MicrodriveDialog.this.driveNumber.setText("Microdrive");
                    MicrodriveDialog.this.newCartridge.setEnabled(false);
                    MicrodriveDialog.this.openCartridge.setEnabled(false);
                    MicrodriveDialog.this.ejectCartridge.setEnabled(false);
                    MicrodriveDialog.this.saveCartridge.setEnabled(false);
                    MicrodriveDialog.this.saveAsCartridge.setEnabled(false);
                } else {
                    int row = MicrodriveDialog.this.microdrivesTable.getSelectedRow();
                    MicrodriveDialog.this.driveNumber.setText(String.format("Microdrive %d", row + 1));
                    if (MicrodriveDialog.this.if1.isCartridge(row)) {
                        MicrodriveDialog.this.newCartridge.setEnabled(false);
                        MicrodriveDialog.this.openCartridge.setEnabled(false);
                        MicrodriveDialog.this.ejectCartridge.setEnabled(true);
                        MicrodriveDialog.this.saveCartridge.setEnabled(MicrodriveDialog.this.if1.getFilename(row) != null && !MicrodriveDialog.this.if1.getFilename(row).toLowerCase().endsWith(".mdr"));
                        MicrodriveDialog.this.saveAsCartridge.setEnabled(true);
                    } else {
                        MicrodriveDialog.this.newCartridge.setEnabled(true);
                        MicrodriveDialog.this.openCartridge.setEnabled(true);
                        MicrodriveDialog.this.ejectCartridge.setEnabled(false);
                        MicrodriveDialog.this.saveCartridge.setEnabled(false);
                        MicrodriveDialog.this.saveAsCartridge.setEnabled(false);
                    }
                }
                MicrodriveDialog.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }
}

