/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import machine.MachineTypes;
import machine.Memory;
import tv.porst.jhexview.IHexViewListener;
import tv.porst.jhexview.JHexView;

public class MemoryBrowserDialog
extends JPanel {
    private JDialog memoryBrowserDialog;
    private JHexView hexView;
    private Memory memory;
    private MachineTypes spectrumModel;
    private String formatInfo;
    private JLabel addressLabel;
    private JLabel asciiViewLabel;
    private JButton closeButton;
    private JPanel closePanel;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private JSpinner gotoAddress;
    private JLabel gotoAddressLabel;
    private JPanel headerBrowserPanel;
    private JLabel hexViewLabel;
    private JPanel hexViewPanel;
    private JLabel informationLabel;
    private JPanel informationPanel;
    private JCheckBox markPrintableCharacters;
    private JComboBox memoryComboBox;
    private JLabel memoryRangeLabel;
    private JPanel optionsPanel;

    public MemoryBrowserDialog(Memory memory) {
        this.initComponents();
        this.memory = memory;
        this.hexView = new JHexView();
        this.hexView.setData(memory.getMemoryDataProvider());
        this.hexView.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
        this.hexView.setBytesPerColumn(1);
        this.hexView.setEnabled(true);
        this.hexView.addHexListener(new SelectionChangedListener());
        this.hexViewPanel.add(this.hexView);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.formatInfo = bundle.getString("MemoryBrowserDialog.informationLabel.txt");
    }

    public boolean showDialog(Component parent, String title) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.memoryBrowserDialog == null) {
            this.memoryBrowserDialog = new JDialog(owner, false);
            this.memoryBrowserDialog.setMinimumSize(new Dimension(30, 200));
            this.memoryBrowserDialog.setMaximumSize(new Dimension(520, 800));
            this.memoryBrowserDialog.getContentPane().add(this);
            this.memoryBrowserDialog.pack();
        }
        if (this.spectrumModel != this.memory.getSpectrumModel()) {
            this.spectrumModel = this.memory.getSpectrumModel();
            this.memoryComboBox.setEnabled(this.memory.isModel128k());
            this.memoryComboBox.setSelectedIndex(0);
            this.memory.setPageModeBrowser(8);
            this.hexView.setData(this.memory.getMemoryDataProvider());
            this.gotoAddress.setModel(new SpinnerNumberModel(0, 0, 65535, 16));
            if (this.markPrintableCharacters.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MemoryBrowserDialog.this.markPrintableCharacters();
                    }
                });
            }
        }
        this.memoryBrowserDialog.setTitle(title);
        this.memoryBrowserDialog.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.headerBrowserPanel = new JPanel();
        this.addressLabel = new JLabel();
        this.hexViewLabel = new JLabel();
        this.asciiViewLabel = new JLabel();
        this.filler4 = new Box.Filler(new Dimension(16, 21), new Dimension(16, 21), new Dimension(16, 21));
        this.hexViewPanel = new JPanel();
        this.informationPanel = new JPanel();
        this.informationLabel = new JLabel();
        this.filler5 = new Box.Filler(new Dimension(25, 24), new Dimension(25, 24), new Dimension(25, 24));
        this.markPrintableCharacters = new JCheckBox();
        this.optionsPanel = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(16, 25), new Dimension(16, 25), new Dimension(16, 25));
        this.gotoAddressLabel = new JLabel();
        this.gotoAddress = new JSpinner();
        this.filler1 = new Box.Filler(new Dimension(16, 25), new Dimension(16, 25), new Dimension(16, 25));
        this.memoryRangeLabel = new JLabel();
        this.memoryComboBox = new JComboBox();
        this.filler3 = new Box.Filler(new Dimension(16, 25), new Dimension(16, 25), new Dimension(16, 25));
        this.closePanel = new JPanel();
        this.filler6 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.closeButton = new JButton();
        this.filler7 = new Box.Filler(new Dimension(25, 25), new Dimension(25, 25), new Dimension(25, 25));
        this.setMaximumSize(new Dimension(520, 800));
        this.setMinimumSize(new Dimension(30, 200));
        this.setPreferredSize(new Dimension(512, 425));
        this.setLayout(new BoxLayout(this, 3));
        this.headerBrowserPanel.setPreferredSize(new Dimension(512, 21));
        this.headerBrowserPanel.setLayout(new BoxLayout(this.headerBrowserPanel, 2));
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.addressLabel.setText(bundle.getString("MemoryBrowserDialog.addressLabel.txt"));
        this.addressLabel.setToolTipText(bundle.getString("MemoryBrowserDialog.addressTooltipLabel.txt"));
        this.addressLabel.setBorder(new SoftBevelBorder(0));
        this.addressLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MemoryBrowserDialog.this.addressLabelMouseClicked(evt);
            }
        });
        this.headerBrowserPanel.add(this.addressLabel);
        this.hexViewLabel.setHorizontalAlignment(0);
        this.hexViewLabel.setText(bundle.getString("MemoryBrowserDialog.hexViewLabel.txt"));
        this.hexViewLabel.setBorder(new SoftBevelBorder(0));
        this.hexViewLabel.setMaximumSize(new Dimension(330, 21));
        this.headerBrowserPanel.add(this.hexViewLabel);
        this.asciiViewLabel.setHorizontalAlignment(0);
        this.asciiViewLabel.setText(bundle.getString("MemoryBrowserDialog.asciiViewLabel.txt"));
        this.asciiViewLabel.setBorder(new SoftBevelBorder(0));
        this.asciiViewLabel.setMaximumSize(new Dimension(150, 21));
        this.headerBrowserPanel.add(this.asciiViewLabel);
        this.headerBrowserPanel.add(this.filler4);
        this.add(this.headerBrowserPanel);
        this.hexViewPanel.setMinimumSize(new Dimension(50, 50));
        this.hexViewPanel.setPreferredSize(new Dimension(512, 300));
        this.hexViewPanel.setLayout(new BoxLayout(this.hexViewPanel, 2));
        this.add(this.hexViewPanel);
        this.informationPanel.setMinimumSize(new Dimension(513, 34));
        this.informationPanel.setPreferredSize(new Dimension(512, 34));
        this.informationLabel.setForeground(new Color(255, 0, 0));
        this.informationLabel.setText(bundle.getString("MemoryBrowserDialog.informationLabel.txt"));
        this.informationPanel.add(this.informationLabel);
        this.informationPanel.add(this.filler5);
        this.markPrintableCharacters.setText(bundle.getString("MemoryBrowserDialog.markPrintableCharacters.txt"));
        this.markPrintableCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBrowserDialog.this.markPrintableCharactersActionPerformed(evt);
            }
        });
        this.informationPanel.add(this.markPrintableCharacters);
        this.add(this.informationPanel);
        this.optionsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.optionsPanel.setPreferredSize(new Dimension(512, 50));
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 2));
        this.optionsPanel.add(this.filler2);
        this.gotoAddressLabel.setText(bundle.getString("MemoryBrowserDialog.gotoAddress.txt"));
        this.optionsPanel.add(this.gotoAddressLabel);
        this.gotoAddress.setModel(new SpinnerNumberModel(0, 0, 65535, 16));
        this.gotoAddress.setMaximumSize(new Dimension(100, 24));
        this.gotoAddress.setMinimumSize(new Dimension(70, 24));
        this.gotoAddress.setPreferredSize(new Dimension(70, 24));
        this.gotoAddress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MemoryBrowserDialog.this.gotoAddressStateChanged(evt);
            }
        });
        this.optionsPanel.add(this.gotoAddress);
        this.optionsPanel.add(this.filler1);
        this.memoryRangeLabel.setText(bundle.getString("MemoryBrowserDialog.memoryRangeLabel.txt"));
        this.optionsPanel.add(this.memoryRangeLabel);
        this.memoryComboBox.setMaximumRowCount(9);
        this.memoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0x0000-0xFFFF", "RAM 0", "RAM 1", "RAM 2", "RAM 3", "RAM 4", "RAM 5", "RAM 6", "RAM 7"}));
        this.memoryComboBox.setMaximumSize(new Dimension(150, 24));
        this.memoryComboBox.setMinimumSize(new Dimension(50, 24));
        this.memoryComboBox.setPreferredSize(new Dimension(60, 24));
        this.memoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBrowserDialog.this.memoryComboBoxActionPerformed(evt);
            }
        });
        this.optionsPanel.add(this.memoryComboBox);
        this.optionsPanel.add(this.filler3);
        this.add(this.optionsPanel);
        this.closePanel.setPreferredSize(new Dimension(512, 70));
        this.closePanel.setLayout(new BoxLayout(this.closePanel, 2));
        this.closePanel.add(this.filler6);
        this.closeButton.setText(bundle.getString("MemoryBrowser.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBrowserDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.closePanel.add(this.closeButton);
        this.closePanel.add(this.filler7);
        this.add(this.closePanel);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.memoryBrowserDialog.setVisible(false);
    }

    private void gotoAddressStateChanged(ChangeEvent evt) {
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.gotoAddress.getModel();
        this.hexView.gotoOffset(snmAddress.getNumber().longValue() & 0xFFFFL);
    }

    private void memoryComboBoxActionPerformed(ActionEvent evt) {
        JComboBox cbx = (JComboBox)evt.getSource();
        this.hexView.setDefinitionStatus(JHexView.DefinitionStatus.UNDEFINED);
        if (cbx.getSelectedIndex() == 0) {
            this.memory.setPageModeBrowser(8);
            this.gotoAddress.setModel(new SpinnerNumberModel(0, 0, 65535, 16));
        } else {
            this.memory.setPageModeBrowser(cbx.getSelectedIndex() - 1);
            this.gotoAddress.setModel(new SpinnerNumberModel(0, 0, 16383, 16));
        }
        this.hexView.setData(this.memory.getMemoryDataProvider());
        this.hexView.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
        if (this.markPrintableCharacters.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryBrowserDialog.this.markPrintableCharacters();
                }
            });
        }
    }

    private void addressLabelMouseClicked(MouseEvent evt) {
        this.hexView.setAddressMode(this.hexView.getAddressMode() == JHexView.AddressMode.HEXADECIMAL ? JHexView.AddressMode.DECIMAL : JHexView.AddressMode.HEXADECIMAL);
    }

    private void markPrintableCharactersActionPerformed(ActionEvent evt) {
        if (this.markPrintableCharacters.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryBrowserDialog.this.markPrintableCharacters();
                }
            });
        } else {
            this.hexView.uncolorizeAll(0);
        }
    }

    private void markPrintableCharacters() {
        int page;
        int end;
        this.hexView.uncolorizeAll(0);
        if (this.memoryComboBox.getSelectedIndex() == 0) {
            end = 65536;
            page = 8;
        } else {
            end = 16384;
            page = this.memoryComboBox.getSelectedIndex() - 1;
        }
        int start = 0;
        int length = 0;
        for (int address = 0; address < end; ++address) {
            int value = page > 7 ? this.memory.readByte(address) & 0xFF : this.memory.readByte(page, address) & 0xFF;
            if (value < 32 || value > 126) {
                if (length <= 0) continue;
                this.hexView.colorize(0, start, length, Color.YELLOW, Color.BLUE);
                length = 0;
                continue;
            }
            if (length == 0) {
                start = address;
            }
            ++length;
        }
    }

    private class SelectionChangedListener
    implements IHexViewListener {
        private SelectionChangedListener() {
        }

        @Override
        public void selectionChanged(long start, long length) {
            if (MemoryBrowserDialog.this.spectrumModel != MemoryBrowserDialog.this.memory.getSpectrumModel()) {
                MemoryBrowserDialog.this.spectrumModel = MemoryBrowserDialog.this.memory.getSpectrumModel();
                MemoryBrowserDialog.this.memoryComboBox.setEnabled(MemoryBrowserDialog.this.memory.isModel128k());
                MemoryBrowserDialog.this.memoryComboBox.setSelectedIndex(0);
                MemoryBrowserDialog.this.memory.setPageModeBrowser(8);
                MemoryBrowserDialog.this.hexView.setData(MemoryBrowserDialog.this.memory.getMemoryDataProvider());
                MemoryBrowserDialog.this.gotoAddress.setModel(new SpinnerNumberModel(0, 0, 65535, 16));
                if (MemoryBrowserDialog.this.markPrintableCharacters.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MemoryBrowserDialog.this.markPrintableCharacters();
                        }
                    });
                }
            }
            if (length == 1L) {
                int address = (int)(start / 2L) & 0xFFFF;
                int value = MemoryBrowserDialog.this.memoryComboBox.getSelectedIndex() == 0 ? MemoryBrowserDialog.this.memory.readByte(address) & 0xFF : MemoryBrowserDialog.this.memory.readByte(MemoryBrowserDialog.this.memoryComboBox.getSelectedIndex() - 1, address) & 0xFF;
                MemoryBrowserDialog.this.informationLabel.setText(String.format(MemoryBrowserDialog.this.formatInfo, address, address, value, value));
                MemoryBrowserDialog.this.gotoAddress.getModel().setValue(address);
            }
        }
    }
}

