/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import machine.MachineTypes;
import machine.Memory;

public class LoadSaveMemoryDialog
extends JPanel {
    private JDialog loadSaveMemoryDialog;
    private JFileChooser fileDlg;
    FileNameExtensionFilter binExtension;
    private Memory memory;
    private File filename;
    private boolean saveDialog;
    private JLabel addressLabel;
    private JSpinner addressSpinner;
    private JLabel archiveLabel;
    private JButton browseButton;
    private JButton closeButton;
    private JLabel fileChoosedLabel;
    private JButton loadSaveButton;
    private JComboBox rangeCombobox;
    private JLabel rangeLabel;
    private JLabel sizeLabel;
    private JSpinner sizeSpinner;

    public LoadSaveMemoryDialog(Memory memory) {
        this.memory = memory;
        this.initComponents();
        this.binExtension = new FileNameExtensionFilter(ResourceBundle.getBundle("gui/Bundle").getString("BINARY_EXTENSION_TYPE"), "bin");
    }

    public boolean showLoadDialog(Component parent, File file) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.loadSaveMemoryDialog == null) {
            this.loadSaveMemoryDialog = new JDialog(owner, false);
            this.loadSaveMemoryDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.loadSaveMemoryDialog.getContentPane().add(this);
            this.loadSaveMemoryDialog.pack();
        }
        this.saveDialog = false;
        this.filename = file;
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.loadSaveMemoryDialog.setTitle(bundle.getString("LoadSaveMemoryDialog.LoadTitle.text"));
        this.fileChoosedLabel.setText(bundle.getString("LoadSaveMemoryDialog.fileChoosedLabel.text"));
        this.addressSpinner.setEnabled(false);
        this.sizeSpinner.setEnabled(false);
        this.sizeSpinner.getModel().setValue(0);
        this.rangeCombobox.setEnabled(false);
        this.loadSaveButton.setEnabled(false);
        this.loadSaveButton.setText(bundle.getString("LoadSaveMemoryDialog.loadButton.text"));
        if (this.filename != null) {
            this.fileChoosedLabel.setText(this.filename.getName());
            this.addressSpinner.setEnabled(true);
            this.sizeSpinner.setEnabled(true);
            if (!this.saveDialog) {
                this.sizeSpinner.setModel(new SpinnerNumberModel(this.filename.length(), 0.0, this.filename.length(), 1.0));
            }
            this.rangeCombobox.setSelectedIndex(0);
            this.rangeCombobox.setEnabled(this.memory.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUM48K);
            this.loadSaveButton.setEnabled(true);
        }
        this.loadSaveMemoryDialog.setVisible(true);
        return true;
    }

    public boolean showSaveDialog(Component parent) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.loadSaveMemoryDialog == null) {
            this.loadSaveMemoryDialog = new JDialog(owner, false);
            this.loadSaveMemoryDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.loadSaveMemoryDialog.getContentPane().add(this);
            this.loadSaveMemoryDialog.pack();
        }
        this.saveDialog = true;
        this.filename = null;
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.loadSaveMemoryDialog.setTitle(bundle.getString("LoadSaveMemoryDialog.SaveTitle.text"));
        this.fileChoosedLabel.setText(bundle.getString("LoadSaveMemoryDialog.fileChoosedLabel.text"));
        this.addressSpinner.setEnabled(false);
        this.sizeSpinner.setEnabled(false);
        this.sizeSpinner.setModel(new SpinnerNumberModel(0, 0, 65536, 1));
        this.rangeCombobox.setEnabled(false);
        this.loadSaveButton.setText(bundle.getString("LoadSaveMemoryDialog.saveButton.text"));
        this.loadSaveButton.setEnabled(false);
        this.loadSaveMemoryDialog.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.fileChoosedLabel = new JLabel();
        this.browseButton = new JButton();
        this.addressLabel = new JLabel();
        this.addressSpinner = new JSpinner();
        this.sizeLabel = new JLabel();
        this.sizeSpinner = new JSpinner();
        this.rangeLabel = new JLabel();
        this.rangeCombobox = new JComboBox();
        this.closeButton = new JButton();
        this.archiveLabel = new JLabel();
        this.loadSaveButton = new JButton();
        this.fileChoosedLabel.setHorizontalAlignment(4);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.fileChoosedLabel.setText(bundle.getString("LoadSaveMemoryDialog.fileChoosedLabel.text"));
        this.browseButton.setText(bundle.getString("LoadSaveMemoryDialog.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSaveMemoryDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.addressLabel.setText(bundle.getString("LoadSaveMemoryDialog.addressLabel.text"));
        this.addressSpinner.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.sizeLabel.setText(bundle.getString("LoadSaveMemoryDialog.sizeLabel.text"));
        this.sizeSpinner.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.rangeLabel.setText(bundle.getString("LoadSaveMemoryDialog.rangeLabel.text"));
        this.rangeCombobox.setMaximumRowCount(9);
        this.rangeCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"0x0000-0xFFFF", "RAM 0", "RAM 1", "RAM 2", "RAM 3", "RAM 4", "RAM 5", "RAM 6", "RAM 7"}));
        this.closeButton.setText(bundle.getString("LoadSaveMemoryDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSaveMemoryDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.archiveLabel.setText(bundle.getString("LoadSaveMemoryDialog.archiveLabel.text"));
        this.loadSaveButton.setText(bundle.getString("LoadSaveMemoryDialog.loadButton.text"));
        this.loadSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSaveMemoryDialog.this.loadSaveButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.archiveLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addComponent(this.fileChoosedLabel, -2, 145, -2)).addGroup(layout.createSequentialGroup().addComponent(this.rangeLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rangeCombobox, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressLabel, -2, 128, -2).addComponent(this.sizeLabel, -1, 138, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addressSpinner, -2, 86, -2).addComponent(this.sizeSpinner, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.browseButton).addComponent(this.loadSaveButton).addComponent(this.closeButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.archiveLabel).addComponent(this.fileChoosedLabel).addComponent(this.browseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel).addComponent(this.addressSpinner, -2, -1, -2)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeSpinner, -2, -1, -2).addComponent(this.loadSaveButton)).addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.rangeCombobox, -2, -1, -2).addComponent(this.rangeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        int status;
        if (this.fileDlg == null) {
            this.fileDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.fileDlg.addChoosableFileFilter(this.binExtension);
            this.fileDlg.setFileFilter(this.binExtension);
        }
        if ((status = this.saveDialog ? this.fileDlg.showSaveDialog(this) : this.fileDlg.showOpenDialog(this)) == 0) {
            if (this.binExtension.accept(this.fileDlg.getSelectedFile())) {
                this.filename = this.fileDlg.getSelectedFile();
            } else {
                String saveName = this.fileDlg.getSelectedFile().getAbsolutePath() + ".bin";
                this.filename = new File(saveName);
            }
            this.fileChoosedLabel.setText(this.filename.getName());
            this.addressSpinner.setEnabled(true);
            this.sizeSpinner.setEnabled(true);
            if (!this.saveDialog) {
                this.sizeSpinner.setModel(new SpinnerNumberModel(this.filename.length(), 0.0, this.filename.length(), 1.0));
            }
            this.rangeCombobox.setSelectedIndex(0);
            this.rangeCombobox.setEnabled(this.memory.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUM48K);
            this.loadSaveButton.setEnabled(true);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.loadSaveMemoryDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSaveButtonActionPerformed(ActionEvent evt) {
        int maxSize;
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.addressSpinner.getModel();
        SpinnerNumberModel snmSize = (SpinnerNumberModel)this.sizeSpinner.getModel();
        int start = snmAddress.getNumber().intValue();
        int size = snmSize.getNumber().intValue();
        int n = maxSize = this.rangeCombobox.getSelectedIndex() == 0 ? 65536 : 16384;
        if (size == 0) {
            return;
        }
        if (start + size > maxSize) {
            String error = String.format(bundle.getString("SIZE_BINARY_ERROR"), maxSize);
            JOptionPane.showMessageDialog(this, error, bundle.getString("SIZE_BINARY_ERROR_TITLE"), 0);
            return;
        }
        if (this.saveDialog) {
            FilterOutputStream fOut = null;
            try {
                int addr;
                fOut = new BufferedOutputStream(new FileOutputStream(this.filename));
                if (this.rangeCombobox.getSelectedIndex() == 0) {
                    for (addr = start; addr < start + size; ++addr) {
                        ((BufferedOutputStream)fOut).write(this.memory.readByte(addr));
                    }
                } else {
                    for (addr = start; addr < start + size; ++addr) {
                        ((BufferedOutputStream)fOut).write(this.memory.readByte(this.rangeCombobox.getSelectedIndex() - 1, addr));
                    }
                }
                JOptionPane.showMessageDialog(this, bundle.getString("SAVE_BINARY_OK"), bundle.getString("SAVE_BINARY_OK_TITLE"), 1);
            }
            catch (FileNotFoundException excpt) {
                Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, excpt);
            }
            catch (IOException ioExcpt) {
                Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, ioExcpt);
            }
            finally {
                try {
                    if (fOut != null) {
                        fOut.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return;
        }
        BufferedInputStream fIn = null;
        try {
            int addr;
            fIn = new BufferedInputStream(new FileInputStream(this.filename));
            if (this.rangeCombobox.getSelectedIndex() == 0) {
                for (addr = start; addr < start + size; ++addr) {
                    this.memory.writeByte(addr, (byte)(fIn.read() & 0xFF));
                }
            } else {
                for (addr = start; addr < start + size; ++addr) {
                    this.memory.writeByte(this.rangeCombobox.getSelectedIndex() - 1, addr, (byte)(fIn.read() & 0xFF));
                }
            }
            JOptionPane.showMessageDialog(this, bundle.getString("LOAD_BINARY_OK"), bundle.getString("LOAD_BINARY_OK_TITLE"), 1);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LoadSaveMemoryDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

