/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JComponent;
import machine.Spectrum;

public class JSpeccyScreen
extends JComponent {
    private BufferedImage tvImage;
    private BufferedImage tvImageFiltered;
    private BufferedImage tvPalImage;
    private Graphics2D tvImageFilteredGc;
    private Graphics2D tvPalImageGc;
    private int zoom;
    private int screenWidth;
    private int screenHeight;
    private Object interpolationMethod;
    private boolean anyFilter = false;
    private boolean palFilter = false;
    private boolean scanlinesFilter = false;
    private boolean rgbFilter = false;
    private int[] imageBuffer;
    private int[] imagePalBuffer;
    private int[] scanline1 = new int[256];
    private int[] scanline2 = new int[256];
    private static final int redMask = 0xFF0000;
    private static final int greenMask = 65280;
    private static final int blueMask = 255;
    private int[][] tableYUV = new int[3][32];
    private static final int Yuv = 0;
    private static final int yUv = 1;
    private static final int yuV = 2;
    private int LEFT_BORDER = 32;
    private int RIGHT_BORDER = 32;
    private int SCREEN_WIDTH = this.LEFT_BORDER + 256 + this.RIGHT_BORDER;
    private int TOP_BORDER = 24;
    private int BOTTOM_BORDER = 24;
    private int SCREEN_HEIGHT = this.TOP_BORDER + 192 + this.BOTTOM_BORDER;
    private int borderMode;

    public JSpeccyScreen() {
        this.initComponents();
        this.screenWidth = this.SCREEN_WIDTH;
        this.screenHeight = this.SCREEN_HEIGHT;
        this.borderMode = 1;
        this.zoom = 1;
        Dimension screenSize = new Dimension(this.screenWidth, this.screenHeight);
        this.setMaximumSize(screenSize);
        this.setMinimumSize(screenSize);
        this.setPreferredSize(screenSize);
        this.tvPalImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        this.tvPalImageGc = this.tvPalImage.createGraphics();
        this.imagePalBuffer = ((DataBufferInt)this.tvPalImage.getRaster().getDataBuffer()).getBankData()[0];
        this.interpolationMethod = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        this.scanline2[0] = 0;
        this.scanline1[0] = 0;
        for (int color = 1; color < this.scanline1.length; ++color) {
            this.scanline1[color] = (int)((float)color * 0.8f);
            this.scanline2[color] = (int)((float)color * 0.7f);
        }
        int[] yuv = new int[3];
        for (int color = 0; color < Spectrum.Paleta.length; ++color) {
            int rgb = Spectrum.Paleta[color];
            this.rgb2yuv(rgb, yuv);
            this.tableYUV[0][rgb %= 31] = yuv[0];
            this.tableYUV[1][rgb] = yuv[1];
            this.tableYUV[2][rgb] = yuv[2];
        }
    }

    public void setTvImage(BufferedImage bImage) {
        this.tvImage = bImage;
    }

    public void setZoom(int zoom) {
        if (this.zoom == zoom) {
            return;
        }
        if (zoom < 2) {
            zoom = 1;
        }
        if (zoom > 4) {
            zoom = 4;
        }
        this.zoom = zoom;
        this.screenWidth = this.SCREEN_WIDTH * zoom;
        this.screenHeight = this.SCREEN_HEIGHT * zoom;
        if (zoom > 1) {
            this.tvImageFiltered = new BufferedImage(this.screenWidth, this.screenHeight, 1);
            this.imageBuffer = ((DataBufferInt)this.tvImageFiltered.getRaster().getDataBuffer()).getBankData()[0];
            if (this.tvImageFilteredGc != null) {
                this.tvImageFilteredGc.dispose();
            }
            this.tvImageFilteredGc = this.tvImageFiltered.createGraphics();
            this.tvImageFilteredGc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
        }
        Dimension screenSize = new Dimension(this.screenWidth, this.screenHeight);
        this.setMaximumSize(screenSize);
        this.setMinimumSize(screenSize);
        this.setPreferredSize(screenSize);
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean isZoomed() {
        return this.zoom > 1;
    }

    public void setBorderMode(int mode) {
        if (this.borderMode == mode) {
            return;
        }
        this.borderMode = mode;
        switch (mode) {
            case 0: {
                this.BOTTOM_BORDER = 0;
                this.TOP_BORDER = 0;
                this.RIGHT_BORDER = 0;
                this.LEFT_BORDER = 0;
                break;
            }
            case 2: {
                this.LEFT_BORDER = 48;
                this.RIGHT_BORDER = 48;
                this.TOP_BORDER = 48;
                this.BOTTOM_BORDER = 56;
                break;
            }
            case 3: {
                this.LEFT_BORDER = 64;
                this.RIGHT_BORDER = 64;
                this.TOP_BORDER = 56;
                this.BOTTOM_BORDER = 56;
                break;
            }
            default: {
                this.LEFT_BORDER = 32;
                this.RIGHT_BORDER = 32;
                this.TOP_BORDER = 24;
                this.BOTTOM_BORDER = 24;
            }
        }
        this.SCREEN_WIDTH = this.LEFT_BORDER + 256 + this.RIGHT_BORDER;
        this.SCREEN_HEIGHT = this.TOP_BORDER + 192 + this.BOTTOM_BORDER;
        this.tvPalImage = new BufferedImage(this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 1);
        if (this.tvPalImageGc != null) {
            this.tvPalImageGc.dispose();
        }
        this.tvPalImageGc = this.tvPalImage.createGraphics();
        this.imagePalBuffer = ((DataBufferInt)this.tvPalImage.getRaster().getDataBuffer()).getBankData()[0];
        this.screenWidth = this.SCREEN_WIDTH * this.zoom;
        this.screenHeight = this.SCREEN_HEIGHT * this.zoom;
        this.tvImageFiltered = new BufferedImage(this.screenWidth, this.screenHeight, 1);
        this.imageBuffer = ((DataBufferInt)this.tvImageFiltered.getRaster().getDataBuffer()).getBankData()[0];
        if (this.tvImageFilteredGc != null) {
            this.tvImageFilteredGc.dispose();
        }
        this.tvImageFilteredGc = this.tvImageFiltered.createGraphics();
        this.tvImageFilteredGc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
        Dimension screenSize = new Dimension(this.screenWidth, this.screenHeight);
        this.setMaximumSize(screenSize);
        this.setMinimumSize(screenSize);
        this.setPreferredSize(screenSize);
    }

    public int getBorderMode() {
        return this.borderMode;
    }

    @Override
    public void paintComponent(Graphics gc) {
        Graphics2D gc2 = (Graphics2D)gc;
        switch (this.zoom) {
            case 2: {
                if (this.anyFilter) {
                    if (this.palFilter) {
                        this.tvPalImageGc.drawImage((Image)this.tvImage, 0, 0, null);
                        this.palFilterYUV();
                        this.tvImageFilteredGc.drawImage(this.tvPalImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    } else {
                        this.tvImageFilteredGc.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    }
                    if (this.scanlinesFilter) {
                        this.drawScanlines2x();
                    }
                    if (this.rgbFilter) {
                        this.filterRGB2x();
                    }
                    gc2.drawImage((Image)this.tvImageFiltered, 0, 0, null);
                    break;
                }
                gc2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                gc2.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                break;
            }
            case 3: {
                if (this.anyFilter) {
                    if (this.palFilter) {
                        this.tvPalImageGc.drawImage((Image)this.tvImage, 0, 0, null);
                        this.palFilterYUV();
                        this.tvImageFilteredGc.drawImage(this.tvPalImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    } else {
                        this.tvImageFilteredGc.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    }
                    if (this.scanlinesFilter) {
                        this.drawScanlines3x();
                    }
                    if (this.rgbFilter) {
                        this.filterRGB3x();
                    }
                    gc2.drawImage((Image)this.tvImageFiltered, 0, 0, null);
                    break;
                }
                gc2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                gc2.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                break;
            }
            case 4: {
                if (this.anyFilter) {
                    if (this.palFilter) {
                        this.tvPalImageGc.drawImage((Image)this.tvImage, 0, 0, null);
                        this.palFilterYUV();
                        this.tvImageFilteredGc.drawImage(this.tvPalImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    } else {
                        this.tvImageFilteredGc.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                    }
                    if (this.scanlinesFilter) {
                        this.drawScanlines4x();
                    }
                    if (this.rgbFilter) {
                        this.filterRGB4x();
                    }
                    gc2.drawImage((Image)this.tvImageFiltered, 0, 0, null);
                    break;
                }
                gc2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                gc2.drawImage(this.tvImage, 0, 0, this.screenWidth, this.screenHeight, null);
                break;
            }
            default: {
                if (this.palFilter) {
                    this.tvPalImageGc.drawImage((Image)this.tvImage, 0, 0, null);
                    this.palFilterYUV();
                    gc2.drawImage((Image)this.tvPalImage, 0, 0, null);
                    break;
                }
                gc2.drawImage((Image)this.tvImage, 0, 0, null);
            }
        }
    }

    private void drawScanlines2x() {
        int color = 0;
        int res = 0;
        for (int pixel = this.screenWidth; pixel < this.imageBuffer.length; pixel += this.screenWidth) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                if (this.imageBuffer[pixel] == 0) {
                    pixel += 2;
                    continue;
                }
                if (color != this.imageBuffer[pixel]) {
                    color = this.imageBuffer[pixel];
                    int red = this.scanline1[color >>> 16];
                    int green = this.scanline1[color >>> 8 & 0xFF];
                    int blue = this.scanline1[color & 0xFF];
                    res = red << 16 | green << 8 | blue;
                }
                this.imageBuffer[pixel++] = res;
                this.imageBuffer[pixel++] = res;
            }
        }
    }

    private void drawScanlines3x() {
        int color = 0;
        int res1 = 0;
        int res2 = 0;
        int jump = this.screenWidth * 2;
        for (int pixel = this.screenWidth; pixel < this.imageBuffer.length; pixel += jump) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                if (this.imageBuffer[pixel] == 0) {
                    pixel += 3;
                    continue;
                }
                if (color != this.imageBuffer[pixel]) {
                    color = this.imageBuffer[pixel];
                    int red = color >>> 16;
                    int green = color >>> 8 & 0xFF;
                    int blue = color & 0xFF;
                    res1 = this.scanline1[red] << 16 | this.scanline1[green] << 8 | this.scanline1[blue];
                    res2 = this.scanline2[red] << 16 | this.scanline2[green] << 8 | this.scanline2[blue];
                }
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
            }
        }
    }

    private void drawScanlines4x() {
        int color = 0;
        int res1 = 0;
        int res2 = 0;
        int jump = this.screenWidth * 3;
        for (int pixel = this.screenWidth * 2; pixel < this.imageBuffer.length; pixel += jump) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                if (this.imageBuffer[pixel] == 0) {
                    pixel += 4;
                    continue;
                }
                if (color != this.imageBuffer[pixel]) {
                    color = this.imageBuffer[pixel];
                    int red = color >>> 16;
                    int green = color >>> 8 & 0xFF;
                    int blue = color & 0xFF;
                    res1 = this.scanline1[red] << 16 | this.scanline1[green] << 8 | this.scanline1[blue];
                    res2 = this.scanline2[red] << 16 | this.scanline2[green] << 8 | this.scanline2[blue];
                }
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
                this.imageBuffer[pixel + this.screenWidth] = res2;
                this.imageBuffer[pixel++] = res1;
            }
        }
    }

    private void filterRGB2x() {
        for (int pixel = 0; pixel < this.imageBuffer.length; pixel += this.screenWidth) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                int n = pixel + this.screenWidth;
                this.imageBuffer[n] = this.imageBuffer[n] & 0xFF;
                int n2 = pixel++;
                this.imageBuffer[n2] = this.imageBuffer[n2] & 0xFF0000;
                int n3 = pixel++;
                this.imageBuffer[n3] = this.imageBuffer[n3] & 0xFF00;
            }
        }
    }

    private void filterRGB3x() {
        int jump = this.screenWidth * 2;
        for (int pixel = 0; pixel < this.imageBuffer.length; pixel += jump) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                int n = pixel + this.screenWidth;
                this.imageBuffer[n] = this.imageBuffer[n] & 0xFF00;
                int n2 = ++pixel + this.screenWidth;
                this.imageBuffer[n2] = this.imageBuffer[n2] & 0xFF0000;
                int n3 = pixel + jump;
                this.imageBuffer[n3] = this.imageBuffer[n3] & 0xFF;
                int n4 = pixel++;
                this.imageBuffer[n4] = this.imageBuffer[n4] & 0xFF00;
                int n5 = pixel + jump;
                this.imageBuffer[n5] = this.imageBuffer[n5] & 0xFF0000;
                int n6 = pixel++;
                this.imageBuffer[n6] = this.imageBuffer[n6] & 0xFF;
            }
        }
    }

    private void filterRGB4x() {
        int jump = this.screenWidth * 3;
        for (int pixel = 0; pixel < this.imageBuffer.length; pixel += jump) {
            for (int col = 0; col < this.SCREEN_WIDTH; ++col) {
                int n = pixel;
                this.imageBuffer[n] = this.imageBuffer[n] & 0xFF0000;
                int n2 = pixel + 1;
                this.imageBuffer[n2] = this.imageBuffer[n2] & 0xFF0000;
                int n3 = pixel + this.screenWidth;
                this.imageBuffer[n3] = this.imageBuffer[n3] & 0xFF0000;
                int n4 = pixel + this.screenWidth + 1;
                this.imageBuffer[n4] = this.imageBuffer[n4] & 0xFF0000;
                int n5 = pixel + this.screenWidth * 2;
                this.imageBuffer[n5] = this.imageBuffer[n5] & 0xFF;
                int n6 = pixel + this.screenWidth * 2 + 1;
                this.imageBuffer[n6] = this.imageBuffer[n6] & 0xFF;
                int n7 = pixel + this.screenWidth * 3;
                this.imageBuffer[n7] = this.imageBuffer[n7] & 0xFF;
                int n8 = pixel + this.screenWidth * 3 + 1;
                this.imageBuffer[n8] = this.imageBuffer[n8] & 0xFF;
                int n9 = pixel += 2;
                this.imageBuffer[n9] = this.imageBuffer[n9] & 0xFF00;
                int n10 = pixel + 1;
                this.imageBuffer[n10] = this.imageBuffer[n10] & 0xFF00;
                int n11 = pixel + this.screenWidth;
                this.imageBuffer[n11] = this.imageBuffer[n11] & 0xFF00;
                int n12 = pixel + this.screenWidth + 1;
                this.imageBuffer[n12] = this.imageBuffer[n12] & 0xFF00;
                pixel += 2;
            }
        }
    }

    private void rgb2yuv(int rgb, int[] yuv) {
        int r = rgb >>> 16;
        int b = rgb & 0xFF;
        int y = (int)(0.299 * (double)r + 0.587 * (double)(rgb >>> 8 & 0xFF) + 0.114 * (double)b);
        int u = (int)((double)(b - y) * 0.565);
        int v = (int)((double)(r - y) * 0.713);
        yuv[0] = y;
        yuv[1] = u + 128;
        yuv[2] = v + 128;
    }

    private int yuv2rgb(int y, int u, int v) {
        int b;
        int g;
        u -= 128;
        int r = (int)((double)y + 1.402 * (double)(v -= 128));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)y - 0.34414 * (double)u - 0.71414 * (double)v)) < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if ((b = (int)((double)y + 1.772 * (double)u)) < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return r << 16 | g << 8 | b;
    }

    private void palFilterYUV() {
        int start = this.TOP_BORDER * this.SCREEN_WIDTH + this.LEFT_BORDER;
        int limit = (this.TOP_BORDER + 192) * this.SCREEN_WIDTH - this.RIGHT_BORDER - 1;
        int pixel = 0;
        while (pixel < limit) {
            pixel = start;
            int idx1 = this.imagePalBuffer[pixel++] % 31;
            int idx2 = this.imagePalBuffer[pixel] % 31;
            for (int col = 0; col < 254; ++col) {
                int idx3 = this.imagePalBuffer[pixel + 1] % 31;
                this.imagePalBuffer[pixel++] = this.yuv2rgb(this.tableYUV[0][idx2], this.tableYUV[1][idx1] + 2 * this.tableYUV[1][idx2] + this.tableYUV[1][idx3] >>> 2, this.tableYUV[2][idx1] + 2 * this.tableYUV[2][idx2] + this.tableYUV[2][idx3] >>> 2);
                idx1 = idx2;
                idx2 = idx3;
            }
            start += this.SCREEN_WIDTH;
        }
    }

    private void initComponents() {
        this.setDoubleBuffered(false);
    }

    public boolean isPalFilter() {
        return this.palFilter;
    }

    public void setPalFilter(boolean palFilter) {
        this.palFilter = palFilter;
        if (palFilter) {
            this.rgbFilter = false;
            this.anyFilter = true;
        }
    }

    public boolean isScanlinesFilter() {
        return this.scanlinesFilter;
    }

    public void setScanlinesFilter(boolean scanlinesFilter) {
        this.scanlinesFilter = scanlinesFilter;
        if (scanlinesFilter) {
            this.rgbFilter = false;
            this.anyFilter = true;
        }
    }

    public boolean isRgbFilter() {
        return this.rgbFilter;
    }

    public void setRgbFilter(boolean rgbFilter) {
        this.rgbFilter = rgbFilter;
        if (rgbFilter) {
            this.scanlinesFilter = false;
            this.palFilter = false;
            this.anyFilter = true;
        }
    }

    public void setInterpolationMethod(Object interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
        if (this.tvImageFilteredGc != null) {
            this.tvImageFilteredGc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationMethod);
        }
    }

    public boolean isAnyFilter() {
        return this.anyFilter;
    }

    public void setAnyFilter(boolean anyFilter) {
        this.anyFilter = anyFilter;
        if (!anyFilter) {
            this.rgbFilter = false;
            this.scanlinesFilter = false;
            this.palFilter = false;
        }
    }
}

