/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuration.JSpeccySettingsType;
import configuration.ObjectFactory;
import gui.CommandLineOptions;
import gui.JSpeccyScreen;
import gui.LoadSaveMemoryDialog;
import gui.MemoryBrowserDialog;
import gui.MicrodriveDialog;
import gui.SettingsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableModel;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import machine.Interface1DriveListener;
import machine.Keyboard;
import machine.MachineTypes;
import machine.Spectrum;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import snapshots.SnapshotException;
import snapshots.SnapshotFactory;
import snapshots.SnapshotFile;
import snapshots.SnapshotSZX;
import snapshots.SpectrumState;
import utilities.Tape;
import utilities.TapeBlockListener;
import utilities.TapeStateListener;

public class JSpeccy
extends JFrame {
    private Spectrum spectrum;
    private Tape tape;
    private JSpeccyScreen jscr;
    private File currentFileSnapshot;
    private File currentDirSaveSnapshot;
    private File currentFileTape;
    private File currentDirLoadImage;
    private File currentDirSaveImage;
    private File currentDirRom;
    private JFileChooser openSnapshotDlg;
    private JFileChooser saveSnapshotDlg;
    private JFileChooser openTapeDlg;
    private JFileChooser loadImageDlg;
    private JFileChooser saveImageDlg;
    private JFileChooser IF2RomDlg;
    private File[] recentFile = new File[5];
    private ListSelectionModel lsm;
    private JSpeccySettingsType settings;
    private SettingsDialog settingsDialog;
    private MicrodriveDialog microdriveDialog;
    private MemoryBrowserDialog memoryBrowserDialog;
    private LoadSaveMemoryDialog loadSaveMemoryDialog;
    private FileNameExtensionFilter allSnapTapeExtension;
    private FileNameExtensionFilter snapshotExtension;
    private FileNameExtensionFilter saveSnapshotExtension;
    private FileNameExtensionFilter tapeExtension;
    private FileNameExtensionFilter createTapeExtension;
    private FileNameExtensionFilter imageExtension;
    private FileNameExtensionFilter screenExtension;
    private FileNameExtensionFilter romExtension;
    private SpectrumState memorySnapshot;
    private CommandLineOptions clo;
    Icon mdrOn = new ImageIcon(this.getClass().getResource("/icons/microdrive_on.png"));
    Icon mdrOff = new ImageIcon(this.getClass().getResource("/icons/microdrive_off.png"));
    Icon tapeStopped = new ImageIcon(this.getClass().getResource("/icons/Akai24x24.png"));
    Icon tapePlaying = new ImageIcon(this.getClass().getResource("/icons/Akai24x24-playing.png"));
    Icon tapeRecording = new ImageIcon(this.getClass().getResource("/icons/Akai24x24-recording.png"));
    private final TransferHandler handler = new TransferHandler(){

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean copySupported;
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            if (JSpeccy.this.spectrum.isPaused() && JSpeccy.this.tape.isTapePlaying()) {
                return false;
            }
            boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
            if (!copySupported) {
                return false;
            }
            support.setDropAction(1);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transfer = support.getTransferable();
            try {
                File file;
                List list = (List)transfer.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() != 1) {
                    return false;
                }
                Iterator iterator = list.iterator();
                do {
                    ResourceBundle bundle;
                    if (!iterator.hasNext()) return true;
                    file = (File)iterator.next();
                    if (file.isDirectory()) {
                        return false;
                    }
                    if (JSpeccy.this.snapshotExtension.accept(file)) {
                        JSpeccy.this.rotateRecentFile(file);
                        if (JSpeccy.this.tape.isTapeRunning()) {
                            JSpeccy.this.tape.stop();
                        }
                        JSpeccy.this.stopEmulation();
                        try {
                            SnapshotFile snap = SnapshotFactory.getSnapshot(file);
                            SpectrumState snapState = snap.load(file);
                            if (snap instanceof SnapshotSZX) {
                                File tapeLink;
                                SnapshotSZX snapSZX = (SnapshotSZX)snap;
                                if (snapSZX.isTapeEmbedded()) {
                                    JSpeccy.this.tape.eject();
                                    JSpeccy.this.tape.insertEmbeddedTape(snapSZX.getTapeName(), snapSZX.getTapeExtension(), snapSZX.getTapeData(), snapSZX.getTapeBlock());
                                }
                                if (snapSZX.isTapeLinked() && (tapeLink = new File(snapSZX.getTapeName())).exists()) {
                                    JSpeccy.this.tape.eject();
                                    JSpeccy.this.tape.insert(tapeLink);
                                    JSpeccy.this.tape.setSelectedBlock(snapSZX.getTapeBlock());
                                }
                            }
                            JSpeccy.this.spectrum.setSpectrumState(snapState);
                            JSpeccy.this.startEmulation();
                            return true;
                        }
                        catch (SnapshotException excpt) {
                            JOptionPane.showMessageDialog(JSpeccy.this.getContentPane(), ResourceBundle.getBundle("gui/Bundle").getString(excpt.getMessage()), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_LOAD_ERROR"), 0);
                            JSpeccy.this.startEmulation();
                        }
                    }
                    if (JSpeccy.this.tapeExtension.accept(file)) {
                        if (((JSpeccy)JSpeccy.this).spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3 && JSpeccy.this.settings.getTapeSettings().isAutoLoadTape() && JSpeccy.this.extractIF2RomMediaMenu.isEnabled()) {
                            JSpeccy.this.spectrum.ejectIF2Rom();
                            JSpeccy.this.insertIF2RomMediaMenu.setEnabled(true);
                            JSpeccy.this.extractIF2RomMediaMenu.setEnabled(false);
                        }
                        if (JSpeccy.this.tape.isTapeRunning()) {
                            JSpeccy.this.tape.stop();
                        }
                        JSpeccy.this.tape.eject();
                        if (JSpeccy.this.tape.insert(file)) {
                            JSpeccy.this.rotateRecentFile(file);
                            if (!JSpeccy.this.settings.getTapeSettings().isAutoLoadTape()) return true;
                            JSpeccy.this.spectrum.autoLoadTape();
                            return true;
                        }
                        bundle = ResourceBundle.getBundle("gui/Bundle");
                        JOptionPane.showMessageDialog(JSpeccy.this.getContentPane(), bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
                    }
                    if (JSpeccy.this.romExtension.accept(file)) {
                        if (JSpeccy.this.tape.isTapeRunning()) {
                            JSpeccy.this.tape.stop();
                        }
                        JSpeccy.this.stopEmulation();
                        if (JSpeccy.this.spectrum.getSpectrumModel() != MachineTypes.SPECTRUM48K) {
                            JSpeccy.this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM48K);
                        }
                        JSpeccy.this.spectrum.reset();
                        if (JSpeccy.this.spectrum.insertIF2Rom(file)) {
                            JSpeccy.this.insertIF2RomMediaMenu.setEnabled(false);
                            JSpeccy.this.extractIF2RomMediaMenu.setEnabled(true);
                        } else {
                            bundle = ResourceBundle.getBundle("gui/Bundle");
                            JOptionPane.showMessageDialog(JSpeccy.this.getContentPane(), bundle.getString("LOAD_ROM_ERROR"), bundle.getString("LOAD_ROM_ERROR_TITLE"), 0);
                        }
                        JSpeccy.this.startEmulation();
                        return true;
                    }
                    if (!JSpeccy.this.screenExtension.accept(file)) continue;
                    if (!JSpeccy.this.spectrum.loadScreen(file)) {
                        bundle = ResourceBundle.getBundle("gui/Bundle");
                        JOptionPane.showMessageDialog(JSpeccy.this.getContentPane(), bundle.getString("LOAD_SCREEN_ERROR"), bundle.getString("LOAD_SCREEN_ERROR_TITLE"), 0);
                    }
                    JSpeccy.this.spectrum.invalidateScreen(true);
                    return true;
                } while (!file.getName().toLowerCase().endsWith(".bin"));
                if (JSpeccy.this.loadSaveMemoryDialog == null) {
                    JSpeccy.this.loadSaveMemoryDialog = new LoadSaveMemoryDialog(JSpeccy.this.spectrum.getMemory());
                }
                JSpeccy.this.stopEmulation();
                JSpeccy.this.loadSaveMemoryDialog.showLoadDialog(JSpeccy.this.getContentPane(), file);
                JSpeccy.this.startEmulation();
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
    };
    private JMenu IF1MediaMenu;
    private JMenu IF2MediaMenu;
    private JMenuItem aboutHelpMenu;
    private JPanel addrValuePanel;
    private JSpinner addressSpinner;
    private JRadioButtonMenuItem bicubicZoom;
    private JRadioButtonMenuItem bilinearZoom;
    private ButtonGroup borderSizeButtonGroup;
    private JMenu borderSizeOptionMenu;
    private JMenuItem browserTapeMediaMenu;
    private JMenuItem clearTapeMediaMenu;
    private JButton closeKeyboardHelper;
    private JButton closePokeDialogButton;
    private JPanel closePokeDialogPanel;
    private JMenuItem createTapeMediaMenu;
    private JRadioButtonMenuItem cursorJoystick;
    private JCheckBoxMenuItem doubleSizeOption;
    private JToggleButton doubleSizeToggleButton;
    private JMenuItem ejectTapeMediaMenu;
    private JRadioButton embeddedRadioButton;
    private JMenuItem extractIF2RomMediaMenu;
    private JToggleButton fastEmulationToggleButton;
    private JMenu fileMenu;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private ButtonGroup filtersButtonGroup;
    private JMenu filtersOptionMenu;
    private JRadioButtonMenuItem fullBorder;
    private JRadioButtonMenuItem fullerJoystick;
    private JMenuItem hardResetMachineMenu;
    private JButton hardResetSpectrumButton;
    private ButtonGroup hardwareButtonGroup;
    private JMenu hardwareMachineMenu;
    private JMenu helpMenu;
    private JRadioButtonMenuItem hugeBorder;
    private JRadioButton ignoreRadioButton;
    private JMenuItem imageHelpMenu;
    private JMenuItem insertIF2RomMediaMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JSeparator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private ButtonGroup joystickButtonGroup;
    private JMenu joystickOptionMenu;
    private JRadioButtonMenuItem kempstonJoystick;
    private JDialog keyboardHelper;
    private JLabel keyboardImage;
    private JRadioButton linkedRadioButton;
    private JMenuItem loadBinaryFile;
    private JMenuItem loadMemorySnapshot;
    private JMenuItem loadScreenShot;
    private JMenu machineMenu;
    private JLabel mdrvLabel;
    private JMenu mediaMenu;
    private JMenuItem memoryBrowserMachineMenu;
    private JMenuItem microdrivesIF1MediaMenu;
    private JLabel modelLabel;
    private JMenuItem nmiMachineMenu;
    private JRadioButtonMenuItem noBorder;
    private JRadioButtonMenuItem noneFilter;
    private JRadioButtonMenuItem noneJoystick;
    private JMenuItem openSnapshot;
    private JButton openSnapshotButton;
    private JMenuItem openTapeMediaMenu;
    private JMenu optionsMenu;
    private JRadioButtonMenuItem palTvFilter;
    private JCheckBoxMenuItem pauseMachineMenu;
    private JToggleButton pauseToggleButton;
    private JMenuItem playTapeMediaMenu;
    private JLabel pokeAddress;
    private JButton pokeButton;
    private JDialog pokeDialog;
    private JMenuItem pokeMachineMenu;
    private JLabel pokeValue;
    private JMenuItem recentFileMenu0;
    private JMenuItem recentFileMenu1;
    private JMenuItem recentFileMenu2;
    private JMenuItem recentFileMenu3;
    private JMenuItem recentFileMenu4;
    private JMenu recentFilesMenu;
    private JMenuItem recordStartTapeMediaMenu;
    private JMenuItem recordStopTapeMediaMenu;
    private JMenuItem reloadTapeMediaMenu;
    private JMenuItem resetMachineMenu;
    private JButton resetSpectrumButton;
    private JMenuItem rewindTapeMediaMenu;
    private JRadioButtonMenuItem rgbFilter;
    private JMenuItem saveBinaryFile;
    private JMenuItem saveMemorySnapshot;
    private JMenuItem saveScreenShot;
    private JMenuItem saveSnapshot;
    private ButtonGroup saveSzxButtonGroup;
    private JPanel saveSzxChoosePanel;
    private JButton saveSzxCloseButton;
    private JDialog saveSzxTape;
    private JCheckBoxMenuItem scanlinesFilter;
    private JMenuItem settingsOptionsMenu;
    private JCheckBoxMenuItem silenceMachineMenu;
    private JToggleButton silenceSoundToggleButton;
    private JRadioButtonMenuItem sinclair1Joystick;
    private JRadioButtonMenuItem sinclair2Joystick;
    private JRadioButtonMenuItem spec128kHardware;
    private JRadioButtonMenuItem spec16kHardware;
    private JRadioButtonMenuItem spec48kHardware;
    private JRadioButtonMenuItem specPlus2AHardware;
    private JRadioButtonMenuItem specPlus2Hardware;
    private JRadioButtonMenuItem specPlus3Hardware;
    private JLabel speedLabel;
    private JRadioButtonMenuItem standardBorder;
    private JRadioButtonMenuItem standardZoom;
    private JPanel statusPanel;
    private JButton tapeBrowserButtonEject;
    private JButton tapeBrowserButtonPlay;
    private JButton tapeBrowserButtonRec;
    private JButton tapeBrowserButtonRew;
    private JButton tapeBrowserButtonStop;
    private JDialog tapeBrowserDialog;
    private JToolBar tapeBrowserToolbar;
    private JTable tapeCatalog;
    private JLabel tapeFilename;
    private JLabel tapeFilenameLabel;
    private JLabel tapeLabel;
    private JMenu tapeMediaMenu;
    private JLabel tapeMessageInfo;
    private JMenuItem thisIsTheEndMyFriend;
    private JToolBar toolbarMenu;
    private JSpinner valueSpinner;
    private ButtonGroup zoomMethodButtonGroup;
    private JMenu zoomMethodOptionMenu;

    public JSpeccy(String[] args) {
        if (UIManager.getLookAndFeel().getName().equals("Metal")) {
            try {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                UIManager.setLookAndFeel(new MetalLookAndFeel());
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.readSettingsFile();
        if (args.length > 0) {
            if (!this.readArguments(args)) {
                System.exit(1);
            }
            if (args.length > 1 || this.clo.getArguments().size() != 1) {
                this.clo.copyArgumentsToSettings();
            }
        }
        this.initComponents();
        this.setTransferHandler(this.handler);
        this.initEmulator();
        if (this.clo != null) {
            if (this.clo.isIf1() && this.clo.getIf1mdv() != null) {
                this.spectrum.getInterface1().insertFile(0, this.clo.getIf1mdv());
            }
            if (this.clo.getArguments().size() == 1) {
                ResourceBundle bundle;
                File file = new File(this.clo.getArguments().get(0));
                if (this.snapshotExtension.accept(file)) {
                    this.rotateRecentFile(file);
                    try {
                        SnapshotFile snap = SnapshotFactory.getSnapshot(file);
                        SpectrumState snapState = snap.load(file);
                        if (snap instanceof SnapshotSZX) {
                            File tapeLink;
                            SnapshotSZX snapSZX = (SnapshotSZX)snap;
                            if (snapSZX.isTapeEmbedded()) {
                                this.tape.eject();
                                this.tape.insertEmbeddedTape(snapSZX.getTapeName(), snapSZX.getTapeExtension(), snapSZX.getTapeData(), snapSZX.getTapeBlock());
                            }
                            if (snapSZX.isTapeLinked() && (tapeLink = new File(snapSZX.getTapeName())).exists()) {
                                this.tape.eject();
                                this.tape.insert(tapeLink);
                                this.tape.setSelectedBlock(snapSZX.getTapeBlock());
                            }
                        }
                        this.spectrum.setSpectrumState(snapState);
                    }
                    catch (SnapshotException excpt) {
                        JOptionPane.showMessageDialog(this.getContentPane(), ResourceBundle.getBundle("gui/Bundle").getString(excpt.getMessage()), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_LOAD_ERROR"), 0);
                    }
                }
                if (this.tapeExtension.accept(file)) {
                    if (this.tape.insert(file)) {
                        this.rotateRecentFile(file);
                        if (this.settings.getTapeSettings().isAutoLoadTape()) {
                            this.spectrum.autoLoadTape();
                        }
                    } else {
                        bundle = ResourceBundle.getBundle("gui/Bundle");
                        JOptionPane.showMessageDialog(this.getContentPane(), bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
                    }
                }
                if (this.romExtension.accept(file)) {
                    if (this.spectrum.getSpectrumModel().codeModel == MachineTypes.CodeModel.SPECTRUMPLUS3) {
                        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM48K);
                    }
                    if (this.spectrum.insertIF2Rom(file)) {
                        this.insertIF2RomMediaMenu.setEnabled(false);
                        this.extractIF2RomMediaMenu.setEnabled(true);
                        this.spectrum.reset();
                    } else {
                        bundle = ResourceBundle.getBundle("gui/Bundle");
                        JOptionPane.showMessageDialog(this.getContentPane(), bundle.getString("LOAD_ROM_ERROR"), bundle.getString("LOAD_ROM_ERROR_TITLE"), 0);
                    }
                }
            }
        }
        this.startEmulation();
    }

    private boolean readArguments(String[] args) {
        this.clo = new CommandLineOptions(this.settings);
        CmdLineParser parser = new CmdLineParser(this.clo);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.err));
        try {
            parser.parseArgument(args);
            if (this.clo.isPrintUsage()) {
                System.err.println(bundle.getString("JSpeccy.usage.sample.text"));
                System.err.println("");
                System.err.println(bundle.getString("JSpeccy.usage.header.text"));
                parser.printUsage(out, bundle);
                return false;
            }
            return true;
        }
        catch (CmdLineException excpt) {
            System.err.println(excpt.getMessage());
            System.err.println(bundle.getString("JSpeccy.usage.sample.text"));
            System.err.println("");
            System.err.println(bundle.getString("JSpeccy.usage.header.text"));
            parser.printUsage(out, bundle);
            System.err.println();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConfigFile(boolean deleteFile) {
        File file = new File(System.getProperty("user.home") + "/JSpeccy.xml");
        if (file.exists() && !deleteFile) {
            return;
        }
        if (deleteFile && !file.delete()) {
            System.out.println("Can't delete the bad JSpeccy.xml");
        }
        InputStream input = null;
        FilterOutputStream output = null;
        try {
            input = Spectrum.class.getResourceAsStream("/schema/JSpeccy.xml");
            output = new BufferedOutputStream(new FileOutputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
            byte[] fileConf = new byte[input.available()];
            input.read(fileConf);
            ((BufferedOutputStream)output).write(fileConf, 0, fileConf.length);
        }
        catch (FileNotFoundException notFoundExcpt) {
            Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, notFoundExcpt);
        }
        catch (IOException ioExcpt) {
            Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, ioExcpt);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void readSettingsFile() {
        JAXBElement settingsElement;
        Unmarshaller unmsh;
        JAXBContext jc;
        this.verifyConfigFile(false);
        boolean readed = true;
        try {
            jc = JAXBContext.newInstance((String)"configuration");
            unmsh = jc.createUnmarshaller();
            settingsElement = (JAXBElement)unmsh.unmarshal((InputStream)new FileInputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
            this.settings = (JSpeccySettingsType)settingsElement.getValue();
        }
        catch (JAXBException jexcpt) {
            System.out.println("Something during unmarshalling go very bad!");
            readed = false;
        }
        catch (FileNotFoundException ioexcpt) {
            System.out.println("Can't open the JSpeccy.xml configuration file");
        }
        if (readed) {
            return;
        }
        System.out.println("Trying to create a new one JSpeccy.xml for you");
        this.verifyConfigFile(true);
        try {
            jc = JAXBContext.newInstance((String)"configuration");
            unmsh = jc.createUnmarshaller();
            settingsElement = (JAXBElement)unmsh.unmarshal((InputStream)new FileInputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
            this.settings = (JSpeccySettingsType)settingsElement.getValue();
        }
        catch (JAXBException jexcpt) {
            System.out.println("Something go very very badly with unmarshalling!");
        }
        catch (FileNotFoundException ioexcpt) {
            System.out.println("Can't open the JSpeccy.xml configuration file anyway");
            System.exit(0);
        }
    }

    private void saveRecentFiles() {
        if (!this.settings.getEmulatorSettings().isAutosaveConfigOnExit()) {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"configuration");
                Unmarshaller unmsh = jc.createUnmarshaller();
                JAXBElement settingsElement = (JAXBElement)unmsh.unmarshal((InputStream)new FileInputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
                this.settings = (JSpeccySettingsType)settingsElement.getValue();
            }
            catch (JAXBException jexcpt) {
                System.out.println("Something during unmarshalling go very bad!");
            }
            catch (FileNotFoundException ioexcpt) {
                System.out.println("Can't open the JSpeccy.xml configuration file");
            }
        }
        if (this.recentFile[0] != null) {
            this.settings.getRecentFilesSettings().setRecentFile0(this.recentFile[0].getAbsolutePath());
        }
        if (this.recentFile[1] != null) {
            this.settings.getRecentFilesSettings().setRecentFile1(this.recentFile[1].getAbsolutePath());
        }
        if (this.recentFile[2] != null) {
            this.settings.getRecentFilesSettings().setRecentFile2(this.recentFile[2].getAbsolutePath());
        }
        if (this.recentFile[3] != null) {
            this.settings.getRecentFilesSettings().setRecentFile3(this.recentFile[3].getAbsolutePath());
        }
        if (this.recentFile[4] != null) {
            this.settings.getRecentFilesSettings().setRecentFile4(this.recentFile[4].getAbsolutePath());
        }
        if (this.currentFileSnapshot != null) {
            this.settings.getRecentFilesSettings().setLastSnapshotDir(this.currentFileSnapshot.getParent());
        }
        if (this.currentFileTape != null) {
            this.settings.getRecentFilesSettings().setLastTapeDir(this.currentFileTape.getParent());
        }
        if (this.clo == null) {
            int filterM = 0;
            int zoomM = 0;
            if (this.palTvFilter.isSelected()) {
                filterM = 1;
            }
            if (this.rgbFilter.isSelected()) {
                filterM = 2;
            }
            if (this.bilinearZoom.isSelected()) {
                zoomM = 1;
            }
            if (this.bicubicZoom.isSelected()) {
                zoomM = 2;
            }
            this.settings.getSpectrumSettings().setZoomMethod(zoomM);
            this.settings.getSpectrumSettings().setFilterMethod(filterM);
            this.settings.getSpectrumSettings().setScanLines(this.scanlinesFilter.isSelected());
            this.settings.getSpectrumSettings().setBorderSize(this.jscr.getBorderMode());
            this.settings.getSpectrumSettings().setZoomed(this.jscr.isZoomed());
        }
        try {
            BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(System.getProperty("user.home") + "/JSpeccy.xml"));
            JAXBElement<JSpeccySettingsType> confElement = new ObjectFactory().createJSpeccySettings(this.settings);
            JAXB.marshal(confElement, (OutputStream)fOut);
            try {
                fOut.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initEmulator() {
        File autoload;
        int zoom;
        this.spectrum = new Spectrum(this.settings);
        this.spectrum.selectHardwareModel(this.settings.getSpectrumSettings().getDefaultModel());
        this.spectrum.setJoystick(this.settings.getKeyboardJoystickSettings().getJoystickModel());
        this.spectrum.setBorderMode(this.settings.getSpectrumSettings().getBorderSize());
        this.spectrum.loadConfigVars();
        this.tape = new Tape(this.settings.getTapeSettings());
        this.spectrum.setTape(this.tape);
        this.jscr = new JSpeccyScreen();
        this.spectrum.setScreenComponent(this.jscr);
        this.jscr.setTvImage(this.spectrum.getTvImage());
        this.jscr.setBorderMode(this.settings.getSpectrumSettings().getBorderSize());
        this.spectrum.setSpeedLabel(this.speedLabel);
        this.tapeCatalog.setModel(this.tape.getTapeTableModel());
        this.tapeCatalog.getColumnModel().getColumn(0).setMaxWidth(150);
        this.lsm = this.tapeCatalog.getSelectionModel();
        this.lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && event.getLastIndex() != -1) {
                    JSpeccy.this.tape.setSelectedBlock(JSpeccy.this.lsm.getLeadSelectionIndex());
                }
            }
        });
        this.tape.addTapeChangedListener(new TapeChangedListener());
        this.tape.addTapeBlockListener(new TapeBlockListener(){

            @Override
            public void blockChanged(int block) {
                JSpeccy.this.lsm.setSelectionInterval(block, block);
            }
        });
        this.spectrum.getInterface1().addInterface1DriveListener(new Interface1DriveListener(){

            @Override
            public void driveSelected(int unit) {
                if (unit == 0) {
                    JSpeccy.this.mdrvLabel.setIcon(JSpeccy.this.mdrOff);
                    JSpeccy.this.mdrvLabel.setToolTipText(ResourceBundle.getBundle("gui/Bundle").getString("MICRODRIVES_STOPPED"));
                } else {
                    JSpeccy.this.mdrvLabel.setIcon(JSpeccy.this.mdrOn);
                    JSpeccy.this.mdrvLabel.setToolTipText(String.format(ResourceBundle.getBundle("gui/Bundle").getString("MICRODRIVE_RUNNING"), unit));
                }
            }

            @Override
            public void driveModified(int drive) {
            }
        });
        this.getContentPane().add((Component)this.jscr, "Center");
        this.pack();
        this.addKeyListener(this.spectrum.getKeyboard());
        if (this.settings.getSpectrumSettings().isMutedSound()) {
            this.silenceMachineMenu.setSelected(true);
            this.silenceSoundToggleButton.setSelected(true);
        }
        if ((zoom = this.settings.getSpectrumSettings().getZoom()) < 2 || zoom > 4) {
            zoom = 2;
            this.settings.getSpectrumSettings().setZoom(zoom);
        }
        if (this.settings.getSpectrumSettings().isZoomed()) {
            this.jscr.setZoom(zoom);
            this.doubleSizeOption.setSelected(true);
            this.doubleSizeToggleButton.setSelected(true);
        } else {
            this.jscr.setZoom(1);
            this.doubleSizeOption.setSelected(false);
            this.doubleSizeToggleButton.setSelected(false);
        }
        this.pack();
        if (this.settings.getRecentFilesSettings().getRecentFile0() != null && !this.settings.getRecentFilesSettings().getRecentFile0().isEmpty()) {
            this.recentFile[0] = new File(this.settings.getRecentFilesSettings().getRecentFile0());
            this.recentFileMenu0.setText(this.recentFile[0].getName());
            this.recentFileMenu0.setToolTipText(this.recentFile[0].getAbsolutePath());
            this.recentFileMenu0.setEnabled(true);
        }
        if (this.settings.getRecentFilesSettings().getRecentFile1() != null && !this.settings.getRecentFilesSettings().getRecentFile1().isEmpty()) {
            this.recentFile[1] = new File(this.settings.getRecentFilesSettings().getRecentFile1());
            this.recentFileMenu1.setText(this.recentFile[1].getName());
            this.recentFileMenu1.setToolTipText(this.recentFile[1].getAbsolutePath());
            this.recentFileMenu1.setEnabled(true);
        }
        if (this.settings.getRecentFilesSettings().getRecentFile2() != null && !this.settings.getRecentFilesSettings().getRecentFile2().isEmpty()) {
            this.recentFile[2] = new File(this.settings.getRecentFilesSettings().getRecentFile2());
            this.recentFileMenu2.setText(this.recentFile[2].getName());
            this.recentFileMenu2.setToolTipText(this.recentFile[2].getAbsolutePath());
            this.recentFileMenu2.setEnabled(true);
        }
        if (this.settings.getRecentFilesSettings().getRecentFile3() != null && !this.settings.getRecentFilesSettings().getRecentFile3().isEmpty()) {
            this.recentFile[3] = new File(this.settings.getRecentFilesSettings().getRecentFile3());
            this.recentFileMenu3.setText(this.recentFile[3].getName());
            this.recentFileMenu3.setToolTipText(this.recentFile[3].getAbsolutePath());
            this.recentFileMenu3.setEnabled(true);
        }
        if (this.settings.getRecentFilesSettings().getRecentFile4() != null && !this.settings.getRecentFilesSettings().getRecentFile4().isEmpty()) {
            this.recentFile[4] = new File(this.settings.getRecentFilesSettings().getRecentFile4());
            this.recentFileMenu4.setText(this.recentFile[4].getName());
            this.recentFileMenu4.setToolTipText(this.recentFile[4].getAbsolutePath());
            this.recentFileMenu4.setEnabled(true);
        }
        this.settingsDialog = new SettingsDialog(this.settings);
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.allSnapTapeExtension = new FileNameExtensionFilter(bundle.getString("SNAPSHOT_TAPE_TYPE"), "sna", "z80", "szx", "sp", "tap", "tzx", "csw");
        this.snapshotExtension = new FileNameExtensionFilter(bundle.getString("SNAPSHOT_TYPE"), "sna", "z80", "szx", "sp");
        this.saveSnapshotExtension = new FileNameExtensionFilter(bundle.getString("SAVE_SNAPSHOT_TYPE"), "sna", "z80", "szx");
        this.tapeExtension = new FileNameExtensionFilter(bundle.getString("TAPE_TYPE"), "tap", "tzx", "csw");
        this.createTapeExtension = new FileNameExtensionFilter(bundle.getString("SAVE_TAPE_TYPE"), "tap", "tzx");
        this.imageExtension = new FileNameExtensionFilter(bundle.getString("IMAGE_TYPE"), "scr", "png");
        this.screenExtension = new FileNameExtensionFilter(bundle.getString("SCR_TYPE"), "scr");
        this.romExtension = new FileNameExtensionFilter(bundle.getString("ROM_TYPE"), "rom");
        if (this.settings.getSpectrumSettings().isHibernateMode() && (autoload = new File(System.getProperty("user.home") + "/JSpeccy.szx")).exists()) {
            SnapshotSZX snapSZX = new SnapshotSZX();
            try {
                File tapeLink;
                this.spectrum.setSpectrumState(snapSZX.load(autoload));
                if (snapSZX.isTapeLinked() && (tapeLink = new File(snapSZX.getTapeName())).exists()) {
                    this.tape.eject();
                    this.tape.insert(tapeLink);
                    this.tape.setSelectedBlock(snapSZX.getTapeBlock());
                }
            }
            catch (SnapshotException ex) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("gui/Bundle").getString("HIBERNATE_IMAGE_ERROR"), ResourceBundle.getBundle("gui/Bundle").getString("HIBERNATE_LOAD_ERROR"), 0);
            }
        }
        switch (this.settings.getSpectrumSettings().getZoomMethod()) {
            case 1: {
                this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                this.bilinearZoom.setSelected(true);
                break;
            }
            case 2: {
                this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                this.bicubicZoom.setSelected(true);
                break;
            }
            default: {
                this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                this.standardZoom.setSelected(true);
            }
        }
        this.jscr.setScanlinesFilter(this.settings.getSpectrumSettings().isScanLines());
        this.scanlinesFilter.setSelected(this.settings.getSpectrumSettings().isScanLines());
        switch (this.settings.getSpectrumSettings().getFilterMethod()) {
            case 1: {
                this.jscr.setPalFilter(true);
                this.palTvFilter.setSelected(true);
                break;
            }
            case 2: {
                this.jscr.setRgbFilter(true);
                this.rgbFilter.setSelected(true);
                this.scanlinesFilter.setEnabled(false);
                break;
            }
            default: {
                this.jscr.setAnyFilter(this.settings.getSpectrumSettings().isScanLines());
                this.noneFilter.setSelected(true);
            }
        }
        this.updateGuiSelections();
        new Thread((Runnable)this.spectrum, "SpectrumThread").start();
    }

    private void exitEmulator() {
        int ret;
        int dialogType;
        String msg;
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.stopEmulation();
        if (this.spectrum.getInterface1().hasDirtyCartridges()) {
            msg = bundle.getString("DIRTY_CARTRIDGES_WARNING");
            dialogType = 2;
        } else {
            msg = bundle.getString("ARE_YOU_SURE_QUESTION");
            dialogType = 3;
        }
        if ((this.settings.getEmulatorSettings().isConfirmActions() || dialogType == 2) && (ret = JOptionPane.showConfirmDialog(this.getContentPane(), msg, bundle.getString("QUIT_JSPECCY"), 2, dialogType)) == 2) {
            this.startEmulation();
            return;
        }
        if (this.tape.isTapeRunning()) {
            this.tape.stop();
        }
        if (this.settings.getSpectrumSettings().isHibernateMode()) {
            SnapshotSZX snapSZX = new SnapshotSZX();
            if (this.tape.getTapeFilename() != null) {
                snapSZX.setTapeLinked(true);
                snapSZX.setTapeName(this.tape.getTapeFilename().getAbsolutePath());
                snapSZX.setTapeBlock(this.tape.getSelectedBlock());
            }
            try {
                snapSZX.save(new File(System.getProperty("user.home") + "/JSpeccy.szx"), this.spectrum.getSpectrumState());
            }
            catch (SnapshotException ex) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("gui/Bundle").getString("HIBERNATE_SAVE_ERROR"), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_SAVE_ERROR"), 0);
            }
        }
        this.saveRecentFiles();
        this.dispose();
        System.exit(0);
    }

    private void rotateRecentFile(File lastname) {
        for (int idx = 0; idx < 5; ++idx) {
            if (this.recentFile[idx] == null || !lastname.getAbsolutePath().equals(this.recentFile[idx].getAbsolutePath())) continue;
            return;
        }
        this.recentFile[4] = this.recentFile[3];
        this.recentFile[3] = this.recentFile[2];
        this.recentFile[2] = this.recentFile[1];
        this.recentFile[1] = this.recentFile[0];
        this.recentFile[0] = lastname;
        if (this.recentFile[0] != null && !this.recentFile[0].getName().isEmpty()) {
            this.recentFileMenu0.setText(this.recentFile[0].getName());
            this.recentFileMenu0.setToolTipText(this.recentFile[0].getAbsolutePath());
            this.recentFileMenu0.setEnabled(true);
            this.settings.getRecentFilesSettings().setRecentFile0(this.recentFile[0].getAbsolutePath());
        }
        if (this.recentFile[1] != null && !this.recentFile[1].getName().isEmpty()) {
            this.recentFileMenu1.setText(this.recentFile[1].getName());
            this.recentFileMenu1.setToolTipText(this.recentFile[1].getAbsolutePath());
            this.recentFileMenu1.setEnabled(true);
            this.settings.getRecentFilesSettings().setRecentFile1(this.recentFile[1].getAbsolutePath());
        }
        if (this.recentFile[2] != null && !this.recentFile[2].getName().isEmpty()) {
            this.recentFileMenu2.setText(this.recentFile[2].getName());
            this.recentFileMenu2.setToolTipText(this.recentFile[2].getAbsolutePath());
            this.recentFileMenu2.setEnabled(true);
            this.settings.getRecentFilesSettings().setRecentFile2(this.recentFile[2].getAbsolutePath());
        }
        if (this.recentFile[3] != null && !this.recentFile[3].getName().isEmpty()) {
            this.recentFileMenu3.setText(this.recentFile[3].getName());
            this.recentFileMenu3.setToolTipText(this.recentFile[3].getAbsolutePath());
            this.recentFileMenu3.setEnabled(true);
            this.settings.getRecentFilesSettings().setRecentFile3(this.recentFile[3].getAbsolutePath());
        }
        if (this.recentFile[4] != null && !this.recentFile[4].getName().isEmpty()) {
            this.recentFileMenu4.setText(this.recentFile[4].getName());
            this.recentFileMenu4.setToolTipText(this.recentFile[4].getAbsolutePath());
            this.recentFileMenu4.setEnabled(true);
            this.settings.getRecentFilesSettings().setRecentFile4(this.recentFile[4].getAbsolutePath());
        }
    }

    private void updateGuiSelections() {
        if (this.spectrum.getSpectrumModel().codeModel != MachineTypes.CodeModel.SPECTRUMPLUS3) {
            if (this.settings.getInterface1Settings().isConnectedIF1()) {
                this.IF1MediaMenu.setEnabled(true);
                this.mdrvLabel.setEnabled(true);
                this.mdrvLabel.setIcon(this.mdrOff);
                this.mdrvLabel.setToolTipText(ResourceBundle.getBundle("gui/Bundle").getString("MICRODRIVES_STOPPED"));
            } else {
                this.IF1MediaMenu.setEnabled(false);
                this.mdrvLabel.setEnabled(false);
                this.mdrvLabel.setToolTipText(null);
            }
            this.IF2MediaMenu.setEnabled(true);
            this.insertIF2RomMediaMenu.setEnabled(!this.spectrum.isIF2RomInserted());
            this.extractIF2RomMediaMenu.setEnabled(this.spectrum.isIF2RomInserted());
        } else {
            this.IF1MediaMenu.setEnabled(false);
            this.IF2MediaMenu.setEnabled(false);
            this.mdrvLabel.setEnabled(false);
            this.mdrvLabel.setToolTipText(null);
        }
        switch (this.spectrum.getSpectrumModel()) {
            case SPECTRUM16K: {
                this.spec16kHardware.setSelected(true);
                break;
            }
            case SPECTRUM48K: {
                this.spec48kHardware.setSelected(true);
                break;
            }
            case SPECTRUM128K: {
                this.spec128kHardware.setSelected(true);
                break;
            }
            case SPECTRUMPLUS2: {
                this.specPlus2Hardware.setSelected(true);
                break;
            }
            case SPECTRUMPLUS2A: {
                this.specPlus2AHardware.setSelected(true);
                this.IF2MediaMenu.setEnabled(false);
                break;
            }
            case SPECTRUMPLUS3: {
                this.specPlus3Hardware.setSelected(true);
                this.IF2MediaMenu.setEnabled(false);
            }
        }
        this.modelLabel.setToolTipText(this.spectrum.getSpectrumModel().getLongModelName());
        this.modelLabel.setText(this.spectrum.getSpectrumModel().getShortModelName());
        switch (this.spectrum.getJoystick()) {
            case KEMPSTON: {
                this.kempstonJoystick.setSelected(true);
                break;
            }
            case SINCLAIR1: {
                this.sinclair1Joystick.setSelected(true);
                break;
            }
            case SINCLAIR2: {
                this.sinclair2Joystick.setSelected(true);
                break;
            }
            case CURSOR: {
                this.cursorJoystick.setSelected(true);
                break;
            }
            case FULLER: {
                this.fullerJoystick.setSelected(true);
                break;
            }
            default: {
                this.noneJoystick.setSelected(true);
            }
        }
        if (this.settings.getSpectrumSettings().isULAplus()) {
            if (this.jscr.isPalFilter()) {
                this.noneFilter.setSelected(true);
                this.jscr.setAnyFilter(false);
                this.scanlinesFilter.setEnabled(true);
                this.jscr.setScanlinesFilter(this.scanlinesFilter.isSelected());
                this.jscr.repaint();
            }
            this.palTvFilter.setEnabled(false);
        } else {
            this.palTvFilter.setEnabled(true);
        }
        switch (this.jscr.getBorderMode()) {
            case 0: {
                this.noBorder.setSelected(true);
                break;
            }
            case 2: {
                this.fullBorder.setSelected(true);
                break;
            }
            case 3: {
                this.hugeBorder.setSelected(true);
                break;
            }
            default: {
                this.standardBorder.setSelected(true);
            }
        }
    }

    private void startEmulation() {
        if (this.pauseToggleButton.isSelected()) {
            return;
        }
        this.speedLabel.setForeground(Color.black);
        this.updateGuiSelections();
        this.spectrum.startEmulation();
    }

    private void stopEmulation() {
        if (this.spectrum.isPaused()) {
            return;
        }
        this.spectrum.stopEmulation();
        this.speedLabel.setForeground(Color.red);
        this.speedLabel.setText("STOP");
        this.updateGuiSelections();
    }

    private void initComponents() {
        this.keyboardHelper = new JDialog(this);
        this.keyboardImage = new JLabel();
        this.closeKeyboardHelper = new JButton();
        this.joystickButtonGroup = new ButtonGroup();
        this.hardwareButtonGroup = new ButtonGroup();
        this.tapeBrowserDialog = new JDialog();
        this.jScrollPane1 = new JScrollPane();
        this.tapeCatalog = new JTable();
        this.jPanel2 = new JPanel();
        this.tapeBrowserToolbar = new JToolBar();
        this.tapeBrowserButtonRec = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.tapeBrowserButtonStop = new JButton();
        this.tapeBrowserButtonRew = new JButton();
        this.tapeBrowserButtonPlay = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.tapeBrowserButtonEject = new JButton();
        this.tapeFilename = new JLabel();
        this.saveSzxTape = new JDialog();
        this.jPanel4 = new JPanel();
        this.tapeMessageInfo = new JLabel();
        this.tapeFilenameLabel = new JLabel();
        this.saveSzxChoosePanel = new JPanel();
        this.ignoreRadioButton = new JRadioButton();
        this.linkedRadioButton = new JRadioButton();
        this.embeddedRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.saveSzxCloseButton = new JButton();
        this.filler5 = new Box.Filler(new Dimension(25, 25), new Dimension(25, 25), new Dimension(25, 25));
        this.saveSzxButtonGroup = new ButtonGroup();
        this.pokeDialog = new JDialog();
        this.addrValuePanel = new JPanel();
        this.pokeAddress = new JLabel();
        this.addressSpinner = new JSpinner();
        this.filler1 = new Box.Filler(new Dimension(20, 16), new Dimension(20, 16), new Dimension(20, 16));
        this.pokeValue = new JLabel();
        this.valueSpinner = new JSpinner();
        this.filler2 = new Box.Filler(new Dimension(20, 16), new Dimension(20, 16), new Dimension(20, 16));
        this.pokeButton = new JButton();
        this.closePokeDialogPanel = new JPanel();
        this.closePokeDialogButton = new JButton();
        this.filtersButtonGroup = new ButtonGroup();
        this.zoomMethodButtonGroup = new ButtonGroup();
        this.borderSizeButtonGroup = new ButtonGroup();
        this.statusPanel = new JPanel();
        this.modelLabel = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.mdrvLabel = new JLabel();
        this.jSeparator10 = new JSeparator();
        this.tapeLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.speedLabel = new JLabel();
        this.toolbarMenu = new JToolBar();
        this.openSnapshotButton = new JButton();
        this.pauseToggleButton = new JToggleButton();
        this.fastEmulationToggleButton = new JToggleButton();
        this.doubleSizeToggleButton = new JToggleButton();
        this.silenceSoundToggleButton = new JToggleButton();
        this.resetSpectrumButton = new JButton();
        this.hardResetSpectrumButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openSnapshot = new JMenuItem();
        this.saveSnapshot = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.loadMemorySnapshot = new JMenuItem();
        this.saveMemorySnapshot = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.loadBinaryFile = new JMenuItem();
        this.saveBinaryFile = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.loadScreenShot = new JMenuItem();
        this.saveScreenShot = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.recentFilesMenu = new JMenu();
        this.recentFileMenu0 = new JMenuItem();
        this.recentFileMenu1 = new JMenuItem();
        this.recentFileMenu2 = new JMenuItem();
        this.recentFileMenu3 = new JMenuItem();
        this.recentFileMenu4 = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.thisIsTheEndMyFriend = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.doubleSizeOption = new JCheckBoxMenuItem();
        this.zoomMethodOptionMenu = new JMenu();
        this.standardZoom = new JRadioButtonMenuItem();
        this.bilinearZoom = new JRadioButtonMenuItem();
        this.bicubicZoom = new JRadioButtonMenuItem();
        this.borderSizeOptionMenu = new JMenu();
        this.noBorder = new JRadioButtonMenuItem();
        this.standardBorder = new JRadioButtonMenuItem();
        this.fullBorder = new JRadioButtonMenuItem();
        this.hugeBorder = new JRadioButtonMenuItem();
        this.filtersOptionMenu = new JMenu();
        this.noneFilter = new JRadioButtonMenuItem();
        this.palTvFilter = new JRadioButtonMenuItem();
        this.rgbFilter = new JRadioButtonMenuItem();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.scanlinesFilter = new JCheckBoxMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.joystickOptionMenu = new JMenu();
        this.noneJoystick = new JRadioButtonMenuItem();
        this.kempstonJoystick = new JRadioButtonMenuItem();
        this.sinclair1Joystick = new JRadioButtonMenuItem();
        this.sinclair2Joystick = new JRadioButtonMenuItem();
        this.cursorJoystick = new JRadioButtonMenuItem();
        this.fullerJoystick = new JRadioButtonMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.settingsOptionsMenu = new JMenuItem();
        this.machineMenu = new JMenu();
        this.pauseMachineMenu = new JCheckBoxMenuItem();
        this.silenceMachineMenu = new JCheckBoxMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.resetMachineMenu = new JMenuItem();
        this.hardResetMachineMenu = new JMenuItem();
        this.nmiMachineMenu = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.pokeMachineMenu = new JMenuItem();
        this.memoryBrowserMachineMenu = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.hardwareMachineMenu = new JMenu();
        this.spec16kHardware = new JRadioButtonMenuItem();
        this.spec48kHardware = new JRadioButtonMenuItem();
        this.spec128kHardware = new JRadioButtonMenuItem();
        this.specPlus2Hardware = new JRadioButtonMenuItem();
        this.specPlus2AHardware = new JRadioButtonMenuItem();
        this.specPlus3Hardware = new JRadioButtonMenuItem();
        this.mediaMenu = new JMenu();
        this.tapeMediaMenu = new JMenu();
        this.openTapeMediaMenu = new JMenuItem();
        this.playTapeMediaMenu = new JMenuItem();
        this.browserTapeMediaMenu = new JMenuItem();
        this.rewindTapeMediaMenu = new JMenuItem();
        this.ejectTapeMediaMenu = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.createTapeMediaMenu = new JMenuItem();
        this.clearTapeMediaMenu = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.recordStartTapeMediaMenu = new JMenuItem();
        this.recordStopTapeMediaMenu = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.reloadTapeMediaMenu = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.IF1MediaMenu = new JMenu();
        this.microdrivesIF1MediaMenu = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.IF2MediaMenu = new JMenu();
        this.insertIF2RomMediaMenu = new JMenuItem();
        this.extractIF2RomMediaMenu = new JMenuItem();
        this.helpMenu = new JMenu();
        this.imageHelpMenu = new JMenuItem();
        this.aboutHelpMenu = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.keyboardHelper.setTitle(bundle.getString("JSpeccy.keyboardHelper.title"));
        this.keyboardImage.setIcon(new ImageIcon(this.getClass().getResource("/icons/Keyboard48k.png")));
        this.keyboardImage.setText(bundle.getString("JSpeccy.keyboardImage.text"));
        this.keyboardHelper.getContentPane().add((Component)this.keyboardImage, "First");
        this.closeKeyboardHelper.setText(bundle.getString("JSpeccy.closeKeyboardHelper.text"));
        this.closeKeyboardHelper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.closeKeyboardHelperActionPerformed(evt);
            }
        });
        this.keyboardHelper.getContentPane().add((Component)this.closeKeyboardHelper, "Last");
        this.tapeBrowserDialog.setTitle(bundle.getString("JSpeccy.tapeBrowserDialog.title"));
        this.tapeCatalog.setModel(new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"Block Number", "Block Type", "Block information"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tapeCatalog.setAutoResizeMode(3);
        this.tapeCatalog.setSelectionMode(0);
        this.tapeCatalog.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tapeCatalog);
        this.tapeCatalog.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.tapeCatalog.getColumnModel().getColumnCount() > 0) {
            this.tapeCatalog.getColumnModel().getColumn(0).setResizable(false);
            this.tapeCatalog.getColumnModel().getColumn(0).setHeaderValue(bundle.getString("JSpeccy.tapeCatalog.columnModel.title0"));
            this.tapeCatalog.getColumnModel().getColumn(1).setHeaderValue(bundle.getString("JSpeccy.tapeCatalog.columnModel.title1"));
            this.tapeCatalog.getColumnModel().getColumn(2).setHeaderValue(bundle.getString("JSpeccy.tapeCatalog.columnModel.title2"));
        }
        this.tapeBrowserDialog.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.tapeBrowserToolbar.setRollover(true);
        this.tapeBrowserButtonRec.setIcon(new ImageIcon(this.getClass().getResource("/icons/32x32/player-rec.png")));
        this.tapeBrowserButtonRec.setText(bundle.getString("JSpeccy.tapeBrowserButtonRec.text"));
        this.tapeBrowserButtonRec.setToolTipText(bundle.getString("JSpeccy.tapeBrowserButtonRec.tooltip.text"));
        this.tapeBrowserButtonRec.setEnabled(false);
        this.tapeBrowserButtonRec.setFocusable(false);
        this.tapeBrowserButtonRec.setHorizontalTextPosition(0);
        this.tapeBrowserButtonRec.setVerticalTextPosition(3);
        this.tapeBrowserButtonRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recordStartTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeBrowserToolbar.add(this.tapeBrowserButtonRec);
        this.jSeparator11.setSeparatorSize(new Dimension(25, 10));
        this.tapeBrowserToolbar.add(this.jSeparator11);
        this.tapeBrowserButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/icons/32x32/player_stop.png")));
        this.tapeBrowserButtonStop.setText(bundle.getString("JSpeccy.tapeBrowserButtonStop.text"));
        this.tapeBrowserButtonStop.setToolTipText(bundle.getString("JSpeccy.tapeBrowserButtonStop.tooltip.text"));
        this.tapeBrowserButtonStop.setEnabled(false);
        this.tapeBrowserButtonStop.setFocusable(false);
        this.tapeBrowserButtonStop.setHorizontalTextPosition(0);
        this.tapeBrowserButtonStop.setVerticalTextPosition(3);
        this.tapeBrowserButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.tapeBrowserButtonStopActionPerformed(evt);
            }
        });
        this.tapeBrowserToolbar.add(this.tapeBrowserButtonStop);
        this.tapeBrowserButtonRew.setIcon(new ImageIcon(this.getClass().getResource("/icons/32x32/player_rew.png")));
        this.tapeBrowserButtonRew.setText(bundle.getString("JSpeccy.tapeBrowserButtonRew.text"));
        this.tapeBrowserButtonRew.setToolTipText(bundle.getString("JSpeccy.tapeBrowserButtonRew.tooltip.text"));
        this.tapeBrowserButtonRew.setEnabled(false);
        this.tapeBrowserButtonRew.setFocusable(false);
        this.tapeBrowserButtonRew.setHorizontalTextPosition(0);
        this.tapeBrowserButtonRew.setVerticalTextPosition(3);
        this.tapeBrowserButtonRew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.rewindTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeBrowserToolbar.add(this.tapeBrowserButtonRew);
        this.tapeBrowserButtonPlay.setIcon(new ImageIcon(this.getClass().getResource("/icons/32x32/player_play.png")));
        this.tapeBrowserButtonPlay.setText(bundle.getString("JSpeccy.tapeBrowserButtonPlay.text"));
        this.tapeBrowserButtonPlay.setToolTipText(bundle.getString("JSpeccy.tapeBrowserButtonPlay.tooltip.text"));
        this.tapeBrowserButtonPlay.setEnabled(false);
        this.tapeBrowserButtonPlay.setFocusable(false);
        this.tapeBrowserButtonPlay.setHorizontalTextPosition(0);
        this.tapeBrowserButtonPlay.setVerticalTextPosition(3);
        this.tapeBrowserButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.tapeBrowserButtonPlayActionPerformed(evt);
            }
        });
        this.tapeBrowserToolbar.add(this.tapeBrowserButtonPlay);
        this.jSeparator12.setSeparatorSize(new Dimension(25, 10));
        this.tapeBrowserToolbar.add(this.jSeparator12);
        this.tapeBrowserButtonEject.setIcon(new ImageIcon(this.getClass().getResource("/icons/32x32/player_eject.png")));
        this.tapeBrowserButtonEject.setText(bundle.getString("JSpeccy.tapeBrowserButtonEject.text"));
        this.tapeBrowserButtonEject.setToolTipText(bundle.getString("JSpeccy.tapeBrowserButtonEject.tooltip.text"));
        this.tapeBrowserButtonEject.setEnabled(false);
        this.tapeBrowserButtonEject.setFocusable(false);
        this.tapeBrowserButtonEject.setHorizontalTextPosition(0);
        this.tapeBrowserButtonEject.setVerticalTextPosition(3);
        this.tapeBrowserButtonEject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.tapeBrowserButtonEjectActionPerformed(evt);
            }
        });
        this.tapeBrowserToolbar.add(this.tapeBrowserButtonEject);
        this.jPanel2.add(this.tapeBrowserToolbar);
        this.tapeBrowserDialog.getContentPane().add((Component)this.jPanel2, "Last");
        this.tapeFilename.setHorizontalAlignment(0);
        this.tapeFilename.setText(bundle.getString("JSpeccy.tapeFilename.text"));
        this.tapeBrowserDialog.getContentPane().add((Component)this.tapeFilename, "First");
        this.saveSzxTape.setTitle(bundle.getString("JSpeccy.saveSzxTapeDialog.title.text"));
        this.saveSzxTape.setModal(true);
        this.jPanel4.setLayout(new GridLayout(3, 0, 5, 5));
        this.tapeMessageInfo.setHorizontalAlignment(0);
        this.tapeMessageInfo.setText(bundle.getString("JSpeccy.tapeMessageInfo.text"));
        this.jPanel4.add(this.tapeMessageInfo);
        this.tapeFilenameLabel.setForeground(new Color(204, 0, 0));
        this.tapeFilenameLabel.setHorizontalAlignment(0);
        this.jPanel4.add(this.tapeFilenameLabel);
        this.saveSzxChoosePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("JSpeccy.saveSzxChoosePanel.title")));
        this.saveSzxButtonGroup.add(this.ignoreRadioButton);
        this.ignoreRadioButton.setSelected(true);
        this.ignoreRadioButton.setText(bundle.getString("JSpeccy.ignoreRadioButton.text"));
        this.saveSzxChoosePanel.add(this.ignoreRadioButton);
        this.saveSzxButtonGroup.add(this.linkedRadioButton);
        this.linkedRadioButton.setText(bundle.getString("JSpeccy.linkedRadioButton.text"));
        this.saveSzxChoosePanel.add(this.linkedRadioButton);
        this.saveSzxButtonGroup.add(this.embeddedRadioButton);
        this.embeddedRadioButton.setText(bundle.getString("JSpeccy.embeddedRadioButton.text"));
        this.saveSzxChoosePanel.add(this.embeddedRadioButton);
        this.jPanel4.add(this.saveSzxChoosePanel);
        this.saveSzxTape.getContentPane().add((Component)this.jPanel4, "Center");
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.jPanel3.add(this.filler4);
        this.saveSzxCloseButton.setText(bundle.getString("JSpeccy.saveSzxCloseButton.text"));
        this.saveSzxCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.saveSzxCloseButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.saveSzxCloseButton);
        this.jPanel3.add(this.filler5);
        this.saveSzxTape.getContentPane().add((Component)this.jPanel3, "Last");
        this.pokeDialog.setTitle(bundle.getString("JSpecy.pokeDialog.title.text"));
        this.pokeDialog.getContentPane().setLayout(new BoxLayout(this.pokeDialog.getContentPane(), 3));
        this.pokeAddress.setText(bundle.getString("JSpeccy.pokeAddress.text"));
        this.addrValuePanel.add(this.pokeAddress);
        this.addressSpinner.setModel(new SpinnerNumberModel(23296, 16384, 65535, 1));
        this.addressSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSpeccy.this.addressSpinnerStateChanged(evt);
            }
        });
        this.addrValuePanel.add(this.addressSpinner);
        this.addrValuePanel.add(this.filler1);
        this.pokeValue.setText(bundle.getString("JSpeccy.pokeValue.text"));
        this.addrValuePanel.add(this.pokeValue);
        this.valueSpinner.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.valueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSpeccy.this.valueSpinnerStateChanged(evt);
            }
        });
        this.addrValuePanel.add(this.valueSpinner);
        this.addrValuePanel.add(this.filler2);
        this.pokeButton.setText(bundle.getString("JSpeccy.pokeButton.text"));
        this.pokeButton.setEnabled(false);
        this.pokeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.pokeButtonActionPerformed(evt);
            }
        });
        this.addrValuePanel.add(this.pokeButton);
        this.pokeDialog.getContentPane().add(this.addrValuePanel);
        this.closePokeDialogButton.setText(bundle.getString("JSpeccy.closePokeDialogButton.text"));
        this.closePokeDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.closePokeDialogButtonActionPerformed(evt);
            }
        });
        this.closePokeDialogPanel.add(this.closePokeDialogButton);
        this.pokeDialog.getContentPane().add(this.closePokeDialogPanel);
        this.setDefaultCloseOperation(0);
        this.setTitle(bundle.getString("JSpeccy.title"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(JSpeccy.class.getResource("/icons/JSpeccy48x48.png")));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JSpeccy.this.formWindowClosing(evt);
            }
        });
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 2));
        this.modelLabel.setText(bundle.getString("JSpeccy.modelLabel.text"));
        this.modelLabel.setToolTipText(bundle.getString("JSpeccy.modelLabel.toolTipText"));
        this.modelLabel.setBorder(new SoftBevelBorder(0));
        this.statusPanel.add(this.modelLabel);
        this.statusPanel.add(this.filler3);
        this.mdrvLabel.setHorizontalAlignment(0);
        this.mdrvLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/microdrive_on.png")));
        this.mdrvLabel.setText(bundle.getString("JSpeccy.mdrvLabel.text"));
        this.mdrvLabel.setEnabled(false);
        this.mdrvLabel.setMaximumSize(new Dimension(26, 26));
        this.mdrvLabel.setMinimumSize(new Dimension(26, 26));
        this.mdrvLabel.setPreferredSize(new Dimension(26, 26));
        this.mdrvLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSpeccy.this.mdrvLabelMouseClicked(evt);
            }
        });
        this.statusPanel.add(this.mdrvLabel);
        this.jSeparator10.setOrientation(1);
        this.jSeparator10.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator10.setMinimumSize(new Dimension(3, 16));
        this.jSeparator10.setPreferredSize(new Dimension(3, 16));
        this.jSeparator10.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator10);
        this.tapeLabel.setHorizontalAlignment(0);
        this.tapeLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/Akai24x24.png")));
        this.tapeLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tapeLabel.setEnabled(false);
        this.tapeLabel.setHorizontalTextPosition(0);
        this.tapeLabel.setPreferredSize(new Dimension(30, 26));
        this.tapeLabel.setRequestFocusEnabled(false);
        this.tapeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSpeccy.this.tapeLabelMouseClicked(evt);
            }
        });
        this.statusPanel.add(this.tapeLabel);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator2.setMinimumSize(new Dimension(3, 16));
        this.jSeparator2.setPreferredSize(new Dimension(3, 16));
        this.jSeparator2.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator2);
        this.speedLabel.setHorizontalAlignment(4);
        this.speedLabel.setText(bundle.getString("JSpeccy.speedLabel.text"));
        this.speedLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.speedLabel.setMaximumSize(new Dimension(85, 18));
        this.speedLabel.setMinimumSize(new Dimension(50, 18));
        this.speedLabel.setPreferredSize(new Dimension(60, 18));
        this.speedLabel.setRequestFocusEnabled(false);
        this.statusPanel.add(this.speedLabel);
        this.getContentPane().add((Component)this.statusPanel, "Last");
        this.toolbarMenu.setRollover(true);
        this.openSnapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/fileopen.png")));
        this.openSnapshotButton.setToolTipText(bundle.getString("JSpeccy.openSnapshotButton.toolTipText"));
        this.openSnapshotButton.setFocusable(false);
        this.openSnapshotButton.setHorizontalTextPosition(0);
        this.openSnapshotButton.setVerticalTextPosition(3);
        this.openSnapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.openSnapshotActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.openSnapshotButton);
        this.pauseToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/player_pause.png")));
        this.pauseToggleButton.setToolTipText(bundle.getString("JSpeccy.pauseToggleButton.toolTipText"));
        this.pauseToggleButton.setFocusable(false);
        this.pauseToggleButton.setHorizontalTextPosition(0);
        this.pauseToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/player_play.png")));
        this.pauseToggleButton.setVerticalTextPosition(3);
        this.pauseToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.pauseMachineMenuActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.pauseToggleButton);
        this.fastEmulationToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/player_fwd.png")));
        this.fastEmulationToggleButton.setText(bundle.getString("JSpeccy.fastEmulationToggleButton.text"));
        this.fastEmulationToggleButton.setToolTipText(bundle.getString("JSpeccy.fastEmulationToggleButton.toolTipText"));
        this.fastEmulationToggleButton.setFocusable(false);
        this.fastEmulationToggleButton.setHorizontalTextPosition(0);
        this.fastEmulationToggleButton.setVerticalTextPosition(3);
        this.fastEmulationToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.fastEmulationToggleButtonActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.fastEmulationToggleButton);
        this.doubleSizeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/viewmag+.png")));
        this.doubleSizeToggleButton.setToolTipText(bundle.getString("JSpeccy.doubleSizeToggleButton.toolTipText"));
        this.doubleSizeToggleButton.setFocusable(false);
        this.doubleSizeToggleButton.setHorizontalTextPosition(0);
        this.doubleSizeToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/viewmag-.png")));
        this.doubleSizeToggleButton.setVerticalTextPosition(3);
        this.doubleSizeToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.doubleSizeOptionActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.doubleSizeToggleButton);
        this.silenceSoundToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/sound-on-16x16.png")));
        this.silenceSoundToggleButton.setToolTipText(bundle.getString("JSpeccy.silenceSoundToggleButton.toolTipText"));
        this.silenceSoundToggleButton.setFocusable(false);
        this.silenceSoundToggleButton.setHorizontalTextPosition(0);
        this.silenceSoundToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/sound-off-16x16.png")));
        this.silenceSoundToggleButton.setVerticalTextPosition(3);
        this.silenceSoundToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.silenceSoundToggleButtonActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.silenceSoundToggleButton);
        this.resetSpectrumButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/shutdown.png")));
        this.resetSpectrumButton.setToolTipText(bundle.getString("JSpeccy.resetSpectrumButton.toolTipText"));
        this.resetSpectrumButton.setFocusable(false);
        this.resetSpectrumButton.setHorizontalTextPosition(0);
        this.resetSpectrumButton.setVerticalTextPosition(3);
        this.resetSpectrumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.resetMachineMenuActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.resetSpectrumButton);
        this.hardResetSpectrumButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/exit.png")));
        this.hardResetSpectrumButton.setToolTipText(bundle.getString("JSpeccy.hardResetSpectrumButton.toolTipText"));
        this.hardResetSpectrumButton.setFocusable(false);
        this.hardResetSpectrumButton.setHorizontalTextPosition(0);
        this.hardResetSpectrumButton.setVerticalTextPosition(3);
        this.hardResetSpectrumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.hardResetSpectrumButtonActionPerformed(evt);
            }
        });
        this.toolbarMenu.add(this.hardResetSpectrumButton);
        this.getContentPane().add((Component)this.toolbarMenu, "First");
        this.fileMenu.setText(bundle.getString("JSpeccy.fileMenu.text"));
        this.openSnapshot.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.openSnapshot.setText(bundle.getString("JSpeccy.openSnapshot.text"));
        this.openSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.openSnapshotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openSnapshot);
        this.saveSnapshot.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.saveSnapshot.setText(bundle.getString("JSpeccy.saveSnapshot.text"));
        this.saveSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.saveSnapshotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveSnapshot);
        this.fileMenu.add(this.jSeparator4);
        this.loadMemorySnapshot.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.loadMemorySnapshot.setText(bundle.getString("JSpeccy.loadMemorySnapshot.text"));
        this.loadMemorySnapshot.setEnabled(false);
        this.loadMemorySnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.loadMemorySnapshotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMemorySnapshot);
        this.saveMemorySnapshot.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.saveMemorySnapshot.setText(bundle.getString("JSpeccy.saveMemorySnapshot.text"));
        this.saveMemorySnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.saveMemorySnapshotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMemorySnapshot);
        this.fileMenu.add(this.jSeparator15);
        this.loadBinaryFile.setText(bundle.getString("JSpeccy.loadBinaryFile.text"));
        this.loadBinaryFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.loadBinaryFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadBinaryFile);
        this.saveBinaryFile.setText(bundle.getString("JSpeccy.saveBinaryFile.text"));
        this.saveBinaryFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.saveBinaryFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveBinaryFile);
        this.fileMenu.add(this.jSeparator16);
        this.loadScreenShot.setText(bundle.getString("JSpeccy.loadScreenShot.text"));
        this.loadScreenShot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.loadScreenShotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadScreenShot);
        this.saveScreenShot.setText(bundle.getString("JSpeccy.saveScreenShot.text"));
        this.saveScreenShot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.saveScreenShotActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveScreenShot);
        this.fileMenu.add(this.jSeparator1);
        this.recentFilesMenu.setText(bundle.getString("JSpeccy.recentFilesMenu.text"));
        this.recentFileMenu0.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.recentFileMenu0.setText(bundle.getString("JSpeccy.recentFileMenu0.text"));
        this.recentFileMenu0.setEnabled(false);
        this.recentFileMenu0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recentFileMenu0ActionPerformed(evt);
            }
        });
        this.recentFilesMenu.add(this.recentFileMenu0);
        this.recentFileMenu1.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.recentFileMenu1.setText(bundle.getString("JSpeccy.recentFileMenu0.text"));
        this.recentFileMenu1.setEnabled(false);
        this.recentFileMenu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recentFileMenu1ActionPerformed(evt);
            }
        });
        this.recentFilesMenu.add(this.recentFileMenu1);
        this.recentFileMenu2.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.recentFileMenu2.setText(bundle.getString("JSpeccy.recentFileMenu0.text"));
        this.recentFileMenu2.setEnabled(false);
        this.recentFileMenu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recentFileMenu2ActionPerformed(evt);
            }
        });
        this.recentFilesMenu.add(this.recentFileMenu2);
        this.recentFileMenu3.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        this.recentFileMenu3.setText(bundle.getString("JSpeccy.recentFileMenu0.text"));
        this.recentFileMenu3.setEnabled(false);
        this.recentFileMenu3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recentFileMenu3ActionPerformed(evt);
            }
        });
        this.recentFilesMenu.add(this.recentFileMenu3);
        this.recentFileMenu4.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        this.recentFileMenu4.setText(bundle.getString("JSpeccy.recentFileMenu0.text"));
        this.recentFileMenu4.setEnabled(false);
        this.recentFileMenu4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recentFileMenu4ActionPerformed(evt);
            }
        });
        this.recentFilesMenu.add(this.recentFileMenu4);
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.add(this.jSeparator7);
        this.thisIsTheEndMyFriend.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.thisIsTheEndMyFriend.setText(bundle.getString("JSpeccy.thisIsTheEndMyFriend.text"));
        this.thisIsTheEndMyFriend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.thisIsTheEndMyFriendActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.thisIsTheEndMyFriend);
        this.jMenuBar1.add(this.fileMenu);
        this.optionsMenu.setText(bundle.getString("JSpeccy.optionsMenu.text"));
        this.doubleSizeOption.setAccelerator(KeyStroke.getKeyStroke(90, 8));
        this.doubleSizeOption.setText(bundle.getString("JSpeccy.doubleSizeOption.text"));
        this.doubleSizeOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.doubleSizeOptionActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.doubleSizeOption);
        this.zoomMethodOptionMenu.setText(bundle.getString("JSpeccy.zoomMethodOptionMenu.text"));
        this.zoomMethodButtonGroup.add(this.standardZoom);
        this.standardZoom.setSelected(true);
        this.standardZoom.setText(bundle.getString("JSpeccy.standardZoom.text"));
        this.standardZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.standardZoomActionPerformed(evt);
            }
        });
        this.zoomMethodOptionMenu.add(this.standardZoom);
        this.zoomMethodButtonGroup.add(this.bilinearZoom);
        this.bilinearZoom.setText(bundle.getString("JSpeccy.bilinearZoom.text"));
        this.bilinearZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.bilinearZoomActionPerformed(evt);
            }
        });
        this.zoomMethodOptionMenu.add(this.bilinearZoom);
        this.zoomMethodButtonGroup.add(this.bicubicZoom);
        this.bicubicZoom.setText(bundle.getString("JSpeccy.bicubicZoom.text"));
        this.bicubicZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.bicubicZoomActionPerformed(evt);
            }
        });
        this.zoomMethodOptionMenu.add(this.bicubicZoom);
        this.optionsMenu.add(this.zoomMethodOptionMenu);
        this.borderSizeOptionMenu.setText(bundle.getString("JSpeccy.borderSizeOptionMenu.text"));
        this.borderSizeButtonGroup.add(this.noBorder);
        this.noBorder.setText(bundle.getString("JSpeccy.noBorder.text"));
        this.noBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.noBorderActionPerformed(evt);
            }
        });
        this.borderSizeOptionMenu.add(this.noBorder);
        this.borderSizeButtonGroup.add(this.standardBorder);
        this.standardBorder.setSelected(true);
        this.standardBorder.setText(bundle.getString("JSpeccy.standardBorder.text"));
        this.standardBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.standardBorderActionPerformed(evt);
            }
        });
        this.borderSizeOptionMenu.add(this.standardBorder);
        this.borderSizeButtonGroup.add(this.fullBorder);
        this.fullBorder.setText(bundle.getString("JSpeccy.fullBorder.text"));
        this.fullBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.fullBorderActionPerformed(evt);
            }
        });
        this.borderSizeOptionMenu.add(this.fullBorder);
        this.borderSizeButtonGroup.add(this.hugeBorder);
        this.hugeBorder.setText(bundle.getString("JSpeccy.hugeBorder.text"));
        this.hugeBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.hugeBorderActionPerformed(evt);
            }
        });
        this.borderSizeOptionMenu.add(this.hugeBorder);
        this.optionsMenu.add(this.borderSizeOptionMenu);
        this.filtersOptionMenu.setText(bundle.getString("JSpeccy.filtersOptionMenu.text"));
        this.filtersButtonGroup.add(this.noneFilter);
        this.noneFilter.setSelected(true);
        this.noneFilter.setText(bundle.getString("JSpeccy.noneFilter.text"));
        this.noneFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.noneFilterActionPerformed(evt);
            }
        });
        this.filtersOptionMenu.add(this.noneFilter);
        this.filtersButtonGroup.add(this.palTvFilter);
        this.palTvFilter.setText(bundle.getString("JSpeccy.palTvFilter.text"));
        this.palTvFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.palTvFilterActionPerformed(evt);
            }
        });
        this.filtersOptionMenu.add(this.palTvFilter);
        this.filtersButtonGroup.add(this.rgbFilter);
        this.rgbFilter.setText(bundle.getString("JSpeccy.rgbFilter.text"));
        this.rgbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.rgbFilterActionPerformed(evt);
            }
        });
        this.filtersOptionMenu.add(this.rgbFilter);
        this.filtersOptionMenu.add(this.jSeparator20);
        this.scanlinesFilter.setText(bundle.getString("JSpeccy.scanlinesFilter.text"));
        this.scanlinesFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.scanlinesFilterActionPerformed(evt);
            }
        });
        this.filtersOptionMenu.add(this.scanlinesFilter);
        this.optionsMenu.add(this.filtersOptionMenu);
        this.optionsMenu.add(this.jSeparator19);
        this.joystickOptionMenu.setText(bundle.getString("JSpeccy.joystickOptionMenu.text"));
        this.joystickButtonGroup.add(this.noneJoystick);
        this.noneJoystick.setSelected(true);
        this.noneJoystick.setText(bundle.getString("JSpeccy.noneJoystick.text"));
        this.noneJoystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.noneJoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.noneJoystick);
        this.joystickButtonGroup.add(this.kempstonJoystick);
        this.kempstonJoystick.setText(bundle.getString("JSpeccy.kempstonJoystick.text"));
        this.kempstonJoystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.kempstonJoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.kempstonJoystick);
        this.joystickButtonGroup.add(this.sinclair1Joystick);
        this.sinclair1Joystick.setText(bundle.getString("JSpeccy.sinclair1Joystick.text"));
        this.sinclair1Joystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.sinclair1JoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.sinclair1Joystick);
        this.joystickButtonGroup.add(this.sinclair2Joystick);
        this.sinclair2Joystick.setText(bundle.getString("JSpeccy.sinclair2Joystick.text"));
        this.sinclair2Joystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.sinclair2JoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.sinclair2Joystick);
        this.joystickButtonGroup.add(this.cursorJoystick);
        this.cursorJoystick.setText(bundle.getString("JSpeccy.cursorJoystick.text"));
        this.cursorJoystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.cursorJoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.cursorJoystick);
        this.joystickButtonGroup.add(this.fullerJoystick);
        this.fullerJoystick.setText(bundle.getString("JSpeccy.fullerJoystick.text"));
        this.fullerJoystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.fullerJoystickActionPerformed(evt);
            }
        });
        this.joystickOptionMenu.add(this.fullerJoystick);
        this.optionsMenu.add(this.joystickOptionMenu);
        this.optionsMenu.add(this.jSeparator18);
        this.settingsOptionsMenu.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.settingsOptionsMenu.setText(bundle.getString("JSpeccy.settings.text"));
        this.settingsOptionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.settingsOptionsMenuActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.settingsOptionsMenu);
        this.jMenuBar1.add(this.optionsMenu);
        this.machineMenu.setText(bundle.getString("JSpeccy.machineMenu.text"));
        this.machineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.silenceSoundToggleButtonActionPerformed(evt);
            }
        });
        this.pauseMachineMenu.setAccelerator(KeyStroke.getKeyStroke(19, 0));
        this.pauseMachineMenu.setText(bundle.getString("JSpeccy.pauseMachineMenu.text"));
        this.pauseMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.pauseMachineMenuActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.pauseMachineMenu);
        this.silenceMachineMenu.setText(bundle.getString("JSpeccy.silenceMachineMenu.text"));
        this.silenceMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.silenceSoundToggleButtonActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.silenceMachineMenu);
        this.machineMenu.add(this.jSeparator17);
        this.resetMachineMenu.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.resetMachineMenu.setText(bundle.getString("JSpeccy.resetMachineMenu.text"));
        this.resetMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.resetMachineMenuActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.resetMachineMenu);
        this.hardResetMachineMenu.setText(bundle.getString("JSpeccy.hardResetMachineMenu.text"));
        this.hardResetMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.hardResetSpectrumButtonActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.hardResetMachineMenu);
        this.nmiMachineMenu.setAccelerator(KeyStroke.getKeyStroke(116, 2));
        this.nmiMachineMenu.setText(bundle.getString("JSpeccy.nmiMachineMenu.text"));
        this.nmiMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.nmiMachineMenuActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.nmiMachineMenu);
        this.machineMenu.add(this.jSeparator3);
        this.pokeMachineMenu.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.pokeMachineMenu.setText(bundle.getString("JSpeccy.pokeMachineMenu.text"));
        this.pokeMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.pokeMachineMenuActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.pokeMachineMenu);
        this.memoryBrowserMachineMenu.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        this.memoryBrowserMachineMenu.setText(bundle.getString("JSpeccy.memoryBrowserMachineMenu.text"));
        this.memoryBrowserMachineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.memoryBrowserMachineMenuActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.memoryBrowserMachineMenu);
        this.machineMenu.add(this.jSeparator14);
        this.hardwareMachineMenu.setText(bundle.getString("JSpeccy.hardwareMachineMenu.text"));
        this.hardwareButtonGroup.add(this.spec16kHardware);
        this.spec16kHardware.setText(bundle.getString("JSpeccy.spec16kHardware.text"));
        this.spec16kHardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.spec16kHardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.spec16kHardware);
        this.hardwareButtonGroup.add(this.spec48kHardware);
        this.spec48kHardware.setSelected(true);
        this.spec48kHardware.setText(bundle.getString("JSpeccy.spec48kHardware.text"));
        this.spec48kHardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.spec48kHardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.spec48kHardware);
        this.hardwareButtonGroup.add(this.spec128kHardware);
        this.spec128kHardware.setText(bundle.getString("JSpeccy.spec128kHardware.text"));
        this.spec128kHardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.spec128kHardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.spec128kHardware);
        this.hardwareButtonGroup.add(this.specPlus2Hardware);
        this.specPlus2Hardware.setText(bundle.getString("JSpeccy.specPlus2Hardware.text"));
        this.specPlus2Hardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.specPlus2HardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.specPlus2Hardware);
        this.hardwareButtonGroup.add(this.specPlus2AHardware);
        this.specPlus2AHardware.setText(bundle.getString("JSpeccy.specPlus2AHardware.text"));
        this.specPlus2AHardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.specPlus2AHardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.specPlus2AHardware);
        this.hardwareButtonGroup.add(this.specPlus3Hardware);
        this.specPlus3Hardware.setText(bundle.getString("JSpeccy.specPlus3Hardware.text"));
        this.specPlus3Hardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.specPlus3HardwareActionPerformed(evt);
            }
        });
        this.hardwareMachineMenu.add(this.specPlus3Hardware);
        this.machineMenu.add(this.hardwareMachineMenu);
        this.jMenuBar1.add(this.machineMenu);
        this.mediaMenu.setText(bundle.getString("JSpeccy.mediaMenu.text"));
        this.tapeMediaMenu.setText(bundle.getString("JSpeccy.tapeMediaMenu.text"));
        this.openTapeMediaMenu.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.openTapeMediaMenu.setText(bundle.getString("JSpeccy.openTapeMediaMenu.text"));
        this.openTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.openTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.openTapeMediaMenu);
        this.playTapeMediaMenu.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.playTapeMediaMenu.setText(bundle.getString("JSpeccy.playTapeMediaMenu.text"));
        this.playTapeMediaMenu.setEnabled(false);
        this.playTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.playTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.playTapeMediaMenu);
        this.browserTapeMediaMenu.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.browserTapeMediaMenu.setText(bundle.getString("JSpeccy.browserTapeMediaMenu.text"));
        this.browserTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.browserTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.browserTapeMediaMenu);
        this.rewindTapeMediaMenu.setText(bundle.getString("JSpeccy.rewindTapeMediaMenu.text"));
        this.rewindTapeMediaMenu.setEnabled(false);
        this.rewindTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.rewindTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.rewindTapeMediaMenu);
        this.ejectTapeMediaMenu.setText(bundle.getString("JSpeccy.ejectTapeMediaMenu.text"));
        this.ejectTapeMediaMenu.setEnabled(false);
        this.ejectTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.tapeBrowserButtonEjectActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.ejectTapeMediaMenu);
        this.tapeMediaMenu.add(this.jSeparator5);
        this.createTapeMediaMenu.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.createTapeMediaMenu.setText(bundle.getString("JSpeccy.createTapeMediaMenu.text"));
        this.createTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.createTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.createTapeMediaMenu);
        this.clearTapeMediaMenu.setText(bundle.getString("JSpeccy.clearTapeMediaMenu.text"));
        this.clearTapeMediaMenu.setEnabled(false);
        this.clearTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.clearTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.clearTapeMediaMenu);
        this.tapeMediaMenu.add(this.jSeparator6);
        this.recordStartTapeMediaMenu.setText(bundle.getString("JSpeccy.recordStartTapeMediaMenu.text"));
        this.recordStartTapeMediaMenu.setEnabled(false);
        this.recordStartTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recordStartTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.recordStartTapeMediaMenu);
        this.recordStopTapeMediaMenu.setText(bundle.getString("JSpeccy.recordStopTapeMediaMenu.text"));
        this.recordStopTapeMediaMenu.setEnabled(false);
        this.recordStopTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.recordStopTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.recordStopTapeMediaMenu);
        this.tapeMediaMenu.add(this.jSeparator13);
        this.reloadTapeMediaMenu.setAccelerator(KeyStroke.getKeyStroke(118, 2));
        this.reloadTapeMediaMenu.setText(bundle.getString("JSpeccy.reloadTapeMediaMenu.text"));
        this.reloadTapeMediaMenu.setEnabled(false);
        this.reloadTapeMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.reloadTapeMediaMenuActionPerformed(evt);
            }
        });
        this.tapeMediaMenu.add(this.reloadTapeMediaMenu);
        this.mediaMenu.add(this.tapeMediaMenu);
        this.mediaMenu.add(this.jSeparator8);
        this.IF1MediaMenu.setText(bundle.getString("JSpeccy.IF1MediaMenu.text"));
        this.microdrivesIF1MediaMenu.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.microdrivesIF1MediaMenu.setText(bundle.getString("JSpeccy.microdrivesIF1MediaMenu.text"));
        this.microdrivesIF1MediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.microdrivesIF1MediaMenuActionPerformed(evt);
            }
        });
        this.IF1MediaMenu.add(this.microdrivesIF1MediaMenu);
        this.mediaMenu.add(this.IF1MediaMenu);
        this.mediaMenu.add(this.jSeparator9);
        this.IF2MediaMenu.setText(bundle.getString("JSpeccy.IF2MediaMenu.text"));
        this.insertIF2RomMediaMenu.setText(bundle.getString("JSpeccy.insertIF2RomMediaMenu.text"));
        this.insertIF2RomMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.insertIF2RomMediaMenuActionPerformed(evt);
            }
        });
        this.IF2MediaMenu.add(this.insertIF2RomMediaMenu);
        this.extractIF2RomMediaMenu.setText(bundle.getString("JSpeccy.extractIF2RomMediaMenu.text"));
        this.extractIF2RomMediaMenu.setEnabled(false);
        this.extractIF2RomMediaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.extractIF2RomMediaMenuActionPerformed(evt);
            }
        });
        this.IF2MediaMenu.add(this.extractIF2RomMediaMenu);
        this.mediaMenu.add(this.IF2MediaMenu);
        this.jMenuBar1.add(this.mediaMenu);
        this.helpMenu.setText(bundle.getString("JSpeccy.helpMenu.text"));
        this.imageHelpMenu.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.imageHelpMenu.setText(bundle.getString("JSpeccy.imageHelpMenu.text"));
        this.imageHelpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.imageHelpMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.imageHelpMenu);
        this.aboutHelpMenu.setText(bundle.getString("JSpeccy.aboutHelpMenu.text"));
        this.aboutHelpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSpeccy.this.aboutHelpMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutHelpMenu);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void openSnapshotActionPerformed(ActionEvent evt) {
        if (this.openSnapshotDlg == null) {
            this.openSnapshotDlg = new JFileChooser(this.settings.getRecentFilesSettings().getLastSnapshotDir());
            this.openSnapshotDlg.addChoosableFileFilter(this.allSnapTapeExtension);
            this.openSnapshotDlg.addChoosableFileFilter(this.snapshotExtension);
            this.openSnapshotDlg.addChoosableFileFilter(this.tapeExtension);
            this.openSnapshotDlg.addChoosableFileFilter(this.createTapeExtension);
            this.openSnapshotDlg.setFileFilter(this.allSnapTapeExtension);
        } else {
            this.openSnapshotDlg.setSelectedFile(this.currentFileSnapshot);
        }
        this.stopEmulation();
        int status = this.openSnapshotDlg.showOpenDialog(this.getContentPane());
        if (status == 0) {
            this.currentFileSnapshot = this.openSnapshotDlg.getSelectedFile();
            this.settings.getRecentFilesSettings().setLastSnapshotDir(this.currentFileSnapshot.getParent());
            if (this.snapshotExtension.accept(this.currentFileSnapshot)) {
                this.rotateRecentFile(this.currentFileSnapshot);
                try {
                    SnapshotFile snap = SnapshotFactory.getSnapshot(this.currentFileSnapshot);
                    SpectrumState snapState = snap.load(this.currentFileSnapshot);
                    if (snap instanceof SnapshotSZX) {
                        File tapeLink;
                        SnapshotSZX snapSZX = (SnapshotSZX)snap;
                        if (snapSZX.isTapeEmbedded()) {
                            this.tape.eject();
                            this.tape.insertEmbeddedTape(snapSZX.getTapeName(), snapSZX.getTapeExtension(), snapSZX.getTapeData(), snapSZX.getTapeBlock());
                        }
                        if (snapSZX.isTapeLinked() && (tapeLink = new File(snapSZX.getTapeName())).exists()) {
                            this.tape.eject();
                            this.tape.insert(tapeLink);
                            this.tape.setSelectedBlock(snapSZX.getTapeBlock());
                        }
                    }
                    this.spectrum.setSpectrumState(snapState);
                }
                catch (SnapshotException excpt) {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("gui/Bundle").getString(excpt.getMessage()), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_LOAD_ERROR"), 0);
                }
            } else {
                this.currentFileTape = this.openSnapshotDlg.getSelectedFile();
                this.settings.getRecentFilesSettings().setLastTapeDir(this.currentFileTape.getParent());
                this.tape.eject();
                if (this.tape.insert(this.currentFileTape)) {
                    this.rotateRecentFile(this.currentFileTape);
                    if (this.settings.getTapeSettings().isAutoLoadTape()) {
                        this.spectrum.autoLoadTape();
                    }
                } else {
                    ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                    JOptionPane.showMessageDialog(this, bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
                }
            }
        }
        this.startEmulation();
    }

    private void thisIsTheEndMyFriendActionPerformed(ActionEvent evt) {
        this.exitEmulator();
    }

    private void doubleSizeOptionActionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            this.doubleSizeToggleButton.setSelected(this.doubleSizeOption.isSelected());
        } else {
            this.doubleSizeOption.setSelected(this.doubleSizeToggleButton.isSelected());
        }
        this.settings.getSpectrumSettings().setZoomed(this.doubleSizeOption.isSelected());
        if (this.settings.getSpectrumSettings().isZoomed()) {
            this.jscr.setZoom(this.settings.getSpectrumSettings().getZoom());
        } else {
            this.jscr.setZoom(1);
        }
        this.spectrum.invalidateScreen(true);
        this.pack();
    }

    private void pauseMachineMenuActionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            this.pauseToggleButton.setSelected(this.pauseMachineMenu.isSelected());
        } else {
            this.pauseMachineMenu.setSelected(this.pauseToggleButton.isSelected());
        }
        if (this.pauseMachineMenu.isSelected()) {
            this.stopEmulation();
        } else {
            this.startEmulation();
        }
    }

    private void resetMachineMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        if (!this.settings.getEmulatorSettings().isConfirmActions()) {
            this.spectrum.reset();
            return;
        }
        this.stopEmulation();
        int ret = JOptionPane.showConfirmDialog(this.getContentPane(), bundle.getString("ARE_YOU_SURE_QUESTION"), bundle.getString("RESET_SPECTRUM"), 0, 3);
        if (ret == 0) {
            this.spectrum.reset();
        }
        this.startEmulation();
    }

    private void silenceSoundToggleButtonActionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JToggleButton) {
            this.silenceMachineMenu.setSelected(this.silenceSoundToggleButton.isSelected());
        } else {
            this.silenceSoundToggleButton.setSelected(this.silenceMachineMenu.isSelected());
        }
        this.spectrum.muteSound(this.silenceSoundToggleButton.isSelected());
    }

    private void playTapeMediaMenuActionPerformed(ActionEvent evt) {
        if (this.tape.isTapePlaying()) {
            this.tape.stop();
        } else {
            this.tape.play();
        }
    }

    private void openTapeMediaMenuActionPerformed(ActionEvent evt) {
        if (this.openTapeDlg == null) {
            this.openTapeDlg = new JFileChooser(this.settings.getRecentFilesSettings().getLastTapeDir());
            this.openTapeDlg.addChoosableFileFilter(this.tapeExtension);
            this.openTapeDlg.addChoosableFileFilter(this.createTapeExtension);
            this.openTapeDlg.setFileFilter(this.tapeExtension);
        } else {
            this.openTapeDlg.setSelectedFile(this.currentFileTape);
        }
        this.stopEmulation();
        int status = this.openTapeDlg.showOpenDialog(this.getContentPane());
        if (status == 0) {
            this.currentFileTape = this.openTapeDlg.getSelectedFile();
            this.settings.getRecentFilesSettings().setLastTapeDir(this.currentFileTape.getParent());
            this.tape.eject();
            if (this.tape.insert(this.currentFileTape)) {
                this.rotateRecentFile(this.currentFileTape);
                if (this.settings.getTapeSettings().isAutoLoadTape()) {
                    this.spectrum.autoLoadTape();
                }
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                JOptionPane.showMessageDialog(this, bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
            }
        }
        this.startEmulation();
    }

    private void rewindTapeMediaMenuActionPerformed(ActionEvent evt) {
        this.tape.rewind();
    }

    private void imageHelpMenuActionPerformed(ActionEvent evt) {
        this.keyboardHelper.setResizable(false);
        this.keyboardHelper.pack();
        this.keyboardHelper.setVisible(true);
    }

    private void aboutHelpMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.stopEmulation();
        JOptionPane.showMessageDialog(this.getContentPane(), bundle.getString("ABOUT_MESSAGE"), bundle.getString("ABOUT_TITLE"), 1, new ImageIcon(this.getClass().getResource("/icons/JSpeccy64x64.png")));
        this.startEmulation();
    }

    private void nmiMachineMenuActionPerformed(ActionEvent evt) {
        this.spectrum.triggerNMI();
    }

    private void closeKeyboardHelperActionPerformed(ActionEvent evt) {
        this.keyboardHelper.setVisible(false);
    }

    private void saveSnapshotActionPerformed(ActionEvent evt) {
        if (this.saveSnapshotDlg == null) {
            this.saveSnapshotDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.saveSnapshotDlg.addChoosableFileFilter(this.snapshotExtension);
            this.saveSnapshotDlg.setFileFilter(this.saveSnapshotExtension);
            this.currentDirSaveSnapshot = this.saveSnapshotDlg.getCurrentDirectory();
        } else {
            this.saveSnapshotDlg.setCurrentDirectory(this.currentDirSaveSnapshot);
            BasicFileChooserUI chooserUI = (BasicFileChooserUI)this.saveSnapshotDlg.getUI();
            chooserUI.setFileName("");
        }
        this.stopEmulation();
        int status = this.saveSnapshotDlg.showSaveDialog(this.getContentPane());
        if (status == 0) {
            this.currentDirSaveSnapshot = this.saveSnapshotDlg.getCurrentDirectory();
            if (!this.snapshotExtension.accept(this.saveSnapshotDlg.getSelectedFile())) {
                String saveName = this.saveSnapshotDlg.getSelectedFile().getAbsolutePath() + ".szx";
                this.saveSnapshotDlg.setSelectedFile(new File(saveName));
            }
            try {
                SnapshotFile snap = SnapshotFactory.getSnapshot(this.saveSnapshotDlg.getSelectedFile());
                if (snap instanceof SnapshotSZX && this.tape.getTapeFilename() != null) {
                    SnapshotSZX snapSZX = (SnapshotSZX)snap;
                    this.tapeFilenameLabel.setText(this.tape.getTapeFilename().getName());
                    this.ignoreRadioButton.setSelected(true);
                    this.saveSzxTape.pack();
                    this.saveSzxTape.setVisible(true);
                    snapSZX.setTapeEmbedded(this.embeddedRadioButton.isSelected());
                    snapSZX.setTapeLinked(this.linkedRadioButton.isSelected());
                    if (snapSZX.isTapeEmbedded() || snapSZX.isTapeLinked()) {
                        snapSZX.setTapeName(this.tape.getTapeFilename().getAbsolutePath());
                        snapSZX.setTapeBlock(this.tape.getSelectedBlock());
                    }
                }
                snap.save(this.saveSnapshotDlg.getSelectedFile(), this.spectrum.getSpectrumState());
            }
            catch (SnapshotException excpt) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("gui/Bundle").getString(excpt.getMessage()), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_SAVE_ERROR"), 0);
            }
        }
        this.startEmulation();
    }

    private void noneJoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
        this.noneJoystick.setSelected(true);
    }

    private void kempstonJoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.KEMPSTON);
        this.kempstonJoystick.setSelected(true);
    }

    private void sinclair1JoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR1);
        this.sinclair1Joystick.setSelected(true);
    }

    private void sinclair2JoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR2);
        this.sinclair2Joystick.setSelected(true);
    }

    private void cursorJoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.CURSOR);
        this.cursorJoystick.setSelected(true);
    }

    private void spec48kHardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUM48K) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM48K);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void spec128kHardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUM128K) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM128K);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void fastEmulationToggleButtonActionPerformed(ActionEvent evt) {
        if (this.fastEmulationToggleButton.isSelected()) {
            this.spectrum.changeSpeed(this.settings.getSpectrumSettings().getFramesInt());
        } else {
            this.spectrum.changeSpeed(1);
        }
    }

    private void browserTapeMediaMenuActionPerformed(ActionEvent evt) {
        this.tapeBrowserDialog.setVisible(true);
        this.tapeBrowserDialog.pack();
        this.tapeCatalog.doLayout();
    }

    private void specPlus2HardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUMPLUS2) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS2);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void specPlus2AHardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUMPLUS2A) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS2A);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void settingsOptionsMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        int AYsoundMode = this.settings.getAY8912Settings().getSoundMode();
        boolean hifiSound = this.settings.getSpectrumSettings().isHifiSound();
        boolean muted = this.settings.getSpectrumSettings().isMutedSound();
        boolean zoomed = this.settings.getSpectrumSettings().isZoomed();
        boolean ayOn48k = this.settings.getSpectrumSettings().isAYEnabled48K();
        int zoom = this.settings.getSpectrumSettings().getZoom();
        this.stopEmulation();
        this.settingsDialog.showDialog(this, bundle.getString("SETTINGS_DIALOG_TITLE"));
        this.spectrum.loadConfigVars();
        if (muted != this.settings.getSpectrumSettings().isMutedSound()) {
            this.spectrum.muteSound(!muted);
            this.silenceMachineMenu.setSelected(!muted);
            this.silenceSoundToggleButton.setSelected(!muted);
        }
        if (!(AYsoundMode == this.settings.getAY8912Settings().getSoundMode() && hifiSound == this.settings.getSpectrumSettings().isHifiSound() && ayOn48k == this.settings.getSpectrumSettings().isAYEnabled48K() || this.spectrum.isMuteSound())) {
            this.spectrum.muteSound(true);
            this.spectrum.muteSound(false);
        }
        if (this.settings.getSpectrumSettings().isZoomed() != zoomed) {
            this.doubleSizeToggleButton.setSelected(this.settings.getSpectrumSettings().isZoomed());
            this.doubleSizeOption.setSelected(this.settings.getSpectrumSettings().isZoomed());
            this.jscr.setZoom(this.settings.getSpectrumSettings().isZoomed() ? this.settings.getSpectrumSettings().getZoom() : 1);
            this.spectrum.invalidateScreen(true);
            this.pack();
        } else if (zoomed && zoom != this.settings.getSpectrumSettings().getZoom()) {
            this.jscr.setZoom(this.settings.getSpectrumSettings().getZoom());
            this.spectrum.invalidateScreen(true);
            this.pack();
        }
        this.startEmulation();
    }

    private void saveScreenShotActionPerformed(ActionEvent evt) {
        if (this.saveImageDlg == null) {
            this.saveImageDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.saveImageDlg.addChoosableFileFilter(this.imageExtension);
            this.saveImageDlg.setFileFilter(this.imageExtension);
            this.currentDirSaveImage = this.saveImageDlg.getCurrentDirectory();
        } else {
            this.saveImageDlg.setCurrentDirectory(this.currentDirSaveImage);
            BasicFileChooserUI chooserUI = (BasicFileChooserUI)this.saveImageDlg.getUI();
            chooserUI.setFileName("");
        }
        this.stopEmulation();
        int status = this.saveImageDlg.showSaveDialog(this.getContentPane());
        if (status == 0) {
            this.currentDirSaveImage = this.saveImageDlg.getCurrentDirectory();
            if (this.imageExtension.accept(this.saveImageDlg.getSelectedFile())) {
                this.spectrum.saveImage(this.saveImageDlg.getSelectedFile());
            } else {
                String saveName = this.saveImageDlg.getSelectedFile().getAbsolutePath() + ".scr";
                this.spectrum.saveImage(new File(saveName));
            }
        }
        this.startEmulation();
    }

    private void createTapeMediaMenuActionPerformed(ActionEvent evt) {
        if (this.openTapeDlg == null) {
            this.openTapeDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.openTapeDlg.addChoosableFileFilter(this.createTapeExtension);
            this.openTapeDlg.addChoosableFileFilter(this.tapeExtension);
        } else {
            this.openTapeDlg.setCurrentDirectory(this.currentFileTape.getParentFile());
        }
        this.stopEmulation();
        this.openTapeDlg.setFileFilter(this.createTapeExtension);
        int status = this.openTapeDlg.showOpenDialog(this);
        if (status == 0) {
            if (!this.createTapeExtension.accept(this.openTapeDlg.getSelectedFile())) {
                String saveName = this.openTapeDlg.getSelectedFile().getAbsolutePath() + ".tzx";
                this.openTapeDlg.setSelectedFile(new File(saveName));
            }
            this.currentFileTape = this.openTapeDlg.getSelectedFile();
            try {
                boolean res = this.currentFileTape.createNewFile();
                if (res) {
                    this.tape.eject();
                }
                if (res && this.tape.insert(this.currentFileTape)) {
                    this.rotateRecentFile(this.currentFileTape);
                } else {
                    ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                    JOptionPane.showMessageDialog(this, bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.startEmulation();
    }

    private void hardResetSpectrumButtonActionPerformed(ActionEvent evt) {
        int ret;
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        this.stopEmulation();
        if (this.settings.getEmulatorSettings().isConfirmActions() && (ret = JOptionPane.showConfirmDialog(this.getContentPane(), bundle.getString("ARE_YOU_SURE_QUESTION"), bundle.getString("HARD_RESET_SPECTRUM"), 0, 3)) == 1) {
            this.startEmulation();
            return;
        }
        this.spectrum.hardReset();
        switch (this.settings.getSpectrumSettings().getDefaultModel()) {
            case 0: {
                this.spec16kHardware.setSelected(true);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUM16K.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUM16K.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM16K);
                break;
            }
            case 2: {
                this.spec128kHardware.setSelected(true);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUM128K.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUM128K.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM128K);
                break;
            }
            case 3: {
                this.specPlus2Hardware.setSelected(true);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUMPLUS2.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUMPLUS2.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS2);
                break;
            }
            case 4: {
                this.specPlus2AHardware.setSelected(true);
                this.IF1MediaMenu.setEnabled(false);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUMPLUS2A.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUMPLUS2A.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS2A);
                break;
            }
            case 5: {
                this.specPlus3Hardware.setSelected(true);
                this.IF1MediaMenu.setEnabled(false);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUMPLUS3.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUMPLUS3.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS3);
                break;
            }
            default: {
                this.spec48kHardware.setSelected(true);
                this.modelLabel.setToolTipText(MachineTypes.SPECTRUM48K.getLongModelName());
                this.modelLabel.setText(MachineTypes.SPECTRUM48K.getShortModelName());
                this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM48K);
            }
        }
        switch (this.settings.getKeyboardJoystickSettings().getJoystickModel()) {
            case 1: {
                this.kempstonJoystick.setSelected(true);
                this.spectrum.setJoystick(Keyboard.JoystickModel.KEMPSTON);
                break;
            }
            case 2: {
                this.sinclair1Joystick.setSelected(true);
                this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR1);
                break;
            }
            case 3: {
                this.sinclair2Joystick.setSelected(true);
                this.spectrum.setJoystick(Keyboard.JoystickModel.SINCLAIR2);
                break;
            }
            case 4: {
                this.cursorJoystick.setSelected(true);
                this.spectrum.setJoystick(Keyboard.JoystickModel.CURSOR);
                break;
            }
            default: {
                this.noneJoystick.setSelected(true);
                this.spectrum.setJoystick(Keyboard.JoystickModel.NONE);
            }
        }
        if (this.settings.getSpectrumSettings().getDefaultModel() < 4) {
            this.IF1MediaMenu.setEnabled(this.settings.getInterface1Settings().isConnectedIF1());
            this.IF2MediaMenu.setEnabled(true);
        } else {
            this.IF1MediaMenu.setEnabled(false);
            this.IF2MediaMenu.setEnabled(false);
        }
        this.startEmulation();
    }

    private void clearTapeMediaMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        int ret = JOptionPane.showConfirmDialog(this.getContentPane(), bundle.getString("ARE_YOU_SURE_QUESTION"), bundle.getString("CLEAR_TAPE"), 0, 3);
        this.stopEmulation();
        if (ret == 0 && this.tape.isTapeReady()) {
            try {
                File tmp = this.tape.getTapeFilename();
                if (tmp.delete()) {
                    this.tape.eject();
                }
                if (tmp.createNewFile() && !this.tape.insert(tmp)) {
                    JOptionPane.showMessageDialog(this, bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JSpeccy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.startEmulation();
    }

    private void spec16kHardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUM16K) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUM16K);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void specPlus3HardwareActionPerformed(ActionEvent evt) {
        if (this.spectrum.getSpectrumModel() == MachineTypes.SPECTRUMPLUS3) {
            return;
        }
        this.stopEmulation();
        this.spectrum.selectHardwareModel(MachineTypes.SPECTRUMPLUS3);
        this.spectrum.reset();
        this.startEmulation();
    }

    private void recordStartTapeMediaMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        if (!this.tape.isTapeReady()) {
            JOptionPane.showMessageDialog(this, bundle.getString("RECORD_START_ERROR"), bundle.getString("RECORD_START_TITLE"), 0);
        } else if (!this.spectrum.startRecording()) {
            JOptionPane.showMessageDialog(this, bundle.getString("RECORD_START_FORMAT_ERROR"), bundle.getString("RECORD_START_FORMAT_TITLE"), 0);
        }
        this.playTapeMediaMenu.setSelected(false);
    }

    private void recordStopTapeMediaMenuActionPerformed(ActionEvent evt) {
        this.spectrum.stopRecording();
    }

    private void loadRecentFile(int idx) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        if (!this.recentFile[idx].exists()) {
            JOptionPane.showMessageDialog(this, bundle.getString("RECENT_FILE_ERROR"), bundle.getString("RECENT_FILE_ERROR_TITLE"), 0);
        } else if (this.snapshotExtension.accept(this.recentFile[idx])) {
            this.stopEmulation();
            this.currentFileSnapshot = this.recentFile[idx];
            try {
                SnapshotFile snap = SnapshotFactory.getSnapshot(this.currentFileSnapshot);
                SpectrumState snapState = snap.load(this.currentFileSnapshot);
                if (snap instanceof SnapshotSZX) {
                    File tapeLink;
                    SnapshotSZX snapSZX = (SnapshotSZX)snap;
                    if (snapSZX.isTapeEmbedded()) {
                        this.tape.eject();
                        this.tape.insertEmbeddedTape(snapSZX.getTapeName(), snapSZX.getTapeExtension(), snapSZX.getTapeData(), snapSZX.getTapeBlock());
                    }
                    if (snapSZX.isTapeLinked() && (tapeLink = new File(snapSZX.getTapeName())).exists()) {
                        this.tape.eject();
                        this.tape.insert(tapeLink);
                        this.tape.setSelectedBlock(snapSZX.getTapeBlock());
                    }
                }
                this.spectrum.setSpectrumState(snapState);
            }
            catch (SnapshotException excpt) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("gui/Bundle").getString(excpt.getMessage()), ResourceBundle.getBundle("gui/Bundle").getString("SNAPSHOT_LOAD_ERROR"), 0);
            }
            this.startEmulation();
        } else {
            this.tape.eject();
            this.currentFileTape = this.recentFile[idx];
            if (!this.tape.insert(this.currentFileTape)) {
                JOptionPane.showMessageDialog(this, bundle.getString("LOAD_TAPE_ERROR"), bundle.getString("LOAD_TAPE_ERROR_TITLE"), 0);
            } else if (this.settings.getTapeSettings().isAutoLoadTape()) {
                this.spectrum.autoLoadTape();
            }
        }
    }

    private void recentFileMenu0ActionPerformed(ActionEvent evt) {
        this.loadRecentFile(0);
    }

    private void recentFileMenu1ActionPerformed(ActionEvent evt) {
        this.loadRecentFile(1);
    }

    private void recentFileMenu2ActionPerformed(ActionEvent evt) {
        this.loadRecentFile(2);
    }

    private void recentFileMenu3ActionPerformed(ActionEvent evt) {
        this.loadRecentFile(3);
    }

    private void recentFileMenu4ActionPerformed(ActionEvent evt) {
        this.loadRecentFile(4);
    }

    private void insertIF2RomMediaMenuActionPerformed(ActionEvent evt) {
        if (this.IF2RomDlg == null) {
            this.IF2RomDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.IF2RomDlg.addChoosableFileFilter(this.romExtension);
            this.IF2RomDlg.setFileFilter(this.romExtension);
            this.currentDirRom = this.IF2RomDlg.getCurrentDirectory();
        } else {
            this.IF2RomDlg.setCurrentDirectory(this.currentDirRom);
        }
        this.stopEmulation();
        int status = this.IF2RomDlg.showOpenDialog(this.getContentPane());
        if (status == 0) {
            this.currentDirRom = this.IF2RomDlg.getCurrentDirectory();
            if (this.spectrum.insertIF2Rom(this.IF2RomDlg.getSelectedFile())) {
                this.insertIF2RomMediaMenu.setEnabled(false);
                this.extractIF2RomMediaMenu.setEnabled(true);
                this.spectrum.reset();
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                JOptionPane.showMessageDialog(this, bundle.getString("LOAD_ROM_ERROR"), bundle.getString("LOAD_ROM_ERROR_TITLE"), 0);
            }
        }
        this.startEmulation();
    }

    private void extractIF2RomMediaMenuActionPerformed(ActionEvent evt) {
        this.spectrum.ejectIF2Rom();
        this.insertIF2RomMediaMenu.setEnabled(true);
        this.extractIF2RomMediaMenu.setEnabled(false);
        this.spectrum.reset();
    }

    private void fullerJoystickActionPerformed(ActionEvent evt) {
        this.spectrum.setJoystick(Keyboard.JoystickModel.FULLER);
        this.fullerJoystick.setSelected(true);
    }

    private void saveSzxCloseButtonActionPerformed(ActionEvent evt) {
        this.saveSzxTape.setVisible(false);
    }

    private void loadScreenShotActionPerformed(ActionEvent evt) {
        if (this.loadImageDlg == null) {
            this.loadImageDlg = new JFileChooser("/home/jsanchez/Spectrum");
            this.loadImageDlg.addChoosableFileFilter(this.screenExtension);
            this.loadImageDlg.setFileFilter(this.screenExtension);
            this.currentDirLoadImage = this.loadImageDlg.getCurrentDirectory();
        } else {
            this.loadImageDlg.setCurrentDirectory(this.currentDirLoadImage);
            BasicFileChooserUI chooserUI = (BasicFileChooserUI)this.loadImageDlg.getUI();
            chooserUI.setFileName("");
        }
        this.stopEmulation();
        int status = this.loadImageDlg.showOpenDialog(this.getContentPane());
        if (status == 0) {
            this.currentDirLoadImage = this.loadImageDlg.getCurrentDirectory();
            if (!this.spectrum.loadScreen(this.loadImageDlg.getSelectedFile())) {
                ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                JOptionPane.showMessageDialog(this, bundle.getString("LOAD_SCREEN_ERROR"), bundle.getString("LOAD_SCREEN_ERROR_TITLE"), 0);
            }
        }
        this.startEmulation();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitEmulator();
    }

    private void microdrivesIF1MediaMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        if (this.microdriveDialog == null) {
            this.microdriveDialog = new MicrodriveDialog(this.spectrum.getInterface1());
        }
        this.microdriveDialog.showDialog(this, bundle.getString("MICRODRIVES_DIALOG_TITLE"));
    }

    private void tapeBrowserButtonStopActionPerformed(ActionEvent evt) {
        if (this.tape.isTapePlaying()) {
            this.tape.stop();
            return;
        }
        if (this.tape.isTapeRecording()) {
            this.spectrum.stopRecording();
        }
    }

    private void tapeBrowserButtonPlayActionPerformed(ActionEvent evt) {
        if (this.tape.isTapeReady()) {
            this.tape.play();
        }
    }

    private void tapeBrowserButtonEjectActionPerformed(ActionEvent evt) {
        this.tape.eject();
    }

    private void reloadTapeMediaMenuActionPerformed(ActionEvent evt) {
        if (this.currentFileTape != null && this.currentFileTape.exists() && this.tape.isTapeReady()) {
            File tmp = this.tape.getTapeFilename();
            this.tape.eject();
            this.tape.insert(tmp);
            if (this.settings.getTapeSettings().isAutoLoadTape()) {
                this.spectrum.autoLoadTape();
            }
        }
    }

    private void memoryBrowserMachineMenuActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
        if (this.memoryBrowserDialog == null) {
            this.memoryBrowserDialog = new MemoryBrowserDialog(this.spectrum.getMemory());
        }
        this.memoryBrowserDialog.showDialog(this, bundle.getString("MEMORY_BROWSER_DIALOG_TITLE"));
    }

    private void pokeMachineMenuActionPerformed(ActionEvent evt) {
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.addressSpinner.getModel();
        SpinnerNumberModel snmValue = (SpinnerNumberModel)this.valueSpinner.getModel();
        snmValue.setValue(this.spectrum.getMemory().readByte(snmAddress.getNumber().intValue()) & 0xFF);
        this.pokeDialog.setVisible(true);
        this.pokeDialog.pack();
    }

    private void addressSpinnerStateChanged(ChangeEvent evt) {
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.addressSpinner.getModel();
        SpinnerNumberModel snmValue = (SpinnerNumberModel)this.valueSpinner.getModel();
        snmValue.setValue(this.spectrum.getMemory().readByte(snmAddress.getNumber().intValue()) & 0xFF);
        this.pokeButton.setEnabled(false);
    }

    private void valueSpinnerStateChanged(ChangeEvent evt) {
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.addressSpinner.getModel();
        SpinnerNumberModel snmValue = (SpinnerNumberModel)this.valueSpinner.getModel();
        int address = snmAddress.getNumber().intValue() & 0xFFFF;
        byte value = snmValue.getNumber().byteValue();
        this.pokeButton.setEnabled(value != this.spectrum.getMemory().readByte(address));
    }

    private void pokeButtonActionPerformed(ActionEvent evt) {
        SpinnerNumberModel snmAddress = (SpinnerNumberModel)this.addressSpinner.getModel();
        SpinnerNumberModel snmValue = (SpinnerNumberModel)this.valueSpinner.getModel();
        int address = snmAddress.getNumber().intValue() & 0xFFFF;
        this.spectrum.getMemory().writeByte(address, snmValue.getNumber().byteValue());
        this.pokeButton.setEnabled(false);
        if (this.spectrum.getMemory().isScreenByte(address)) {
            this.spectrum.invalidateScreen(false);
        }
    }

    private void closePokeDialogButtonActionPerformed(ActionEvent evt) {
        this.pokeDialog.setVisible(false);
    }

    private void loadMemorySnapshotActionPerformed(ActionEvent evt) {
        if (this.memorySnapshot == null) {
            return;
        }
        this.stopEmulation();
        this.spectrum.setSpectrumState(this.memorySnapshot);
        this.startEmulation();
    }

    private void saveMemorySnapshotActionPerformed(ActionEvent evt) {
        this.memorySnapshot = this.spectrum.getSpectrumState();
        this.loadMemorySnapshot.setEnabled(true);
    }

    private void loadBinaryFileActionPerformed(ActionEvent evt) {
        if (this.loadSaveMemoryDialog == null) {
            this.loadSaveMemoryDialog = new LoadSaveMemoryDialog(this.spectrum.getMemory());
        }
        this.stopEmulation();
        this.loadSaveMemoryDialog.showLoadDialog(this, null);
        this.startEmulation();
    }

    private void saveBinaryFileActionPerformed(ActionEvent evt) {
        if (this.loadSaveMemoryDialog == null) {
            this.loadSaveMemoryDialog = new LoadSaveMemoryDialog(this.spectrum.getMemory());
        }
        this.stopEmulation();
        this.loadSaveMemoryDialog.showSaveDialog(this);
        this.startEmulation();
    }

    private void noneFilterActionPerformed(ActionEvent evt) {
        this.jscr.setAnyFilter(false);
        this.scanlinesFilter.setEnabled(true);
        this.jscr.setScanlinesFilter(this.scanlinesFilter.isSelected());
        this.jscr.repaint();
    }

    private void palTvFilterActionPerformed(ActionEvent evt) {
        if (this.settings.getSpectrumSettings().isULAplus()) {
            this.noneFilter.setSelected(true);
            return;
        }
        this.jscr.setPalFilter(true);
        this.scanlinesFilter.setEnabled(true);
        this.jscr.setScanlinesFilter(this.scanlinesFilter.isSelected());
        this.jscr.repaint();
    }

    private void rgbFilterActionPerformed(ActionEvent evt) {
        this.jscr.setRgbFilter(true);
        this.scanlinesFilter.setEnabled(false);
        this.jscr.repaint();
    }

    private void scanlinesFilterActionPerformed(ActionEvent evt) {
        this.jscr.setScanlinesFilter(this.scanlinesFilter.isSelected());
        this.jscr.repaint();
    }

    private void standardZoomActionPerformed(ActionEvent evt) {
        this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.jscr.repaint();
    }

    private void bilinearZoomActionPerformed(ActionEvent evt) {
        this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.jscr.repaint();
    }

    private void bicubicZoomActionPerformed(ActionEvent evt) {
        this.jscr.setInterpolationMethod(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.jscr.repaint();
    }

    private void noBorderActionPerformed(ActionEvent evt) {
        if (this.jscr.getBorderMode() == 0) {
            return;
        }
        this.stopEmulation();
        this.spectrum.setBorderMode(0);
        this.jscr.setBorderMode(0);
        this.jscr.setTvImage(this.spectrum.getTvImage());
        this.pack();
        this.startEmulation();
    }

    private void standardBorderActionPerformed(ActionEvent evt) {
        if (this.jscr.getBorderMode() == 1) {
            return;
        }
        this.stopEmulation();
        this.spectrum.setBorderMode(1);
        this.jscr.setBorderMode(1);
        this.jscr.setTvImage(this.spectrum.getTvImage());
        this.pack();
        this.startEmulation();
    }

    private void hugeBorderActionPerformed(ActionEvent evt) {
        if (this.jscr.getBorderMode() == 3) {
            return;
        }
        this.stopEmulation();
        this.spectrum.setBorderMode(3);
        this.jscr.setBorderMode(3);
        this.jscr.setTvImage(this.spectrum.getTvImage());
        this.pack();
        this.startEmulation();
    }

    private void fullBorderActionPerformed(ActionEvent evt) {
        if (this.jscr.getBorderMode() == 2) {
            return;
        }
        this.stopEmulation();
        this.spectrum.setBorderMode(2);
        this.jscr.setBorderMode(2);
        this.jscr.setTvImage(this.spectrum.getTvImage());
        this.pack();
        this.startEmulation();
    }

    private void tapeLabelMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && !evt.isConsumed()) {
            evt.consume();
            this.tapeBrowserDialog.setVisible(true);
            this.tapeBrowserDialog.pack();
            this.tapeCatalog.doLayout();
        }
    }

    private void mdrvLabelMouseClicked(MouseEvent evt) {
        if (this.IF1MediaMenu.isEnabled() && evt.getClickCount() == 2 && !evt.isConsumed()) {
            evt.consume();
            ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
            if (this.microdriveDialog == null) {
                this.microdriveDialog = new MicrodriveDialog(this.spectrum.getInterface1());
            }
            this.microdriveDialog.showDialog(this, bundle.getString("MICRODRIVES_DIALOG_TITLE"));
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JSpeccy(args).setVisible(true);
            }
        });
    }

    private class TapeChangedListener
    implements TapeStateListener {
        private TapeChangedListener() {
        }

        @Override
        public void stateChanged(Tape.TapeState state) {
            boolean canRec = false;
            switch (state) {
                case INSERT: {
                    JSpeccy.this.tapeLabel.setEnabled(true);
                    JSpeccy.this.tapeLabel.setIcon(JSpeccy.this.tapeStopped);
                    JSpeccy.this.tapeLabel.setToolTipText(JSpeccy.this.tape.getTapeFilename().getName());
                    JSpeccy.this.tapeFilename.setText(JSpeccy.this.tape.getTapeFilename().getName());
                    JSpeccy.this.tapeBrowserButtonPlay.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonStop.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonRew.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonEject.setEnabled(true);
                    JSpeccy.this.playTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.recordStopTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.rewindTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.ejectTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.reloadTapeMediaMenu.setEnabled(true);
                    if (JSpeccy.this.tape.getTapeFilename().canWrite() && !JSpeccy.this.tape.getTapeFilename().getName().toLowerCase().endsWith(".csw")) {
                        canRec = true;
                    }
                    JSpeccy.this.clearTapeMediaMenu.setEnabled(canRec);
                    JSpeccy.this.recordStartTapeMediaMenu.setEnabled(canRec);
                    JSpeccy.this.tapeBrowserButtonRec.setEnabled(canRec);
                    JSpeccy.this.tapeCatalog.scrollRectToVisible(JSpeccy.this.tapeCatalog.getCellRect(0, 0, true));
                    break;
                }
                case EJECT: {
                    ResourceBundle bundle = ResourceBundle.getBundle("gui/Bundle");
                    JSpeccy.this.tapeFilename.setText(bundle.getString("JSpeccy.tapeFilename.text"));
                    JSpeccy.this.tapeLabel.setEnabled(false);
                    JSpeccy.this.tapeLabel.setToolTipText(null);
                    JSpeccy.this.tapeBrowserButtonRec.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonPlay.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonStop.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonRew.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonEject.setEnabled(false);
                    JSpeccy.this.playTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.recordStartTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.recordStopTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.clearTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.rewindTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.ejectTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.reloadTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.createTapeMediaMenu.setEnabled(true);
                    break;
                }
                case STOP: {
                    JSpeccy.this.tapeLabel.setIcon(JSpeccy.this.tapeStopped);
                    JSpeccy.this.tapeBrowserButtonPlay.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonStop.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonRew.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonEject.setEnabled(true);
                    JSpeccy.this.playTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.recordStopTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.rewindTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.ejectTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.reloadTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.createTapeMediaMenu.setEnabled(true);
                    if (JSpeccy.this.tape.getTapeFilename().canWrite() && !JSpeccy.this.tape.getTapeFilename().getName().toLowerCase().endsWith(".csw")) {
                        canRec = true;
                    }
                    JSpeccy.this.clearTapeMediaMenu.setEnabled(canRec);
                    JSpeccy.this.recordStartTapeMediaMenu.setEnabled(canRec);
                    JSpeccy.this.tapeBrowserButtonRec.setEnabled(canRec);
                    JSpeccy.this.pauseToggleButton.setEnabled(true);
                    JSpeccy.this.pauseMachineMenu.setEnabled(true);
                    JSpeccy.this.fastEmulationToggleButton.setEnabled(true);
                    break;
                }
                case RECORD: {
                    JSpeccy.this.tapeLabel.setIcon(JSpeccy.this.tapeRecording);
                    JSpeccy.this.playTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonRec.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonPlay.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonStop.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonRew.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonEject.setEnabled(false);
                    JSpeccy.this.recordStartTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.recordStopTapeMediaMenu.setEnabled(true);
                    JSpeccy.this.clearTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.rewindTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.ejectTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.reloadTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.createTapeMediaMenu.setEnabled(false);
                    if (!JSpeccy.this.settings.getTapeSettings().isAccelerateLoading()) break;
                    JSpeccy.this.pauseToggleButton.setEnabled(false);
                    JSpeccy.this.pauseMachineMenu.setEnabled(false);
                    JSpeccy.this.fastEmulationToggleButton.setEnabled(false);
                    break;
                }
                case PLAY: {
                    JSpeccy.this.tapeLabel.setIcon(JSpeccy.this.tapePlaying);
                    JSpeccy.this.tapeBrowserButtonRec.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonPlay.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonStop.setEnabled(true);
                    JSpeccy.this.tapeBrowserButtonRew.setEnabled(false);
                    JSpeccy.this.tapeBrowserButtonEject.setEnabled(false);
                    JSpeccy.this.recordStartTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.recordStopTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.clearTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.rewindTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.ejectTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.reloadTapeMediaMenu.setEnabled(false);
                    JSpeccy.this.createTapeMediaMenu.setEnabled(false);
                    if (!JSpeccy.this.settings.getTapeSettings().isAccelerateLoading()) break;
                    JSpeccy.this.pauseToggleButton.setEnabled(false);
                    JSpeccy.this.pauseMachineMenu.setEnabled(false);
                    JSpeccy.this.fastEmulationToggleButton.setEnabled(false);
                }
            }
        }
    }
}

