/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuration.JSpeccySettingsType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import machine.Keyboard;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CommandLineOptions {
    JSpeccySettingsType settings;
    @Option(name="-h", aliases={"--help"}, usage="CommandLineOptions.help.text")
    private boolean printUsage;
    @Option(name="-m", aliases={"--model"}, metaVar="CommandLineOptions.metaVar.model.text", usage="CommandLineOptions.model.text")
    private Model model = Model.sp48k;
    @Option(name="-u", aliases={"--ulaplus"}, usage="CommandLineOptions.ulaplus.text")
    private boolean ulaplus;
    @Option(name="-if1", aliases={"--interface1"}, usage="CommandLineOptions.interface1.text")
    private boolean if1;
    @Option(name="--microdrive-file", depends={"-if1"}, metaVar="CommandLineOptions.metaVar.file.text", usage="CommandLineOptions.microdriveFile.text")
    private File if1mdv;
    @Option(name="--multiface", usage="CommandLineOptions.multiface.text")
    private boolean multiface;
    @Option(name="--mf128-on-48k", depends={"--multiface"}, usage="CommandLineOptions.mf128on48k.text")
    private boolean mf128on48k;
    @Option(name="--lec", usage="CommandLineOptions.lec.text")
    private boolean lec;
    @Option(name="--emulate-128k-bug", usage="CommandLineOptions.emulate128kBug.text")
    private boolean bug128k;
    @Option(name="--issue2", usage="CommandLineOptions.issue2.text")
    private boolean issue2;
    @Option(name="-j", aliases={"--joystick"}, metaVar="CommandLineOptions.metaVar.model.text", usage="CommandLineOptions.joystick.text")
    private Keyboard.JoystickModel joystick = Keyboard.JoystickModel.NONE;
    @Option(name="--map-pc-keyboard", usage="CommandLineOptions.mapPCkeyboard.text")
    private boolean mapPCkeys;
    @Option(name="-z", aliases={"--zoom"}, metaVar="CommandLineOptions.metaVar.size.text", usage="CommandLineOptions.zoom.text")
    private int zoom = 1;
    @Option(name="--scanlines", usage="CommandLineOptions.scanlines.text")
    private boolean scanlines;
    @Option(name="--mute", usage="CommandLineOptions.mute.text")
    private boolean silence;
    @Option(name="--melodik", usage="CommandLineOptions.melodik.text")
    private boolean ayEnabled;
    @Option(name="--hifi-sound", usage="CommandLineOptions.hifi.text")
    private boolean hifi;
    @Option(name="--sound-mode", metaVar="CommandLineOptions.metaVar.mode.text", usage="CommandLineOptions.soundMode.text")
    private SoundMode soundMode = SoundMode.MONO;
    @Option(name="--zoom-filter", metaVar="CommandLineOptions.metaVar.filter.text", usage="CommandLineOptions.zoomFilter.text")
    private ZoomFilter zoomFilter = ZoomFilter.STANDARD;
    @Option(name="--border-size", metaVar="CommandLineOptions.metaVar.size.text", usage="CommandLineOptions.borderSize.text")
    private BorderSize borderSize = BorderSize.STANDARD;
    @Option(name="--no-load-trap", usage="CommandLineOptions.noLoadTrap.text")
    private boolean loadTrap;
    @Option(name="--fastload", usage="CommandLineOptions.fastload.text")
    private boolean fastload;
    @Option(name="--no-accelerated-loading", usage="CommandLineOptions.noAcceleratedLoading.text")
    private boolean acceleratedLoading;
    @Option(name="--no-autoload", usage="CommandLineOptions.noAutoLoad.text")
    private boolean autoload;
    @Option(name="--no-save-trap", usage="CommandLineOptions.noSaveTrap.text")
    private boolean saveTrap;
    @Option(name="--no-confirm-actions", usage="CommandLineOptions.noConfirmActions.text")
    private boolean confirmActions;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    CommandLineOptions(JSpeccySettingsType config) {
        this.settings = config;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public boolean isIf1() {
        return this.if1;
    }

    public File getIf1mdv() {
        return this.if1mdv;
    }

    public void copyArgumentsToSettings() {
        this.settings.getSpectrumSettings().setDefaultModel(this.model.ordinal());
        this.settings.getSpectrumSettings().setULAplus(this.ulaplus);
        if (this.model != Model.plus2a && this.model != Model.plus3) {
            this.settings.getInterface1Settings().setConnectedIF1(this.if1);
        }
        this.settings.getSpectrumSettings().setMultifaceEnabled(this.multiface);
        if (this.multiface) {
            this.settings.getSpectrumSettings().setMf128On48K(this.mf128on48k);
        }
        if (this.lec && this.model == Model.sp48k) {
            this.settings.getSpectrumSettings().setLecEnabled(this.lec);
        }
        this.settings.getSpectrumSettings().setEmulate128KBug(this.bug128k);
        this.settings.getKeyboardJoystickSettings().setIssue2(this.issue2);
        this.settings.getKeyboardJoystickSettings().setJoystickModel(this.joystick.ordinal());
        this.settings.getKeyboardJoystickSettings().setMapPCKeys(this.mapPCkeys);
        if (this.zoom < 2 || this.zoom > 4) {
            this.zoom = 1;
        }
        if (this.zoom > 1) {
            this.settings.getSpectrumSettings().setZoom(this.zoom);
        }
        this.settings.getSpectrumSettings().setZoomed(this.zoom > 1);
        this.settings.getSpectrumSettings().setScanLines(this.scanlines);
        this.settings.getSpectrumSettings().setZoomMethod(this.zoomFilter.ordinal());
        this.settings.getSpectrumSettings().setBorderSize(this.borderSize.ordinal());
        this.settings.getSpectrumSettings().setMutedSound(this.silence);
        if (!this.silence) {
            this.settings.getSpectrumSettings().setAYEnabled48K(this.ayEnabled);
            this.settings.getSpectrumSettings().setHifiSound(this.hifi);
            this.settings.getAY8912Settings().setSoundMode(this.soundMode.ordinal());
        }
        this.settings.getTapeSettings().setEnableLoadTraps(!this.loadTrap);
        this.settings.getTapeSettings().setFlashLoad(this.fastload);
        this.settings.getTapeSettings().setAccelerateLoading(!this.acceleratedLoading);
        this.settings.getTapeSettings().setAutoLoadTape(!this.autoload);
        this.settings.getTapeSettings().setEnableSaveTraps(!this.saveTrap);
        this.settings.getEmulatorSettings().setConfirmActions(!this.confirmActions);
    }

    static enum BorderSize {
        NONE,
        STANDARD,
        FULL,
        HUGE;

    }

    static enum ZoomFilter {
        STANDARD,
        BILINEAL,
        BICUBIC;

    }

    static enum SoundMode {
        MONO,
        ABC,
        ACB,
        BAC;

    }

    static enum Model {
        sp16k,
        sp48k,
        sp128k,
        plus2,
        plus2a,
        plus3;

    }
}

